.\" $XFree86: xc/programs/Xserver/hw/xfree86/drivers/ati/radeon.man,v 1.0 2003/01/31 23:04:50 $
.ds q \N'34'
.TH RM6 __drivermansuffix__ __vendorversion__
.SH NAME
rm6 \- ATI RADEON Mobility M6 video driver
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qrm6\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B rm6
is a __xservername__ driver for ATI RADEON Mobility M6 based video
cards.
It is based on the X.Org 6.8.2 Radeon driver, and is provided only as
a work-around for problems in the current radeon driver with this
chipset.
It contains
full support for 8, 15, 16 and 24 bit pixel depths, dual-head setup,
flat panel, hardware 2D acceleration,
 hardware cursor, XV extension, Xinerama extension.
.SH SUPPORTED HARDWARE
The
.B rm6
driver supports AGP video cards based on the ATI RADEON Mobility M6 LY chip.

.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
The driver auto\-detects all device information necessary to initialize
the card.  However, if you have problems with auto\-detection, you can
specify:
.PP
.RS 4
VideoRam \- in kilobytes
.br
MemBase  \- physical address of the linear framebuffer
.br
IOBase   \- physical address of the MMIO registers
.br
ChipID   \- PCI DEVICE ID
.RE
.PP
In addition, the following driver
.B Options
are supported:
.TP
.BI "Option \*qSWcursor\*q \*q" boolean \*q
Selects software cursor.  The default is
.B off.
.TP
.BI "Option \*qNoAccel\*q \*q" boolean \*q
Enables or disables all hardware acceleration.
.br
The default is to
.B enable
hardware acceleration.
.TP
.BI "Option \*qDac6Bit\*q \*q" boolean \*q
Enables or disables the use of 6 bits per color component when in 8 bpp
mode (emulates VGA mode).  By default, all 8 bits per color component
are used.
.br
The default is
.B off.
.TP
.BI "Option \*qVideoKey\*q \*q" integer \*q
This overrides the default pixel value for the YUV video overlay key.
.br
The default value is
.B 0x1E.
.TP 
.BI "Option \*qDDCMode\*q \*q" boolean \*q
Force to use the modes queried from the connected monitor.
.br
The default is
.B off.
.TP
.BI "Option \*qDisplayPriority\*q \*q" string \*q
.br
Used to prevent flickering or tearing problem caused by display buffer underflow.
.br
AUTO   \-\- Driver calculated (default).
.br
BIOS   \-\- Remain unchanged from BIOS setting.
          Use this if the calculation is not correct
          for your card.
.br
HIGH   \-\- Force to the highest priority.
          Use this if you have problem with above options.
          This may affect performence slightly.
.br
The default value is
.B AUTO.
.TP
.BI "Option \*qMonitorLayout\*q \*q" string \*q
.br
This option is used to overwrite the detected monitor types.
This is only required when driver makes a false detection.
The possible monitor types are:
.br
NONE   \-\- Not connected
.br
CRT    \-\- Analog CRT monitor
.br
TMDS   \-\- Desktop flat panel
.br 
LVDS   \-\- Laptop flat panel
.br
This option can be used in following format:
.br
Option "MonitorLayout" "[type on primary], [type on secondary]"
.br
For example, Option "MonitorLayout" "CRT, TMDS"

Primary/Secondary head for dual\-head cards:
.br
(when only one port is used, it will be treated as the primary regardless)
.br
.B Primary head:
.br
DVI port on DVI+VGA cards
.br
LCD output on laptops
.br 
Internal TMDS port on DVI+DVI cards
.br 
.B Secondary head:
.br
VGA port on DVI+VGA cards
.br
VGA port on laptops
.br
External TMDS port on DVI+DVI cards

The default value is
.B undefined.
.TP 
.BI "Option \*qMergedFB\*q \*q" boolean \*q
This enables merged framebuffer mode.  In this mode you have a single 
shared framebuffer with two viewports looking into it.  It is similar
to Xinerama, but has some advantages.  It is faster than Xinerama, the
DRI works on both heads, and it supports clone modes.  
.br
Merged framebuffer mode provides two linked viewports looking into a
single large shared framebuffer.  The size of the framebuffer is 
determined by the
.B Virtual
keyword defined on the
.B Screen
section of your XF86Config file.  It works just like regular virtual
desktop except you have two viewports looking into it instead of one.
.br
For example, if you wanted a desktop composed of two 1024x768 viewports
looking into a single desktop you would create a virtual desktop of 
2048x768 (left/right) or 1024x1536 (above/below), e.g.,
.br
.B Virtual 2048 768
or
.B Virtual 1024 1536
.br
The virtual desktop can be larger than larger than the size of the viewports
looking into it.  In this case the linked viewports will scroll around in the 
virtual desktop.  Viewports with different sizes are also supported (e.g., one
that is 1024x768 and one that is 640x480).  In this case the smaller viewport
will scroll relative to the larger one such that none of the virtual desktop 
is inaccessable.  If you do not define a virtual desktop the driver will create
one based on the orientation of the heads and size of the largest defined mode in 
the display section that is supported on each head.
.br
The relation of the viewports in specified by the
.B CRT2Position
Option.  The options are
.B Clone
,
.B LeftOf
,
.B RightOf
,
.B Above
, and
.B Below.  
MergedFB is enabled by default if a monitor is detected on each output.  If 
no position is given it defaults to clone mode (the old clone options are now 
deprecated, also, the option OverlayOnCRTC2 has been replaced by the Xv 
attribute XV_SWITCHCRT; the overlay can be switched to CRT1 or CRT2 on the fly 
in clone mode).
.br
The maximum framebuffer size that the 2D acceleration engine can handle is 
8192x8192.  The maximum framebuffer size that the 3D engine can handle is 
2048x2048.
.br
.B Note:
Page flipping does not work well in certain configurations with MergedFB.  If you 
see rendering errors or other strange behavior, disable page flipping. 
.br
The default value is
.B undefined.
.TP 
.BI "Option \*qCRT2HSync\*q \*q" "string" \*q
Set the horizontal sync range for the secondary  monitor. 
It is not required if a DDC\-capable monitor is connected.
.br
For example, Option "CRT2HSync" "30.0-86.0"
.br
The default value is
.B undefined.
.TP 
.BI "Option \*qCRT2VRefresh\*q \*q" "string" \*q
Set the vertical refresh range for the secondary monitor.
It is not required if a DDC\-capable monitor is connected.
.br
For example, Option "CRT2VRefresh" "50.0-120.0"
.br
The default value is
.B undefined.
.TP
.BI "Option \*qCRT2Position\*q \*q" "string" \*q
Set the relationship of CRT2 relative to CRT1. Valid options are: 
.B Clone
,
.B LeftOf
,
.B RightOf
,
.B Above
, and
.B Below
.
.br
For example, Option "CRT2Position" "RightOf"
.br
The default value is
.B Clone.
.TP
.BI "Option \*qMetaModes\*q \*q" "string" \*q
MetaModes are mode combinations for CRT1 and CRT2.  If you are using merged
frame buffer mode and want to change modes (CTRL-ALT-+/-), these define which
modes will be switched to on CRT1 and CRT2.  The MetaModes are defined as 
CRT1Mode-CRT2Mode (800x600-1024x768).  Modes listed individually (800x600) 
define clone modes, that way you can mix clone modes with non-clone modes.
Also some programs require "standard" modes.  
.br
Note:  Any mode you use in the MetaModes must be defined in the
.B Screen 
section of your XF86Config file.  Modes not defined there will be ignored when
the MetaModes are parsed since the driver uses them to make sure the monitors can 
handle those modes.  If you do not define a MetaMode the driver will create
one based on the orientation of the heads and size of the largest defined mode in 
the display section that is supported on each head.
.br
.B Modes "1024x768" "800x600" "640x480"
.br
For example, Option "MetaModes" "1024x768-1024x768 800x600-1024x768 640x480-800x600 800x600"
.br
The default value is
.B undefined.
.TP
.BI "Option \*qOverlayOnCRTC2\*q \*q" boolean \*q
Force hardware overlay to clone head.
.br
The default value is
.B off.
.TP
.BI "Option \*qNoMergedXinerama\*q \*q" boolean \*q
Since merged framebuffer mode does not use Xinerama, apps are not able to intelligently
place windows.  Merged framebuffer mode provides its own pseudo-Xinerama.  This allows
Xinerama compliant applications to place windows appropriately.  There are some caveats.
Since merged framebuffer mode is able to change relative screen sizes and orientations on
the fly, as well has having overlapping viewports, pseudo-Xinerama, might not always 
provide the right hints.  Also many Xinerama compliant applications only query Xinerama
once at startup; if the information changes, they may not be aware of the change.  If
you are already using Xinerama (e.g., a single head card and a dualhead card providing
three heads), pseudo-Xinerama will be disabled.
.br
This option allows you turn off the driver provided pseudo-Xinerama extension.
.br
The default value is
.B FALSE.
.TP 
.BI "Option \*qMergedXineramaCRT2IsScreen0\*q \*q" boolean \*q
By default the pseudo-Xinerama provided by the driver makes the left-most or bottom
head Xinerama screen 0.  Certain Xinerama-aware applications do special things with 
screen 0.  To change that behavior, use this option.
.br
The default value is
.B undefined.
.TP
.BI "Option \*qMergedDPI\*q \*q" "string" \*q
The driver will attempt to figure out an appropriate DPI based on the DDC information
and the orientation of the heads when in merged framebuffer mode.  If this value does 
not suit you, you can manually set the DPI using this option.
.br
For example, Option "MergedDPI" "100 100"
.br
The default value is
.B undefined.
.TP 
.BI "Option \*qIgnoreEDID\*q \*q" boolean \*q
Do not use EDID data for mode validation, but DDC is still used
for monitor detection. This is different from NoDDC option.
.br
The default value is
.B off.
.TP 
.BI "Option \*qPanelSize\*q \*q" "string" \*q
Should only be used when driver cannot detect the correct panel size.
Apply to both desktop (TMDS) and laptop (LVDS) digital panels.
When a valid panel size is specified, the timings collected from
DDC and BIOS will not be used. If you have a panel with timings 
different from that of a standard VESA mode, you have to provide
this information through the Modeline.
.br
For example, Option "PanelSize" "1400x1050"
.br
The default value is
.B none.
.TP 
.BI "Option \*qPanelOff\*q \*q" boolean \*q
Disable panel output.
.br
The default value is
.B off.
.TP
.BI "Option \*qEnablePageFlip\*q \*q" boolean \*q
Enable page flipping for 3D acceleration. This will increase performance
but not work correctly in some rare cases, hence the default is
.B off.
.br
.B Note:
Page flipping does not work well in certain configurations with MergedFB.  If you
see rendering errors or other strange behavior, disable page flipping.

.TP
.BI "Option \*qForceMinDotClock\*q \*q" frequency \*q
Override minimum dot clock. Some Radeon BIOSes report a minimum dot
clock unsuitable (too high) for use with television sets even when they
actually can produce lower dot clocks. If this is the case you can
override the value here.
.B Note that using this option may damage your hardware.
You have been warned. The
.B frequency
parameter may be specified as a float value with standard suffixes like
"k", "kHz", "M", "MHz".
.TP
.BI "Option \*qRenderAccel\*q \*q" boolean \*q
Enables or disables hardware Render acceleration.  This driver does not
support component alpha (subpixel) rendering.    The default is to
.B enable
Render acceleration.
.TP
.BI "Option \*qSubPixelOrder\*q \*q" "string" \*q
Force subpixel order to specified order.
Subpixel order is used for subpixel decimation on flat panels.
.br
NONE   \-\- No subpixel (CRT like displays)
.br
RGB    \-\- in horizontal RGB order (most flat panels)
.br
BGR    \-\- in horizontal BGR order (some flat panels)

.br
This option is intended to be used in following cases:
.br
1. The default subpixel order is incorrect for your panel.
.br
2. Enable subpixel decimation on analog panels.
.br
3. Adjust to one display type in dual-head clone mode setup.
.br
4. Get better performance with Render acceleration on 
digital panels (use NONE setting).
.br
The default is 
.B NONE 
for CRT, 
.B RGB 
for digital panels
.TP
.BI "Option \*qDynamicClocks\*q \*q" boolean \*q
Enable dynamic clock scaling.  The on-chip clocks will scale dynamically 
based on usage. This can help reduce heat and increase battery 
life by reducing power usage.  Some users report reduced 3D preformance
with this enabled.  The default is
.B off.
.TP
.BI "Option \*qiBookHacks\*q \*q" boolean \*q
On some iBook models and on the Mac mini the screen is distorted and exiting
the X server does not reset the console properly.
This option enables a workaround for these problems.
The default is
.B off.

.SH SEE ALSO
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), xorgconfig(__appmansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.SH AUTHORS
.nf
Authors include: ...
