<?php
/**
 * Nag base inclusion file.
 *
 * $Horde: nag/lib/base.php,v 1.28.2.3 2002/12/17 04:43:58 jon Exp $
 *
 * This file brings in all of the dependencies that every Nag
 * script will need and sets up objects that all scripts use.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of Nag
@define('NAG_BASE', dirname(__FILE__) . '/..');

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('nag');
$conf = &$GLOBALS['conf'];
@define('NAG_TEMPLATES', $registry->getParam('templates'));

// Set the error reporting level in accordance with the config settings.
error_reporting($conf['debug_level']);

// Set the maximum execution time in accordance with the config settings.
set_time_limit($conf['max_exec_time']);

// set the umask according to config settings
if (isset($conf['umask'])) {
    umask($conf['umask']);
}

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Text.php';
require_once HORDE_BASE . '/lib/Help.php';

// Redirect the user to the Horde login page if they haven't authenticated.
if (!Auth::getAuth()) {
    header('Location: ' . Horde::url($registry->getParam('webroot', 'horde') . '/login.php?url=' . urlencode(Horde::selfUrl()), true));
    exit;
}

// Nag base libraries
require_once NAG_BASE . '/lib/Nag.php';
require_once NAG_BASE . '/lib/Driver.php';

// Browser detection library
require_once HORDE_BASE . '/lib/Browser.php';
$browser = &new Browser();

// Notification sytem
require_once HORDE_BASE . '/lib/Notification.php';
$notification = &Notification::singleton();
$notification->attach('status');

// Set the timezone variable, if available.
$timezone = $GLOBALS['prefs']->getValue('timezone');
if (!empty($timezone)) {
    putenv('TZ=' . $timezone);
}
