import sys
import gtk, pango
from cStringIO import *
import traceback
import urllib
from pynicotine.utils import version, _

REPORT_URL = "http://www.thegraveyard.org/nicotine/report_tb.php"
def report(data):
    try:
        conn = urllib.urlopen(REPORT_URL, urllib.urlencode({"data": data, "version": version}))
        result = conn.read()
        conn.close()
        return result
    except:
        return None

def _info(type, value, tb):
    dialog = gtk.MessageDialog(parent=None,
			       flags=0,
			       type=gtk.MESSAGE_WARNING,
			       buttons=gtk.BUTTONS_NONE,
			       message_format=_(
	"<big><b>A programming error has been detected during the execution of this program.</b></big>"
	"\n\nIt probably isn't fatal, but should be reported to the developers nonetheless."))
    dialog.set_title(_("Bug Detected"))
    dialog.set_property("has-separator", False)
    dialog.vbox.get_children()[0].get_children()[1].set_property("use-markup", True)

    dialog.add_button(_("Details..."), 1)
    report_button = dialog.add_button(_("Report..."), 2)
    report_button.set_sensitive(gtk.FALSE)
    dialog.add_button(gtk.STOCK_CLOSE, gtk.RESPONSE_CLOSE)
    
    while 1:
	resp = dialog.run()
	if resp == 1:
	    # Show details...
	    details = gtk.Dialog(_("Bug Details"), dialog,
				 gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,
				 (gtk.STOCK_CLOSE, gtk.RESPONSE_CLOSE,))

	    textview = gtk.TextView(); textview.show()
	    textview.set_editable(False)
	    textview.modify_font(pango.FontDescription("Monospace"))
	    
	    sw = gtk.ScrolledWindow(); sw.show()
	    sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
	    sw.add(textview)
	    details.vbox.add(sw)
	    textbuffer = textview.get_buffer()
	    trace = StringIO()
	    traceback.print_exception(type, value, tb, None, trace)
	    textbuffer.set_text(trace.getvalue())
	    details.set_default_size(gtk.gdk.screen_width()/2, gtk.gdk.screen_height()/3)
	    details.run()
	    details.destroy()
	    report_button.set_sensitive(gtk.TRUE)
	elif resp == 2:
	    report_button.set_sensitive(gtk.FALSE)
	    trace = StringIO()
	    traceback.print_exception(type, value, tb, None, trace)
	    if report(trace.getvalue()) == "OK":
	        result_dialog = gtk.MessageDialog(dialog,
	        			gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,
	        			gtk.MESSAGE_INFO, gtk.BUTTONS_OK,
	        			"Bug has been successfully reported")
	    else:
	        result_dialog = gtk.MessageDialog(dialog,
	        			gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,
	        			gtk.MESSAGE_ERROR, gtk.BUTTONS_OK,
	        			"There was a problem reporting the bug")
	    result_dialog.run()
	    result_dialog.destroy()
	else: break
    dialog.destroy()

sys.excepthook = _info


