// -*- c++ -*-

/*
 *  Copyright (C) 2003, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#ifndef KJSEMBED_SLOTPROXY_H
#define KJSEMBED_SLOTPROXY_H

#include <kjs/object.h>
#include <qobject.h>

namespace KJSEmbed {

/**
 * Allows slots to be connected to methods of a JS object.
 *
 * @author Richard Moore, rich@kde.org
 */
class JSSlotProxy : public QObject
{
    Q_OBJECT

public:
    JSSlotProxy( QObject *parent, const char *name=0 );
    virtual ~JSSlotProxy();

    void setInterpreter( KJS::Interpreter *js ) { this->js = js; }
    void setObject( const KJS::Object &obj ) { this->obj = obj; }
    void setMethod( const QString &method ) { this->method = method; }

public slots:
    void slot_void();
    void slot_bool( bool b );
    void slot_string( const QString &s );
    void slot_int( int i );
    void slot_uint( uint i );
    void slot_long( long i );
    void slot_ulong( ulong i );
    void slot_double( double d );
    void slot_font( const QFont &font);
    void slot_color( const QColor &color);

private:
    KJS::Interpreter *js;
    KJS::Object obj;
    QString method;
    class SlotProxyPrivate *d;
};

} // namespace KJSEmbed

#endif // KJSEMBED_SLOTPROXY_H

