"""
parser.http.utils module (imdb package).

This module provides miscellaneous utilities used by
the imdb.parser.http classes.

Copyright 2004 Davide Alberani <davide.alberani@erlug.linux.it>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""

import re
from htmllib import HTMLParser
from formatter import NullFormatter

from imdb._exceptions import IMDbParserError


# XXX: this class inherits from HTMLParser; see the documentation for
#      the "htmllib" and "sgmllib" modules.
class ParserBase(HTMLParser):
    # The imdbID is a 7-ciphers number.
    re_imdbID = re.compile('([0-9]{7})')
    
    def __init__(self, formatter=NullFormatter(), verbose=0):
        self._init()
        HTMLParser.__init__(self, formatter, verbose)
        # Use a "normal" space in place of the non-breaking space (0240/0xA0).
        self.entitydefs['nbsp'] = ' '

    def reset(self):
        """Reset the parser."""
        HTMLParser.reset(self)
        self._reset()

    def get_attr_value(self, attrs_list, searched_attr):
        """Given a list of attributes in the form ('attr_name', 'attr_value')',
        return the attr_value of the 'searched_attr' attribute or None if it's
        not found."""
        for attr in attrs_list:
            if attr[0] == searched_attr:
                return attr[1]
        return None

    def _init(self): pass

    def _reset(self): pass

    def get_data(self): return None

    def anchor_bgn(self, href, name, type): pass

    def anchor_end(self): pass
    
    def handle_image(self, src, alt, *args): pass

    def error(self, message):
        raise IMDbParserError, 'HTML parser error: "%s"' % str(message)

    def parse(self, html_string):
        """Return the dictionary generated from the given html string."""
        self.reset()
        self.feed(html_string)
        return self.get_data()


