<?php
/**
 * $Horde: kronolith/month.php,v 1.69.2.13 2003/04/05 15:13:02 chuck Exp $
 *
 * Copyright 1999-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function time_compare($x, $y)
{
    $a = mktime(date('G', $x['d']), date('i', $x['d']), date('s', $x['d']));
    $b = mktime(date('G', $y['d']), date('i', $y['d']), date('s', $y['d']));

    if ($a < $b) {
        return -1;
    } elseif ($a == $b) {
        return 0;
    } else {
        return 1;
    }
}

@define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

if ($timestamp = Horde::getFormData('timestamp')) {
    $month = date('n', $timestamp);
    $year = date('Y', $timestamp);
} else {
    $month = Horde::getFormData('month', date('n'));
    $year = Horde::getFormData('year', date('Y'));
}
$timestamp = mktime(1, 1, 1, $month, 1, $year);
$prevstamp = mktime(1, 1, 1, $month - 1, 1, $year);
$nextstamp = mktime(1, 1, 1, $month + 1, 1, $year);
$title = strftime('%B %Y', $timestamp);
$js_onLoad = null;

if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

require KRONOLITH_TEMPLATES . '/common-header.inc';

$print_view = (Horde::getFormData('print') == 'true');
if ($print_view) {
    require KRONOLITH_TEMPLATES . '/javascript/print.inc';
} else {
    $print_link = Kronolith::addParameter('month.php', 'timestamp=' . $timestamp);
    $print_link = Kronolith::addParameter($print_link, 'print=true');
    $print_link = Horde::url($print_link);
    if ($browser->hasFeature('javascript')) {
        require KRONOLITH_TEMPLATES . '/javascript/open_print_win.js';
    }

    require KRONOLITH_BASE . '/menu.php';
}

require KRONOLITH_TEMPLATES . '/month/head.inc';

$daysInMonth = Kronolith::daysInMonth($month, $year);
$startday = Kronolith::dayOfWeek($year, $month, $prefs->getValue('week_start_monday') ? 1 : 2);

$colors = Kronolith::categoryColors();

// Days before the month starts.
for ($i = 0; $i < $startday; $i++) {
    echo '<td></td>';
}

$startStamp = mktime(0, 0, 0, $month, 1, $year);
$startDate = Kronolith::timestampToObject($startStamp);
$endStamp = mktime(23, 59, 59, $month, $daysInMonth, $year);
$endDate = Kronolith::timestampToObject($endStamp);
$allevents = Kronolith::listEvents($startDate, $endDate);
$currentCalendars = array(true); 
foreach ($currentCalendars as $id => $cal) {
    $dayofweek = $startday;
    for ($day = 1; $day <= $daysInMonth; $day++) {
        $dayStamp = mktime(0, 0, 0, $month, $day, $year);
        $week = Kronolith::weekOfYear($day, $month, $year);
    
        if (($dayofweek % 7 == 0) && ($dayofweek != 0)) {
            echo '</tr><tr>';
        }
        if (mktime(0, 0, 0) == $dayStamp) {
            $style = 'selected';
        } elseif (isset($date_array[$i]) && is_array($date_array[$i])) {
            $style = 'text';
        } else {
            $style = 'item';
        }
    
        echo '<td class="' . $style . '" height="100" width="14%" valign="top">';
        echo '<table cellspacing="0" cellpadding="1" width="100%"><tr><td>';
    
        $url = Kronolith::addParameter(Horde::applicationUrl('day.php'),
                                   'timestamp=' . $dayStamp);
        echo '<b><a class="day" href="' . $url . "\">&nbsp;$day&nbsp;</a></b>";
    
        if (($dayofweek % 7 == 0) && (($dayofweek != 0 || $startday == 0))) {
            $url = Kronolith::addParameter('week.php', 'week=' . $week);
            if ($month == 12 && $week == 1) {
                $url = Kronolith::addParameter($url, 'year=' . ($year + 1));
            } else {
                $url = Kronolith::addParameter($url, 'year=' . $year);
            }
            echo ' (' . Horde::link(Horde::applicationUrl($url), sprintf(_("Week %d"), $week)) . sprintf(_("Week&nbsp;%d"), $week) . '</a>)';
        }
        echo '</td>';

        if (Auth::getAuth() && !$print_view) {
            $url = Kronolith::addParameter(Horde::applicationUrl('addevent.php'),
                                       'timestamp=' . $dayStamp);
            $url = Kronolith::addParameter($url, 'url', Horde::selfURL(true));
            echo '<td width="14%">' . Horde::link($url, _("Create a New Event")) . Horde::img('new.gif', 'alt="' . _("Create a New Event") . '" align="right"') . '</a></td>';
        }

        echo '</tr></table>';

        if (!empty($allevents[$dayStamp]) &&
            count($allevents[$dayStamp])) {
            $cell = '<table cellspacing="0" cellpadding="1" width="100%">';
            foreach ($allevents[$dayStamp] as $event) {
                $categoryColor = isset($colors[$event->getCategory()]) ? $colors[$event->getCategory()] : '#ccccff' ;

                $cell .= '<tr><td class="month-eventbox" style="background-color: ' . $categoryColor . '; ' ;
                $cell .= 'border-color: ' . Kronolith::borderColor($categoryColor) . '" ' ;
                $cell .= 'onmouseover="javascript:style.backgroundColor=\'' . Kronolith::modifyColor($categoryColor) . '\'" ' ;
                $cell .= 'onmouseout="javascript:style.backgroundColor=\'' . $categoryColor . '\'" ' ;
                $cell .= 'valign="top">';
                $cell .= $event->getLink($dayStamp);
                $cell .= '</td></tr>';
            }

            $cell .= '</table>';
            echo $cell;
        }
    
        echo '</td>';
        $dayofweek++;
    }
}
?>

</tr></table>
</td></tr></table>

<?php
require KRONOLITH_TEMPLATES . '/common-footer.inc';
