(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Franois Pessaux, projet Cristal, INRIA Rocquencourt     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)

val check_header : string -> Image.header
  (* Checks the file header *)

val load : string -> Image.load_option list -> Image.t
  (* Loads a tiff image. *)

val save : string -> Image.save_option list -> Image.t -> unit;;
  (* Save a full-color image in tiff format file.
     Raises [Invalid_argument] if the image is not a full-color image. *)

(* Scanline based I/O functions *)

type colormodel = RGB | CMYK | WHITEBLACK | BLACKWHITE

type in_handle

val open_in : string -> int * int * float * colormodel * in_handle
val read_scanline : in_handle -> string -> int -> unit
val close_in : in_handle -> unit

type out_handle

val open_out : string -> int -> int -> float -> out_handle
val write_scanline : out_handle -> string -> int -> unit
val close_out : out_handle -> unit


