#!/usr/bin/env python
#####################################################################
#
# emailAccepter     Script to launch from /etc/aliases or procmail
#                   to accept email messages and push them into the
#                   JTracker instance at JTRACKER_URL
#
# This software is governed by a license. See
# LICENSE.txt for the terms of this license.
#
#####################################################################
__version__='$Revision: 1.7 $'[11:-2]

import sys, urllib

JTRACKER_URL   = 'http://server.my.org:8080/tracker'
LOGIN          = None     # Use None if anonymous access is sufficient
PASSWORD       = None     # Use None if anonymous access is sufficient


class JTrackerURLopener(urllib.FancyURLopener):
    """ Overriding the method that provides the username/password... """

    def prompt_user_passwd(self, host, realm):
        """ Returns a username/password pair """
        return LOGIN, PASSWORD


if __name__ == '__main__':
    # Called from the command line: We received an email
    email_text = sys.stdin.read()
    urllib._urlopener = JTrackerURLopener()
    url = '%s/receiveMail' % JTRACKER_URL
    encoded_email = urllib.urlencode({'file' : email_text})

    try:
        result = urllib.urlopen(url, encoded_email).read()
    except (IOError,EOFError), e:
        result = str(e)

    if result:
        print result
        sys.exit(1)

