// I18N constants

// Translation Note
// 1. translate the left  side of fontname, font size and formatblock
// 2. translate the right side of tooltips

HTMLArea.I18N = {
	fontname: {
		"Arial":           'arial,helvetica,sans-serif',
		"Courier New":     'courier new,courier,monospace',
		"Georgia":         'georgia,times new roman,times,serif',
		"Tahoma":          'tahoma,arial,helvetica,sans-serif',
		"Times New Roman": 'times new roman,times,serif',
		"Verdana":         'verdana,arial,helvetica,sans-serif',
		"impact":          'impact',
		"WingDings":       'wingdings'
	},

	fontsize: {
		"1 (8 pt)":  "1",
		"2 (10 pt)": "2",
		"3 (12 pt)": "3",
		"4 (14 pt)": "4",
		"5 (18 pt)": "5",
		"6 (24 pt)": "6",
		"7 (36 pt)": "7"
	},

	formatblock: {
		" 1": "h1",
		" 2": "h2",
		" 3": "h3",
		" 4": "h4",
		" 5": "h5",
		" 6": "h6",
		"": "p",
		"": "address",
		"": "pre"
	},

	tooltips: {
		bold:           "",
		italic:         "",
		underline:      "",
		strikethrough:  "",
		subscript:      "",
		superscript:    "",
		justifyleft:    "  ",
		justifycenter:  "",
		justifyright:   "  ",
		justifyfull:    "    ",
		insertorderedlist:    " ",
		insertunorderedlist:  " ",
		outdent:        " ",
		indent:         " ",
		forecolor:      "  ",
		hilitecolor:    "  ",
		horizontalrule: " ",
		createlink:     " ",
		insertimage:    " ",
		insertsound:    " ",
		inserttable:    " ",
		htmlmode:       "HTML -  ",
		popupeditor:    " ",
		about:          " ",
		showhelp:       "   ",
		textindicator:  " ",
		undo:           "  ",
		redo:           "  ",
		cut:            " ",
		copy:           " ",
		paste:          "  "
	},

	buttons: {
		"ok":           "",
		"cancel":       ""
	},

	msg: {
		"Path":         "",
		"TEXT_MODE":    "    .   [<>]    WYSIWIG."
	}
};
