#
# (C) 2003 Tenable Network Security
#
# Redistribution and use in source, with or without modification, are 
# permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#     This product includes software developed by Tenable Network Security
#

if (description)
{
  script_version("$Revision: 1.39 $");
  script_id(11936);

  name["english"] = "OS Identification, using icmp";
  script_name(english:name["english"]);

  desc["english"] = "
This script attempts to identify the Operating System type and version by
sending more or less incorrect ICMP requests using the techniques outlined
in Ofir Arkin's paper 'ICMP Usage In Scanning'.

An attacker may use this to identify the kind of the remote operating
system and gain further knowledge about this host.

See also : http://www.sys-security.com/html/projects/icmp.html
Risk factor : Low";

  script_description(english:desc["english"]);
 
  summary["english"] = "Fingerprints the remote web server";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright(english:"This script is Copyright (C) 2003 Tenable Network Security");
  family["english"] = "General";
  script_family(english:family["english"]);

  exit(0);
}



include("network_func.inc");
ttl = 0; # global
ip_id_sent = "1"; # global
MAX_RETRIES = 3;

db = "
# Submitted by Michael Scheidell
3Com SuperStack II:1:1:0:255:0:255:1:0:255:1:0:255:1:8:255:0:1:1:1:1:1:1:0:1:255:1024:M:N:N:N

# Submitted by Joannathan Herv : ATLAS 550 Rev B03
Adtran ATLAS 550:0:1:0:64:0:64:1:1:64:1:0:64:1:8:64:0:1:1:2:1:1:1:0:1:64:4096:M:N:N:N

# Submitted by Ragis Guirguis
AIX 5.1:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:1:>20:1:0:1:64:65535:MNWNNT:4:1:1

# Submitted by Owen Crow
AIX 5.2:1:1:1:255:1:255:1:0:255:1:1:255:1:8:255:1:1:0:2:1:>20:1:0:1:64:17520:M:N:N:N

# Submitted by Joel (asmodianx) (firmware 1.10.008, boot 1.13, hw 01)
Belkin Wireless Router:1:1:1:64:1:64:1:0:64:1:0:64:1:X:X:X:X:X:X:X:X:X:0:1:64:8192:MNW:0:N:N
CISCO IOS 11.2:1:S:1:255:1:255:S:0:255:S:1:255:S:8:255:0:1:1:1:1:1:1:0:0:255:4288:M:N:N:N
# Submitted by Joannathan Herv : CISCO IOS 12.0(9)
CISCO IOS 12.0:1:S:1:255:1:255:S:0:255:S:1:255:S:8:255:0:1:1:1:1:1:1:0:0:255:4128:M:N:N:N

# Submitted by Marc at spooshland.com
D-Link Router:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:5808:M:N:N:N
D-Link WLAN Access Point:1:1:0:32:0:32:1:0:32:1:0:32:1:X:X:X:X:X:X:X:X:X:0:1:32:16000:M:N:N:N
# Actually a DI-713P WAP
D-Link WLAN Access Point:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:5840:M:N:N:N


# Submitted by Marco IANNOZI and Owen Crow
HP/UX B 11.11:1:1:1:255:0:255:1:0:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:64:32768:MNNSWNNNT:0:1:1

HP JetDirect:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:0:3:1:3:0:1:64:8192:MNW:0:N:N


FreeBSD 5.1:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:65535:MNWNNT:1:1:1
FreeBSD 4.8:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:57344:MNWNNT:0:1:1
FreeBSD 4.7:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:57344:MNWNNT:0:1:1
FreeBSD 4.5:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:0:1:64:65535:MNWNNT:1:1:1
FreeBSD 4.2:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:1:1:1:1:1:1:64:17520:M:N:N:N
FreeBSD 4.1:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:2:3:1:3:1:1:64:17520:M:N:N:N
FreeBSD 4.0:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:2:3:1:3:1:1:64:17520:M:N:N:N
FreeBSD 3.5:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:2:3:1:3:1:1:64:17520:M:N:N:N
FreeBSD 3.4:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:2:3:1:3:1:1:64:17520:M:N:N:N
FreeBSD 3.3:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:0:2:3:1:3:1:1:64:17520:M:N:N:N

# Actually is IRIX 6.5.18f
IRIX 6.5:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:1:1:1:1:1:1:1:64:60816:MNWNNTNNS:0:1:1

Lexmark Printer:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:1:1:1:1:1:1:1:1:1:255:2896:MNWNNT:0:1:1

# Submitted by Ron Searle (BEFSR114 router)
Linksys Router:1:S:0:64:0:64:1:0:64:1:0:64:1:8:64:0:S:1:1:1:1:1:0:0:64:5840:M:N:N:N
# Submitted by Christopher Walsh
Linksys Access Hub WAP11:1:1:0:64:0:64:1:0:64:1:0:64:1:8:64:0:1:1:1:1:1:1:0:1:64:4608:M:N:N:N


# Linux 2.4.20 - submitted by Clyde Hoadley
Linux Kernel 2.4:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:1:1:1:1:1:64:5792:MSTNW:0:1:1

# Submitted by Paul Kuhanst
Linux Kernel 2.4:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:3:1:1:1:0:64:5792:MSTNW:0:1:1

# 2.4.17 to 2.4.xx
Linux Kernel 2.4:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:1:1:1:1:0:64:5792:MSTNW:0:1:1

# This actually is 2.4.0 to 2.4.17
Linux Kernel 2.4:1:1:0:255:1:255:1:0:255:1:0:255:1:>64:255:0:1:1:1:1:1:1:1:0:64:5792:MSTNW:0:1:1

# Submitted by Ryan Tryssernaar
Linux Kernel 2.2:1:1:0:255:1:255:1:0:255:1:0:255:1:>64:255:0:1:1:1:1:1:1:1:1:64:32120:MSTNW:0:1:1



MacOS X 10.3:1:1:1:64:0:64:1:0:64:1:0:64:1:8:64:1:1:0:1:1:1:1:1:1:64:65535:MNWNNT:0:1:1
# Submitted by Chris Gamboni
Microsoft Windows 2003 Server:0:1:1:128:1:128:1:0:128:1:0:128:1:>64:128:0:1:1:1:1:1:1:1:1:128:17520:MNWNNTNNS:0:0:0
Microsoft Windows 2003 Server:0:1:1:128:1:128:1:0:128:1:0:128:1:>64:128:0:1:1:1:1:1:1:1:1:128:65535:MNWNNTNNS:0:0:0

Microsoft Windows XP Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:64240:MNWNNTNNS:0:0:0
Microsoft Windows XP Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:17520:MNWNNTNNS:0:0:0
# Submitted by Jim Cassata - XP Pro + Cisco vpn 3.5.2
Microsoft Windows XP Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:65268:MNWNNTNNS:0:0:0
# Submitted by Yoni
Microsoft Windows XP Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:17680:MNWNNTNNS:0:0:0
# Submitted by Zube
Microsoft Windows XP Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:0:1:128:16384:MNNS:N:N:N


Microsoft Windows XP Server:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:64512:MNWNNTNNS:0:0:0
# Submitted by Erik Ball
Microsoft Windows 2000 Server Service Pack 4:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:0:1:128:65535:MNWNNTNNS:0:0:0
# Submitted by Christopher Walsh
Microsoft Windows 2000 Server Service Pack 4:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:17520:MNWNNTNNS:0:0:0

Microsoft Windows 2000 Server:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:65535:MNWNNTNNS:0:0:0


# Submitted by Jakob Staerk
Microsoft Windows 2000 Professional:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:64512:MNWINNTNNS:0:0:0
# Submitted by Florin Mariutea
Microsoft Windows 2000 Professional Service Pack 4:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8760:MNWNNTNNS:0:0:

# Submitted by Nick Nero
Microsoft Windows NT 4.0 Server:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:3:1:1:1:1:128:8760:M:N:N:N
# Submitted by Ralph Utz
Microsoft Windows NT 4.0 Server:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8280:M:N:N:N
Microsoft Windows NT 4.0 Workstation:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8280:M:N:N:N

Microsoft Windows NT 4.0 Server:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8760:M:N:N:N
Microsoft Windows NT 4.0 Workstation:0:1:1:128:0:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8760:M:N:N:N
Microsoft Windows NT 4.0 Workstation (pre-SP3):0:1:1:128:0:128:1:1:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8760:M:N:N:N
Microsoft Windows NT 4.0 Server (pre-SP3):0:1:1:128:0:128:1:1:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8760:M:N:N:N

# Submitted by George Theall
Microsoft Windows 95:0:1:1:128:0:128:1:1:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8760:MNWNNTNNS:0:0:0

# Submitted by Patrick Davignon - 4.00.950B Build 1111
Microsoft Windows 95:0:1:1:32:0:32:1:1:32:1:0:32:1:8:32:0:1:1:1:1:1:1:1:1:32:8760:M:N:N:N


Microsoft Windows 98:0:1:1:128:1:128:1:1:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:8760:MNNS:N:N:N

# Submitted by George Theall
Microsoft Windows 98SE:0:1:1:128:1:128:1:0:128:1:0:128:1:8:128:0:1:1:1:1:1:1:1:1:128:17520:MNWNNTNNS:0:0:0

# Submitted by W. Anderson
Microsoft Windows 98SE:0:1:1:64:1:64:1:1:64:1:0:64:1:8:64:0:1:1:1:1:1:1:1:1:64:64240:MNNS:N:N:N


# Submitted by Ian Anderson (version is 4.0.1.14)
Netilla Service Platform 4.0:1:1:0:64:1:64:1:0:64:1:0:64:1:>64:64:0:1:1:1:1:1:1:1:0:64:5840:MNNSNW:0:N:N

NetGear ProSafe VPN Firewall (FVS318):1:S:1:64:0:64:1:0:64:1:0:64:1:X:X:X:X:X:X:X:X:X:0:1:32:4095:M:N:N:N
NetGear Wireless Router (MR814):1:1:0:255:0:255:1:0:255:1:1:255:1:X:X:X:X:X:X:X:X:X:0:1:255:2048:M:N:N:N

# Submitted by Mark Basset
Nokia IPSO Firewall:1:1:1:255:0:255:1:0:255:1:0:255:1:X:X:X:X:X:X:X:X:X:0:1:64:16384:MNWNNT:0:1:1


OpenBSD 3.1:1:1:1:255:1:255:1:0:255:1:0:255:1:8:255:0:1:1:2:1:>20:1:1:1:64:17376:MNNSNWNNT:0:1:1
OpenBSD 2.9:1:1:1:255:0:255:1:0:255:1:0:255:1:8:255:0:1:2:1:1:>20:1:1:1:64:16992:MNNSNWNNT:0:1:1
OpenBSD 2.7:0:1:0:64:0:64:1:0:64:1:0:64:1:8:255:0:1:2:2:1:>20:1:0:1:64:16500:MNNSNWNNT:0:1:1

# Submitted by Hal Davis - DEC VMS MultiNet V4.2(16)/ OpenVMS V7.1-2
OpenVMS 7.1:1:1:1:255:1:255:1:1:255:1:1:255:1:8:255:1:1:0:0:3:1:3:1:1:64:6144:MNWNNT:0:1:1

# Solaris
Sun Solaris 7:1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:255:10136:NNTNWM:0:1:1
Sun Solaris 8:1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:64:24616:NNTNWNNSM:0:1:1

# Submitted by Pavel Vachek - Solaris 8 + IP filter
Sun Solaris 8:1:1:1:255:0:255:1:0:255:1:0:255:1:8:64:1:1:1:1:1:1:1:1:1:64:24616:NNTNWNNSM:0:1:1

Sun Solaris 9:1:1:1:255:1:255:1:1:255:1:0:255:1:64:255:1:1:1:1:1:1:1:1:1:64:49232:NNTMNWNNS:0:1:1

# Submitted by Michael Scheidell
VxWorks 5.4:1:1:1:64:1:64:1:0:64:1:0:64:1:8:64:1:1:0:0:3:1:3:0:1:64:8192:MNWNNT:0:1:1
";


function make_ttl(ttl)
{
 if ( ttl <= 32 )
	return 32;
else if ( ttl <= 64 )
return 64;
else if ( ttl <= 128 )
return 128;
else return 255;
}


function icmp_echo_probe()
{
id = rand() % 65534;
ip = forge_ip_packet(ip_v:4, ip_hl:5, ip_tos:6, ip_off:IP_DF,ip_len:20,
		ip_p:IPPROTO_ICMP, ip_id:0x4747, ip_ttl:0x40,
		ip_src:this_host());
icmp = forge_icmp_packet(ip:ip, icmp_type:8, icmp_code:123,
		    icmp_seq: id, icmp_id:id);

for ( i = 0 ; i < MAX_RETRIES ; i ++ )
{
filter = "icmp and src host " + get_host_ip() + " and icmp[0:1]=0 and icmp[6:2] = " + id;
reply = send_packet(icmp, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
if ( reply ) break;
}

if ( reply == NULL ) {  exit(0); }

sig = NULL;
code = get_icmp_element(icmp:reply, element:"icmp_code");

if ( code ) sig = ":1";
else sig = ":0";

ipid = get_ip_element(ip:reply, element:"ip_id");
if ( ipid == 0x4747 ) sig += ":S";
else if (ipid != 0) sig += ":1";
else sig += ":0";

tos = get_ip_element(ip:reply, element:"ip_tos");
#sig += ":[01]";
#if ( tos == 0 ) 
#sig += ":0";
#else 
#sig += ":1";

df_bit = get_ip_element(ip:reply, element:"ip_off");
if ( df_bit & IP_DF ) sig += ":1";
else sig += ":0";

ttl = make_ttl(ttl:get_ip_element(ip:reply, element:"ip_ttl"));

sig += ":" + ttl;

return sig;
}


function icmp_timestamp_probe()
{
ip = forge_ip_packet(ip_hl:5, ip_v:4,   ip_off:0,
	     ip_id:0x4343, ip_tos:0, ip_p : IPPROTO_ICMP,
	     ip_len : 20, ip_src : this_host(),
                     ip_ttl : 255);

 icmp = forge_icmp_packet(ip:ip,icmp_type : 13, icmp_code:0,
                          icmp_seq : 1, icmp_id : 1);


 filter = "icmp and src host " + get_host_ip() + " and icmp[0] = 14";
 for ( i = 0 ; i < MAX_RETRIES ; i ++ )
   {
     reply = send_packet(icmp, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
     if ( reply ) break;
   }

 if ( reply == NULL ) 
 {
  sig = ":0:" + ttl + ":1";
  return sig;
 }
 
 sig = ":1";
 ttl = make_ttl(ttl:get_ip_element(ip:reply, element:"ip_ttl"));
 sig += ":" + ttl;

 ipid = get_ip_element(ip:reply, element:"ip_id");
 if ( ipid == 0x4343 ) { sig += ":S"; ip_id_sent = "S"; }
 else if (ipid != 0) { sig += ":1"; ip_id_sent = "1"; }
 else { sig += ":0"; ip_id_sent = "0"; }
 
 
 return sig;
}


function icmp_netmask_probe()
{
  ip = forge_ip_packet(ip_hl:5, ip_v:4,   ip_off:0,
                     ip_id:0x4444, ip_tos:0, ip_p : IPPROTO_ICMP,
                     ip_len : 20, ip_src : this_host(),
                     ip_ttl : 255);
  icmp = forge_icmp_packet(ip:ip,icmp_type : 17, icmp_code:0,
                          icmp_seq : 1, icmp_id : 1, data:raw_string(0xFF, 0xFF, 0xFF, 0xFF));

 filter = "icmp and src host " + get_host_ip() + " and icmp[0] = 18";
 for ( i = 0 ; i < MAX_RETRIES ; i ++ )
   {
     reply = send_packet(icmp, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
     if ( reply ) break;
   }

 if ( reply == NULL ) 
 {
  sig = ":0:" + ttl + ":" + ip_id_sent;
  return sig;
 }
 
 sig = ":1";
 ttl = make_ttl(ttl:get_ip_element(ip:reply, element:"ip_ttl"));
 sig += ":" + ttl;

 ipid = get_ip_element(ip:reply, element:"ip_id");
 if ( ipid == 0x4444 ) { sig += ":S"; ip_id_sent = "S"; }
 else if (ipid != 0) { sig += ":1"; ip_id_sent = "1"; }
 else { sig += ":0"; ip_id_sent = "0"; }
 
 return sig;
}

function icmp_inforeq_probe()
{
  ip = forge_ip_packet(ip_hl:5, ip_v:4,   ip_off:0,
                     ip_id:0x4545, ip_tos:0, ip_p : IPPROTO_ICMP,
                     ip_len : 20, ip_src : this_host(),
                     ip_ttl : 255);
  icmp = forge_icmp_packet(ip:ip,icmp_type : 15, icmp_code:0,
                          icmp_seq : 1, icmp_id : 1);

 filter = "icmp and src host " + get_host_ip() + " and icmp[0] = 16";
 for ( i = 0 ; i < MAX_RETRIES ; i ++ )
   {
     reply = send_packet(icmp, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
     if ( reply ) break;
   }

 if ( reply == NULL ) 
 {
  sig = ":0:" + ttl + ":" + ip_id_sent;
  return sig;
 }
 
 sig = ":1";
 ttl = make_ttl(ttl:get_ip_element(ip:reply, element:"ip_ttl"));
 sig += ":" + ttl;

 ipid = get_ip_element(ip:reply, element:"ip_id");
 if ( ipid == 0x4545 ) sig += ":S";
 else if (ipid != 0) sig += ":1";
 else sig += ":0";
 
 return sig;
}

function icmp_udpunreach_probe()
{
  local_var i;

  filter = "icmp[30:2] = 42000";
  for ( i = 1 ; i < MAX_RETRIES * 2 ; i ++ )
  {
    filter += " or icmp[30:2] = " + string(42000 + i);
  }

  sig = "";
 filter = "icmp and src host " + get_host_ip() + " and icmp[0] = 3 and (" + filter + ")";


 for ( i = 0 ; i < MAX_RETRIES * 2 ; i ++ )
   {
    ip = forge_ip_packet(ip_v   : 4, ip_hl  : 5, ip_tos : 0, ip_id  : 0x4664, ip_len : 20, ip_off : IP_DF, ip_p   : IPPROTO_UDP, ip_src : this_host(), ip_ttl : 255);
    ip = insstr(ip, raw_string(0x46, 0x64), 4, 5);
    udpip = forge_udp_packet( ip : ip, uh_sport : 53, uh_dport : 42000 + i, uh_ulen :8+128, uh_sum:0, data:crap(128));          

  # Work around a nasl bug.
  reply = send_packet(udpip, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
     if ( reply ) break;
   }
 
 if ( ! reply ) 
 {
  return ":X:X:X:X:X:X:X:X:X:X";
 }

 hl  = get_ip_element(ip:reply, element:"ip_hl");
 len = get_ip_element(ip:reply, element:"ip_len");
 len -= hl * 4 + 8 + 20;

 # udp_echoed_dtsize

 if ( len == 8 ) sig = ":8";
 else if ( len <= 64 ) sig = ":64";
 else sig = ":>64";

 # reply_ttl 
 ttl = make_ttl(ttl:get_ip_element(ip:reply, element:"ip_ttl"));
 sig += ":" + ttl;

 # Precedence bits
 tos = get_ip_element(ip:reply, element:"ip_tos");
 #sig += ":[012]";
 #if ( tos == 0 ) sig += ":0";
 #else if ( tos == 0xc0 ) sig += ":2";
 #else sig += ":1";

 # Unfrag bit
 unfrag = get_ip_element(ip:reply, element:"ip_off");
 if ( unfrag & IP_DF ) sig += ":1";
 else sig += ":0";
 
 # IP ID
 ipid = get_ip_element(ip:reply, element:"ip_id");
 if ( ipid == 0x4664 || ipid == 0x6446) sig += ":S";
 else if (ipid != 0) sig += ":1";
 else sig += ":0";

 # Checksums
 udp = substr(reply, hl * 4 + 8 , strlen(reply) - 1);

 sum = substr(udp, 26, 27);
 udp2 = substr(udp, 20, 25) + raw_string(0,0) + substr(udp, 28, strlen(udp) - 1 );

 pseudo = substr(udp, 12, 19) + raw_string(0, 0x11) + htons(n:strlen(udp) - 20) + udp2;
 
 sum2 = ip_checksum(data:pseudo);
 origsum = substr(udpip, 26,27);
 if ( sum == raw_string(0,0) ) sig += ":0"; 
 else if ( sum == origsum || sum == sum2 ) sig += ":1";
 else sig += ":2";


 sum = get_ip_element(ip:udp, element:"ip_sum");
 udp2 = set_ip_elements(ip:udp, ip_sum:0);
 sum2 = get_ip_element(ip:udp2, element:"ip_sum");
 

 if ( sum == sum2 ) sig += ":1"; 
 else if ( sum == 0 ) sig += ":0";
 else sig += ":2";


 # echoed_ip_id
 ip_id = substr(udp, 4, 5);
 if ( hexstr(ip_id) == "4664" ) sig += ":1";
 else sig += ":3";

 # total_len
 len = get_ip_element(ip:udp, element:"ip_len");
 if ( len == 0x9c || len == 0x9c00 ) sig += ":1";
 else if ( len >= 20) sig += ":>20";
 else sig += ":<20";
 

 # 3bit_flag
 # ????
 off = substr(udp, 6, 7);
 if ( hexstr(off) == "4000" ) sig += ":1";
 else sig += ":3";
 

 return sig;
}


function tcp_synack_probe()
{
 port = get_host_open_port();
 if ( ! port ) {  exit(0); }

 for ( i = 0 ; i < MAX_RETRIES ; i ++ )
 {
 ip = forge_ip_packet(   ip_v : 4,
                        ip_hl : 5,
                        ip_tos : 0x10,
                        ip_len : 20,
                        ip_id : 0x4747,
                        ip_p : IPPROTO_TCP,
                        ip_ttl : 255,
                        ip_off : IP_DF,
                        ip_src : this_host());



  opts = raw_string(2, 4, 1460 / 256, 1460 % 256 );
  opts += raw_string(4, 2);
  time = raw_string(1,2,3,4,5,6,7,8);
  opts += raw_string(8, 10) + time;
  opts += raw_string(1);
  opts += raw_string(3, 3, 0);
  seq   = rand();
  tcpip = forge_tcp_packet(  ip       : ip,
                             th_sport : 4242,
                             th_dport : port,
                             th_flags : TH_SYN,
                             th_seq   : seq,
                             th_ack   : 0,
                             th_x2    : 0,
                             th_off   : (20+strlen(opts))/4,
                             th_win   : 5840,
                             th_urp   : 0, 
			     data     : opts);


     filter = "tcp and src host " + get_host_ip() + " and src port " + port + " and dst port 4242 and tcp[13:1] = " + string(TH_SYN|TH_ACK);
     reply = send_packet(tcpip, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
     if ( strlen(reply) ) {
 	flag = get_tcp_element(tcp:reply, element:"th_flags");
 	if ( flag == TH_SYN|TH_ACK) break;
	}
   }
 
 if ( strlen( reply ) == 0 ) { exit(0); }
 
 
 tos = get_ip_element(ip:reply, element:"ip_tos");
 #sig = ":[^:]*"; 
 sig = "";
 #if ( tos == 0 ) sig = ":0";
 #else sig = ":" + hex(tos);


 df = get_ip_element(ip:reply, element:"ip_off");
 if ( df & IP_DF ) sig += ":1";
 else sig += ":0";

 
 ipid = get_ip_element(ip:reply, element:"ip_id");
 if ( ipid == 0x4747 ) sig += ":S";
 else if (ipid != 0) sig += ":1";
 else sig += ":0";

 ttl = make_ttl(ttl:get_ip_element(ip:reply, element:"ip_ttl"));
 sig += ":" + ttl;

 win = get_tcp_element(tcp:reply, element:"th_win");
 sig += ":" + win;
 
 hl = get_ip_element(ip:reply, element:"ip_hl");
 tcpopts = substr(reply, hl * 4 + 20, strlen(reply) - 1);
 
 str = "";
 blank = "";
 for ( i = 0 ; i < strlen(tcpopts); i ++ )
 {
  if ( ord(tcpopts[i]) == 2 ) str +=  "M";
  else if ( ord(tcpopts[i]) == 1 ) str += "N";
  else if ( ord(tcpopts[i]) == 4 ) str += "S";
  else if ( ord(tcpopts[i]) == 3 ) { 
	str += "W";
	wscale = ord(tcpopts[i+2]);
	}
  else if ( ord(tcpopts[i]) == 8 ) {
	str += "T";
	tsval = substr(tcpopts, i + 2, i + 6 );
        tsecr = substr(tcpopts, i + 6, i + 9);
      }
   else if (ord(tcpopts[i]) == 0 ) {  break; }

  if ( ord(tcpopts[i]) != 1 ) i += ord(tcpopts[i+1]) - 1;
 }
 
 sig += ":" + str;

 if ( !isnull(wscale) )
 {
  sig += ":" + wscale;
 }
 else sig += ":N";

 if ( tsval )
 {
 if( hexstr(tsval) >< "0000000000" ) sig += ":0";
 else sig += ":1";
 }
 else sig += ":N";
 
 if ( tsecr )
 {
 if( hexstr(tsecr) >< "0000000000" ) sig += ":0";
 else sig += ":1";
 }
 else sig += ":N";
 
  
 return sig;
}


#-------------------------------------------------------------------------------------------------#
# MAIN 												  #
#-------------------------------------------------------------------------------------------------#

if ( islocalhost() ) exit(0);


mysig = icmp_echo_probe() + icmp_timestamp_probe() + icmp_netmask_probe() + icmp_inforeq_probe() + icmp_udpunreach_probe() + tcp_synack_probe();




os = egrep(pattern:mysig, string:db);


if ( os )
{
 os = split(os);
 name = "";
 flag = 0;
 foreach os_name (os)
 {
 tmp = split(os_name, sep:":", keep:0);
 if ( strlen(name) == 0 )
	name = tmp[0];
 else
	{
	name += '\n' + tmp[0];
	flag ++;
	}
 }

 if ( strlen ( name ) ) 
 {
 if ( ! flag ) 
	report = "The remote host is running " + name;
 else 
	report = "The remote host is running one of these operating systems : " + '\n' + name;


 set_kb_item(name:"Host/OS/icmp", value:name);

 security_note(port:0, data:report);
 exit(0);
 }
}

if( "X:X:X:X:X:X" >< mysig) {  exit(0); }

results = split(mysig, sep:":", keep:0);
db = egrep(pattern:"^[^#].*", string:db);

foreach sig (split(db))
{
 sig = sig - '\n';
 if ( strlen(sig) > 1 )
 {
 v = split(sig, sep:":", keep:0);
 n = max_index(v);
 os = v[0];
 diff = 0;
 for ( i = 1; i < n ; i ++ )
   if ( v[i] != results[i] ) diff ++;

 differences[os] = diff;
 }
}

m = 999999;
foreach d (differences)  if ( d < m ) m = d;

if ( m < 10 )
{

os = NULL;

foreach i (keys(differences))
{
 if ( differences[i] == m )
  {
   if( ! os ) os = i;
   else os += '\n' + i;
  }
}


report = 'Nessus was not able to reliably identify the remote operating system. It might be:\n' + 
 os + '\nThe fingerprint differs from these known signatures on ' + m + ' points.\n' +
 'If you know what operating system this host is running, please send this signature to\n' +
 'os-signatures@nessus.org : \n' + mysig; 

 security_note(port:0, data:report);
 exit(0);
}




report = "The remote host operating system could not be identified. If you know what this server
is running please send this signature to os-signatures@nessus.org : 
" + mysig;
security_note(port:0, data:report);
