# -*- coding: iso-8859-1 -*-
"""Handle https links"""
# Copyright (C) 2000-2004  Bastian Kleineidam
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import i18n
from HttpUrlData import HttpUrlData, supportHttps
from linkcheck.debug import *


class HttpsUrlData (HttpUrlData):
    """Url link with https scheme"""

    def _check (self):
        if supportHttps:
            super(HttpsUrlData, self)._check()
        else:
            self.setWarning(i18n._("%s url ignored")%self.scheme.capitalize())
            self.logMe()
