'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.4/tcllib-1.4/modules/irc/irc.man' by tcllib/doctools with format 'nroff'
'\"
'\" -*- tcl -*- doctools manpage
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2000/03/06 21:34:53 ericm Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "irc" n 0.3 irc "Low Level Tcl IRC Interface"
.BS
.SH "NAME"
irc \- Create IRC connection and interface.
.SH "SYNOPSIS"
package require \fBTcl \fR
.sp
package require \fBirc  ?0.3?\fR
.sp
\fB::irc::connection\fR \fIhostname\fR\fR
.sp
\fB::irc::config\fR \fIkey\fR \fIvalue\fR\fR
.sp
\fInet\fR \fBregisterevent\fR \fIevent\fR \fIscript\fR\fR
.sp
\fInet\fR \fBconnect\fR\fR
.sp
\fInet\fR \fBuser\fR \fIusername\fR \fIlocalhostname\fR \fIuserinfo\fR\fR
.sp
\fInet\fR \fBnick\fR \fInick\fR\fR
.sp
\fInet\fR \fBping\fR\fR
.sp
\fInet\fR \fBjoin\fR \fIchannel\fR\fR
.sp
\fInet\fR \fBpart\fR \fIchannel\fR\fR
.sp
\fInet\fR \fBprivmsg\fR \fItarget\fR \fImessage\fR\fR
.sp
\fInet\fR \fBsend\fR \fItext\fR\fR
.sp
\fBwho\fR ?\fBaddress\fR?\fR
.sp
\fBaction\fR \fR
.sp
\fBtarget\fR ?\fIindex\fR?\fR
.sp
\fBmsg\fR \fR
.sp
.BE
.SH "DESCRIPTION"
This package provides low-level commands to deal with the IRC protocol
(Internet Relay Chat) for immediate and interactive multi-cast
communication.
.PP
.TP
\fB::irc::connection\fR \fIhostname\fR\fR
The command creates a new object to deal with an IRC connection.
Creating this IRC object does not automatically create the network
connection.  It returns a new irc namespace command which can be used
to interact with the new IRC connection.
.TP
\fB::irc::config\fR \fIkey\fR \fIvalue\fR\fR
Sets configuration \fIkey\fR to \fIvalue\fR.  Currently, the only
config key defined is the boolean flag \fBdebug\fR which, when
turned on, makes \fBirc\fR print more information about what is
going on.
.SH "Per-connection Commands"
.PP
In the following list of available connection methods \fInet\fR
represents a connection command as returned by
\fB::irc::connection\fR.
.TP
\fInet\fR \fBregisterevent\fR \fIevent\fR \fIscript\fR\fR
Registers a callback handler for the specific event.  Events available
are those described in the IRC
RFC 1459 (\fIhttp://www.rfc-editor.org/rfc/rfc1459.txt\fR).
In addition, there are several other events defined.
\fBdefaultcommand\fR adds a command that is called if no other
callback is present.  \fBEOF\fR is called if the connection signals
an End of File condition.
\fIscript\fR is executed in the connection namespace, which can take
advantage of several commands (see \fBCallback Commands\fR
below) to aid in the parsing of data.
.TP
\fInet\fR \fBconnect\fR\fR
This causes the socket to be established.  \fB::irc::connection\fR
created the namespace and the commands to be used, but did not
actually open the socket. This is done here.
.TP
\fInet\fR \fBuser\fR \fIusername\fR \fIlocalhostname\fR \fIuserinfo\fR\fR
Sends USER command to server.  \fIusername\fR is the username you want
to appear.  \fIlocalhostname\fR is the name of your server, and
\fIuserinfo\fR is a short description of who you are.
.TP
\fInet\fR \fBnick\fR \fInick\fR\fR
NICK command.  \fInick\fR is the nickname you wish to use for the
particular connection.
.TP
\fInet\fR \fBping\fR\fR
PING the IRC server.
.TP
\fInet\fR \fBjoin\fR \fIchannel\fR\fR
\fIchannel\fR is the IRC channel to join.  IRC channels typically
begin with a hashmark ("#").
.TP
\fInet\fR \fBpart\fR \fIchannel\fR\fR
Makes the client leave \fIchannel\fR.
.TP
\fInet\fR \fBprivmsg\fR \fItarget\fR \fImessage\fR\fR
Sends \fImessage\fR to \fItarget\fR, which can be either a channel, or
another user, in which case their nick is used.
.TP
\fInet\fR \fBsend\fR \fItext\fR\fR
Sends \fItext\fR to the IRC server.
.SH "Callback Commands"
.PP
These commands can be used within callbacks
.TP
\fBwho\fR ?\fBaddress\fR?\fR
Returns the nick of the user who performed a command.  The optional
keyword \fBaddress\fR causes the command to return the user in the
format "username@address".
.TP
\fBaction\fR \fR
Returns the action performed, such as KICK, PRIVMSG, MODE, etc...
Normally not useful, as callbacks are bound to a particular event.
.TP
\fBtarget\fR ?\fIindex\fR?\fR
Returns the target of a particular command, such as the channel or
user to whom a PRIVMSG is sent.  In the case of multiple targets, the
optional \fIindex\fR argument may be used to specify which one to
return.  The default is 0.
.TP
\fBmsg\fR \fR
Returns the message portion of the command (the part after the :).
.SH "SEE ALSO"
rfc 1459
.SH "KEYWORDS"
chat, irc, rfc 1459