/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Alexander Pipelka
    pipelka@teleweb.at

    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/06/25 17:36:58 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/include/Attic/paragui_doc.h,v $
    CVS/RCS Revision: $Revision: 1.1.2.21 $
    Status:           $State: Exp $
*/

/*! \mainpage ParaGUI Documentation

	\section intro Introduction
	ParaGUI is a cross-platform high-level application framework and GUI (graphical user interface) library.<br>
	It can be compiled on various platforms (Linux, Win32, BeOS, MacOS, ...)<br><br>
	ParaGUI is completely based on the Simple DirectMedia Layer (SDL).<br>
	ParaGUI is targeted on crossplatform multimedia applications and
	embedded devices operating on framebuffer displays.

	\section highlights Highlights of the library
	
	\li published under LGPL<br>
	\li straight forward C++ class-design (see the API documentation)<br>
	\li asynchronous messagehandling (messageposts between objects)<br>
	\li overlapping non-modal translucent widgets<br>
	\li multithreaded<br>
	\li highly customizable widgets<br>
	(background gradients, background images, transparency, colors, fonts)<br>
	\li many standard widgets already implemented<br>
	(buttons, labels, scrollbars, progressbars, windows ...)<br>
	\li create your own widgets<br>
	(subclass an existing widget) <br>
	\li supports various imagetypes through SDL_Image (configurable at compile time)<br>
	\li OpenGL support (via the ParaGL extension library)<br>


	\section install Installation

	\subsection step1 Installing from RPM
	That's the easiest method:
			
	\code
	rpm -Uhv paragui-x.x.x.rpm
	rpm -Uhv paragui-devel-x.x.x.rpm
	\endcode

	and you're set.

	
	\subsection step2 Requirements for building the sources

	\li <a href="http://www.libsdl.org">SDL</a> >= 1.2.0<br>
	\li <a href="http://www.libsdl.org/projects/SDL_ttf/index.html">SDL_ttf</a> >= 1.2.2 / <a href="http://freetype.sourceforge.net/">freetype</a> >= 1.3.1<br>
	\li SDL_ttf >= 2.0.2 / <a href="http://freetype.sourceforge.net/">freetype</a> >= 2.0<br>
	\li <a href="http://www.libsdl.org/projects/SDL_image/index.html">SDL_Image</a> >= 1.2.0 (if enabled)<br>
	\li <a href="http://www.opengl.org">OpenGL</a> (for the ParaGL extension)<br>

	You will also need the correponding development packages.


	\subsection step3 Installation for distributions:
			
	\code
	tar -zxvf paragui-x.x.x.tar.gz
	cd paragui-x.x.x
	./configure [options]
	make
	make install (as root)
	\endcode

	\subsection step4 Installation for CVS snapshots
	Get the snapshot via \ref contribute "CVS checkout" or by downloading a tarball

	\code
	tar -zxvf paragui-cvs.tar.gz
	cd paragui
	sh autogen.sh
	./configure [options]
	make
	make install (as root)
	\endcode

	\subsection step5 Available configure options

	<b>--disable-sdlimage</b><br>
	Compile the sources without SDL_image support.
	Will produce smaller code but only bmp's can be loaded.

	<b>--enable-debug</b><br>
	Will produce debug messages during execution (slow).

	<b>--with-themedir=DIR</b><br>
	ParaGUI themefiles will be placed in DIR.<br>
	Default location is PREFIX/share/paragui


	\subsection step6 Installation hint:
	Several people had troubles compiling CVS snapshots on
	SuSE and Slackware.
	If you get error messages running the autogen.sh script
	please try the following:

	Change this line in autogen.sh<br>
	\code
	aclocal
	\endcode
	to:<br>
	\code
	aclocal -I/usr/local/share/aclocal
	\endcode
			
\latexonly
\pagebreak
\endlatexonly
*/

/** \page Binary Compatibility Issues With C++

	<br>
	Binary compatibility has to be targeted for post 1.0.0 versions of ParaGUI

	Matthias Ettrich from the KDE project has written a very useful document
	that explains the do's and don'ts.

\htmlonly
	The original document can be found <a href="http://developer.kde.org/documentation/kde2arch/devel-binarycompatibility.html">here</a>.
\endhtmlonly

\latexonly
	The original document can be found at developer.kde.org/documentation/kde2arch/devel-binarycompatibility.html
\endlatexonly

	<br>
	Here is an excerpt of the most important things:
	<br>

	<hr><br>
	<h3>The dos and don'ts </h3>

	You can ...
	<ul>

	<li> add new non-virtual functions.

	<li> reimplement virtual functions defined in one of the base classes
	<b>if</b> it is safe that programs linked with the prior version of
	the library call the implementation in the base class rather than the
	new one. <em> This is tricky and might be dangerous. Think twice
	before doing it. </em>

	<li> change an inline function or make an inline function non-inline
	<b>if</b> it is safe that programs linked with the prior version of
	the library call the old implementation. <em> This is tricky and might
	be dangerous. Think twice before doing it. </em>

	<li> Remove private non-virtual function <b>if</b> they are not called
	by any inline functions.

	<li> add new <b>static</b> data members.

	<li> add new classes.

	</ul>

	<p> You cannot ...
	<ul>

	<li> add new virtual functions as this will change the layout of the
	virtual table and thus break subclasses.

	<li> change the order of virtual functions in the class
	declaration. This will just as well change the layout of the virtual
	table.

	<li> change the signature of a function. Note that extending a
	function with another parameter, even if this parameter has a default
	argument, changes the signature and thus is <b>not</b> binary compatible
	(only source compatible). Simply add another function with the same
	name and the extended argument list and add a short BCI (binary
	incompatibiliy issue) note that the two functions shall be merged with
	a default argument in later versions of the library.

	<li> change the access rights to some functions, for example from
	<tt>private</tt> to <tt>public</tt>. With some compilers, this
	information may be part of the signature. If you need to make a
	private function protected or even public, you have to add a new
	function that calls the private one.

	<li> add new data members to a class except static ones.

	<li> change the class hierachy apart from adding new classes.

	</ul>
       <br>

\htmlonly
	<p align=right> <small> <em>
	Matthias Ettrich <a href="mailto:ettrich@kde.org">ettrich@kde.org</a>
	</em></small></p>
\endhtmlonly
\latexonly
\pagebreak
\endlatexonly
*/

/**	\page coding Coding conventions for ParaGUI

<h2>The Easy Route</h2>

Grab astyle, a code formatter for C, C++, and Java, from astyle.sourceforge.net.
All code in the repository should be run through astyle
before being committed, with these options:

<pre>astyle --style=kr --indent=tab filename</pre>

Doing this has several advantages:
<ul>
	<li>Code in the repository will be consistently
	    formatted.
	<li>You don't have to worry about the coding
	    conventions while coding, or at all for that
	    matter.
	<li>You can reformat code to your own personal
	    style preference while working on it, and
	    then easily convert it back to the way it was,
	    along with your added code.  Since astyle will
	    format it in the exact same way, patches won't
	    be filled with many lines of useless formatting
	    changes.
	<li>It's easy.
</ul>

Note: don't make a habit of formatting all source files
('just to be sure') instead of just the ones you modified.
This will update the timestamps on the files and cause all
hell to break loose.

Here's an outline of the code format, for the sake of
completeness.. but use astyle. Please.

<h2>Sample code:</h2>

\code
// No, this code is not supposed to make sense
void foo(int bar) {
	if (bar < 7) {
		cout << bar << endl;
	}
	else {
		cout << "That's a big bar you got there.";
	}
}
\endcode

<h2>Things to notice:</h2>

<ul>
	<li>C++ style comments are best for few-line comments
	<li>Use C comments for commenting large blocks
	<li>K&R style braces, with one space before the first brace
	<li>No spaces padding the inside of parenthesis
	<li>One space padding of operators on both sides
	<li>An if statement's block will always be enclosed in braces,
	    even if it is just one line.
	<li>Hard tabs for indents
	<li>And the most important thing of all, no matter what you do:
	  <b>Do not assume anything about the length of a tab.</b>
	  This means don't mix tabs and spaces in an interchangeable way.
	  This way, everything that looks nice in an editor with 8-space
	  tabs, will look just fine in an editor with 4-space tabs, etc.
</ul>
\latexonly
\pagebreak
\endlatexonly

*/

/**	\page requirements	Requirements for compiling ParaGUI

	ParaGUI is completely based on SDL from Sam Lantinga. <br>
	You have to checkout the following libs from his <a href="http://www.libpg.org">website</a>: <p>

	<ul>
		<li><h2><b>ParaGUI Version <= 0.5.2: </b></h2><br><br>

			SDL (Simple Directmedia Layer) Version <= 1.1.4 <br>
			SDL_ttf (True Type Font Rendering Engine for SDL) Version <= 1.2.1 <br>
			FreeType >= 1.2.0 <br><br>

		<li><h2><b>ParaGUI Version >= 0.5.3: </b></h2><br><br>

			SDL (Simple Directmedia Layer) Version >= 1.1.5 <br>
			or the latest snapshot from the CVS repository <br>
			SDL_ttf (True Type Font Rendering Engine for SDL) Version >= 1.2.2 <br>
			FreeType >= 1.2.0<br><br>

		<li><h2><b>ParaGUI Version >= 0.6.5: </b></h2><br><br>

			SDL (Simple Directmedia Layer) Version >= 1.2.0 <br>
			or the latest snapshot from the CVS repository <br>
			SDL_ttf (True Type Font Rendering Engine for SDL) Version >= 1.2.2 <br>
			FreeType >= 1.2.0<br>
			SDL_Image >= 1.1.0 (if enabled)<br><br>
	</ul>
\latexonly
\pagebreak
\endlatexonly
*/

/**	\page	contribute	Contributing (A small CVS guide)

<br>
<ol>
	<li>Download the sourcetree via CVS<br>
	<br>
		<i>cvs -d :pserver:guest@www.bms-austria.com:/usr/local/CVSROOT login<br>
		password: guest<br>
		<br>
		cvs -d :pserver:guest@www.bms-austria.com:/usr/local/CVSROOT -z3 checkout -r devel-0-7 paragui<br>
		<br>
		sh autogen.sh<br>
		./configure<br>
		make<br>
		make install (as root)<br>
		<br><br>
		</i>
	<li>Make your changes<br>
	<br>
	<li>Sync with the repository<br>
	<br>
	<i>cvs -z3 update -d -P<br>
	</i>
	<br><br>
	<li>Create a patchfile<br>
	<br>
		<i>cvs -z3 diff -c3p<br>
		</i>
		<br><br>
		<li>Send the patchfile via email to <a href="mailto:pipelka@bms-austria.com">me</a><br>
		Please give a short (or even longer) description what the patch exactly does.<br>
		<br><br>
</ol>
\latexonly
\pagebreak
\endlatexonly
*/

/**	\page	roadmap		The current roadmap (TODO's and plans)

\verbinclude TODO
\latexonly
\pagebreak
\endlatexonly

*/

/**
	\page screenshots	ParaGUI screenshots

	<br>
	<H2>Demo applications</H2>
	<br>
\htmlonly <center> \endhtmlonly
	Just 2 of these useless applications demonstrating the capabilities of a library.<br>
	;-)
	<br><br>
\htmlonly
	</center>
	<table border="0" cellpadding="0" cellspacing="0" width="100%">
	<center>
	<tr>
		<td width="50%" valign="top">
		<center>
		<img src="images/shot1-small.png"><br><a href="images/shot1.png">Large</a><br>
		<b>Example application with the default theme</b>
		</center>
		<br><br>
		</td>

		<td width="50%" valign="top">
		<center>
		<img src="images/shot2-small.png"><br><a href="images/shot2.png">Large</a><br>
		<b>A shot from the OpenGL demo application</b>
		</center>
		<br><br>
		</td>
	</tr>
	</center>
	</table>
\endhtmlonly
	\image latex shot1-small.eps "Example application with the default theme"
	\image latex shot2-small.eps "A shot from the OpenGL demo application"
	<br><br>

	<H2>Some shots from PacWars2 (pw2.sourceforge.net)</H2>

\htmlonly <center> \endhtmlonly
	<br>
	It is a project which was inspired by the old network game called PacWars.<br>
	The PacWars game was created by Iain Syme in 1990-91.<br>
	This new version was written by Antonin Hildebrand.
	<br><br>
\htmlonly
	<center>
	<table border="0" cellpadding="0" cellspacing="0" width="100%">
	<tr>
		<td width="50%" valign="top">
		<center>
		<img src="images/pw2-small-1.png"><br><a href="images/pw2-1.png">Large</a><br>
		<b>PW2 startscreen</b>
		</center>
		<br><br>
		</td>

		<td width="50%" valign="top">
		<center>
		<img src="images/pw2-small-2.png"><br><a href="images/pw2-2.png">Large</a><br>
		<b>The options dialog (sound)</b>
		</center>
		<br><br>
		</td>
	</tr>

	<tr>
		<td width="50%" valign="top">
		<center>
		<img src="images/pw2-small-3.png"><br><a href="images/pw2-3.png">Large</a><br>
		<b>Info 'bout weapons & bonuses</b>
		</center>
		<br><br>
		</td>

		<td width="50%" valign="top">
		<center>
		<img src="images/pw2-small-4.png"><br><a href="images/pw2-4.png">Large</a><br>
		<b>Create a new player</b>
		</center>
		<br><br>
		</td>
	</tr>
	</center>
	</table>
\endhtmlonly

	<br><br>

	<H2>easyDose - radiation management system</H2>
	<br>
\htmlonly <center> \endhtmlonly
	This is our first commercial project based on ParaGUI.<br>
	It is used in several hospitals in Austria to acquire and manage
	radiaton dose data from different modalities.<br>
	The application runs on a small embedded device operated via touch-screen.
	<br><br>

\htmlonly
	</center>
	<table border="0" cellpadding="0" cellspacing="0" width="100%">
	<tr>
		<td width="50%" valign="top">
		<center>
		<img src="images/radi1-small.png"><br><a href="images/radi1.png">Large</a><br>
		<b>easyDose startscreen</b>
		</center>
		<br><br>
		</td>

		<td width="50%" valign="top">
		<center>
		<img src="images/radi2-small.png"><br><a href="images/radi2.png">Large</a><br>
		<b>worklist dialog</b>
		</center>
		<br><br>
		</td>
	</tr>

	<tr>
		<td width="50%" valign="top">
		<center>
		<img src="images/radi3-small.png"><br><a href="images/radi3.png">Large</a><br>
		<b>manual patient selection</b>
		</center>
		<br><br>
		</td>

		<td width="50%" valign="top">
		<center>
		<img src="images/radi4-small.png"><br><a href="images/radi4.png">Large</a><br>
		<b>radiation acquistion screen</b>
		</center>
		<br><br>
		</td>
	</tr>
	</table>
\endhtmlonly
\latexonly
\pagebreak
\endlatexonly
*/

/**
	\page VisualC ParaGUI & VisualC++

	<H2>PARGUI project files for Microsoft Visual C++ 6.0</H2>

	You can either use the precompiled libraries from the ParaGUI web site, or you can build ParaGUI yourself.

	<H2>Directory structure</H2>

	The following directories should be created in the ParaGUI root directory:

	\li bin => place for binary files (.dll, .exe), paragui examples, paragui dlls
	\li lib => library files (.lib)
	\li src => ParaGUI source files
	\li include => directory for common headers
	\li expat => expat source files (ParaGUI module)
	\li themes => themes source files (ParaGUI module)
	\li test => example sources
	\li VisualC => MSVC++ project files & workspaces (created after unzipping from VisualC.zip)

	<H2>Library files</H2>

	First you have to choose if you want to link your application  dynamically or statically against
	ParaGUI. For dynamic linkage you need the dynamic link library (DLL) and the import library
	(LIB). For static linkage you only need the static library (LIB). If your application should be
	compiled multi-threaded use the multi-threaded static library.

	\li paragui.dll + paragui.lib => release mode dynamic link library and import library
	\li paraguid.dll + paraguid.lib => debug mode dynamic link library and import library
	\li paraguis.lib => release mode static link library (single threaded)
	\li paraguisd.lib => debug mode static link library (single threaded)
	\li paraguimts.lib => release mode static link library (multi threaded)
	\li paraguimtsd.lib => debug mode static link library (multi threaded)

	Note: The ParaGUI library is under LGPL licence. See <a href="http://www.bms-austria.com/projects/paragui/license.html">licence</a> for terms of linking
	with ParaGUI.

	<H2>Building ParaGUI</H2>

	<ol>
	<li> Unzip the VisualC.zip file in the root ParaGUI directory.<br>
		Be certain that you unzip it into this directory and not any other directory.
		If you are using WinZip, be careful to make sure that it extracts into this
		folder, because it's convenient feature of unzipping to a folder with the
		name of the file currently being unzipped will get you in trouble if you
		use it right now.<br><br>
	<li> Go into the VisualC directory that is created, and open the workspace file " paragui_all.dsw " with MSVC++.<br>
		You may be prompted at this point to upgrade the workspace, if you are
		using a more recent version of MSVC++. If so, allow the workspace to be upgraded.<br><br>
	<li> Choose dynamic or static paragui project.<br>
		This is done by right clicking on each project in turn (Projects are listed in the
		Workspace panel in the FileView tab), and selecting "Set as active  project".<br><br>
	<li> ParaGUI depends on sdl.lib, sdl_ttf.lib, sdl_image.lib (when HAVE_SDLIMAGE is defined) and freetype.lib<br><br>
		<ol>
		<li> You need to supply these libraries to the linker. There are three ways how to do this:<br><br>
			Go to "Tools|Options|Directories|Library files", and add proper paths to all listed .lib files<br>
			Go to "Project|Settings|Link|Category: Input|Additional Library Path", add here path to libs (relative or absolute)<br>
			Find .lib files and copy them into /lib directory in your ParaGUI root. This dir is preset to be on the library path.<br><br>
		<li> You also need set paths to header files of these libraries. There are also several ways how to do this:<br><br>
			Go to "Tools|Options|Directories|Include files", and add proper paths to all listed .lib files<br>
			Go to "Project|Settings|C/C++|Category:  Preprocessor|Additional Include directories", add here paths to headers
			(relative or absolute)<br>
			Find .h files and copy them into /include directory in your ParaGUI root. This dir
			is preset to be on the include path.<br><br>
		</ol>
	<li> Choose the proper configuration from "Build|Configurations...":<br><br>
		<ol>
		<li> For <b>paragui_dynamic</b> there are<br><br>
			<b>Release</b> => produces release mode dynamic link library and import library [bin/paragui.dll, lib/paragui.lib]<br>
			<b>Debug</b> => produces debug mode dynamic link library and import library    [bin/paraguid.dll, lib/paraguid.lib]<br><br>
		<li>For <b>paragui_static</b> there are<br><br>
			<b>Release</b> = >  produces release mode static link library (single threaded) [lib/paraguis.lib]<br>
			<b>Debug</b> => produces debug mode static link library (single threaded) [lib/paraguisd.lib]<br>
			<b>Release MT</b> => produces release mode static link library (multi threaded) [lib/paraguimts.lib]<br>
			<b>Debug MT</b> =>  produces debug mode static link library (multi threaded) [lib/paraguimtsd.lib]<br><br>
		</ol>
	<li> Build the project with the "Project|Build" command.<br>
		You may get a few warnings, but you should not get any errors. If
		yes check again. If you did it all correctly, check types of
		libraries sdl.lib, sdl_ttf.lib, sdl_image.lib, freetype.lib. They must
		be compiled in mode Multithreaded DLL. Anyway check troubleshoting section.<br><br>
	<li> Your library files are created. Check if you find them in /lib and /bin directories.<br><br>
	</ol>

	<H2>Building example files for ParaGUI</H2>

	\li Build paragui_dynamic project library files as described in <b>Building ParaGUI library</b>.<br><br>
	\li Choose the example project you want build "As active project".<br><br>
	\li Example projects are dependent on sdlmain.lib (lib file which comes with SDL library).<br>
		Add it to paths in similar way as is described in step 4. of <b>Building ParaGUI library</b>.<br><br>
	\li Choose the configuration Debug or Release same way as step 5. of Building ParaGUI library.<br><br>
	\li Build the project with "Project|Build" command.<br>
		File [/bin/<examplename>.exe] should becreated in the "bin" directory.<br><br>
	\li Test your ParaGUI example.<br>
		It will need some dlls to run (sdl.dll, sdl_image.dll). Just copy
		them to bin directory or move them into system searching paths for dlls.<br><br>

	<H2>Troubleshooting</H2>

	\li I don't want to use SDL_Image library. I just want to load BMP files.<br>
		<b>Answer:</b> remove HAVE_SDLIMAGE define from project settings.<br>
		"Project|Settings|C/C++|Category: Preprocessor|Preprocessor definitions".<br>
		Now you don't have to supply sdl_image.lib and SDL_Image header files.<br><br>
	\li I want to link example files statically with ParaGUI.<br>
		<b>Answer:</b> specify another ParaGUI library to link with in project setting:<br>
		"Project|Settings|Link|Category: General|Object/library modules", change paragui.lib to paraguis.lib (or
		paraguid.lib  to paraguisd.lib), or use multithreaded versions of static library.<br>
		Don't  forget to set proper code generation for example project:<br>
		"Project|Settings|C/C++|Category:  Code generation|Use runtime library.<br><br>
	\li I get compiler errors like: "fatal error C1083: Cannot open include file: 'SDL_image.h': No such file or directory"<br>
		<b>Answer:</b> header files of library were not found by the compiler. You did step 4b wrong.<br><br>
	\li I get linker errors like: "fatal error LNK1104: cannot open file "sdl.lib""<br>
		<b>Answer:</b> lib file was not found by the linker. You did step 4a wrong.<br><br>
	\li I get linker errors like: "error LNK2005: __alloc_osfhnd already defined in LIBC.lib(osfinfo.obj)"<br>
		<b>Answer:</b> you are mixing libraries of different types
		(static vs. dynamic, multithreaded vs. singlethreaded, etc.)<br><br>
	\li I get linker warnings like: "warning LNK4098: defaultlib "msvcrt.lib" conflicts with use of other libs; use /NODEFAULTLIB:library"<br>
		<b>Answer:</b> you are mixing libraries of different types
		(static vs. dynamic, multithreaded vs. singlethreaded, etc.), but it was only a warning - the project got compiled.<br><br>

\htmlonly
 2001 Documentation written by <a href="mailto:woid@centrum.cz">Antonin Hildebrand</a><br>
 2001 ParaGUI library by Alexander Pipelka
\endhtmlonly
\latexonly
\pagebreak
\endlatexonly
*/


/**
	\page	tut1		TUTORIAL 1 - application initialization, eventloop
	\include tut1.cpp
	\latexonly
	\pagebreak
	\endlatexonly
*/

/**
	\page tut2		TUTORIAL 2 - our first widget (a button)
	\include tut2.cpp
	\latexonly
	\pagebreak
	\endlatexonly
*/

/**
	\page tut3		TUTORIAL 3 - callback functions
	\include tut3.cpp
	\latexonly
	\pagebreak
	\endlatexonly
*/

/**
	\page tut4		TUTORIAL 4 - custom widgets
	\include tut4.cpp
	\latexonly
	\pagebreak
	\endlatexonly
*/

/**
	\page tut5		TUTORIAL 5 - member callbacks, message exchange between widgets
	\include tut5.cpp
	\latexonly
	\pagebreak
	\endlatexonly
*/

/**
	\page tut6		TUTORIAL 6 - mouse event functions - part 1
	\include tut6.cpp
	\latexonly
	\pagebreak
	\endlatexonly
*/

/**
	\page tut7		TUTORIAL 7 - mouse event functions - part 2
	\include tut7.cpp
	\latexonly
	\pagebreak
	\endlatexonly
*/
