#
# Copyright (C) 2004 Tenable Network Security 
#
#

if(description)
{
 script_id(12009);
 script_version("$Revision: 1.1 $");

 name["english"] = "ALEXA detection";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using the ALEXA program.  
You should ensure that:
- the user intended to install ALEXA (it is sometimes silently installed)
- the use of ALEXA matches your corporate mandates and security policies.

To remove this sort of software, you may wish to check out ad-aware or spybot. 

See also : http://pestpatrol.com/PestInfo/a/alexa.asp


Solution : Uninstall this software
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "ALEXA detection";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_full_access.nasl");
 script_require_keys("SMB/registry_full_access");

 script_require_ports(139, 445);
 exit(0);
}


# start the script
if ( !get_kb_item("SMB/registry_full_access") ) exit(0);

path[0] = "clsid\{3df73df8-41e2-4fc2-8cbf-4b9407433755}";
path[1] = "software\microsoft\internet";
path[2] = "software\microsoft\internet explorer\extensions\{c95fe080-8f5d-11d2-a20b-00aa003c157a}";



include("smb_nt.inc");

for (i=0; path[i]; i++) {
    if (key[i]) {
        rootfile = registry_get_sz(key:path[i], item:key[i]);
        if(rootfile) {
           mypattern = string(".*", regx[i], ".*");
           if (egrep(string:rootfile, pattern:mypattern)) {security_hole(kb_smb_transport()); exit(0);}
       }
    } else {
       val = registry_get_acl(key:path[i]);
       if(val != NULL) {security_hole(kb_smb_transport()); exit(0); } 
    } 
}


