// -*- c++ -*-
//  Generated by gtkmmproc from /usr/obj/ports/gtkmm-1.2.10/gtkmm-1.2.10/src/build_sources/../statusbar.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_STATUSBAR_H
#define _GTKMM_STATUSBAR_H

/* $Id: statusbar.gen_h,v 1.49 2001/07/15 13:33:38 murrayc Exp $ */

/* statusbar.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/box.h>
#include <gtk/gtkstatusbar.h>

namespace Gtk {
class Statusbar;
class Statusbar_Class;
}
namespace Gtk { Gtk::Statusbar *wrap (GtkStatusbar *o); }
namespace Gtk
{

namespace Statusbar_Helpers
{
  class Message: protected GtkStatusbarMsg
    {
      private:
        Message& operator=(const Message&);
        Message(const Message&);
      protected:
        Message(void* do_not_derive_this);
      public:
        inline string get_text() {return text;}
        inline guint get_context_id() {return context_id;}
        inline guint get_message_id() {return message_id;}
    };

  struct Element
    {
     guint context_id;
     string message;
     Element(const char* str) : context_id(1), message(str) {}
     Element(const string& str) : context_id(1), message(str) {}
     Element(guint cid,const string& str) : context_id(cid), message(str) {}
    };

  class MsgList
    {
      public:
        typedef Message*                           value_type;
        typedef value_type &                       reference;
        typedef const value_type &                 const_reference;

        typedef G_SList_Iterator<value_type>       iterator;
        typedef G_List_ConstIterator<iterator>     const_iterator;

        typedef size_t                             difference_type;
        typedef size_t                             size_type;

      private:
        friend class Gtk::Statusbar;
        Gtk::Statusbar *parent_;
        explicit MsgList(Statusbar* parent): parent_(parent) {}

        GSList*& glist() const;

      public:
        ~MsgList() {}

        iterator begin();
        iterator end();

        inline const_iterator begin() const
          { return const_iterator(begin()); }
        inline const_iterator end() const
          { return const_iterator(end()); }

        void push_front(const Element& e);
        inline void pop_front() { erase(begin()); }

        inline void clear() { erase(begin(),end()); }
        size_type size(void) const;
        inline size_type max_size(void) { return size_type(-1); }
        inline bool empty(void) { return glist() == 0; }

        iterator erase(iterator);
        void erase(iterator start, iterator stop);
        void remove(const_reference);
    };

};

//: Text status indicator
//- This widget is used to display status information.
//- Messages are pushed and poped onto a message stack.
//- When text is pushed it replaces the old contents.
//- The old text is restored when popped.
//-
//- It derives from Gtk_HBox so that additional information can be added
//- easily.
//-
//- The message list can be accessed through the messages() list.
class Statusbar : public HBox
{

public:
  typedef Statusbar          CppObjectType;
  typedef Statusbar_Class    CppClassType;
  typedef GtkStatusbar           BaseObjectType;
  typedef GtkStatusbarClass      BaseClassType;

private:
  friend class Statusbar_Class;
  static CppClassType statusbar_class;

  Statusbar(const Statusbar&);
  Statusbar& operator=(const Statusbar&); // not implemented

protected:
  void   initialize_class();
  explicit Statusbar(GtkStatusbar *castitem);

public:
  static GtkType get_type();
  GtkStatusbar* gtkobj()             { return (GtkStatusbar*)(gtkobject); }
  const GtkStatusbar* gtkobj() const { return (GtkStatusbar*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~Statusbar();

private:

public:
  typedef Statusbar_Helpers::MsgList MsgList;

  Statusbar();



  //: Is emitted whenever a new message gets pushed onto a statusbar's stack.

  //: Is emitted whenever a new message is popped off a statusbar's stack.


  //: Returns a new context identifier, given a description of the actual context.
  //- {\var context_description}: Textual description of what context the new message is being used in.
  //-
  //- {\var Returns}: An integer id.


  guint get_context_id(const nstring& context_description) const;

  //: Pushes a new message onto a statusbar's stack.
  //- {\var context_id}: The message's context id, as returned by {get_context_id()}.
  //-
  //- {\var text}: The message to add to the statusbar.
  //-
  //- {\var Returns}: The message's new message id for use with {remove()}.



  guint push(guint context_id,const nstring& text);

  //: Removes the message at the top of a GtkStatusBar's stack.
  //- {\var context_id}: A context identifier.


  void pop(guint context_id);

  typedef G_SList_Iterator < GtkStatusbarMsg * > iterator;
  iterator messages_begin() { return iterator(gtkobj()->messages);}
  iterator messages_end() { return iterator(static_cast<GSList*>(0));}

  //: Forces the removal of a message from a statusbar's stack. The exact context_id and message_id must be specified.
  //- {\var context_id}: A context identifier.
  //-
  //- {\var message_id}: A message identifier, as returned by {push()}.

  void remove_message(guint context_id,guint message_id);

  MsgList& messages()
    {return reinterpret_cast<MsgList&>(widget_self); }
  const MsgList& messages() const
    {return reinterpret_cast<const MsgList&>(widget_self); }

public:

  union
    {
      CppObjectType * statusbar_self;
      Gtk::ProxySignal2<void,guint,const gchar*,CppObjectType,BaseObjectType,0> text_pushed;
      Gtk::ProxySignal2<void,guint,const gchar*,CppObjectType,BaseObjectType,1> text_popped;
    };

protected:
  // impl functions
    virtual void text_pushed_impl(guint p0,const gchar* p1);
    virtual void text_popped_impl(guint p0,const gchar* p1);

};

}


//+ PROPERTIES(Gtk_StatusBar)
//. name: frame
//. type: Gtk_Widget*
//. get:
//. set:
//. desc:

//. name: label
//. type: Gtk_Widget*
//. get:
//. set:
//. desc:

//. name: messages
//. type: GSList*
//. get:
//. set:
//. desc:

//. name: keys
//. type: GSList*
//. get:
//. set:
//. desc:

//. name: seq_context_id
//. type: guint
//. get:
//. set:
//. desc:

//. name: seq_message_id
//. type: guint
//. get:
//. set:
//. desc:

#endif
