require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_MACHINE)) {
    sub _MACHINE () {	 &alpha;}
}
unless(defined(&MACHINE)) {
    sub MACHINE () {	"alpha";}
}
unless(defined(&_MACHINE_ARCH)) {
    sub _MACHINE_ARCH () {	 &alpha;}
}
unless(defined(&MACHINE_ARCH)) {
    sub MACHINE_ARCH () {	"alpha";}
}
unless(defined(&MID_MACHINE)) {
    sub MID_MACHINE () {	 &MID_ALPHA;}
}
require 'machine/alpha_cpu.ph';
require 'machine/cpu.ph';
unless(defined(&ALIGNBYTES)) {
    sub ALIGNBYTES () {	7;}
}
unless(defined(&ALIGN)) {
    sub ALIGN {
	local($p) = @_;
	eval q(((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES));
    }
}
unless(defined(&ALIGNED_POINTER)) {
    sub ALIGNED_POINTER {
	local($p,$t) = @_;
	eval q((((($p)) & ($sizeof{$t}-1)) == 0));
    }
}
unless(defined(&NBPG)) {
    sub NBPG () {	(1<<  &ALPHA_PGSHIFT);}
}
unless(defined(&PGOFSET)) {
    sub PGOFSET () {	( &NBPG-1);}
}
unless(defined(&PGSHIFT)) {
    sub PGSHIFT () {	 &ALPHA_PGSHIFT;}
}
unless(defined(&PAGE_SHIFT)) {
    sub PAGE_SHIFT () {	13;}
}
unless(defined(&PAGE_SIZE)) {
    sub PAGE_SIZE () {	(1<<  &PAGE_SHIFT);}
}
unless(defined(&PAGE_MASK)) {
    sub PAGE_MASK () {	( &PAGE_SIZE - 1);}
}
unless(defined(&KERNBASE)) {
    sub KERNBASE () {	0xfffffc0000230000;}
}
unless(defined(&BTOPKERNBASE)) {
    sub BTOPKERNBASE () {	( &KERNBASE >>  &PGSHIFT);}
}
unless(defined(&DEV_BSIZE)) {
    sub DEV_BSIZE () {	512;}
}
unless(defined(&DEV_BSHIFT)) {
    sub DEV_BSHIFT () {	9;}
}
unless(defined(&BLKDEV_IOSIZE)) {
    sub BLKDEV_IOSIZE () {	2048;}
}
unless(defined(&MAXPHYS)) {
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
}
unless(defined(&SSIZE)) {
    sub SSIZE () {	1;}
}
unless(defined(&SINCR)) {
    sub SINCR () {	1;}
}
unless(defined(&UPAGES)) {
    sub UPAGES () {	2;}
}
unless(defined(&USPACE)) {
    sub USPACE () {	( &UPAGES *  &NBPG);}
}
unless(defined(&USPACE_ALIGN)) {
    sub USPACE_ALIGN () {	(0);}
}
unless(defined(&MSGBUFSIZE)) {
    eval 'sub MSGBUFSIZE () { &NBPG;}' unless defined(&MSGBUFSIZE);
}
unless(defined(&MSIZE)) {
    sub MSIZE () {	256;}
}
unless(defined(&MCLSHIFT)) {
    eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
}
unless(defined(&MCLBYTES)) {
    sub MCLBYTES () {	(1<<  &MCLSHIFT);}
}
unless(defined(&MCLOFSET)) {
    sub MCLOFSET () {	( &MCLBYTES - 1);}
}
unless(defined(&NMBCLUSTERS)) {
    sub NMBCLUSTERS () {	4096;}
}
unless(defined(&NKMEMPAGES_MIN_DEFAULT)) {
    sub NKMEMPAGES_MIN_DEFAULT () {	((8* 1024* 1024) >>  &PAGE_SHIFT);}
}
unless(defined(&NKMEMPAGES_MAX_DEFAULT)) {
    sub NKMEMPAGES_MAX_DEFAULT () {	((128* 1024* 1024) >>  &PAGE_SHIFT);}
}
unless(defined(&ctod)) {
    sub ctod {
	local($x) = @_;
	eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&dtoc)) {
    sub dtoc {
	local($x) = @_;
	eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&ctob)) {
    sub ctob {
	local($x) = @_;
	eval q((($x) <<  &PGSHIFT));
    }
}
unless(defined(&btoc)) {
    sub btoc {
	local($x) = @_;
	eval q(((($x) +  &PGOFSET) >>  &PGSHIFT));
    }
}
unless(defined(&btodb)) {
    sub btodb {
	local($x) = @_;
	eval q((($x) >>  &DEV_BSHIFT));
    }
}
unless(defined(&dbtob)) {
    sub dbtob {
	local($x) = @_;
	eval q((($x) <<  &DEV_BSHIFT));
    }
}
unless(defined(&bdbtofsb)) {
    sub bdbtofsb {
	local($bn) = @_;
	eval q((($bn) / ( &BLKDEV_IOSIZE/ &DEV_BSIZE)));
    }
}
unless(defined(&alpha_round_page)) {
    sub alpha_round_page {
	local($x) = @_;
	eval q((((($x)) +  &NBPG - 1) & ~( &NBPG-1)));
    }
}
unless(defined(&alpha_trunc_page)) {
    sub alpha_trunc_page {
	local($x) = @_;
	eval q((($x) & ~( &NBPG-1)));
    }
}
unless(defined(&alpha_btop)) {
    sub alpha_btop {
	local($x) = @_;
	eval q((($x) >>  &PGSHIFT));
    }
}
unless(defined(&alpha_ptob)) {
    sub alpha_ptob {
	local($x) = @_;
	eval q((($x) <<  &PGSHIFT));
    }
}
if(defined(&_KERNEL)) {
    unless(defined(&_LOCORE)) {
	require 'machine/intr.ph';
	eval 'sub DELAY {
	    local($n) = @_;
    	    eval q( &delay($n));
	}' unless defined(&DELAY);
    }
}
1;
