/*-
 * Copyright (c) 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Ralph Campbell.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "SYS.h"

#if defined(SYSLIBC_SCCS)
	.text
	.asciz "$OpenBSD: brk.S,v 1.6 2003/06/02 20:18:32 millert Exp $"
#endif /* SYSLIBC_SCCS */

	.globl	minbrk
	.globl	curbrk

	.data
minbrk:	.word	_C_LABEL(end)
	.text

LEAF(brk)
	.set	reorder
	lw	v0, minbrk
	bltu	a0, v0, 1f
	la	t9, _brk
	jr	t9
1:
	move	a0, v0		# dont allow break < minbrk
	li	v0, SYS_break
	syscall
	bne	a3, zero, 2f
	sw	a0, curbrk
	move	v0, zero
	j	ra
2:
	la	t9, _C_LABEL(cerror)
	jr	t9
END(brk)

LEAF(_brk)
	.set	reorder
	li	v0, SYS_break
	syscall
	bne	a3, zero, 1f
	sw	a0, curbrk
	move	v0, zero
	j	ra
1:
	la	t9, _C_LABEL(cerror)
	jr	t9
END(brk)
