require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&PIIX_BMIBA)) {
    sub PIIX_BMIBA () {	0x20;}
}
unless(defined(&PIIX_BMIBA_ADDR)) {
    sub PIIX_BMIBA_ADDR {
	local($x) = @_;
	eval q(($x & 0xffff0));
    }
}
unless(defined(&PIIX_BMIBA_RTE)) {
    sub PIIX_BMIBA_RTE {
	local($x) = @_;
	eval q(($x & 0x1));
    }
}
unless(defined(&PIIX_BMIBA_RTE_IO)) {
    sub PIIX_BMIBA_RTE_IO () {	0x1;}
}
unless(defined(&PIIX_IDETIM)) {
    sub PIIX_IDETIM () {	0x40;}
}
unless(defined(&PIIX_IDETIM_READ)) {
    sub PIIX_IDETIM_READ {
	local($x, $channel) = @_;
	eval q(((($x) >> (16* ($channel))) & 0xffff));
    }
}
unless(defined(&PIIX_IDETIM_SET)) {
    sub PIIX_IDETIM_SET {
	local($x, $bytes, $channel) = @_;
	eval q((($x) | (($bytes) << (16* ($channel)))));
    }
}
unless(defined(&PIIX_IDETIM_CLEAR)) {
    sub PIIX_IDETIM_CLEAR {
	local($x, $bytes, $channel) = @_;
	eval q((($x) & ~(($bytes) << (16* ($channel)))));
    }
}
unless(defined(&PIIX_IDETIM_IDE)) {
    sub PIIX_IDETIM_IDE () {	0x8000;}
}
unless(defined(&PIIX_IDETIM_SITRE)) {
    sub PIIX_IDETIM_SITRE () {	0x4000;}
}
unless(defined(&PIIX_IDETIM_ISP_MASK)) {
    sub PIIX_IDETIM_ISP_MASK () {	0x3000;}
}
unless(defined(&PIIX_IDETIM_ISP_SHIFT)) {
    sub PIIX_IDETIM_ISP_SHIFT () {	12;}
}
unless(defined(&PIIX_IDETIM_ISP_SET)) {
    sub PIIX_IDETIM_ISP_SET {
	local($x) = @_;
	eval q((($x) <<  &PIIX_IDETIM_ISP_SHIFT));
    }
}
unless(defined(&PIIX_IDETIM_RTC_MASK)) {
    sub PIIX_IDETIM_RTC_MASK () {	0x300;}
}
unless(defined(&PIIX_IDETIM_RTC_SHIFT)) {
    sub PIIX_IDETIM_RTC_SHIFT () {	8;}
}
unless(defined(&PIIX_IDETIM_RTC_SET)) {
    sub PIIX_IDETIM_RTC_SET {
	local($x) = @_;
	eval q((($x) <<  &PIIX_IDETIM_RTC_SHIFT));
    }
}
unless(defined(&PIIX_IDETIM_DTE)) {
    sub PIIX_IDETIM_DTE {
	local($d) = @_;
	eval q((0x8 << (4* ($d))));
    }
}
unless(defined(&PIIX_IDETIM_PPE)) {
    sub PIIX_IDETIM_PPE {
	local($d) = @_;
	eval q((0x4 << (4* ($d))));
    }
}
unless(defined(&PIIX_IDETIM_IE)) {
    sub PIIX_IDETIM_IE {
	local($d) = @_;
	eval q((0x2 << (4* ($d))));
    }
}
unless(defined(&PIIX_IDETIM_TIME)) {
    sub PIIX_IDETIM_TIME {
	local($d) = @_;
	eval q((0x1 << (4* ($d))));
    }
}
unless(defined(&PIIX_SIDETIM)) {
    sub PIIX_SIDETIM () {	0x44;}
}
unless(defined(&PIIX_SIDETIM_ISP_MASK)) {
    sub PIIX_SIDETIM_ISP_MASK {
	local($channel) = @_;
	eval q((0xc << (($channel) * 4)));
    }
}
unless(defined(&PIIX_SIDETIM_ISP_SHIFT)) {
    sub PIIX_SIDETIM_ISP_SHIFT () {	2;}
}
unless(defined(&PIIX_SIDETIM_ISP_SET)) {
    sub PIIX_SIDETIM_ISP_SET {
	local($x, $channel) = @_;
	eval q(($x << ( &PIIX_SIDETIM_ISP_SHIFT + (($channel) * 4))));
    }
}
unless(defined(&PIIX_SIDETIM_RTC_MASK)) {
    sub PIIX_SIDETIM_RTC_MASK {
	local($channel) = @_;
	eval q((0x3 << (($channel) * 4)));
    }
}
unless(defined(&PIIX_SIDETIM_RTC_SHIFT)) {
    sub PIIX_SIDETIM_RTC_SHIFT () {	0;}
}
unless(defined(&PIIX_SIDETIM_RTC_SET)) {
    sub PIIX_SIDETIM_RTC_SET {
	local($x, $channel) = @_;
	eval q(($x << ( &PIIX_SIDETIM_RTC_SHIFT + (($channel) * 4))));
    }
}
unless(defined(&PIIX_UDMAREG)) {
    sub PIIX_UDMAREG () {	0x48;}
}
unless(defined(&PIIX_UDMACTL_DRV_EN)) {
    sub PIIX_UDMACTL_DRV_EN {
	local($channel, $drive) = @_;
	eval q((0x1 << (($channel) * 2+ ($drive))));
    }
}
unless(defined(&PIIX_UDMATIM_SHIFT)) {
    sub PIIX_UDMATIM_SHIFT () {	16;}
}
unless(defined(&PIIX_UDMATIM_SET)) {
    sub PIIX_UDMATIM_SET {
	local($x, $channel, $drive) = @_;
	eval q(((($x) << (($channel * 8) + ($drive * 4))) <<  &PIIX_UDMATIM_SHIFT));
    }
}
unless(defined(&PIIX_CONFIG)) {
    sub PIIX_CONFIG () {	0x54;}
}
unless(defined(&PIIX_CONFIG_PINGPONG)) {
    sub PIIX_CONFIG_PINGPONG () {	0x400;}
}
unless(defined(&PIIX_CONFIG_CR)) {
    sub PIIX_CONFIG_CR {
	local($channel, $drive) = @_;
	eval q((0x10 << (($channel) * 2+ ($drive))));
    }
}
unless(defined(&PIIX_CONFIG_UDMA66)) {
    sub PIIX_CONFIG_UDMA66 {
	local($channel, $drive) = @_;
	eval q((0x1 << (($channel) * 2+ ($drive))));
    }
}
unless(defined(&PIIX_CONFIG_UDMA100)) {
    sub PIIX_CONFIG_UDMA100 {
	local($channel, $drive) = @_;
	eval q((0x1000 << (($channel) * 2+ ($drive))));
    }
}
unless(defined(&ICH5_SATA_MAP)) {
    sub ICH5_SATA_MAP () {	0x90;}
}
unless(defined(&ICH5_SATA_MAP_MV_MASK)) {
    sub ICH5_SATA_MAP_MV_MASK () {	0x7;}
}
unless(defined(&ICH_SATA_PCS)) {
    sub ICH_SATA_PCS () {	0x92;}
}
unless(defined(&ICH_SATA_PCS_P0E)) {
    sub ICH_SATA_PCS_P0E () {	0x1;}
}
unless(defined(&ICH_SATA_PCS_P1E)) {
    sub ICH_SATA_PCS_P1E () {	0x2;}
}
unless(defined(&ICH_SATA_PCS_P0P)) {
    sub ICH_SATA_PCS_P0P () {	0x10;}
}
unless(defined(&ICH_SATA_PCS_P1P)) {
    sub ICH_SATA_PCS_P1P () {	0x20;}
}
1;
