require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&HME_SEBI_RESET)) {
    sub HME_SEBI_RESET () {	(0*4);}
}
unless(defined(&HME_SEBI_CFG)) {
    sub HME_SEBI_CFG () {	(1*4);}
}
unless(defined(&HME_SEBI_STAT)) {
    sub HME_SEBI_STAT () {	(64*4);}
}
unless(defined(&HME_SEBI_IMASK)) {
    sub HME_SEBI_IMASK () {	(65*4);}
}
unless(defined(&HME_SEB_RESET_ETX)) {
    sub HME_SEB_RESET_ETX () {	0x1;}
}
unless(defined(&HME_SEB_RESET_ERX)) {
    sub HME_SEB_RESET_ERX () {	0x2;}
}
unless(defined(&HME_SEB_CFG_BURSTMASK)) {
    sub HME_SEB_CFG_BURSTMASK () {	0x3;}
}
unless(defined(&HME_SEB_CFG_BURST16)) {
    sub HME_SEB_CFG_BURST16 () {	0x;}
}
unless(defined(&HME_SEB_CFG_BURST32)) {
    sub HME_SEB_CFG_BURST32 () {	0x1;}
}
unless(defined(&HME_SEB_CFG_BURST64)) {
    sub HME_SEB_CFG_BURST64 () {	0x2;}
}
unless(defined(&HME_SEB_CFG_64BIT)) {
    sub HME_SEB_CFG_64BIT () {	0x4;}
}
unless(defined(&HME_SEB_CFG_PARITY)) {
    sub HME_SEB_CFG_PARITY () {	0x8;}
}
unless(defined(&HME_SEB_STAT_GOTFRAME)) {
    sub HME_SEB_STAT_GOTFRAME () {	0x1;}
}
unless(defined(&HME_SEB_STAT_RCNTEXP)) {
    sub HME_SEB_STAT_RCNTEXP () {	0x2;}
}
unless(defined(&HME_SEB_STAT_ACNTEXP)) {
    sub HME_SEB_STAT_ACNTEXP () {	0x4;}
}
unless(defined(&HME_SEB_STAT_CCNTEXP)) {
    sub HME_SEB_STAT_CCNTEXP () {	0x8;}
}
unless(defined(&HME_SEB_STAT_LCNTEXP)) {
    sub HME_SEB_STAT_LCNTEXP () {	0x10;}
}
unless(defined(&HME_SEB_STAT_RFIFOVF)) {
    sub HME_SEB_STAT_RFIFOVF () {	0x20;}
}
unless(defined(&HME_SEB_STAT_CVCNTEXP)) {
    sub HME_SEB_STAT_CVCNTEXP () {	0x40;}
}
unless(defined(&HME_SEB_STAT_STSTERR)) {
    sub HME_SEB_STAT_STSTERR () {	0x80;}
}
unless(defined(&HME_SEB_STAT_SENTFRAME)) {
    sub HME_SEB_STAT_SENTFRAME () {	0x100;}
}
unless(defined(&HME_SEB_STAT_TFIFO_UND)) {
    sub HME_SEB_STAT_TFIFO_UND () {	0x200;}
}
unless(defined(&HME_SEB_STAT_MAXPKTERR)) {
    sub HME_SEB_STAT_MAXPKTERR () {	0x400;}
}
unless(defined(&HME_SEB_STAT_NCNTEXP)) {
    sub HME_SEB_STAT_NCNTEXP () {	0x800;}
}
unless(defined(&HME_SEB_STAT_ECNTEXP)) {
    sub HME_SEB_STAT_ECNTEXP () {	0x1000;}
}
unless(defined(&HME_SEB_STAT_LCCNTEXP)) {
    sub HME_SEB_STAT_LCCNTEXP () {	0x2000;}
}
unless(defined(&HME_SEB_STAT_FCNTEXP)) {
    sub HME_SEB_STAT_FCNTEXP () {	0x4000;}
}
unless(defined(&HME_SEB_STAT_DTIMEXP)) {
    sub HME_SEB_STAT_DTIMEXP () {	0x8000;}
}
unless(defined(&HME_SEB_STAT_RXTOHOST)) {
    sub HME_SEB_STAT_RXTOHOST () {	0x10000;}
}
unless(defined(&HME_SEB_STAT_NORXD)) {
    sub HME_SEB_STAT_NORXD () {	0x20000;}
}
unless(defined(&HME_SEB_STAT_RXERR)) {
    sub HME_SEB_STAT_RXERR () {	0x40000;}
}
unless(defined(&HME_SEB_STAT_RXLATERR)) {
    sub HME_SEB_STAT_RXLATERR () {	0x80000;}
}
unless(defined(&HME_SEB_STAT_RXPERR)) {
    sub HME_SEB_STAT_RXPERR () {	0x100000;}
}
unless(defined(&HME_SEB_STAT_RXTERR)) {
    sub HME_SEB_STAT_RXTERR () {	0x200000;}
}
unless(defined(&HME_SEB_STAT_EOPERR)) {
    sub HME_SEB_STAT_EOPERR () {	0x400000;}
}
unless(defined(&HME_SEB_STAT_MIFIRQ)) {
    sub HME_SEB_STAT_MIFIRQ () {	0x800000;}
}
unless(defined(&HME_SEB_STAT_HOSTTOTX)) {
    sub HME_SEB_STAT_HOSTTOTX () {	0x1000000;}
}
unless(defined(&HME_SEB_STAT_TXALL)) {
    sub HME_SEB_STAT_TXALL () {	0x2000000;}
}
unless(defined(&HME_SEB_STAT_TXEACK)) {
    sub HME_SEB_STAT_TXEACK () {	0x4000000;}
}
unless(defined(&HME_SEB_STAT_TXLERR)) {
    sub HME_SEB_STAT_TXLERR () {	0x8000000;}
}
unless(defined(&HME_SEB_STAT_TXPERR)) {
    sub HME_SEB_STAT_TXPERR () {	0x10000000;}
}
unless(defined(&HME_SEB_STAT_TXTERR)) {
    sub HME_SEB_STAT_TXTERR () {	0x20000000;}
}
unless(defined(&HME_SEB_STAT_SLVERR)) {
    sub HME_SEB_STAT_SLVERR () {	0x40000000;}
}
unless(defined(&HME_SEB_STAT_SLVPERR)) {
    sub HME_SEB_STAT_SLVPERR () {	0x80000000;}
}
unless(defined(&HME_SEB_STAT_BITS)) {
    sub HME_SEB_STAT_BITS () {	"\020\1RX\2RCNT\3ACNT\4CCNT\5LCNT\6RFIFO\7CVCNT\10STST" "\11TX\12TFIFO\13MAXPKT\14NCNT\15ECNT\16LCCNT\17FCNT" "\20DTIME\21RXHOST\22NORXD\23RXE\24EXLATE\25RXP\26RXT\27EOP" "\30MIF\31TXHOST\32TXALL\33TXE\34TXL\35TXP\36TXT\37SLV" "\40SLVP";}
}
unless(defined(&HME_SEB_STAT_ALL_ERRORS)) {
    sub HME_SEB_STAT_ALL_ERRORS () {	( &HME_SEB_STAT_SLVPERR |  &HME_SEB_STAT_SLVERR |  &HME_SEB_STAT_TXTERR |  &HME_SEB_STAT_TXPERR |  &HME_SEB_STAT_TXLERR |  &HME_SEB_STAT_TXEACK |  &HME_SEB_STAT_EOPERR |  &HME_SEB_STAT_RXTERR |  &HME_SEB_STAT_RXPERR |  &HME_SEB_STAT_RXLATERR |  &HME_SEB_STAT_RXERR |  &HME_SEB_STAT_NORXD |  &HME_SEB_STAT_DTIMEXP |  &HME_SEB_STAT_FCNTEXP |  &HME_SEB_STAT_LCCNTEXP |  &HME_SEB_STAT_ECNTEXP |  &HME_SEB_STAT_NCNTEXP |  &HME_SEB_STAT_MAXPKTERR|  &HME_SEB_STAT_TFIFO_UND|  &HME_SEB_STAT_STSTERR |  &HME_SEB_STAT_CVCNTEXP |  &HME_SEB_STAT_LCNTEXP |  &HME_SEB_STAT_CCNTEXP|  &HME_SEB_STAT_ACNTEXP);}
}
unless(defined(&HME_SEB_STAT_VLAN_ERRORS)) {
    sub HME_SEB_STAT_VLAN_ERRORS () {	( &HME_SEB_STAT_SLVPERR |  &HME_SEB_STAT_SLVERR |  &HME_SEB_STAT_TXTERR |  &HME_SEB_STAT_TXPERR |  &HME_SEB_STAT_TXLERR |  &HME_SEB_STAT_TXEACK |  &HME_SEB_STAT_EOPERR |  &HME_SEB_STAT_RXTERR |  &HME_SEB_STAT_RXPERR |  &HME_SEB_STAT_RXLATERR |  &HME_SEB_STAT_RXERR |  &HME_SEB_STAT_NORXD |  &HME_SEB_STAT_DTIMEXP |  &HME_SEB_STAT_FCNTEXP |  &HME_SEB_STAT_LCCNTEXP |  &HME_SEB_STAT_ECNTEXP |  &HME_SEB_STAT_NCNTEXP |  &HME_SEB_STAT_TFIFO_UND|  &HME_SEB_STAT_STSTERR |  &HME_SEB_STAT_CVCNTEXP |  &HME_SEB_STAT_LCNTEXP |  &HME_SEB_STAT_CCNTEXP |  &HME_SEB_STAT_ACNTEXP);}
}
unless(defined(&HME_ETXI_PENDING)) {
    sub HME_ETXI_PENDING () {	(0*4);}
}
unless(defined(&HME_ETXI_CFG)) {
    sub HME_ETXI_CFG () {	(1*4);}
}
unless(defined(&HME_ETXI_RING)) {
    sub HME_ETXI_RING () {	(2*4);}
}
unless(defined(&HME_ETXI_BBASE)) {
    sub HME_ETXI_BBASE () {	(3*4);}
}
unless(defined(&HME_ETXI_BDISP)) {
    sub HME_ETXI_BDISP () {	(4*4);}
}
unless(defined(&HME_ETXI_FIFO_WPTR)) {
    sub HME_ETXI_FIFO_WPTR () {	(5*4);}
}
unless(defined(&HME_ETXI_FIFO_SWPTR)) {
    sub HME_ETXI_FIFO_SWPTR () {	(6*4);}
}
unless(defined(&HME_ETXI_FIFO_RPTR)) {
    sub HME_ETXI_FIFO_RPTR () {	(7*4);}
}
unless(defined(&HME_ETXI_FIFO_SRPTR)) {
    sub HME_ETXI_FIFO_SRPTR () {	(8*4);}
}
unless(defined(&HME_ETXI_FIFO_PKTCNT)) {
    sub HME_ETXI_FIFO_PKTCNT () {	(9*4);}
}
unless(defined(&HME_ETXI_STATEMACHINE)) {
    sub HME_ETXI_STATEMACHINE () {	(10*4);}
}
unless(defined(&HME_ETXI_RSIZE)) {
    sub HME_ETXI_RSIZE () {	(11*4);}
}
unless(defined(&HME_ETXI_BPTR)) {
    sub HME_ETXI_BPTR () {	(12*4);}
}
unless(defined(&HME_ETX_TP_DMAWAKEUP)) {
    sub HME_ETX_TP_DMAWAKEUP () {	0x1;}
}
unless(defined(&HME_ETX_CFG_DMAENABLE)) {
    sub HME_ETX_CFG_DMAENABLE () {	0x1;}
}
unless(defined(&HME_ETX_CFG_FIFOTHRESH)) {
    sub HME_ETX_CFG_FIFOTHRESH () {	0x3fe;}
}
unless(defined(&HME_ETX_CFG_IRQDAFTER)) {
    sub HME_ETX_CFG_IRQDAFTER () {	0x400;}
}
unless(defined(&HME_ETX_CFG_IRQDBEFORE)) {
    sub HME_ETX_CFG_IRQDBEFORE () {	0x;}
}
unless(defined(&HME_ERXI_CFG)) {
    sub HME_ERXI_CFG () {	(0*4);}
}
unless(defined(&HME_ERXI_RING)) {
    sub HME_ERXI_RING () {	(1*4);}
}
unless(defined(&HME_ERXI_BPTR)) {
    sub HME_ERXI_BPTR () {	(2*4);}
}
unless(defined(&HME_ERXI_FIFO_WPTR)) {
    sub HME_ERXI_FIFO_WPTR () {	(3*4);}
}
unless(defined(&HME_ERXI_FIFO_SWPTR)) {
    sub HME_ERXI_FIFO_SWPTR () {	(4*4);}
}
unless(defined(&HME_ERXI_FIFO_RPTR)) {
    sub HME_ERXI_FIFO_RPTR () {	(5*4);}
}
unless(defined(&HME_ERXI_FIFO_SRPTR)) {
    sub HME_ERXI_FIFO_SRPTR () {	(6*4);}
}
unless(defined(&HME_ERXI_STATEMACHINE)) {
    sub HME_ERXI_STATEMACHINE () {	(7*4);}
}
unless(defined(&HME_ERX_CFG_DMAENABLE)) {
    sub HME_ERX_CFG_DMAENABLE () {	0x1;}
}
unless(defined(&HME_ERX_CFG_BYTEOFFSET)) {
    sub HME_ERX_CFG_BYTEOFFSET () {	0x38;}
}
unless(defined(&HME_ERX_CFG_RINGSIZE32)) {
    sub HME_ERX_CFG_RINGSIZE32 () {	0x;}
}
unless(defined(&HME_ERX_CFG_RINGSIZE64)) {
    sub HME_ERX_CFG_RINGSIZE64 () {	0x200;}
}
unless(defined(&HME_ERX_CFG_RINGSIZE128)) {
    sub HME_ERX_CFG_RINGSIZE128 () {	0x400;}
}
unless(defined(&HME_ERX_CFG_RINGSIZE256)) {
    sub HME_ERX_CFG_RINGSIZE256 () {	0x600;}
}
unless(defined(&HME_ERX_CFG_CSUMSTART)) {
    sub HME_ERX_CFG_CSUMSTART () {	0x7f0000;}
}
unless(defined(&HME_MACI_XIF)) {
    sub HME_MACI_XIF () {	(0*4);}
}
unless(defined(&HME_MACI_TXSWRST)) {
    sub HME_MACI_TXSWRST () {	(130*4);}
}
unless(defined(&HME_MACI_TXCFG)) {
    sub HME_MACI_TXCFG () {	(131*4);}
}
unless(defined(&HME_MACI_JSIZE)) {
    sub HME_MACI_JSIZE () {	(139*4);}
}
unless(defined(&HME_MACI_TXSIZE)) {
    sub HME_MACI_TXSIZE () {	(140*4);}
}
unless(defined(&HME_MACI_NCCNT)) {
    sub HME_MACI_NCCNT () {	(144*4);}
}
unless(defined(&HME_MACI_FCCNT)) {
    sub HME_MACI_FCCNT () {	(145*4);}
}
unless(defined(&HME_MACI_EXCNT)) {
    sub HME_MACI_EXCNT () {	(146*4);}
}
unless(defined(&HME_MACI_LTCNT)) {
    sub HME_MACI_LTCNT () {	(147*4);}
}
unless(defined(&HME_MACI_RANDSEED)) {
    sub HME_MACI_RANDSEED () {	(148*4);}
}
unless(defined(&HME_MACI_RXSWRST)) {
    sub HME_MACI_RXSWRST () {	(194*4);}
}
unless(defined(&HME_MACI_RXCFG)) {
    sub HME_MACI_RXCFG () {	(195*4);}
}
unless(defined(&HME_MACI_RXSIZE)) {
    sub HME_MACI_RXSIZE () {	(196*4);}
}
unless(defined(&HME_MACI_MACADDR2)) {
    sub HME_MACI_MACADDR2 () {	(198*4);}
}
unless(defined(&HME_MACI_MACADDR1)) {
    sub HME_MACI_MACADDR1 () {	(199*4);}
}
unless(defined(&HME_MACI_MACADDR0)) {
    sub HME_MACI_MACADDR0 () {	(200*4);}
}
unless(defined(&HME_MACI_HASHTAB3)) {
    sub HME_MACI_HASHTAB3 () {	(208*4);}
}
unless(defined(&HME_MACI_HASHTAB2)) {
    sub HME_MACI_HASHTAB2 () {	(209*4);}
}
unless(defined(&HME_MACI_HASHTAB1)) {
    sub HME_MACI_HASHTAB1 () {	(210*4);}
}
unless(defined(&HME_MACI_HASHTAB0)) {
    sub HME_MACI_HASHTAB0 () {	(211*4);}
}
unless(defined(&HME_MACI_AFILTER2)) {
    sub HME_MACI_AFILTER2 () {	(212*4);}
}
unless(defined(&HME_MACI_AFILTER1)) {
    sub HME_MACI_AFILTER1 () {	(213*4);}
}
unless(defined(&HME_MACI_AFILTER0)) {
    sub HME_MACI_AFILTER0 () {	(214*4);}
}
unless(defined(&HME_MACI_AFILTER_MASK)) {
    sub HME_MACI_AFILTER_MASK () {	(215*4);}
}
unless(defined(&HME_MAC_XIF_OE)) {
    sub HME_MAC_XIF_OE () {	0x1;}
}
unless(defined(&HME_MAC_XIF_XLBACK)) {
    sub HME_MAC_XIF_XLBACK () {	0x2;}
}
unless(defined(&HME_MAC_XIF_MLBACK)) {
    sub HME_MAC_XIF_MLBACK () {	0x4;}
}
unless(defined(&HME_MAC_XIF_MIIENABLE)) {
    sub HME_MAC_XIF_MIIENABLE () {	0x8;}
}
unless(defined(&HME_MAC_XIF_SQENABLE)) {
    sub HME_MAC_XIF_SQENABLE () {	0x10;}
}
unless(defined(&HME_MAC_XIF_SQETWIN)) {
    sub HME_MAC_XIF_SQETWIN () {	0x3e0;}
}
unless(defined(&HME_MAC_XIF_LANCE)) {
    sub HME_MAC_XIF_LANCE () {	0x10;}
}
unless(defined(&HME_MAC_XIF_LIPG0)) {
    sub HME_MAC_XIF_LIPG0 () {	0x3e0;}
}
unless(defined(&HME_MAC_TXCFG_ENABLE)) {
    sub HME_MAC_TXCFG_ENABLE () {	0x1;}
}
unless(defined(&HME_MAC_TXCFG_SMODE)) {
    sub HME_MAC_TXCFG_SMODE () {	0x20;}
}
unless(defined(&HME_MAC_TXCFG_CIGN)) {
    sub HME_MAC_TXCFG_CIGN () {	0x40;}
}
unless(defined(&HME_MAC_TXCFG_FCSOFF)) {
    sub HME_MAC_TXCFG_FCSOFF () {	0x80;}
}
unless(defined(&HME_MAC_TXCFG_DBACKOFF)) {
    sub HME_MAC_TXCFG_DBACKOFF () {	0x100;}
}
unless(defined(&HME_MAC_TXCFG_FULLDPLX)) {
    sub HME_MAC_TXCFG_FULLDPLX () {	0x200;}
}
unless(defined(&HME_MAC_TXCFG_DGIVEUP)) {
    sub HME_MAC_TXCFG_DGIVEUP () {	0x400;}
}
unless(defined(&HME_MAC_RXCFG_ENABLE)) {
    sub HME_MAC_RXCFG_ENABLE () {	0x1;}
}
unless(defined(&HME_MAC_RXCFG_PSTRIP)) {
    sub HME_MAC_RXCFG_PSTRIP () {	0x20;}
}
unless(defined(&HME_MAC_RXCFG_PMISC)) {
    sub HME_MAC_RXCFG_PMISC () {	0x40;}
}
unless(defined(&HME_MAC_RXCFG_DERR)) {
    sub HME_MAC_RXCFG_DERR () {	0x80;}
}
unless(defined(&HME_MAC_RXCFG_DCRCS)) {
    sub HME_MAC_RXCFG_DCRCS () {	0x100;}
}
unless(defined(&HME_MAC_RXCFG_ME)) {
    sub HME_MAC_RXCFG_ME () {	0x200;}
}
unless(defined(&HME_MAC_RXCFG_PGRP)) {
    sub HME_MAC_RXCFG_PGRP () {	0x400;}
}
unless(defined(&HME_MAC_RXCFG_HENABLE)) {
    sub HME_MAC_RXCFG_HENABLE () {	0x800;}
}
unless(defined(&HME_MAC_RXCFG_AENABLE)) {
    sub HME_MAC_RXCFG_AENABLE () {	0x1000;}
}
unless(defined(&HME_MIFI_BB_CLK)) {
    sub HME_MIFI_BB_CLK () {	(0*4);}
}
unless(defined(&HME_MIFI_BB_DATA)) {
    sub HME_MIFI_BB_DATA () {	(1*4);}
}
unless(defined(&HME_MIFI_BB_OE)) {
    sub HME_MIFI_BB_OE () {	(2*4);}
}
unless(defined(&HME_MIFI_FO)) {
    sub HME_MIFI_FO () {	(3*4);}
}
unless(defined(&HME_MIFI_CFG)) {
    sub HME_MIFI_CFG () {	(4*4);}
}
unless(defined(&HME_MIFI_IMASK)) {
    sub HME_MIFI_IMASK () {	(5*4);}
}
unless(defined(&HME_MIFI_STAT)) {
    sub HME_MIFI_STAT () {	(6*4);}
}
unless(defined(&HME_MIFI_SM)) {
    sub HME_MIFI_SM () {	(7*4);}
}
unless(defined(&HME_MIF_CFG_PHY)) {
    sub HME_MIF_CFG_PHY () {	0x1;}
}
unless(defined(&HME_MIF_CFG_PE)) {
    sub HME_MIF_CFG_PE () {	0x2;}
}
unless(defined(&HME_MIF_CFG_BBMODE)) {
    sub HME_MIF_CFG_BBMODE () {	0x4;}
}
unless(defined(&HME_MIF_CFG_PRADDR)) {
    sub HME_MIF_CFG_PRADDR () {	0xf8;}
}
unless(defined(&HME_MIF_CFG_MDI0)) {
    sub HME_MIF_CFG_MDI0 () {	0x100;}
}
unless(defined(&HME_MIF_CFG_MDI1)) {
    sub HME_MIF_CFG_MDI1 () {	0x200;}
}
unless(defined(&HME_MIF_CFG_PPADDR)) {
    sub HME_MIF_CFG_PPADDR () {	0x7c00;}
}
unless(defined(&HME_MIF_FO_ST)) {
    sub HME_MIF_FO_ST () {	0xc0000000;}
}
unless(defined(&HME_MIF_FO_ST_SHIFT)) {
    sub HME_MIF_FO_ST_SHIFT () {	30;}
}
unless(defined(&HME_MIF_FO_OPC)) {
    sub HME_MIF_FO_OPC () {	0x30000000;}
}
unless(defined(&HME_MIF_FO_OPC_SHIFT)) {
    sub HME_MIF_FO_OPC_SHIFT () {	28;}
}
unless(defined(&HME_MIF_FO_PHYAD)) {
    sub HME_MIF_FO_PHYAD () {	0xf800000;}
}
unless(defined(&HME_MIF_FO_PHYAD_SHIFT)) {
    sub HME_MIF_FO_PHYAD_SHIFT () {	23;}
}
unless(defined(&HME_MIF_FO_REGAD)) {
    sub HME_MIF_FO_REGAD () {	0x7c0000;}
}
unless(defined(&HME_MIF_FO_REGAD_SHIFT)) {
    sub HME_MIF_FO_REGAD_SHIFT () {	18;}
}
unless(defined(&HME_MIF_FO_TAMSB)) {
    sub HME_MIF_FO_TAMSB () {	0x20000;}
}
unless(defined(&HME_MIF_FO_TALSB)) {
    sub HME_MIF_FO_TALSB () {	0x10000;}
}
unless(defined(&HME_MIF_FO_DATA)) {
    sub HME_MIF_FO_DATA () {	0xffff;}
}
unless(defined(&HME_PHYAD_INTERNAL)) {
    sub HME_PHYAD_INTERNAL () {	1;}
}
unless(defined(&HME_PHYAD_EXTERNAL)) {
    sub HME_PHYAD_EXTERNAL () {	0;}
}
if(defined(&notdef)) {
}
unless(defined(&HME_XD_SIZE)) {
    sub HME_XD_SIZE () {	8;}
}
unless(defined(&HME_XD_FLAGS)) {
    sub HME_XD_FLAGS {
	local($base, $index) = @_;
	eval q((($base) + (($index) *  &HME_XD_SIZE) + 0));
    }
}
unless(defined(&HME_XD_ADDR)) {
    sub HME_XD_ADDR {
	local($base, $index) = @_;
	eval q((($base) + (($index) *  &HME_XD_SIZE) + 4));
    }
}
unless(defined(&HME_XD_GETFLAGS)) {
    sub HME_XD_GETFLAGS {
	local($p, $b, $i) = @_;
	eval q( ?  &letoh32(*( &HME_XD_FLAGS($b,$i))) : (*( &HME_XD_FLAGS($b,$i))));
    }
}
unless(defined(&HME_XD_SETFLAGS)) {
    sub HME_XD_SETFLAGS {
	local($p, $b, $i, $f) = @_;
	eval q( &do { *( &HME_XD_FLAGS($b,$i)) = (($p) ?  &htole32($f) : ($f)); }  &while(0));
    }
}
unless(defined(&HME_XD_SETADDR)) {
    sub HME_XD_SETADDR {
	local($p, $b, $i, $a) = @_;
	eval q( &do { *( &HME_XD_ADDR($b,$i)) = (($p) ?  &htole32($a) : ($a)); }  &while(0));
    }
}
unless(defined(&HME_XD_OWN)) {
    sub HME_XD_OWN () {	0x80000000;}
}
unless(defined(&HME_XD_SOP)) {
    sub HME_XD_SOP () {	0x40000000;}
}
unless(defined(&HME_XD_OFL)) {
    sub HME_XD_OFL () {	0x40000000;}
}
unless(defined(&HME_XD_EOP)) {
    sub HME_XD_EOP () {	0x20000000;}
}
unless(defined(&HME_XD_TXCKSUM)) {
    sub HME_XD_TXCKSUM () {	0x10000000;}
}
unless(defined(&HME_XD_RXLENMSK)) {
    sub HME_XD_RXLENMSK () {	0x3fff0000;}
}
unless(defined(&HME_XD_RXLENSHIFT)) {
    sub HME_XD_RXLENSHIFT () {	16;}
}
unless(defined(&HME_XD_TXLENMSK)) {
    sub HME_XD_TXLENMSK () {	0x3fff;}
}
unless(defined(&HME_XD_RXCKSUM)) {
    sub HME_XD_RXCKSUM () {	0xffff;}
}
unless(defined(&HME_XD_ENCODE_RSIZE)) {
    sub HME_XD_ENCODE_RSIZE {
	local($sz) = @_;
	eval q(((($sz) <<  &HME_XD_RXLENSHIFT) &  &HME_XD_RXLENMSK));
    }
}
unless(defined(&HME_XD_DECODE_RSIZE)) {
    sub HME_XD_DECODE_RSIZE {
	local($flags) = @_;
	eval q(((($flags) &  &HME_XD_RXLENMSK) >>  &HME_XD_RXLENSHIFT));
    }
}
unless(defined(&HME_XD_ENCODE_TSIZE)) {
    sub HME_XD_ENCODE_TSIZE {
	local($sz) = @_;
	eval q(((($sz) << 0) &  &HME_XD_TXLENMSK));
    }
}
unless(defined(&HME_XD_DECODE_TSIZE)) {
    sub HME_XD_DECODE_TSIZE {
	local($flags) = @_;
	eval q(((($flags) &  &HME_XD_TXLENMSK) >> 0));
    }
}
unless(defined(&EVL_ENCAPLEN)) {
    eval 'sub EVL_ENCAPLEN () {0;}' unless defined(&EVL_ENCAPLEN);
}
unless(defined(&HME_MTU)) {
    sub HME_MTU () {	( &ETHERMTU +  &EVL_ENCAPLEN + $sizeof{ &u_int32_t} + $sizeof{'struct ether_header'});}
}
1;
