require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&EARLY_RX)) {
    sub EARLY_RX () {	1;}
}
unless(defined(&TX_RING_SIZE)) {
    sub TX_RING_SIZE () {	16;}
}
unless(defined(&RX_RING_SIZE)) {
    sub RX_RING_SIZE () {	16;}
}
unless(defined(&TX_RING_MASK)) {
    sub TX_RING_MASK () {	( &TX_RING_SIZE - 1);}
}
unless(defined(&RX_RING_MASK)) {
    sub RX_RING_MASK () {	( &RX_RING_SIZE - 1);}
}
unless(defined(&ETHER_MAX_FRAME_LEN)) {
    sub ETHER_MAX_FRAME_LEN () {	( &ETHER_MAX_LEN +  &ETHER_CRC_LEN);}
}
if(defined( &__FreeBSD__)) {
    eval 'sub PCIR_BASEIO () {( &PCIR_MAPS + 0x);}' unless defined(&PCIR_BASEIO);
    eval 'sub PCIR_BASEMEM () {( &PCIR_MAPS + 0x4);}' unless defined(&PCIR_BASEMEM);
} else {
    eval 'sub PCI_BASEIO () {( &PCI_MAPS + 0x);}' unless defined(&PCI_BASEIO);
    eval 'sub PCI_BASEMEM () {( &PCI_MAPS + 0x4);}' unless defined(&PCI_BASEMEM);
}
unless(defined(&SMC_VENDORID)) {
    sub SMC_VENDORID () {	0x10b8;}
}
unless(defined(&SMC_DEVICEID_83C170)) {
    sub SMC_DEVICEID_83C170 () {	0x5;}
}
unless(defined(&COMMAND)) {
    sub COMMAND () {	0x;}
}
unless(defined(&INTSTAT)) {
    sub INTSTAT () {	0x4;}
}
unless(defined(&INTMASK)) {
    sub INTMASK () {	0x8;}
}
unless(defined(&GENCTL)) {
    sub GENCTL () {	0xc;}
}
unless(defined(&NVCTL)) {
    sub NVCTL () {	0x10;}
}
unless(defined(&EECTL)) {
    sub EECTL () {	0x14;}
}
unless(defined(&TEST1)) {
    sub TEST1 () {	0x1c;}
}
unless(defined(&CRCCNT)) {
    sub CRCCNT () {	0x20;}
}
unless(defined(&ALICNT)) {
    sub ALICNT () {	0x24;}
}
unless(defined(&MPCNT)) {
    sub MPCNT () {	0x28;}
}
unless(defined(&MIICTL)) {
    sub MIICTL () {	0x30;}
}
unless(defined(&MIIDATA)) {
    sub MIIDATA () {	0x34;}
}
unless(defined(&MIICFG)) {
    sub MIICFG () {	0x38;}
}
unless(defined(&IPG)) {
    sub IPG () {	0x3c;}
}
unless(defined(&LAN0)) {
    sub LAN0 () {	0x40;}
}
unless(defined(&LAN1)) {
    sub LAN1 () {	0x44;}
}
unless(defined(&LAN2)) {
    sub LAN2 () {	0x48;}
}
unless(defined(&ID_CHK)) {
    sub ID_CHK () {	0x4c;}
}
unless(defined(&MC0)) {
    sub MC0 () {	0x50;}
}
unless(defined(&MC1)) {
    sub MC1 () {	0x54;}
}
unless(defined(&MC2)) {
    sub MC2 () {	0x58;}
}
unless(defined(&MC3)) {
    sub MC3 () {	0x5c;}
}
unless(defined(&RXCON)) {
    sub RXCON () {	0x60;}
}
unless(defined(&TXCON)) {
    sub TXCON () {	0x70;}
}
unless(defined(&TXSTAT)) {
    sub TXSTAT () {	0x74;}
}
unless(defined(&PRCDAR)) {
    sub PRCDAR () {	0x84;}
}
unless(defined(&PRSTAT)) {
    sub PRSTAT () {	0xa4;}
}
unless(defined(&PRCPTHR)) {
    sub PRCPTHR () {	0xb0;}
}
unless(defined(&PTCDAR)) {
    sub PTCDAR () {	0xc4;}
}
unless(defined(&ETXTHR)) {
    sub ETXTHR () {	0xdc;}
}
unless(defined(&COMMAND_STOP_RX)) {
    sub COMMAND_STOP_RX () {	0x1;}
}
unless(defined(&COMMAND_START_RX)) {
    sub COMMAND_START_RX () {	0x2;}
}
unless(defined(&COMMAND_TXQUEUED)) {
    sub COMMAND_TXQUEUED () {	0x4;}
}
unless(defined(&COMMAND_RXQUEUED)) {
    sub COMMAND_RXQUEUED () {	0x8;}
}
unless(defined(&COMMAND_NEXTFRAME)) {
    sub COMMAND_NEXTFRAME () {	0x10;}
}
unless(defined(&COMMAND_STOP_TDMA)) {
    sub COMMAND_STOP_TDMA () {	0x20;}
}
unless(defined(&COMMAND_STOP_RDMA)) {
    sub COMMAND_STOP_RDMA () {	0x40;}
}
unless(defined(&COMMAND_TXUGO)) {
    sub COMMAND_TXUGO () {	0x80;}
}
unless(defined(&INTSTAT_RCC)) {
    sub INTSTAT_RCC () {	0x1;}
}
unless(defined(&INTSTAT_HCC)) {
    sub INTSTAT_HCC () {	0x2;}
}
unless(defined(&INTSTAT_RQE)) {
    sub INTSTAT_RQE () {	0x4;}
}
unless(defined(&INTSTAT_OVW)) {
    sub INTSTAT_OVW () {	0x8;}
}
unless(defined(&INTSTAT_RXE)) {
    sub INTSTAT_RXE () {	0x10;}
}
unless(defined(&INTSTAT_TXC)) {
    sub INTSTAT_TXC () {	0x20;}
}
unless(defined(&INTSTAT_TCC)) {
    sub INTSTAT_TCC () {	0x40;}
}
unless(defined(&INTSTAT_TQE)) {
    sub INTSTAT_TQE () {	0x80;}
}
unless(defined(&INTSTAT_TXU)) {
    sub INTSTAT_TXU () {	0x100;}
}
unless(defined(&INTSTAT_CNT)) {
    sub INTSTAT_CNT () {	0x200;}
}
unless(defined(&INTSTAT_PREI)) {
    sub INTSTAT_PREI () {	0x400;}
}
unless(defined(&INTSTAT_RCT)) {
    sub INTSTAT_RCT () {	0x800;}
}
unless(defined(&INTSTAT_FATAL)) {
    sub INTSTAT_FATAL () {	0x1000;}
}
unless(defined(&INTSTAT_UNUSED1)) {
    sub INTSTAT_UNUSED1 () {	0x2000;}
}
unless(defined(&INTSTAT_UNUSED2)) {
    sub INTSTAT_UNUSED2 () {	0x4000;}
}
unless(defined(&INTSTAT_GP2)) {
    sub INTSTAT_GP2 () {	0x8000;}
}
unless(defined(&INTSTAT_INT_ACTV)) {
    sub INTSTAT_INT_ACTV () {	0x10000;}
}
unless(defined(&INTSTAT_RXIDLE)) {
    sub INTSTAT_RXIDLE () {	0x20000;}
}
unless(defined(&INTSTAT_TXIDLE)) {
    sub INTSTAT_TXIDLE () {	0x40000;}
}
unless(defined(&INTSTAT_RCIP)) {
    sub INTSTAT_RCIP () {	0x80000;}
}
unless(defined(&INTSTAT_TCIP)) {
    sub INTSTAT_TCIP () {	0x100000;}
}
unless(defined(&INTSTAT_RBE)) {
    sub INTSTAT_RBE () {	0x200000;}
}
unless(defined(&INTSTAT_RCTS)) {
    sub INTSTAT_RCTS () {	0x400000;}
}
unless(defined(&INTSTAT_RSV)) {
    sub INTSTAT_RSV () {	0x800000;}
}
unless(defined(&INTSTAT_DPE)) {
    sub INTSTAT_DPE () {	0x1000000;}
}
unless(defined(&INTSTAT_APE)) {
    sub INTSTAT_APE () {	0x2000000;}
}
unless(defined(&INTSTAT_PMA)) {
    sub INTSTAT_PMA () {	0x4000000;}
}
unless(defined(&INTSTAT_PTA)) {
    sub INTSTAT_PTA () {	0x8000000;}
}
unless(defined(&GENCTL_SOFT_RESET)) {
    sub GENCTL_SOFT_RESET () {	0x1;}
}
unless(defined(&GENCTL_ENABLE_INTERRUPT)) {
    sub GENCTL_ENABLE_INTERRUPT () {	0x2;}
}
unless(defined(&GENCTL_SOFTWARE_INTERRUPT)) {
    sub GENCTL_SOFTWARE_INTERRUPT () {	0x4;}
}
unless(defined(&GENCTL_POWER_DOWN)) {
    sub GENCTL_POWER_DOWN () {	0x8;}
}
unless(defined(&GENCTL_ONECOPY)) {
    sub GENCTL_ONECOPY () {	0x10;}
}
unless(defined(&GENCTL_BIG_ENDIAN)) {
    sub GENCTL_BIG_ENDIAN () {	0x20;}
}
unless(defined(&GENCTL_RECEIVE_DMA_PRIORITY)) {
    sub GENCTL_RECEIVE_DMA_PRIORITY () {	0x40;}
}
unless(defined(&GENCTL_TRANSMIT_DMA_PRIORITY)) {
    sub GENCTL_TRANSMIT_DMA_PRIORITY () {	0x80;}
}
unless(defined(&GENCTL_RECEIVE_FIFO_THRESHOLD128)) {
    sub GENCTL_RECEIVE_FIFO_THRESHOLD128 () {	0x300;}
}
unless(defined(&GENCTL_RECEIVE_FIFO_THRESHOLD96)) {
    sub GENCTL_RECEIVE_FIFO_THRESHOLD96 () {	0x200;}
}
unless(defined(&GENCTL_RECEIVE_FIFO_THRESHOLD64)) {
    sub GENCTL_RECEIVE_FIFO_THRESHOLD64 () {	0x100;}
}
unless(defined(&GENCTL_RECEIVE_FIFO_THRESHOLD32)) {
    sub GENCTL_RECEIVE_FIFO_THRESHOLD32 () {	0x;}
}
unless(defined(&GENCTL_MEMORY_READ_LINE)) {
    sub GENCTL_MEMORY_READ_LINE () {	0x400;}
}
unless(defined(&GENCTL_MEMORY_READ_MULTIPLE)) {
    sub GENCTL_MEMORY_READ_MULTIPLE () {	0x800;}
}
unless(defined(&GENCTL_SOFTWARE1)) {
    sub GENCTL_SOFTWARE1 () {	0x1000;}
}
unless(defined(&GENCTL_SOFTWARE2)) {
    sub GENCTL_SOFTWARE2 () {	0x2000;}
}
unless(defined(&GENCTL_RESET_PHY)) {
    sub GENCTL_RESET_PHY () {	0x4000;}
}
unless(defined(&NVCTL_ENABLE_MEMORY_MAP)) {
    sub NVCTL_ENABLE_MEMORY_MAP () {	0x1;}
}
unless(defined(&NVCTL_CLOCK_RUN_SUPPORTED)) {
    sub NVCTL_CLOCK_RUN_SUPPORTED () {	0x2;}
}
unless(defined(&NVCTL_GP1_OUTPUT_ENABLE)) {
    sub NVCTL_GP1_OUTPUT_ENABLE () {	0x4;}
}
unless(defined(&NVCTL_GP2_OUTPUT_ENABLE)) {
    sub NVCTL_GP2_OUTPUT_ENABLE () {	0x8;}
}
unless(defined(&NVCTL_GP1)) {
    sub NVCTL_GP1 () {	0x10;}
}
unless(defined(&NVCTL_GP2)) {
    sub NVCTL_GP2 () {	0x20;}
}
unless(defined(&NVCTL_CARDBUS_MODE)) {
    sub NVCTL_CARDBUS_MODE () {	0x40;}
}
unless(defined(&NVCTL_IPG_DELAY_MASK)) {
    sub NVCTL_IPG_DELAY_MASK {
	local($x) = @_;
	eval q((($x&0xf)<<7));
    }
}
unless(defined(&RXCON_SAVE_ERRORED_PACKETS)) {
    sub RXCON_SAVE_ERRORED_PACKETS () {	0x1;}
}
unless(defined(&RXCON_RECEIVE_RUNT_FRAMES)) {
    sub RXCON_RECEIVE_RUNT_FRAMES () {	0x2;}
}
unless(defined(&RXCON_RECEIVE_BROADCAST_FRAMES)) {
    sub RXCON_RECEIVE_BROADCAST_FRAMES () {	0x4;}
}
unless(defined(&RXCON_RECEIVE_MULTICAST_FRAMES)) {
    sub RXCON_RECEIVE_MULTICAST_FRAMES () {	0x8;}
}
unless(defined(&RXCON_RECEIVE_INVERSE_INDIVIDUAL_ADDRESS_FRAMES)) {
    sub RXCON_RECEIVE_INVERSE_INDIVIDUAL_ADDRESS_FRAMES () {	0x10;}
}
unless(defined(&RXCON_PROMISCUOUS_MODE)) {
    sub RXCON_PROMISCUOUS_MODE () {	0x20;}
}
unless(defined(&RXCON_MONITOR_MODE)) {
    sub RXCON_MONITOR_MODE () {	0x40;}
}
unless(defined(&RXCON_EARLY_RECEIVE_ENABLE)) {
    sub RXCON_EARLY_RECEIVE_ENABLE () {	0x80;}
}
unless(defined(&RXCON_EXTERNAL_BUFFER_DISABLE)) {
    sub RXCON_EXTERNAL_BUFFER_DISABLE () {	0x;}
}
unless(defined(&RXCON_EXTERNAL_BUFFER_16K)) {
    sub RXCON_EXTERNAL_BUFFER_16K () {	0x100;}
}
unless(defined(&RXCON_EXTERNAL_BUFFER_32K)) {
    sub RXCON_EXTERNAL_BUFFER_32K () {	0x200;}
}
unless(defined(&RXCON_EXTERNAL_BUFFER_128K)) {
    sub RXCON_EXTERNAL_BUFFER_128K () {	0x300;}
}
unless(defined(&TXCON_EARLY_TRANSMIT_ENABLE)) {
    sub TXCON_EARLY_TRANSMIT_ENABLE () {	0x1;}
}
unless(defined(&TXCON_LOOPBACK_DISABLE)) {
    sub TXCON_LOOPBACK_DISABLE () {	0x;}
}
unless(defined(&TXCON_LOOPBACK_MODE_INT)) {
    sub TXCON_LOOPBACK_MODE_INT () {	0x2;}
}
unless(defined(&TXCON_LOOPBACK_MODE_PHY)) {
    sub TXCON_LOOPBACK_MODE_PHY () {	0x4;}
}
unless(defined(&TXCON_LOOPBACK_MODE)) {
    sub TXCON_LOOPBACK_MODE () {	0x6;}
}
unless(defined(&TXCON_FULL_DUPLEX)) {
    sub TXCON_FULL_DUPLEX () {	0x6;}
}
unless(defined(&TXCON_SLOT_TIME)) {
    sub TXCON_SLOT_TIME () {	0x78;}
}
unless(defined(&MIICFG_SERIAL_ENABLE)) {
    sub MIICFG_SERIAL_ENABLE () {	0x1;}
}
unless(defined(&MIICFG_694_ENABLE)) {
    sub MIICFG_694_ENABLE () {	0x2;}
}
unless(defined(&MIICFG_694_STATUS)) {
    sub MIICFG_694_STATUS () {	0x4;}
}
unless(defined(&MIICFG_PHY_PRESENT)) {
    sub MIICFG_PHY_PRESENT () {	0x8;}
}
unless(defined(&MIICFG_SMI_ENABLE)) {
    sub MIICFG_SMI_ENABLE () {	0x10;}
}
unless(defined(&TEST1_CLOCK_TEST)) {
    sub TEST1_CLOCK_TEST () {	0x8;}
}
unless(defined(&TXCON_DEFAULT)) {
    sub TXCON_DEFAULT () {	( &TXCON_SLOT_TIME |  &TXCON_EARLY_TRANSMIT_ENABLE);}
}
unless(defined(&TRANSMIT_THRESHOLD)) {
    sub TRANSMIT_THRESHOLD () {	0x300;}
}
if(defined( &EARLY_RX)) {
    eval 'sub RXCON_EARLY () {( &RXCON_EARLY_RECEIVE_ENABLE |  &RXCON_SAVE_ERRORED_PACKETS);}' unless defined(&RXCON_EARLY);
} else {
    eval 'sub RXCON_EARLY () {(0);}' unless defined(&RXCON_EARLY);
}
unless(defined(&RXCON_DEFAULT)) {
    sub RXCON_DEFAULT () {	( &RXCON_EARLY |  &RXCON_RECEIVE_MULTICAST_FRAMES |  &RXCON_RECEIVE_BROADCAST_FRAMES);}
}
unless(defined(&EPIC_MAX_FRAGS)) {
    sub EPIC_MAX_FRAGS () {	63;}
}
unless(defined(&EPIC_UNKN_PHY)) {
    sub EPIC_UNKN_PHY () {	0x;}
}
unless(defined(&EPIC_QS6612_PHY)) {
    sub EPIC_QS6612_PHY () {	0x1;}
}
unless(defined(&EPIC_AC101_PHY)) {
    sub EPIC_AC101_PHY () {	0x2;}
}
unless(defined(&EPIC_LXT970_PHY)) {
    sub EPIC_LXT970_PHY () {	0x3;}
}
unless(defined(&EPIC_SERIAL)) {
    sub EPIC_SERIAL () {	0x4;}
}
unless(defined(&SMC9432DMT)) {
    sub SMC9432DMT () {	0xa010;}
}
unless(defined(&SMC9432TX)) {
    sub SMC9432TX () {	0xa011;}
}
unless(defined(&SMC9032TXM)) {
    sub SMC9032TXM () {	0xa012;}
}
unless(defined(&SMC9032TX)) {
    sub SMC9032TX () {	0xa013;}
}
unless(defined(&SMC9432TXPWR)) {
    sub SMC9432TXPWR () {	0xa014;}
}
unless(defined(&SMC9432BTX)) {
    sub SMC9432BTX () {	0xa015;}
}
unless(defined(&SMC9432FTX)) {
    sub SMC9432FTX () {	0xa016;}
}
unless(defined(&SMC9432FTX_SC)) {
    sub SMC9432FTX_SC () {	0xa017;}
}
unless(defined(&SMC9432TX_XG_ADHOC)) {
    sub SMC9432TX_XG_ADHOC () {	0xa020;}
}
unless(defined(&SMC9434TX_XG_ADHOC)) {
    sub SMC9434TX_XG_ADHOC () {	0xa021;}
}
unless(defined(&SMC9432FTX_ADHOC)) {
    sub SMC9432FTX_ADHOC () {	0xa022;}
}
unless(defined(&SMC9432BTX1)) {
    sub SMC9432BTX1 () {	0xa024;}
}
if(defined( &__OpenBSD__)) {
} else {
}
if(defined( &EPIC_DEBUG)) {
    eval 'sub dprintf {
        local($a) = @_;
	    eval q( &printf $a);
    }' unless defined(&dprintf);
} else {
    eval 'sub dprintf {
        local($a) = @_;
	    eval q();
    }' unless defined(&dprintf);
}
if(defined( &__FreeBSD__)) {
    eval 'sub EPIC_FORMAT () {"tx%d";}' unless defined(&EPIC_FORMAT);
    eval 'sub EPIC_ARGS {
        local($sc) = @_;
	    eval q(( ($sc->{unit})));
    }' unless defined(&EPIC_ARGS);
    eval 'sub EPIC_BPFTAP_ARG {
        local($ifp) = @_;
	    eval q($ifp);
    }' unless defined(&EPIC_BPFTAP_ARG);
} else {
    eval 'sub EPIC_FORMAT () {"%s";}' unless defined(&EPIC_FORMAT);
    eval 'sub EPIC_ARGS {
        local($sc) = @_;
	    eval q(( ($sc->{dev}->{dv_xname})));
    }' unless defined(&EPIC_ARGS);
    eval 'sub EPIC_BPFTAP_ARG {
        local($ifp) = @_;
	    eval q(($ifp)-> &if_bpf);
    }' unless defined(&EPIC_BPFTAP_ARG);
}
unless(defined(&sc_if)) {
    sub sc_if () {	 ($arpcom->{ac_if});}
}
unless(defined(&sc_macaddr)) {
    sub sc_macaddr () {	 ($arpcom->{ac_enaddr});}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc,$reg,$val) = @_;
	eval q( &bus_space_write_4( ($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val) ));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	local($sc,$reg,$val) = @_;
	eval q( &bus_space_write_2( ($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val) ));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	local($sc,$reg,$val) = @_;
	eval q( &bus_space_write_1( ($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val) ));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc,$reg) = @_;
	eval q( &bus_space_read_4( ($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg) ));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	local($sc,$reg) = @_;
	eval q( &bus_space_read_2( ($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg) ));
    }
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	local($sc,$reg) = @_;
	eval q( &bus_space_read_1( ($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg) ));
    }
}
unless(defined(&PHY_READ_2)) {
    sub PHY_READ_2 {
	local($sc,$phy,$reg) = @_;
	eval q( &epic_read_phy_reg(($sc),($phy),($reg)));
    }
}
unless(defined(&PHY_WRITE_2)) {
    sub PHY_WRITE_2 {
	local($sc,$phy,$reg,$val) = @_;
	eval q( &epic_write_phy_reg(($sc),($phy),($reg),($val)));
    }
}
unless(defined(&EPIC_MGETCLUSTER)) {
    sub EPIC_MGETCLUSTER {
	local($m) = @_;
	eval q({  &MGETHDR(($m), &M_DONTWAIT, &MT_DATA);  &if ($m) {  &MCLGET(($m), &M_DONTWAIT);  &if(  &NULL == (($m)-> &m_flags &  &M_EXT) ) {  &m_freem($m); ($m) =  &NULL; } } });
    }
}
if(defined( &__OpenBSD__)) {
    eval 'sub epic_dev {
        local($sc) = @_;
	    eval q((*$sc));
    }' unless defined(&epic_dev);
    eval 'sub epic_dev_ptr {
        local($sc) = @_;
	    eval q(($sc));
    }' unless defined(&epic_dev_ptr);
    eval 'sub epic_mii {
        local($sc) = @_;
	    eval q(( ($sc->{miibus})));
    }' unless defined(&epic_mii);
    eval 'sub epic_mii_ptr {
        local($sc) = @_;
	    eval q(( ($sc->{miibus})));
    }' unless defined(&epic_mii_ptr);
} else {
    eval 'sub epic_dev {
        local($dev) = @_;
	    eval q((*( &device_get_softc($dev)));
    }' unless defined(&epic_dev);
    eval 'sub epic_dev_ptr {
        local($dev) = @_;
	    eval q(( &device_get_softc($dev)));
    }' unless defined(&epic_dev_ptr);
    eval 'sub epic_mii {
        local($sc) = @_;
	    eval q((*( &device_get_softc( ($sc->{miibus}))));
    }' unless defined(&epic_mii);
    eval 'sub epic_mii_ptr {
        local($sc) = @_;
	    eval q(( &device_get_softc( ($sc->{miibus}))));
    }' unless defined(&epic_mii_ptr);
}
1;
