require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_AMD64_PMAP_H_)) {
    eval 'sub _AMD64_PMAP_H_ () {1;}' unless defined(&_AMD64_PMAP_H_);
    unless(defined(&_LOCORE)) {
	require 'machine/cpufunc.ph';
	require 'machine/pte.ph';
	require 'machine/segments.ph';
	require 'uvm/uvm_object.ph';
    }
    eval 'sub VIRT_BITS () {48;}' unless defined(&VIRT_BITS);
    eval 'sub PHYS_BITS () {40;}' unless defined(&PHYS_BITS);
    eval 'sub VA_SIGN_MASK () {0xffff000000000000;}' unless defined(&VA_SIGN_MASK);
    eval 'sub VA_SIGN_NEG {
        local($va) = @_;
	    eval q((($va) |  &VA_SIGN_MASK));
    }' unless defined(&VA_SIGN_NEG);
    eval 'sub VA_SIGN_POS {
        local($va) = @_;
	    eval q((($va) & ~ &VA_SIGN_MASK));
    }' unless defined(&VA_SIGN_POS);
    eval 'sub L4_SLOT_PTE () {255;}' unless defined(&L4_SLOT_PTE);
    eval 'sub L4_SLOT_KERN () {256;}' unless defined(&L4_SLOT_KERN);
    eval 'sub L4_SLOT_KERNBASE () {511;}' unless defined(&L4_SLOT_KERNBASE);
    eval 'sub L4_SLOT_APTE () {510;}' unless defined(&L4_SLOT_APTE);
    eval 'sub PDIR_SLOT_KERN () { &L4_SLOT_KERN;}' unless defined(&PDIR_SLOT_KERN);
    eval 'sub PDIR_SLOT_PTE () { &L4_SLOT_PTE;}' unless defined(&PDIR_SLOT_PTE);
    eval 'sub PDIR_SLOT_APTE () { &L4_SLOT_APTE;}' unless defined(&PDIR_SLOT_APTE);
    eval 'sub PTE_BASE () {( ( &L4_SLOT_PTE *  &NBPD_L4));}' unless defined(&PTE_BASE);
    eval 'sub APTE_BASE () {( ( &VA_SIGN_NEG(( &L4_SLOT_APTE *  &NBPD_L4))));}' unless defined(&APTE_BASE);
    eval 'sub L1_BASE () { &PTE_BASE;}' unless defined(&L1_BASE);
    eval 'sub AL1_BASE () { &APTE_BASE;}' unless defined(&AL1_BASE);
    eval 'sub L2_BASE () {(( &L1_BASE +  &L4_SLOT_PTE *  &NBPD_L3));}' unless defined(&L2_BASE);
    eval 'sub L3_BASE () {(( &L2_BASE +  &L4_SLOT_PTE *  &NBPD_L2));}' unless defined(&L3_BASE);
    eval 'sub L4_BASE () {(( &L3_BASE +  &L4_SLOT_PTE *  &NBPD_L1));}' unless defined(&L4_BASE);
    eval 'sub AL2_BASE () {(( &AL1_BASE +  &L4_SLOT_PTE *  &NBPD_L3));}' unless defined(&AL2_BASE);
    eval 'sub AL3_BASE () {(( &AL2_BASE +  &L4_SLOT_PTE *  &NBPD_L2));}' unless defined(&AL3_BASE);
    eval 'sub AL4_BASE () {(( &AL3_BASE +  &L4_SLOT_PTE *  &NBPD_L1));}' unless defined(&AL4_BASE);
    eval 'sub PDP_PDE () {( &L4_BASE +  &PDIR_SLOT_PTE);}' unless defined(&PDP_PDE);
    eval 'sub APDP_PDE () {( &L4_BASE +  &PDIR_SLOT_APTE);}' unless defined(&APDP_PDE);
    eval 'sub PDP_BASE () { &L4_BASE;}' unless defined(&PDP_BASE);
    eval 'sub APDP_BASE () { &AL4_BASE;}' unless defined(&APDP_BASE);
    eval 'sub NKL4_MAX_ENTRIES () {1;}' unless defined(&NKL4_MAX_ENTRIES);
    eval 'sub NKL3_MAX_ENTRIES () {( &NKL4_MAX_ENTRIES * 512);}' unless defined(&NKL3_MAX_ENTRIES);
    eval 'sub NKL2_MAX_ENTRIES () {( &NKL3_MAX_ENTRIES * 512);}' unless defined(&NKL2_MAX_ENTRIES);
    eval 'sub NKL1_MAX_ENTRIES () {( &NKL2_MAX_ENTRIES * 512);}' unless defined(&NKL1_MAX_ENTRIES);
    eval 'sub NKL4_KIMG_ENTRIES () {1;}' unless defined(&NKL4_KIMG_ENTRIES);
    eval 'sub NKL3_KIMG_ENTRIES () {1;}' unless defined(&NKL3_KIMG_ENTRIES);
    eval 'sub NKL2_KIMG_ENTRIES () {8;}' unless defined(&NKL2_KIMG_ENTRIES);
    eval 'sub NKL4_START_ENTRIES () {0;}' unless defined(&NKL4_START_ENTRIES);
    eval 'sub NKL3_START_ENTRIES () {0;}' unless defined(&NKL3_START_ENTRIES);
    eval 'sub NKL2_START_ENTRIES () {0;}' unless defined(&NKL2_START_ENTRIES);
    eval 'sub NKL1_START_ENTRIES () {0;}' unless defined(&NKL1_START_ENTRIES);
    eval 'sub NTOPLEVEL_PDES () {( &PAGE_SIZE / ($sizeof{ &pd_entry_t}));}' unless defined(&NTOPLEVEL_PDES);
    eval 'sub KERNSPACE () {( &NKL4_ENTRIES *  &NBPD_L4);}' unless defined(&KERNSPACE);
    eval 'sub NPDPG () {( &PAGE_SIZE / $sizeof{ &pd_entry_t});}' unless defined(&NPDPG);
    eval 'sub ptei {
        local($VA) = @_;
	    eval q(((( &VA_SIGN_POS($VA)) &  &L1_MASK) >>  &L1_SHIFT));
    }' unless defined(&ptei);
    eval 'sub pl1_pi {
        local($VA) = @_;
	    eval q(((( &VA_SIGN_POS($VA)) &  &L1_MASK) >>  &L1_SHIFT));
    }' unless defined(&pl1_pi);
    eval 'sub pl2_pi {
        local($VA) = @_;
	    eval q(((( &VA_SIGN_POS($VA)) &  &L2_MASK) >>  &L2_SHIFT));
    }' unless defined(&pl2_pi);
    eval 'sub pl3_pi {
        local($VA) = @_;
	    eval q(((( &VA_SIGN_POS($VA)) &  &L3_MASK) >>  &L3_SHIFT));
    }' unless defined(&pl3_pi);
    eval 'sub pl4_pi {
        local($VA) = @_;
	    eval q(((( &VA_SIGN_POS($VA)) &  &L4_MASK) >>  &L4_SHIFT));
    }' unless defined(&pl4_pi);
    eval 'sub pl1_i {
        local($VA) = @_;
	    eval q(((( &VA_SIGN_POS($VA)) &  &L1_FRAME) >>  &L1_SHIFT));
    }' unless defined(&pl1_i);
    eval 'sub pl2_i {
        local($VA) = @_;
	    eval q(((( &VA_SIGN_POS($VA)) &  &L2_FRAME) >>  &L2_SHIFT));
    }' unless defined(&pl2_i);
    eval 'sub pl3_i {
        local($VA) = @_;
	    eval q(((( &VA_SIGN_POS($VA)) &  &L3_FRAME) >>  &L3_SHIFT));
    }' unless defined(&pl3_i);
    eval 'sub pl4_i {
        local($VA) = @_;
	    eval q(((( &VA_SIGN_POS($VA)) &  &L4_FRAME) >>  &L4_SHIFT));
    }' unless defined(&pl4_i);
    eval 'sub pl_i {
        local($va, $lvl) = @_;
	    eval q(((( &VA_SIGN_POS($va)) &  $ptp_masks[($lvl)-1]) >>  $ptp_shifts[($lvl)-1]));
    }' unless defined(&pl_i);
    eval 'sub PTP_MASK_INITIALIZER () {{  &L1_FRAME,  &L2_FRAME,  &L3_FRAME,  &L4_FRAME };}' unless defined(&PTP_MASK_INITIALIZER);
    eval 'sub PTP_SHIFT_INITIALIZER () {{  &L1_SHIFT,  &L2_SHIFT,  &L3_SHIFT,  &L4_SHIFT };}' unless defined(&PTP_SHIFT_INITIALIZER);
    eval 'sub NKPTP_INITIALIZER () {{  &NKL1_START_ENTRIES,  &NKL2_START_ENTRIES,  &NKL3_START_ENTRIES,  &NKL4_START_ENTRIES };}' unless defined(&NKPTP_INITIALIZER);
    eval 'sub NKPTPMAX_INITIALIZER () {{  &NKL1_MAX_ENTRIES,  &NKL2_MAX_ENTRIES,  &NKL3_MAX_ENTRIES,  &NKL4_MAX_ENTRIES };}' unless defined(&NKPTPMAX_INITIALIZER);
    eval 'sub NBPD_INITIALIZER () {{  &NBPD_L1,  &NBPD_L2,  &NBPD_L3,  &NBPD_L4 };}' unless defined(&NBPD_INITIALIZER);
    eval 'sub PDES_INITIALIZER () {{  &L2_BASE,  &L3_BASE,  &L4_BASE };}' unless defined(&PDES_INITIALIZER);
    eval 'sub APDES_INITIALIZER () {{  &AL2_BASE,  &AL3_BASE,  &AL4_BASE };}' unless defined(&APDES_INITIALIZER);
    eval 'sub ptp_va2o {
        local($va, $lvl) = @_;
	    eval q(( &pl_i($va, ($lvl)+1) *  &PAGE_SIZE));
    }' unless defined(&ptp_va2o);
    eval 'sub PTP_LEVELS () {4;}' unless defined(&PTP_LEVELS);
    eval 'sub PG_W () { &PG_AVAIL1;}' unless defined(&PG_W);
    eval 'sub PG_PVLIST () { &PG_AVAIL2;}' unless defined(&PG_PVLIST);
    eval 'sub NPTECL () {8;}' unless defined(&NPTECL);
    if(defined( &_KERNEL)  && !defined( &_LOCORE)) {
	eval 'sub pm_lock () { ($pm_obj[0]->{vmobjlock});}' unless defined(&pm_lock);
	eval 'sub pm_obj_l1 () { $pm_obj[0];}' unless defined(&pm_obj_l1);
	eval 'sub pm_obj_l2 () { $pm_obj[1];}' unless defined(&pm_obj_l2);
	eval 'sub pm_obj_l3 () { $pm_obj[2];}' unless defined(&pm_obj_l3);
	eval 'sub PMF_USER_LDT () {0x1;}' unless defined(&PMF_USER_LDT);
	eval 'sub PVE_PER_PVPAGE () {(( &PAGE_SIZE - $sizeof{\'struct pv_page_info\'}) / $sizeof{\'struct pv_entry\'});}' unless defined(&PVE_PER_PVPAGE);
	eval 'sub PMAP_RR_MAX () {16;}' unless defined(&PMAP_RR_MAX);
	eval 'sub pmap_kernel () {
	    eval q(( &kernel_pmap_store));
	}' unless defined(&pmap_kernel);
	eval 'sub pmap_resident_count {
	    local($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{resident_count})));
	}' unless defined(&pmap_resident_count);
	eval 'sub pmap_wired_count {
	    local($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{wired_count})));
	}' unless defined(&pmap_wired_count);
	eval 'sub pmap_update {
	    local($pmap) = @_;
    	    eval q();
	}' unless defined(&pmap_update);
	eval 'sub pmap_clear_modify {
	    local($pg) = @_;
    	    eval q( &pmap_clear_attrs($pg,  &PG_M));
	}' unless defined(&pmap_clear_modify);
	eval 'sub pmap_clear_reference {
	    local($pg) = @_;
    	    eval q( &pmap_clear_attrs($pg,  &PG_U));
	}' unless defined(&pmap_clear_reference);
	eval 'sub pmap_copy {
	    local($DP,$SP,$D,$L,$S) = @_;
    	    eval q();
	}' unless defined(&pmap_copy);
	eval 'sub pmap_is_modified {
	    local($pg) = @_;
    	    eval q( &pmap_test_attrs($pg,  &PG_M));
	}' unless defined(&pmap_is_modified);
	eval 'sub pmap_is_referenced {
	    local($pg) = @_;
    	    eval q( &pmap_test_attrs($pg,  &PG_U));
	}' unless defined(&pmap_is_referenced);
	eval 'sub pmap_move {
	    local($DP,$SP,$D,$L,$S) = @_;
    	    eval q();
	}' unless defined(&pmap_move);
	eval 'sub pmap_phys_address {
	    local($ppn) = @_;
    	    eval q( &ptob($ppn));
	}' unless defined(&pmap_phys_address);
	eval 'sub pmap_valid_entry {
	    local($E) = @_;
    	    eval q((($E) &  &PG_V));
	}' unless defined(&pmap_valid_entry);
	eval 'sub PMAP_GROWKERNEL () {1;}' unless defined(&PMAP_GROWKERNEL);
	eval 'sub PMAP_PAGEIDLEZERO {
	    local($pg) = @_;
    	    eval q( &pmap_pageidlezero(($pg)));
	}' unless defined(&PMAP_PAGEIDLEZERO);
	require 'lib/libkern/libkern.ph';
	if(defined(&LARGEPAGES)) {
	}
	eval 'sub pmap_pte_set {
	    local($p, $n) = @_;
    	    eval q( &x86_atomic_testset_u64($p, $n));
	}' unless defined(&pmap_pte_set);
	eval 'sub pmap_pte_clearbits {
	    local($p, $b) = @_;
    	    eval q( &x86_atomic_clearbits_u64($p, $b));
	}' unless defined(&pmap_pte_clearbits);
	eval 'sub pmap_pte_setbits {
	    local($p, $b) = @_;
    	    eval q( &x86_atomic_setbits_u64($p, $b));
	}' unless defined(&pmap_pte_setbits);
	eval 'sub pmap_cpu_has_pg_n () {
	    eval q((1));
	}' unless defined(&pmap_cpu_has_pg_n);
	eval 'sub pmap_cpu_has_invlpg () {(1);}' unless defined(&pmap_cpu_has_invlpg);
	if(0) {
	    eval 'sub PMAP_FORK () {1;}' unless defined(&PMAP_FORK);
	}
    }
}
1;
