require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ADVANSYS_NARROW_LIBRARY_H_)) {
    eval 'sub _ADVANSYS_NARROW_LIBRARY_H_ () {1;}' unless defined(&_ADVANSYS_NARROW_LIBRARY_H_);
    require 'dev/ic/adv.ph';
    eval 'sub ADV_VERSION () {"3.1E";}' unless defined(&ADV_VERSION);
    eval 'sub ASC_LIB_VERSION_MAJOR () {1;}' unless defined(&ASC_LIB_VERSION_MAJOR);
    eval 'sub ASC_LIB_VERSION_MINOR () {22;}' unless defined(&ASC_LIB_VERSION_MINOR);
    eval 'sub ASC_LIB_SERIAL_NUMBER () {113;}' unless defined(&ASC_LIB_SERIAL_NUMBER);
    eval 'sub ASC_NOERROR () {1;}' unless defined(&ASC_NOERROR);
    eval 'sub ASC_BUSY () {0;}' unless defined(&ASC_BUSY);
    eval 'sub ASC_ERROR () {-1;}' unless defined(&ASC_ERROR);
    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
	eval 'sub LO_BYTE {
	    local($x) = @_;
    	    eval q((*((($x))+1)));
	}' unless defined(&LO_BYTE);
	eval 'sub HI_BYTE {
	    local($x) = @_;
    	    eval q((*(( &u_int8_t *)($x))));
	}' unless defined(&HI_BYTE);
	eval 'sub LO_WORD {
	    local($x) = @_;
    	    eval q((*((($x))+1)));
	}' unless defined(&LO_WORD);
	eval 'sub HI_WORD {
	    local($x) = @_;
    	    eval q((*(( &u_int16_t *)($x))));
	}' unless defined(&HI_WORD);
    } else {
	eval 'sub HI_BYTE {
	    local($x) = @_;
    	    eval q((*((($x))+1)));
	}' unless defined(&HI_BYTE);
	eval 'sub LO_BYTE {
	    local($x) = @_;
    	    eval q((*(( &u_int8_t *)($x))));
	}' unless defined(&LO_BYTE);
	eval 'sub HI_WORD {
	    local($x) = @_;
    	    eval q((*((($x))+1)));
	}' unless defined(&HI_WORD);
	eval 'sub LO_WORD {
	    local($x) = @_;
    	    eval q((*(( &u_int16_t *)($x))));
	}' unless defined(&LO_WORD);
    }
    eval 'sub MAKEWORD {
        local($lo, $hi) = @_;
	    eval q(( ( | ( ($hi) << 8))));
    }' unless defined(&MAKEWORD);
    eval 'sub MAKELONG {
        local($lo, $hi) = @_;
	    eval q(( ( | ( ($hi) << 16))));
    }' unless defined(&MAKELONG);
    eval 'sub SWAPWORDS {
        local($dWord) = @_;
	    eval q(( (($dWord) >> 16) | (($dWord) << 16)));
    }' unless defined(&SWAPWORDS);
    eval 'sub SWAPBYTES {
        local($word) = @_;
	    eval q(( (($word) >> 8) | (($word) << 8)));
    }' unless defined(&SWAPBYTES);
    eval 'sub BIGTOLITTLE {
        local($dWord) = @_;
	    eval q(( &SWAPBYTES( &SWAPWORDS($dWord) >> 16) << 16) |  &SWAPBYTES( &SWAPWORDS($dWord) & 0xffff));
    }' unless defined(&BIGTOLITTLE);
    eval 'sub LITTLETOBIG {
        local($dWord) = @_;
	    eval q( &BIGTOLITTLE($dWord));
    }' unless defined(&LITTLETOBIG);
    eval 'sub ASC_PCI_ID2BUS {
        local($id) = @_;
	    eval q((($id) & 0xff));
    }' unless defined(&ASC_PCI_ID2BUS);
    eval 'sub ASC_PCI_ID2DEV {
        local($id) = @_;
	    eval q(((($id) >> 11) & 0x1f));
    }' unless defined(&ASC_PCI_ID2DEV);
    eval 'sub ASC_PCI_ID2FUNC {
        local($id) = @_;
	    eval q(((($id) >> 8) & 0x7));
    }' unless defined(&ASC_PCI_ID2FUNC);
    eval 'sub ASC_PCI_MKID {
        local($bus, $dev, $func) = @_;
	    eval q((((($dev) & 0x1f) << 11) | ((($func) & 0x7) << 8) | (($bus) & 0xff)));
    }' unless defined(&ASC_PCI_MKID);
    eval 'sub ASC_PCI_REVISION_3150 () {0x2;}' unless defined(&ASC_PCI_REVISION_3150);
    eval 'sub ASC_PCI_REVISION_3050 () {0x3;}' unless defined(&ASC_PCI_REVISION_3050);
    eval 'sub ASC_MAX_SG_QUEUE () {7;}' unless defined(&ASC_MAX_SG_QUEUE);
    eval 'sub ASC_SG_LIST_PER_Q () { &ASC_MAX_SG_QUEUE;}' unless defined(&ASC_SG_LIST_PER_Q);
    eval 'sub ASC_MAX_SG_LIST () {(1+ (( &ASC_SG_LIST_PER_Q) * ( &ASC_MAX_SG_QUEUE)));}' unless defined(&ASC_MAX_SG_LIST);
    eval 'sub ASC_IS_ISA () {0x1;}' unless defined(&ASC_IS_ISA);
    eval 'sub ASC_IS_ISAPNP () {0x81;}' unless defined(&ASC_IS_ISAPNP);
    eval 'sub ASC_IS_EISA () {0x2;}' unless defined(&ASC_IS_EISA);
    eval 'sub ASC_IS_PCI () {0x4;}' unless defined(&ASC_IS_PCI);
    eval 'sub ASC_IS_PCI_ULTRA () {0x104;}' unless defined(&ASC_IS_PCI_ULTRA);
    eval 'sub ASC_IS_PCMCIA () {0x8;}' unless defined(&ASC_IS_PCMCIA);
    eval 'sub ASC_IS_MCA () {0x20;}' unless defined(&ASC_IS_MCA);
    eval 'sub ASC_IS_VL () {0x40;}' unless defined(&ASC_IS_VL);
    eval 'sub ASC_ISA_PNP_PORT_ADDR () {0x279;}' unless defined(&ASC_ISA_PNP_PORT_ADDR);
    eval 'sub ASC_ISA_PNP_PORT_WRITE () {( &ASC_ISA_PNP_PORT_ADDR+0x800);}' unless defined(&ASC_ISA_PNP_PORT_WRITE);
    eval 'sub ASC_IS_WIDESCSI_16 () {0x100;}' unless defined(&ASC_IS_WIDESCSI_16);
    eval 'sub ASC_IS_WIDESCSI_32 () {0x200;}' unless defined(&ASC_IS_WIDESCSI_32);
    eval 'sub ASC_IS_BIG_ENDIAN () {0x8000;}' unless defined(&ASC_IS_BIG_ENDIAN);
    eval 'sub ASC_CHIP_MIN_VER_VL () {0x1;}' unless defined(&ASC_CHIP_MIN_VER_VL);
    eval 'sub ASC_CHIP_MAX_VER_VL () {0x7;}' unless defined(&ASC_CHIP_MAX_VER_VL);
    eval 'sub ASC_CHIP_MIN_VER_PCI () {0x9;}' unless defined(&ASC_CHIP_MIN_VER_PCI);
    eval 'sub ASC_CHIP_MAX_VER_PCI () {0xf;}' unless defined(&ASC_CHIP_MAX_VER_PCI);
    eval 'sub ASC_CHIP_VER_PCI_BIT () {0x8;}' unless defined(&ASC_CHIP_VER_PCI_BIT);
    eval 'sub ASC_CHIP_MIN_VER_ISA () {0x11;}' unless defined(&ASC_CHIP_MIN_VER_ISA);
    eval 'sub ASC_CHIP_MIN_VER_ISA_PNP () {0x21;}' unless defined(&ASC_CHIP_MIN_VER_ISA_PNP);
    eval 'sub ASC_CHIP_MAX_VER_ISA () {0x27;}' unless defined(&ASC_CHIP_MAX_VER_ISA);
    eval 'sub ASC_CHIP_VER_ISA_BIT () {0x30;}' unless defined(&ASC_CHIP_VER_ISA_BIT);
    eval 'sub ASC_CHIP_VER_ISAPNP_BIT () {0x20;}' unless defined(&ASC_CHIP_VER_ISAPNP_BIT);
    eval 'sub ASC_CHIP_VER_ASYN_BUG () {0x21;}' unless defined(&ASC_CHIP_VER_ASYN_BUG);
    eval 'sub ASC_CHIP_VER_PCI () {0x8;}' unless defined(&ASC_CHIP_VER_PCI);
    eval 'sub ASC_CHIP_VER_PCI_ULTRA_3150 () {( &ASC_CHIP_VER_PCI | 0x2);}' unless defined(&ASC_CHIP_VER_PCI_ULTRA_3150);
    eval 'sub ASC_CHIP_VER_PCI_ULTRA_3050 () {( &ASC_CHIP_VER_PCI | 0x3);}' unless defined(&ASC_CHIP_VER_PCI_ULTRA_3050);
    eval 'sub ASC_CHIP_MIN_VER_EISA () {0x41;}' unless defined(&ASC_CHIP_MIN_VER_EISA);
    eval 'sub ASC_CHIP_MAX_VER_EISA () {0x47;}' unless defined(&ASC_CHIP_MAX_VER_EISA);
    eval 'sub ASC_CHIP_VER_EISA_BIT () {0x40;}' unless defined(&ASC_CHIP_VER_EISA_BIT);
    eval 'sub ASC_CHIP_LATEST_VER_EISA () {(( &ASC_CHIP_MIN_VER_EISA - 1) + 3);}' unless defined(&ASC_CHIP_LATEST_VER_EISA);
    eval 'sub ASC_MAX_VL_DMA_ADDR () {0x7ffffff;}' unless defined(&ASC_MAX_VL_DMA_ADDR);
    eval 'sub ASC_MAX_VL_DMA_COUNT () {0x7ffffff;}' unless defined(&ASC_MAX_VL_DMA_COUNT);
    eval 'sub ASC_MAX_PCI_DMA_ADDR () {0xffffffff;}' unless defined(&ASC_MAX_PCI_DMA_ADDR);
    eval 'sub ASC_MAX_PCI_DMA_COUNT () {0xffffffff;}' unless defined(&ASC_MAX_PCI_DMA_COUNT);
    eval 'sub ASC_MAX_ISA_DMA_ADDR () {0xffffff;}' unless defined(&ASC_MAX_ISA_DMA_ADDR);
    eval 'sub ASC_MAX_ISA_DMA_COUNT () {0xffffff;}' unless defined(&ASC_MAX_ISA_DMA_COUNT);
    eval 'sub ASC_MAX_EISA_DMA_ADDR () {0x7ffffff;}' unless defined(&ASC_MAX_EISA_DMA_ADDR);
    eval 'sub ASC_MAX_EISA_DMA_COUNT () {0x7ffffff;}' unless defined(&ASC_MAX_EISA_DMA_COUNT);
    eval 'sub ASC_SCSI_ID_BITS () {3;}' unless defined(&ASC_SCSI_ID_BITS);
    eval 'sub ASC_SCSI_TIX_TYPE () { &u_int8_t;}' unless defined(&ASC_SCSI_TIX_TYPE);
    eval 'sub ASC_ALL_DEVICE_BIT_SET () {0xff;}' unless defined(&ASC_ALL_DEVICE_BIT_SET);
    if(defined(&ASC_WIDESCSI_16)) {
	undef(&ASC_SCSI_ID_BITS) if defined(&ASC_SCSI_ID_BITS);
	eval 'sub ASC_SCSI_ID_BITS () {4;}' unless defined(&ASC_SCSI_ID_BITS);
	eval 'sub ASC_ALL_DEVICE_BIT_SET () {0xffff;}' unless defined(&ASC_ALL_DEVICE_BIT_SET);
    }
    if(defined(&ASC_WIDESCSI_32)) {
	undef(&ASC_SCSI_ID_BITS) if defined(&ASC_SCSI_ID_BITS);
	eval 'sub ASC_SCSI_ID_BITS () {5;}' unless defined(&ASC_SCSI_ID_BITS);
	eval 'sub ASC_ALL_DEVICE_BIT_SET () {0xffffffff;}' unless defined(&ASC_ALL_DEVICE_BIT_SET);
    }
    if((defined(&ASC_SCSI_ID_BITS) ? &ASC_SCSI_ID_BITS : 0) == 3) {
	eval 'sub ASC_SCSI_BIT_ID_TYPE () { &u_int8_t;}' unless defined(&ASC_SCSI_BIT_ID_TYPE);
	eval 'sub ASC_MAX_TID () {7;}' unless defined(&ASC_MAX_TID);
	eval 'sub ASC_MAX_LUN () {7;}' unless defined(&ASC_MAX_LUN);
	eval 'sub ASC_SCSI_WIDTH_BIT_SET () {0xff;}' unless defined(&ASC_SCSI_WIDTH_BIT_SET);
    }
 elsif((defined(&ASC_SCSI_ID_BITS) ? &ASC_SCSI_ID_BITS : 0) == 4) {
	eval 'sub ASC_SCSI_BIT_ID_TYPE () { &u_int16_t;}' unless defined(&ASC_SCSI_BIT_ID_TYPE);
	eval 'sub ASC_MAX_TID () {15;}' unless defined(&ASC_MAX_TID);
	eval 'sub ASC_MAX_LUN () {7;}' unless defined(&ASC_MAX_LUN);
	eval 'sub ASC_SCSI_WIDTH_BIT_SET () {0xffff;}' unless defined(&ASC_SCSI_WIDTH_BIT_SET);
    }
 elsif((defined(&ASC_SCSI_ID_BITS) ? &ASC_SCSI_ID_BITS : 0) == 5) {
	eval 'sub ASC_SCSI_BIT_ID_TYPE () { &u_int32_t;}' unless defined(&ASC_SCSI_BIT_ID_TYPE);
	eval 'sub ASC_MAX_TID () {31;}' unless defined(&ASC_MAX_TID);
	eval 'sub ASC_MAX_LUN () {7;}' unless defined(&ASC_MAX_LUN);
	eval 'sub ASC_SCSI_WIDTH_BIT_SET () {0xffffffff;}' unless defined(&ASC_SCSI_WIDTH_BIT_SET);
    } else {
	die("ASC_SCSI_ID_BITS\ definition\ is\ wrong");
    }
    eval 'sub ASC_MAX_SENSE_LEN () {32;}' unless defined(&ASC_MAX_SENSE_LEN);
    eval 'sub ASC_MIN_SENSE_LEN () {14;}' unless defined(&ASC_MIN_SENSE_LEN);
    eval 'sub ASC_MAX_CDB_LEN () {12;}' unless defined(&ASC_MAX_CDB_LEN);
    eval 'sub ASC_SCSI_RESET_HOLD_TIME_US () {60;}' unless defined(&ASC_SCSI_RESET_HOLD_TIME_US);
    eval 'sub SCSICMD_TestUnitReady () {0x;}' unless defined(&SCSICMD_TestUnitReady);
    eval 'sub SCSICMD_Rewind () {0x1;}' unless defined(&SCSICMD_Rewind);
    eval 'sub SCSICMD_Rezero () {0x1;}' unless defined(&SCSICMD_Rezero);
    eval 'sub SCSICMD_RequestSense () {0x3;}' unless defined(&SCSICMD_RequestSense);
    eval 'sub SCSICMD_Format () {0x4;}' unless defined(&SCSICMD_Format);
    eval 'sub SCSICMD_FormatUnit () {0x4;}' unless defined(&SCSICMD_FormatUnit);
    eval 'sub SCSICMD_Read6 () {0x8;}' unless defined(&SCSICMD_Read6);
    eval 'sub SCSICMD_Write6 () {0xa;}' unless defined(&SCSICMD_Write6);
    eval 'sub SCSICMD_Seek6 () {0xb;}' unless defined(&SCSICMD_Seek6);
    eval 'sub SCSICMD_Inquiry () {0x12;}' unless defined(&SCSICMD_Inquiry);
    eval 'sub SCSICMD_Verify6 () {0x13;}' unless defined(&SCSICMD_Verify6);
    eval 'sub SCSICMD_ModeSelect6 () {0x15;}' unless defined(&SCSICMD_ModeSelect6);
    eval 'sub SCSICMD_ModeSense6 () {0x1a;}' unless defined(&SCSICMD_ModeSense6);
    eval 'sub SCSICMD_StartStopUnit () {0x1b;}' unless defined(&SCSICMD_StartStopUnit);
    eval 'sub SCSICMD_LoadUnloadTape () {0x1b;}' unless defined(&SCSICMD_LoadUnloadTape);
    eval 'sub SCSICMD_ReadCapacity () {0x25;}' unless defined(&SCSICMD_ReadCapacity);
    eval 'sub SCSICMD_Read10 () {0x28;}' unless defined(&SCSICMD_Read10);
    eval 'sub SCSICMD_Write10 () {0x2a;}' unless defined(&SCSICMD_Write10);
    eval 'sub SCSICMD_Seek10 () {0x2b;}' unless defined(&SCSICMD_Seek10);
    eval 'sub SCSICMD_Erase10 () {0x2c;}' unless defined(&SCSICMD_Erase10);
    eval 'sub SCSICMD_WriteAndVerify10 () {0x2e;}' unless defined(&SCSICMD_WriteAndVerify10);
    eval 'sub SCSICMD_Verify10 () {0x2f;}' unless defined(&SCSICMD_Verify10);
    eval 'sub SCSICMD_WriteBuffer () {0x3b;}' unless defined(&SCSICMD_WriteBuffer);
    eval 'sub SCSICMD_ReadBuffer () {0x3c;}' unless defined(&SCSICMD_ReadBuffer);
    eval 'sub SCSICMD_ReadLong () {0x3e;}' unless defined(&SCSICMD_ReadLong);
    eval 'sub SCSICMD_WriteLong () {0x3f;}' unless defined(&SCSICMD_WriteLong);
    eval 'sub SCSICMD_ReadTOC () {0x43;}' unless defined(&SCSICMD_ReadTOC);
    eval 'sub SCSICMD_ReadHeader () {0x44;}' unless defined(&SCSICMD_ReadHeader);
    eval 'sub SCSICMD_ModeSelect10 () {0x55;}' unless defined(&SCSICMD_ModeSelect10);
    eval 'sub SCSICMD_ModeSense10 () {0x5a;}' unless defined(&SCSICMD_ModeSense10);
    eval 'sub SCSI_TYPE_DASD () {0x;}' unless defined(&SCSI_TYPE_DASD);
    eval 'sub SCSI_TYPE_SASD () {0x1;}' unless defined(&SCSI_TYPE_SASD);
    eval 'sub SCSI_TYPE_PRN () {0x2;}' unless defined(&SCSI_TYPE_PRN);
    eval 'sub SCSI_TYPE_PROC () {0x3;}' unless defined(&SCSI_TYPE_PROC);
    eval 'sub SCSI_TYPE_WORM () {0x4;}' unless defined(&SCSI_TYPE_WORM);
    eval 'sub SCSI_TYPE_CDROM () {0x5;}' unless defined(&SCSI_TYPE_CDROM);
    eval 'sub SCSI_TYPE_SCANNER () {0x6;}' unless defined(&SCSI_TYPE_SCANNER);
    eval 'sub SCSI_TYPE_OPTMEM () {0x7;}' unless defined(&SCSI_TYPE_OPTMEM);
    eval 'sub SCSI_TYPE_MED_CHG () {0x8;}' unless defined(&SCSI_TYPE_MED_CHG);
    eval 'sub SCSI_TYPE_COMM () {0x9;}' unless defined(&SCSI_TYPE_COMM);
    eval 'sub SCSI_TYPE_UNKNOWN () {0x1f;}' unless defined(&SCSI_TYPE_UNKNOWN);
    eval 'sub SCSI_TYPE_NO_DVC () {0xff;}' unless defined(&SCSI_TYPE_NO_DVC);
    eval 'sub ASC_SCSIDIR_NOCHK () {0x;}' unless defined(&ASC_SCSIDIR_NOCHK);
    eval 'sub ASC_SCSIDIR_T2H () {0x8;}' unless defined(&ASC_SCSIDIR_T2H);
    eval 'sub ASC_SCSIDIR_H2T () {0x10;}' unless defined(&ASC_SCSIDIR_H2T);
    eval 'sub ASC_SCSIDIR_NODATA () {0x18;}' unless defined(&ASC_SCSIDIR_NODATA);
    eval 'sub SCSI_SENKEY_NO_SENSE () {0x;}' unless defined(&SCSI_SENKEY_NO_SENSE);
    eval 'sub SCSI_SENKEY_UNDEFINED () {0x1;}' unless defined(&SCSI_SENKEY_UNDEFINED);
    eval 'sub SCSI_SENKEY_NOT_READY () {0x2;}' unless defined(&SCSI_SENKEY_NOT_READY);
    eval 'sub SCSI_SENKEY_MEDIUM_ERR () {0x3;}' unless defined(&SCSI_SENKEY_MEDIUM_ERR);
    eval 'sub SCSI_SENKEY_HW_ERR () {0x4;}' unless defined(&SCSI_SENKEY_HW_ERR);
    eval 'sub SCSI_SENKEY_ILLEGAL () {0x5;}' unless defined(&SCSI_SENKEY_ILLEGAL);
    eval 'sub SCSI_SENKEY_ATTENTION () {0x6;}' unless defined(&SCSI_SENKEY_ATTENTION);
    eval 'sub SCSI_SENKEY_PROTECTED () {0x7;}' unless defined(&SCSI_SENKEY_PROTECTED);
    eval 'sub SCSI_SENKEY_BLANK () {0x8;}' unless defined(&SCSI_SENKEY_BLANK);
    eval 'sub SCSI_SENKEY_V_UNIQUE () {0x9;}' unless defined(&SCSI_SENKEY_V_UNIQUE);
    eval 'sub SCSI_SENKEY_CPY_ABORT () {0xa;}' unless defined(&SCSI_SENKEY_CPY_ABORT);
    eval 'sub SCSI_SENKEY_ABORT () {0xb;}' unless defined(&SCSI_SENKEY_ABORT);
    eval 'sub SCSI_SENKEY_EQUAL () {0xc;}' unless defined(&SCSI_SENKEY_EQUAL);
    eval 'sub SCSI_SENKEY_VOL_OVERFLOW () {0xd;}' unless defined(&SCSI_SENKEY_VOL_OVERFLOW);
    eval 'sub SCSI_SENKEY_MISCOMP () {0xe;}' unless defined(&SCSI_SENKEY_MISCOMP);
    eval 'sub SCSI_SENKEY_RESERVED () {0xf;}' unless defined(&SCSI_SENKEY_RESERVED);
    eval 'sub SCSI_ASC_NOMEDIA () {0x3a;}' unless defined(&SCSI_ASC_NOMEDIA);
    eval 'sub ASC_CCB_HOST {
        local($x) = @_;
	    eval q(((($x) >> 4)));
    }' unless defined(&ASC_CCB_HOST);
    eval 'sub ASC_CCB_TID {
        local($x) = @_;
	    eval q((( & 0xf)));
    }' unless defined(&ASC_CCB_TID);
    eval 'sub ASC_CCB_LUN {
        local($x) = @_;
	    eval q(((($x) >> 13)));
    }' unless defined(&ASC_CCB_LUN);
    eval 'sub SS_GOOD () {0x;}' unless defined(&SS_GOOD);
    eval 'sub SS_CHK_CONDITION () {0x2;}' unless defined(&SS_CHK_CONDITION);
    eval 'sub SS_CONDITION_MET () {0x4;}' unless defined(&SS_CONDITION_MET);
    eval 'sub SS_TARGET_BUSY () {0x8;}' unless defined(&SS_TARGET_BUSY);
    eval 'sub SS_INTERMID () {0x10;}' unless defined(&SS_INTERMID);
    eval 'sub SS_INTERMID_COND_MET () {0x14;}' unless defined(&SS_INTERMID_COND_MET);
    eval 'sub SS_RSERV_CONFLICT () {0x18;}' unless defined(&SS_RSERV_CONFLICT);
    eval 'sub SS_CMD_TERMINATED () {0x22;}' unless defined(&SS_CMD_TERMINATED);
    eval 'sub SS_QUEUE_FULL () {0x28;}' unless defined(&SS_QUEUE_FULL);
    eval 'sub MS_CMD_DONE () {0x;}' unless defined(&MS_CMD_DONE);
    eval 'sub MS_EXTEND () {0x1;}' unless defined(&MS_EXTEND);
    eval 'sub MS_SDTR_LEN () {0x3;}' unless defined(&MS_SDTR_LEN);
    eval 'sub MS_SDTR_CODE () {0x1;}' unless defined(&MS_SDTR_CODE);
    eval 'sub MS_WDTR_LEN () {0x2;}' unless defined(&MS_WDTR_LEN);
    eval 'sub MS_WDTR_CODE () {0x3;}' unless defined(&MS_WDTR_CODE);
    eval 'sub MS_MDP_LEN () {0x5;}' unless defined(&MS_MDP_LEN);
    eval 'sub MS_MDP_CODE () {0x;}' unless defined(&MS_MDP_CODE);
    eval 'sub M1_SAVE_DATA_PTR () {0x2;}' unless defined(&M1_SAVE_DATA_PTR);
    eval 'sub M1_RESTORE_PTRS () {0x3;}' unless defined(&M1_RESTORE_PTRS);
    eval 'sub M1_DISCONNECT () {0x4;}' unless defined(&M1_DISCONNECT);
    eval 'sub M1_INIT_DETECTED_ERR () {0x5;}' unless defined(&M1_INIT_DETECTED_ERR);
    eval 'sub M1_ABORT () {0x6;}' unless defined(&M1_ABORT);
    eval 'sub M1_MSG_REJECT () {0x7;}' unless defined(&M1_MSG_REJECT);
    eval 'sub M1_NO_OP () {0x8;}' unless defined(&M1_NO_OP);
    eval 'sub M1_MSG_PARITY_ERR () {0x9;}' unless defined(&M1_MSG_PARITY_ERR);
    eval 'sub M1_LINK_CMD_DONE () {0xa;}' unless defined(&M1_LINK_CMD_DONE);
    eval 'sub M1_LINK_CMD_DONE_WFLAG () {0xb;}' unless defined(&M1_LINK_CMD_DONE_WFLAG);
    eval 'sub M1_BUS_DVC_RESET () {0xc;}' unless defined(&M1_BUS_DVC_RESET);
    eval 'sub M1_ABORT_TAG () {0xd;}' unless defined(&M1_ABORT_TAG);
    eval 'sub M1_CLR_QUEUE () {0xe;}' unless defined(&M1_CLR_QUEUE);
    eval 'sub M1_INIT_RECOVERY () {0xf;}' unless defined(&M1_INIT_RECOVERY);
    eval 'sub M1_RELEASE_RECOVERY () {0x10;}' unless defined(&M1_RELEASE_RECOVERY);
    eval 'sub M1_KILL_IO_PROC () {0x11;}' unless defined(&M1_KILL_IO_PROC);
    eval 'sub M2_QTAG_MSG_SIMPLE () {0x20;}' unless defined(&M2_QTAG_MSG_SIMPLE);
    eval 'sub M2_QTAG_MSG_HEAD () {0x21;}' unless defined(&M2_QTAG_MSG_HEAD);
    eval 'sub M2_QTAG_MSG_ORDERED () {0x22;}' unless defined(&M2_QTAG_MSG_ORDERED);
    eval 'sub M2_IGNORE_WIDE_RESIDUE () {0x23;}' unless defined(&M2_IGNORE_WIDE_RESIDUE);
    eval 'sub ASC_SCSIQ_CPY_BEG () {4;}' unless defined(&ASC_SCSIQ_CPY_BEG);
    eval 'sub ASC_SCSIQ_SGHD_CPY_BEG () {2;}' unless defined(&ASC_SCSIQ_SGHD_CPY_BEG);
    eval 'sub ASC_SCSIQ_B_FWD () {0;}' unless defined(&ASC_SCSIQ_B_FWD);
    eval 'sub ASC_SCSIQ_B_BWD () {1;}' unless defined(&ASC_SCSIQ_B_BWD);
    eval 'sub ASC_SCSIQ_B_STATUS () {2;}' unless defined(&ASC_SCSIQ_B_STATUS);
    eval 'sub ASC_SCSIQ_B_QNO () {3;}' unless defined(&ASC_SCSIQ_B_QNO);
    eval 'sub ASC_SCSIQ_B_CNTL () {4;}' unless defined(&ASC_SCSIQ_B_CNTL);
    eval 'sub ASC_SCSIQ_B_SG_QUEUE_CNT () {5;}' unless defined(&ASC_SCSIQ_B_SG_QUEUE_CNT);
    eval 'sub ASC_SCSIQ_D_DATA_ADDR () {8;}' unless defined(&ASC_SCSIQ_D_DATA_ADDR);
    eval 'sub ASC_SCSIQ_D_DATA_CNT () {12;}' unless defined(&ASC_SCSIQ_D_DATA_CNT);
    eval 'sub ASC_SCSIQ_B_SENSE_LEN () {20;}' unless defined(&ASC_SCSIQ_B_SENSE_LEN);
    eval 'sub ASC_SCSIQ_DONE_INFO_BEG () {22;}' unless defined(&ASC_SCSIQ_DONE_INFO_BEG);
    eval 'sub ASC_SCSIQ_D_CCBPTR () {22;}' unless defined(&ASC_SCSIQ_D_CCBPTR);
    eval 'sub ASC_SCSIQ_B_TARGET_IX () {26;}' unless defined(&ASC_SCSIQ_B_TARGET_IX);
    eval 'sub ASC_SCSIQ_B_CDB_LEN () {28;}' unless defined(&ASC_SCSIQ_B_CDB_LEN);
    eval 'sub ASC_SCSIQ_B_TAG_CODE () {29;}' unless defined(&ASC_SCSIQ_B_TAG_CODE);
    eval 'sub ASC_SCSIQ_W_VM_ID () {30;}' unless defined(&ASC_SCSIQ_W_VM_ID);
    eval 'sub ASC_SCSIQ_DONE_STATUS () {32;}' unless defined(&ASC_SCSIQ_DONE_STATUS);
    eval 'sub ASC_SCSIQ_HOST_STATUS () {33;}' unless defined(&ASC_SCSIQ_HOST_STATUS);
    eval 'sub ASC_SCSIQ_SCSI_STATUS () {34;}' unless defined(&ASC_SCSIQ_SCSI_STATUS);
    eval 'sub ASC_SCSIQ_CDB_BEG () {36;}' unless defined(&ASC_SCSIQ_CDB_BEG);
    eval 'sub ASC_SCSIQ_DW_REMAIN_XFER_ADDR () {56;}' unless defined(&ASC_SCSIQ_DW_REMAIN_XFER_ADDR);
    eval 'sub ASC_SCSIQ_DW_REMAIN_XFER_CNT () {60;}' unless defined(&ASC_SCSIQ_DW_REMAIN_XFER_CNT);
    eval 'sub ASC_SCSIQ_B_SG_WK_QP () {49;}' unless defined(&ASC_SCSIQ_B_SG_WK_QP);
    eval 'sub ASC_SCSIQ_B_SG_WK_IX () {50;}' unless defined(&ASC_SCSIQ_B_SG_WK_IX);
    eval 'sub ASC_SCSIQ_W_REQ_COUNT () {52;}' unless defined(&ASC_SCSIQ_W_REQ_COUNT);
    eval 'sub ASC_SCSIQ_B_LIST_CNT () {6;}' unless defined(&ASC_SCSIQ_B_LIST_CNT);
    eval 'sub ASC_SCSIQ_B_CUR_LIST_CNT () {7;}' unless defined(&ASC_SCSIQ_B_CUR_LIST_CNT);
    eval 'sub ASC_DEF_SCSI1_QNG () {4;}' unless defined(&ASC_DEF_SCSI1_QNG);
    eval 'sub ASC_MAX_SCSI1_QNG () {4;}' unless defined(&ASC_MAX_SCSI1_QNG);
    eval 'sub ASC_DEF_SCSI2_QNG () {16;}' unless defined(&ASC_DEF_SCSI2_QNG);
    eval 'sub ASC_MAX_SCSI2_QNG () {32;}' unless defined(&ASC_MAX_SCSI2_QNG);
    eval 'sub ASC_TAG_CODE_MASK () {0x23;}' unless defined(&ASC_TAG_CODE_MASK);
    eval 'sub ASC_STOP_REQ_RISC_STOP () {0x1;}' unless defined(&ASC_STOP_REQ_RISC_STOP);
    eval 'sub ASC_STOP_ACK_RISC_STOP () {0x3;}' unless defined(&ASC_STOP_ACK_RISC_STOP);
    eval 'sub ASC_STOP_CLEAN_UP_BUSY_Q () {0x10;}' unless defined(&ASC_STOP_CLEAN_UP_BUSY_Q);
    eval 'sub ASC_STOP_CLEAN_UP_DISC_Q () {0x20;}' unless defined(&ASC_STOP_CLEAN_UP_DISC_Q);
    eval 'sub ASC_STOP_HOST_REQ_RISC_HALT () {0x40;}' unless defined(&ASC_STOP_HOST_REQ_RISC_HALT);
    eval 'sub ASC_TIDLUN_TO_IX {
        local($tid, $lun) = @_;
	    eval q((($tid) + (($lun)<< &ASC_SCSI_ID_BITS)));
    }' unless defined(&ASC_TIDLUN_TO_IX);
    eval 'sub ASC_TID_TO_TARGET_ID {
        local($tid) = @_;
	    eval q((0x1 << ($tid)));
    }' unless defined(&ASC_TID_TO_TARGET_ID);
    eval 'sub ASC_TIX_TO_TARGET_ID {
        local($tix) = @_;
	    eval q((0x1 << (($tix) &  &ASC_MAX_TID)));
    }' unless defined(&ASC_TIX_TO_TARGET_ID);
    eval 'sub ASC_TIX_TO_TID {
        local($tix) = @_;
	    eval q((($tix) &  &ASC_MAX_TID));
    }' unless defined(&ASC_TIX_TO_TID);
    eval 'sub ASC_TID_TO_TIX {
        local($tid) = @_;
	    eval q((($tid) &  &ASC_MAX_TID));
    }' unless defined(&ASC_TID_TO_TIX);
    eval 'sub ASC_TIX_TO_LUN {
        local($tix) = @_;
	    eval q(((($tix) >>  &ASC_SCSI_ID_BITS) &  &ASC_MAX_LUN));
    }' unless defined(&ASC_TIX_TO_LUN);
    eval 'sub ASC_QNO_TO_QADDR {
        local($q_no) = @_;
	    eval q((+(($q_no) << 6)));
    }' unless defined(&ASC_QNO_TO_QADDR);
    eval 'sub ASC_QS_FREE () {0x;}' unless defined(&ASC_QS_FREE);
    eval 'sub ASC_QS_READY () {0x1;}' unless defined(&ASC_QS_READY);
    eval 'sub ASC_QS_DISC1 () {0x2;}' unless defined(&ASC_QS_DISC1);
    eval 'sub ASC_QS_DISC2 () {0x4;}' unless defined(&ASC_QS_DISC2);
    eval 'sub ASC_QS_BUSY () {0x8;}' unless defined(&ASC_QS_BUSY);
    eval 'sub ASC_QS_ABORTED () {0x40;}' unless defined(&ASC_QS_ABORTED);
    eval 'sub ASC_QS_DONE () {0x80;}' unless defined(&ASC_QS_DONE);
    eval 'sub ASC_QC_NO_CALLBACK () {0x1;}' unless defined(&ASC_QC_NO_CALLBACK);
    eval 'sub ASC_QC_SG_SWAP_QUEUE () {0x2;}' unless defined(&ASC_QC_SG_SWAP_QUEUE);
    eval 'sub ASC_QC_SG_HEAD () {0x4;}' unless defined(&ASC_QC_SG_HEAD);
    eval 'sub ASC_QC_DATA_IN () {0x8;}' unless defined(&ASC_QC_DATA_IN);
    eval 'sub ASC_QC_DATA_OUT () {0x10;}' unless defined(&ASC_QC_DATA_OUT);
    eval 'sub ASC_QC_URGENT () {0x20;}' unless defined(&ASC_QC_URGENT);
    eval 'sub ASC_QC_MSG_OUT () {0x40;}' unless defined(&ASC_QC_MSG_OUT);
    eval 'sub ASC_QC_REQ_SENSE () {0x80;}' unless defined(&ASC_QC_REQ_SENSE);
    eval 'sub ASC_TAG_FLAG_EXTRA_BYTES () {0x10;}' unless defined(&ASC_TAG_FLAG_EXTRA_BYTES);
    eval 'sub ASC_TAG_FLAG_DISABLE_DISCONNECT () {0x4;}' unless defined(&ASC_TAG_FLAG_DISABLE_DISCONNECT);
    eval 'sub ASC_TAG_FLAG_DISABLE_ASYN_USE_SYN_FIX () {0x8;}' unless defined(&ASC_TAG_FLAG_DISABLE_ASYN_USE_SYN_FIX);
    eval 'sub ASC_TAG_FLAG_DISABLE_CHK_COND_INT_HOST () {0x40;}' unless defined(&ASC_TAG_FLAG_DISABLE_CHK_COND_INT_HOST);
    eval 'sub ASC_QD_IN_PROGRESS () {0x;}' unless defined(&ASC_QD_IN_PROGRESS);
    eval 'sub ASC_QD_NO_ERROR () {0x1;}' unless defined(&ASC_QD_NO_ERROR);
    eval 'sub ASC_QD_ABORTED_BY_HOST () {0x2;}' unless defined(&ASC_QD_ABORTED_BY_HOST);
    eval 'sub ASC_QD_WITH_ERROR () {0x4;}' unless defined(&ASC_QD_WITH_ERROR);
    eval 'sub ASC_QD_INVALID_REQUEST () {0x80;}' unless defined(&ASC_QD_INVALID_REQUEST);
    eval 'sub ASC_QD_INVALID_HOST_NUM () {0x81;}' unless defined(&ASC_QD_INVALID_HOST_NUM);
    eval 'sub ASC_QD_INVALID_DEVICE () {0x82;}' unless defined(&ASC_QD_INVALID_DEVICE);
    eval 'sub ASC_QD_ERR_INTERNAL () {0xff;}' unless defined(&ASC_QD_ERR_INTERNAL);
    eval 'sub ASC_QHSTA_NO_ERROR () {0x;}' unless defined(&ASC_QHSTA_NO_ERROR);
    eval 'sub ASC_QHSTA_M_SEL_TIMEOUT () {0x11;}' unless defined(&ASC_QHSTA_M_SEL_TIMEOUT);
    eval 'sub ASC_QHSTA_M_DATA_OVER_RUN () {0x12;}' unless defined(&ASC_QHSTA_M_DATA_OVER_RUN);
    eval 'sub ASC_QHSTA_M_DATA_UNDER_RUN () {0x12;}' unless defined(&ASC_QHSTA_M_DATA_UNDER_RUN);
    eval 'sub ASC_QHSTA_M_UNEXPECTED_BUS_FREE () {0x13;}' unless defined(&ASC_QHSTA_M_UNEXPECTED_BUS_FREE);
    eval 'sub ASC_QHSTA_M_BAD_BUS_PHASE_SEQ () {0x14;}' unless defined(&ASC_QHSTA_M_BAD_BUS_PHASE_SEQ);
    eval 'sub ASC_QHSTA_D_QDONE_SG_LIST_CORRUPTED () {0x21;}' unless defined(&ASC_QHSTA_D_QDONE_SG_LIST_CORRUPTED);
    eval 'sub ASC_QHSTA_D_ASC_DVC_ERROR_CODE_SET () {0x22;}' unless defined(&ASC_QHSTA_D_ASC_DVC_ERROR_CODE_SET);
    eval 'sub ASC_QHSTA_D_HOST_ABORT_FAILED () {0x23;}' unless defined(&ASC_QHSTA_D_HOST_ABORT_FAILED);
    eval 'sub ASC_QHSTA_D_EXE_SCSI_Q_FAILED () {0x24;}' unless defined(&ASC_QHSTA_D_EXE_SCSI_Q_FAILED);
    eval 'sub ASC_QHSTA_D_EXE_SCSI_Q_BUSY_TIMEOUT () {0x25;}' unless defined(&ASC_QHSTA_D_EXE_SCSI_Q_BUSY_TIMEOUT);
    eval 'sub ASC_QHSTA_D_ASPI_NO_BUF_POOL () {0x26;}' unless defined(&ASC_QHSTA_D_ASPI_NO_BUF_POOL);
    eval 'sub ASC_QHSTA_M_WTM_TIMEOUT () {0x41;}' unless defined(&ASC_QHSTA_M_WTM_TIMEOUT);
    eval 'sub ASC_QHSTA_M_BAD_CMPL_STATUS_IN () {0x42;}' unless defined(&ASC_QHSTA_M_BAD_CMPL_STATUS_IN);
    eval 'sub ASC_QHSTA_M_NO_AUTO_REQ_SENSE () {0x43;}' unless defined(&ASC_QHSTA_M_NO_AUTO_REQ_SENSE);
    eval 'sub ASC_QHSTA_M_AUTO_REQ_SENSE_FAIL () {0x44;}' unless defined(&ASC_QHSTA_M_AUTO_REQ_SENSE_FAIL);
    eval 'sub ASC_QHSTA_M_TARGET_STATUS_BUSY () {0x45;}' unless defined(&ASC_QHSTA_M_TARGET_STATUS_BUSY);
    eval 'sub ASC_QHSTA_M_BAD_TAG_CODE () {0x46;}' unless defined(&ASC_QHSTA_M_BAD_TAG_CODE);
    eval 'sub ASC_QHSTA_M_BAD_QUEUE_FULL_OR_BUSY () {0x47;}' unless defined(&ASC_QHSTA_M_BAD_QUEUE_FULL_OR_BUSY);
    eval 'sub ASC_QHSTA_M_HUNG_REQ_SCSI_BUS_RESET () {0x48;}' unless defined(&ASC_QHSTA_M_HUNG_REQ_SCSI_BUS_RESET);
    eval 'sub ASC_QHSTA_D_LRAM_CMP_ERROR () {0x81;}' unless defined(&ASC_QHSTA_D_LRAM_CMP_ERROR);
    eval 'sub ASC_QHSTA_M_MICRO_CODE_ERROR_HALT () {0xa1;}' unless defined(&ASC_QHSTA_M_MICRO_CODE_ERROR_HALT);
    eval 'sub ASC_MIN_SG_LIST () {2;}' unless defined(&ASC_MIN_SG_LIST);
    eval 'sub ASC_QCX_SORT () {0x1;}' unless defined(&ASC_QCX_SORT);
    eval 'sub ASC_QCX_COALEASE () {0x2;}' unless defined(&ASC_QCX_COALEASE);
    eval 'sub ASC_QCSG_SG_XFER_LIST () {0x2;}' unless defined(&ASC_QCSG_SG_XFER_LIST);
    eval 'sub ASC_QCSG_SG_XFER_MORE () {0x4;}' unless defined(&ASC_QCSG_SG_XFER_MORE);
    eval 'sub ASC_QCSG_SG_XFER_END () {0x8;}' unless defined(&ASC_QCSG_SG_XFER_END);
    eval 'sub ASC_SGQ_B_SG_CNTL () {4;}' unless defined(&ASC_SGQ_B_SG_CNTL);
    eval 'sub ASC_SGQ_B_SG_HEAD_QP () {5;}' unless defined(&ASC_SGQ_B_SG_HEAD_QP);
    eval 'sub ASC_SGQ_B_SG_LIST_CNT () {6;}' unless defined(&ASC_SGQ_B_SG_LIST_CNT);
    eval 'sub ASC_SGQ_B_SG_CUR_LIST_CNT () {7;}' unless defined(&ASC_SGQ_B_SG_CUR_LIST_CNT);
    eval 'sub ASC_SGQ_LIST_BEG () {8;}' unless defined(&ASC_SGQ_LIST_BEG);
    eval 'sub ASC_EXE_SCSI_IO_MAX_IDLE_LOOP () {0x1000000;}' unless defined(&ASC_EXE_SCSI_IO_MAX_IDLE_LOOP);
    eval 'sub ASC_EXE_SCSI_IO_MAX_WAIT_LOOP () {1024;}' unless defined(&ASC_EXE_SCSI_IO_MAX_WAIT_LOOP);
    eval 'sub ASCQ_ERR_NO_ERROR () {0x;}' unless defined(&ASCQ_ERR_NO_ERROR);
    eval 'sub ASCQ_ERR_IO_NOT_FOUND () {0x1;}' unless defined(&ASCQ_ERR_IO_NOT_FOUND);
    eval 'sub ASCQ_ERR_LOCAL_MEM () {0x2;}' unless defined(&ASCQ_ERR_LOCAL_MEM);
    eval 'sub ASCQ_ERR_CHKSUM () {0x3;}' unless defined(&ASCQ_ERR_CHKSUM);
    eval 'sub ASCQ_ERR_START_CHIP () {0x4;}' unless defined(&ASCQ_ERR_START_CHIP);
    eval 'sub ASCQ_ERR_INT_TARGET_ID () {0x5;}' unless defined(&ASCQ_ERR_INT_TARGET_ID);
    eval 'sub ASCQ_ERR_INT_LOCAL_MEM () {0x6;}' unless defined(&ASCQ_ERR_INT_LOCAL_MEM);
    eval 'sub ASCQ_ERR_HALT_RISC () {0x7;}' unless defined(&ASCQ_ERR_HALT_RISC);
    eval 'sub ASCQ_ERR_GET_ASPI_ENTRY () {0x8;}' unless defined(&ASCQ_ERR_GET_ASPI_ENTRY);
    eval 'sub ASCQ_ERR_CLOSE_ASPI () {0x9;}' unless defined(&ASCQ_ERR_CLOSE_ASPI);
    eval 'sub ASCQ_ERR_HOST_INQUIRY () {0xa;}' unless defined(&ASCQ_ERR_HOST_INQUIRY);
    eval 'sub ASCQ_ERR_SAVED_CCB_BAD () {0xb;}' unless defined(&ASCQ_ERR_SAVED_CCB_BAD);
    eval 'sub ASCQ_ERR_QCNTL_SG_LIST () {0xc;}' unless defined(&ASCQ_ERR_QCNTL_SG_LIST);
    eval 'sub ASCQ_ERR_Q_STATUS () {0xd;}' unless defined(&ASCQ_ERR_Q_STATUS);
    eval 'sub ASCQ_ERR_WR_SCSIQ () {0xe;}' unless defined(&ASCQ_ERR_WR_SCSIQ);
    eval 'sub ASCQ_ERR_PC_ADDR () {0xf;}' unless defined(&ASCQ_ERR_PC_ADDR);
    eval 'sub ASCQ_ERR_SYN_OFFSET () {0x10;}' unless defined(&ASCQ_ERR_SYN_OFFSET);
    eval 'sub ASCQ_ERR_SYN_XFER_TIME () {0x11;}' unless defined(&ASCQ_ERR_SYN_XFER_TIME);
    eval 'sub ASCQ_ERR_LOCK_DMA () {0x12;}' unless defined(&ASCQ_ERR_LOCK_DMA);
    eval 'sub ASCQ_ERR_UNLOCK_DMA () {0x13;}' unless defined(&ASCQ_ERR_UNLOCK_DMA);
    eval 'sub ASCQ_ERR_VDS_CHK_INSTALL () {0x14;}' unless defined(&ASCQ_ERR_VDS_CHK_INSTALL);
    eval 'sub ASCQ_ERR_MICRO_CODE_HALT () {0x15;}' unless defined(&ASCQ_ERR_MICRO_CODE_HALT);
    eval 'sub ASCQ_ERR_SET_LRAM_ADDR () {0x16;}' unless defined(&ASCQ_ERR_SET_LRAM_ADDR);
    eval 'sub ASCQ_ERR_CUR_QNG () {0x17;}' unless defined(&ASCQ_ERR_CUR_QNG);
    eval 'sub ASCQ_ERR_SG_Q_LINKS () {0x18;}' unless defined(&ASCQ_ERR_SG_Q_LINKS);
    eval 'sub ASCQ_ERR_SCSIQ_PTR () {0x19;}' unless defined(&ASCQ_ERR_SCSIQ_PTR);
    eval 'sub ASCQ_ERR_ISR_RE_ENTRY () {0x1a;}' unless defined(&ASCQ_ERR_ISR_RE_ENTRY);
    eval 'sub ASCQ_ERR_CRITICAL_RE_ENTRY () {0x1b;}' unless defined(&ASCQ_ERR_CRITICAL_RE_ENTRY);
    eval 'sub ASCQ_ERR_ISR_ON_CRITICAL () {0x1c;}' unless defined(&ASCQ_ERR_ISR_ON_CRITICAL);
    eval 'sub ASCQ_ERR_SG_LIST_ODD_ADDRESS () {0x1d;}' unless defined(&ASCQ_ERR_SG_LIST_ODD_ADDRESS);
    eval 'sub ASCQ_ERR_XFER_ADDRESS_TOO_BIG () {0x1e;}' unless defined(&ASCQ_ERR_XFER_ADDRESS_TOO_BIG);
    eval 'sub ASCQ_ERR_SCSIQ_NULL_PTR () {0x1f;}' unless defined(&ASCQ_ERR_SCSIQ_NULL_PTR);
    eval 'sub ASCQ_ERR_SCSIQ_BAD_NEXT_PTR () {0x20;}' unless defined(&ASCQ_ERR_SCSIQ_BAD_NEXT_PTR);
    eval 'sub ASCQ_ERR_GET_NUM_OF_FREE_Q () {0x21;}' unless defined(&ASCQ_ERR_GET_NUM_OF_FREE_Q);
    eval 'sub ASCQ_ERR_SEND_SCSI_Q () {0x22;}' unless defined(&ASCQ_ERR_SEND_SCSI_Q);
    eval 'sub ASCQ_ERR_HOST_REQ_RISC_HALT () {0x23;}' unless defined(&ASCQ_ERR_HOST_REQ_RISC_HALT);
    eval 'sub ASCQ_ERR_RESET_SDTR () {0x24;}' unless defined(&ASCQ_ERR_RESET_SDTR);
    eval 'sub ASC_WARN_NO_ERROR () {0x;}' unless defined(&ASC_WARN_NO_ERROR);
    eval 'sub ASC_WARN_IO_PORT_ROTATE () {0x1;}' unless defined(&ASC_WARN_IO_PORT_ROTATE);
    eval 'sub ASC_WARN_EEPROM_CHKSUM () {0x2;}' unless defined(&ASC_WARN_EEPROM_CHKSUM);
    eval 'sub ASC_WARN_IRQ_MODIFIED () {0x4;}' unless defined(&ASC_WARN_IRQ_MODIFIED);
    eval 'sub ASC_WARN_AUTO_CONFIG () {0x8;}' unless defined(&ASC_WARN_AUTO_CONFIG);
    eval 'sub ASC_WARN_CMD_QNG_CONFLICT () {0x10;}' unless defined(&ASC_WARN_CMD_QNG_CONFLICT);
    eval 'sub ASC_WARN_EEPROM_RECOVER () {0x20;}' unless defined(&ASC_WARN_EEPROM_RECOVER);
    eval 'sub ASC_WARN_CFG_MSW_RECOVER () {0x40;}' unless defined(&ASC_WARN_CFG_MSW_RECOVER);
    eval 'sub ASC_WARN_SET_PCI_CONFIG_SPACE () {0x80;}' unless defined(&ASC_WARN_SET_PCI_CONFIG_SPACE);
    eval 'sub ASC_IERR_WRITE_EEPROM () {0x1;}' unless defined(&ASC_IERR_WRITE_EEPROM);
    eval 'sub ASC_IERR_MCODE_CHKSUM () {0x2;}' unless defined(&ASC_IERR_MCODE_CHKSUM);
    eval 'sub ASC_IERR_SET_PC_ADDR () {0x4;}' unless defined(&ASC_IERR_SET_PC_ADDR);
    eval 'sub ASC_IERR_START_STOP_CHIP () {0x8;}' unless defined(&ASC_IERR_START_STOP_CHIP);
    eval 'sub ASC_IERR_IRQ_NO () {0x10;}' unless defined(&ASC_IERR_IRQ_NO);
    eval 'sub ASC_IERR_SET_IRQ_NO () {0x20;}' unless defined(&ASC_IERR_SET_IRQ_NO);
    eval 'sub ASC_IERR_CHIP_VERSION () {0x40;}' unless defined(&ASC_IERR_CHIP_VERSION);
    eval 'sub ASC_IERR_SET_SCSI_ID () {0x80;}' unless defined(&ASC_IERR_SET_SCSI_ID);
    eval 'sub ASC_IERR_GET_PHY_ADDR () {0x100;}' unless defined(&ASC_IERR_GET_PHY_ADDR);
    eval 'sub ASC_IERR_BAD_SIGNATURE () {0x200;}' unless defined(&ASC_IERR_BAD_SIGNATURE);
    eval 'sub ASC_IERR_NO_BUS_TYPE () {0x400;}' unless defined(&ASC_IERR_NO_BUS_TYPE);
    eval 'sub ASC_IERR_SCAM () {0x800;}' unless defined(&ASC_IERR_SCAM);
    eval 'sub ASC_IERR_SET_SDTR () {0x1000;}' unless defined(&ASC_IERR_SET_SDTR);
    eval 'sub ASC_IERR_RW_LRAM () {0x8000;}' unless defined(&ASC_IERR_RW_LRAM);
    eval 'sub ASC_DEF_IRQ_NO () {10;}' unless defined(&ASC_DEF_IRQ_NO);
    eval 'sub ASC_MAX_IRQ_NO () {15;}' unless defined(&ASC_MAX_IRQ_NO);
    eval 'sub ASC_MIN_IRQ_NO () {10;}' unless defined(&ASC_MIN_IRQ_NO);
    eval 'sub ASC_MIN_REMAIN_Q () {0x2;}' unless defined(&ASC_MIN_REMAIN_Q);
    eval 'sub ASC_DEF_MAX_TOTAL_QNG () {0xf0;}' unless defined(&ASC_DEF_MAX_TOTAL_QNG);
    eval 'sub ASC_MIN_TAG_Q_PER_DVC () {0x4;}' unless defined(&ASC_MIN_TAG_Q_PER_DVC);
    eval 'sub ASC_DEF_TAG_Q_PER_DVC () {0x4;}' unless defined(&ASC_DEF_TAG_Q_PER_DVC);
    eval 'sub ASC_MIN_FREE_Q () { &ASC_MIN_REMAIN_Q;}' unless defined(&ASC_MIN_FREE_Q);
    eval 'sub ASC_MIN_TOTAL_QNG () {(( &ASC_MAX_SG_QUEUE)+( &ASC_MIN_FREE_Q));}' unless defined(&ASC_MIN_TOTAL_QNG);
    eval 'sub ASC_MAX_TOTAL_QNG () {240;}' unless defined(&ASC_MAX_TOTAL_QNG);
    eval 'sub ASC_MAX_PCI_ULTRA_INRAM_TOTAL_QNG () {16;}' unless defined(&ASC_MAX_PCI_ULTRA_INRAM_TOTAL_QNG);
    eval 'sub ASC_MAX_PCI_ULTRA_INRAM_TAG_QNG () {8;}' unless defined(&ASC_MAX_PCI_ULTRA_INRAM_TAG_QNG);
    eval 'sub ASC_MAX_PCI_INRAM_TOTAL_QNG () {20;}' unless defined(&ASC_MAX_PCI_INRAM_TOTAL_QNG);
    eval 'sub ASC_MAX_INRAM_TAG_QNG () {16;}' unless defined(&ASC_MAX_INRAM_TAG_QNG);
    eval 'sub ASC_IOADR_TABLE_MAX_IX () {11;}' unless defined(&ASC_IOADR_TABLE_MAX_IX);
    eval 'sub ASC_IOADR_GAP () {0x10;}' unless defined(&ASC_IOADR_GAP);
    eval 'sub ASC_SEARCH_IOP_GAP () {0x10;}' unless defined(&ASC_SEARCH_IOP_GAP);
    eval 'sub ASC_MIN_IOP_ADDR () {0x100;}' unless defined(&ASC_MIN_IOP_ADDR);
    eval 'sub ASC_MAX_IOP_ADDR () {0x3f0;}' unless defined(&ASC_MAX_IOP_ADDR);
    eval 'sub ASC_IOADR_1 () {0x110;}' unless defined(&ASC_IOADR_1);
    eval 'sub ASC_IOADR_2 () {0x130;}' unless defined(&ASC_IOADR_2);
    eval 'sub ASC_IOADR_3 () {0x150;}' unless defined(&ASC_IOADR_3);
    eval 'sub ASC_IOADR_4 () {0x190;}' unless defined(&ASC_IOADR_4);
    eval 'sub ASC_IOADR_5 () {0x210;}' unless defined(&ASC_IOADR_5);
    eval 'sub ASC_IOADR_6 () {0x230;}' unless defined(&ASC_IOADR_6);
    eval 'sub ASC_IOADR_7 () {0x250;}' unless defined(&ASC_IOADR_7);
    eval 'sub ASC_IOADR_8 () {0x330;}' unless defined(&ASC_IOADR_8);
    eval 'sub ASC_IOADR_DEF () { &ASC_IOADR_8;}' unless defined(&ASC_IOADR_DEF);
    eval 'sub ASC_LIB_SCSIQ_WK_SP () {256;}' unless defined(&ASC_LIB_SCSIQ_WK_SP);
    eval 'sub ASC_MAX_SYN_XFER_NO () {16;}' unless defined(&ASC_MAX_SYN_XFER_NO);
    eval 'sub ASC_SYN_MAX_OFFSET () {0xf;}' unless defined(&ASC_SYN_MAX_OFFSET);
    eval 'sub ASC_DEF_SDTR_OFFSET () {0xf;}' unless defined(&ASC_DEF_SDTR_OFFSET);
    eval 'sub ASC_DEF_SDTR_INDEX () {0x;}' unless defined(&ASC_DEF_SDTR_INDEX);
    eval 'sub ASC_SDTR_ULTRA_PCI_10MB_INDEX () {0x2;}' unless defined(&ASC_SDTR_ULTRA_PCI_10MB_INDEX);
    eval 'sub xfer_period () { ($u_ext_msg->{sdtr}->{sdtr_xfer_period});}' unless defined(&xfer_period);
    eval 'sub req_ack_offset () { ($u_ext_msg->{sdtr}->{sdtr_req_ack_offset});}' unless defined(&req_ack_offset);
    eval 'sub wdtr_width () { ($u_ext_msg->{wdtr}->{wdtr_width});}' unless defined(&wdtr_width);
    eval 'sub mdp_b3 () { ($u_ext_msg->{mdp_b3});}' unless defined(&mdp_b3);
    eval 'sub mdp_b2 () { ($u_ext_msg->{mdp_b2});}' unless defined(&mdp_b2);
    eval 'sub mdp_b1 () { ($u_ext_msg->{mdp_b1});}' unless defined(&mdp_b1);
    eval 'sub mdp_b0 () { ($u_ext_msg->{mdp_b0});}' unless defined(&mdp_b0);
    eval 'sub ASC_DEF_DVC_CNTL () {0xffff;}' unless defined(&ASC_DEF_DVC_CNTL);
    eval 'sub ASC_DEF_CHIP_SCSI_ID () {7;}' unless defined(&ASC_DEF_CHIP_SCSI_ID);
    eval 'sub ASC_DEF_ISA_DMA_SPEED () {4;}' unless defined(&ASC_DEF_ISA_DMA_SPEED);
    eval 'sub ASC_PCI_DEVICE_ID_REV_A () {0x1100;}' unless defined(&ASC_PCI_DEVICE_ID_REV_A);
    eval 'sub ASC_PCI_DEVICE_ID_REV_B () {0x1200;}' unless defined(&ASC_PCI_DEVICE_ID_REV_B);
    eval 'sub ASC_BUG_FIX_IF_NOT_DWB () {0x1;}' unless defined(&ASC_BUG_FIX_IF_NOT_DWB);
    eval 'sub ASC_BUG_FIX_ASYN_USE_SYN () {0x2;}' unless defined(&ASC_BUG_FIX_ASYN_USE_SYN);
    eval 'sub ASYN_SDTR_DATA_FIX_PCI_REV_AB () {0x41;}' unless defined(&ASYN_SDTR_DATA_FIX_PCI_REV_AB);
    eval 'sub ASC_MIN_TAGGED_CMD () {7;}' unless defined(&ASC_MIN_TAGGED_CMD);
    eval 'sub ASC_MAX_SCSI_RESET_WAIT () {30;}' unless defined(&ASC_MAX_SCSI_RESET_WAIT);
    eval 'sub ASC_HOST_IN_RESET () {0x1;}' unless defined(&ASC_HOST_IN_RESET);
    eval 'sub ASC_HOST_IN_ABORT () {0x2;}' unless defined(&ASC_HOST_IN_ABORT);
    eval 'sub ASC_WIDE_BOARD () {0x4;}' unless defined(&ASC_WIDE_BOARD);
    eval 'sub ASC_SELECT_QUEUE_DEPTHS () {0x8;}' unless defined(&ASC_SELECT_QUEUE_DEPTHS);
    eval 'sub SYN_XFER_NS_0 () {25;}' unless defined(&SYN_XFER_NS_0);
    eval 'sub SYN_XFER_NS_1 () {30;}' unless defined(&SYN_XFER_NS_1);
    eval 'sub SYN_XFER_NS_2 () {35;}' unless defined(&SYN_XFER_NS_2);
    eval 'sub SYN_XFER_NS_3 () {40;}' unless defined(&SYN_XFER_NS_3);
    eval 'sub SYN_XFER_NS_4 () {50;}' unless defined(&SYN_XFER_NS_4);
    eval 'sub SYN_XFER_NS_5 () {60;}' unless defined(&SYN_XFER_NS_5);
    eval 'sub SYN_XFER_NS_6 () {70;}' unless defined(&SYN_XFER_NS_6);
    eval 'sub SYN_XFER_NS_7 () {85;}' unless defined(&SYN_XFER_NS_7);
    eval 'sub SYN_ULTRA_XFER_NS_0 () {12;}' unless defined(&SYN_ULTRA_XFER_NS_0);
    eval 'sub SYN_ULTRA_XFER_NS_1 () {19;}' unless defined(&SYN_ULTRA_XFER_NS_1);
    eval 'sub SYN_ULTRA_XFER_NS_2 () {25;}' unless defined(&SYN_ULTRA_XFER_NS_2);
    eval 'sub SYN_ULTRA_XFER_NS_3 () {32;}' unless defined(&SYN_ULTRA_XFER_NS_3);
    eval 'sub SYN_ULTRA_XFER_NS_4 () {38;}' unless defined(&SYN_ULTRA_XFER_NS_4);
    eval 'sub SYN_ULTRA_XFER_NS_5 () {44;}' unless defined(&SYN_ULTRA_XFER_NS_5);
    eval 'sub SYN_ULTRA_XFER_NS_6 () {50;}' unless defined(&SYN_ULTRA_XFER_NS_6);
    eval 'sub SYN_ULTRA_XFER_NS_7 () {57;}' unless defined(&SYN_ULTRA_XFER_NS_7);
    eval 'sub SYN_ULTRA_XFER_NS_8 () {63;}' unless defined(&SYN_ULTRA_XFER_NS_8);
    eval 'sub SYN_ULTRA_XFER_NS_9 () {69;}' unless defined(&SYN_ULTRA_XFER_NS_9);
    eval 'sub SYN_ULTRA_XFER_NS_10 () {75;}' unless defined(&SYN_ULTRA_XFER_NS_10);
    eval 'sub SYN_ULTRA_XFER_NS_11 () {82;}' unless defined(&SYN_ULTRA_XFER_NS_11);
    eval 'sub SYN_ULTRA_XFER_NS_12 () {88;}' unless defined(&SYN_ULTRA_XFER_NS_12);
    eval 'sub SYN_ULTRA_XFER_NS_13 () {94;}' unless defined(&SYN_ULTRA_XFER_NS_13);
    eval 'sub SYN_ULTRA_XFER_NS_14 () {100;}' unless defined(&SYN_ULTRA_XFER_NS_14);
    eval 'sub SYN_ULTRA_XFER_NS_15 () {107;}' unless defined(&SYN_ULTRA_XFER_NS_15);
    eval 'sub ASC_MCNTL_NO_SEL_TIMEOUT () {0x1;}' unless defined(&ASC_MCNTL_NO_SEL_TIMEOUT);
    eval 'sub ASC_MCNTL_NULL_TARGET () {0x2;}' unless defined(&ASC_MCNTL_NULL_TARGET);
    eval 'sub ASC_CNTL_INITIATOR () {0x1;}' unless defined(&ASC_CNTL_INITIATOR);
    eval 'sub ASC_CNTL_BIOS_GT_1GB () {0x2;}' unless defined(&ASC_CNTL_BIOS_GT_1GB);
    eval 'sub ASC_CNTL_BIOS_GT_2_DISK () {0x4;}' unless defined(&ASC_CNTL_BIOS_GT_2_DISK);
    eval 'sub ASC_CNTL_BIOS_REMOVABLE () {0x8;}' unless defined(&ASC_CNTL_BIOS_REMOVABLE);
    eval 'sub ASC_CNTL_NO_SCAM () {0x10;}' unless defined(&ASC_CNTL_NO_SCAM);
    eval 'sub ASC_CNTL_INT_MULTI_Q () {0x80;}' unless defined(&ASC_CNTL_INT_MULTI_Q);
    eval 'sub ASC_CNTL_NO_LUN_SUPPORT () {0x40;}' unless defined(&ASC_CNTL_NO_LUN_SUPPORT);
    eval 'sub ASC_CNTL_NO_VERIFY_COPY () {0x100;}' unless defined(&ASC_CNTL_NO_VERIFY_COPY);
    eval 'sub ASC_CNTL_RESET_SCSI () {0x200;}' unless defined(&ASC_CNTL_RESET_SCSI);
    eval 'sub ASC_CNTL_INIT_INQUIRY () {0x400;}' unless defined(&ASC_CNTL_INIT_INQUIRY);
    eval 'sub ASC_CNTL_INIT_VERBOSE () {0x800;}' unless defined(&ASC_CNTL_INIT_VERBOSE);
    eval 'sub ASC_CNTL_SCSI_PARITY () {0x1000;}' unless defined(&ASC_CNTL_SCSI_PARITY);
    eval 'sub ASC_CNTL_BURST_MODE () {0x2000;}' unless defined(&ASC_CNTL_BURST_MODE);
    eval 'sub ASC_CNTL_SDTR_ENABLE_ULTRA () {0x4000;}' unless defined(&ASC_CNTL_SDTR_ENABLE_ULTRA);
    eval 'sub ASC_EEP_DVC_CFG_BEG_VL () {2;}' unless defined(&ASC_EEP_DVC_CFG_BEG_VL);
    eval 'sub ASC_EEP_MAX_DVC_ADDR_VL () {15;}' unless defined(&ASC_EEP_MAX_DVC_ADDR_VL);
    eval 'sub ASC_EEP_DVC_CFG_BEG () {32;}' unless defined(&ASC_EEP_DVC_CFG_BEG);
    eval 'sub ASC_EEP_MAX_DVC_ADDR () {45;}' unless defined(&ASC_EEP_MAX_DVC_ADDR);
    eval 'sub ASC_EEP_DEFINED_WORDS () {10;}' unless defined(&ASC_EEP_DEFINED_WORDS);
    eval 'sub ASC_EEP_MAX_ADDR () {63;}' unless defined(&ASC_EEP_MAX_ADDR);
    eval 'sub ASC_EEP_RES_WORDS () {0;}' unless defined(&ASC_EEP_RES_WORDS);
    eval 'sub ASC_EEP_MAX_RETRY () {20;}' unless defined(&ASC_EEP_MAX_RETRY);
    eval 'sub ASC_MAX_INIT_BUSY_RETRY () {8;}' unless defined(&ASC_MAX_INIT_BUSY_RETRY);
    eval 'sub ASC_EEP_ISA_PNP_WSIZE () {16;}' unless defined(&ASC_EEP_ISA_PNP_WSIZE);
    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
    } else {
    }
    eval 'sub ASC_PCI_CFG_LSW_SCSI_PARITY () {0x800;}' unless defined(&ASC_PCI_CFG_LSW_SCSI_PARITY);
    eval 'sub ASC_PCI_CFG_LSW_BURST_MODE () {0x80;}' unless defined(&ASC_PCI_CFG_LSW_BURST_MODE);
    eval 'sub ASC_PCI_CFG_LSW_INTR_ABLE () {0x20;}' unless defined(&ASC_PCI_CFG_LSW_INTR_ABLE);
    eval 'sub ASC_EEP_CMD_READ () {0x80;}' unless defined(&ASC_EEP_CMD_READ);
    eval 'sub ASC_EEP_CMD_WRITE () {0x40;}' unless defined(&ASC_EEP_CMD_WRITE);
    eval 'sub ASC_EEP_CMD_WRITE_ABLE () {0x30;}' unless defined(&ASC_EEP_CMD_WRITE_ABLE);
    eval 'sub ASC_EEP_CMD_WRITE_DISABLE () {0x;}' unless defined(&ASC_EEP_CMD_WRITE_DISABLE);
    eval 'sub ASC_OVERRUN_BSIZE () {0x48;}' unless defined(&ASC_OVERRUN_BSIZE);
    eval 'sub ASC_CTRL_BREAK_ONCE () {0x1;}' unless defined(&ASC_CTRL_BREAK_ONCE);
    eval 'sub ASC_CTRL_BREAK_STAY_IDLE () {0x2;}' unless defined(&ASC_CTRL_BREAK_STAY_IDLE);
    eval 'sub ASCV_MSGOUT_BEG () {0x;}' unless defined(&ASCV_MSGOUT_BEG);
    eval 'sub ASCV_MSGOUT_SDTR_PERIOD () {( &ASCV_MSGOUT_BEG+3);}' unless defined(&ASCV_MSGOUT_SDTR_PERIOD);
    eval 'sub ASCV_MSGOUT_SDTR_OFFSET () {( &ASCV_MSGOUT_BEG+4);}' unless defined(&ASCV_MSGOUT_SDTR_OFFSET);
    eval 'sub ASCV_BREAK_SAVED_CODE () {0x6;}' unless defined(&ASCV_BREAK_SAVED_CODE);
    eval 'sub ASCV_MSGIN_BEG () {( &ASCV_MSGOUT_BEG+8);}' unless defined(&ASCV_MSGIN_BEG);
    eval 'sub ASCV_MSGIN_SDTR_PERIOD () {( &ASCV_MSGIN_BEG+3);}' unless defined(&ASCV_MSGIN_SDTR_PERIOD);
    eval 'sub ASCV_MSGIN_SDTR_OFFSET () {( &ASCV_MSGIN_BEG+4);}' unless defined(&ASCV_MSGIN_SDTR_OFFSET);
    eval 'sub ASCV_SDTR_DATA_BEG () {( &ASCV_MSGIN_BEG+8);}' unless defined(&ASCV_SDTR_DATA_BEG);
    eval 'sub ASCV_SDTR_DONE_BEG () {( &ASCV_SDTR_DATA_BEG+8);}' unless defined(&ASCV_SDTR_DONE_BEG);
    eval 'sub ASCV_MAX_DVC_QNG_BEG () {0x20;}' unless defined(&ASCV_MAX_DVC_QNG_BEG);
    eval 'sub ASCV_BREAK_ADDR () {0x28;}' unless defined(&ASCV_BREAK_ADDR);
    eval 'sub ASCV_BREAK_NOTIFY_COUNT () {0x2a;}' unless defined(&ASCV_BREAK_NOTIFY_COUNT);
    eval 'sub ASCV_BREAK_CONTROL () {0x2c;}' unless defined(&ASCV_BREAK_CONTROL);
    eval 'sub ASCV_BREAK_HIT_COUNT () {0x2e;}' unless defined(&ASCV_BREAK_HIT_COUNT);
    eval 'sub ASCV_ASCDVC_ERR_CODE_W () {0x30;}' unless defined(&ASCV_ASCDVC_ERR_CODE_W);
    eval 'sub ASCV_MCODE_CHKSUM_W () {0x32;}' unless defined(&ASCV_MCODE_CHKSUM_W);
    eval 'sub ASCV_MCODE_SIZE_W () {0x34;}' unless defined(&ASCV_MCODE_SIZE_W);
    eval 'sub ASCV_STOP_CODE_B () {0x36;}' unless defined(&ASCV_STOP_CODE_B);
    eval 'sub ASCV_DVC_ERR_CODE_B () {0x37;}' unless defined(&ASCV_DVC_ERR_CODE_B);
    eval 'sub ASCV_OVERRUN_PADDR_D () {0x38;}' unless defined(&ASCV_OVERRUN_PADDR_D);
    eval 'sub ASCV_OVERRUN_BSIZE_D () {0x3c;}' unless defined(&ASCV_OVERRUN_BSIZE_D);
    eval 'sub ASCV_HALTCODE_W () {0x40;}' unless defined(&ASCV_HALTCODE_W);
    eval 'sub ASCV_CHKSUM_W () {0x42;}' unless defined(&ASCV_CHKSUM_W);
    eval 'sub ASCV_MC_DATE_W () {0x44;}' unless defined(&ASCV_MC_DATE_W);
    eval 'sub ASCV_MC_VER_W () {0x46;}' unless defined(&ASCV_MC_VER_W);
    eval 'sub ASCV_NEXTRDY_B () {0x48;}' unless defined(&ASCV_NEXTRDY_B);
    eval 'sub ASCV_DONENEXT_B () {0x49;}' unless defined(&ASCV_DONENEXT_B);
    eval 'sub ASCV_USE_TAGGED_QNG_B () {0x4a;}' unless defined(&ASCV_USE_TAGGED_QNG_B);
    eval 'sub ASCV_SCSIBUSY_B () {0x4b;}' unless defined(&ASCV_SCSIBUSY_B);
    eval 'sub ASCV_Q_DONE_IN_PROGRESS_B () {0x4c;}' unless defined(&ASCV_Q_DONE_IN_PROGRESS_B);
    eval 'sub ASCV_CURCDB_B () {0x4d;}' unless defined(&ASCV_CURCDB_B);
    eval 'sub ASCV_RCLUN_B () {0x4e;}' unless defined(&ASCV_RCLUN_B);
    eval 'sub ASCV_BUSY_QHEAD_B () {0x4f;}' unless defined(&ASCV_BUSY_QHEAD_B);
    eval 'sub ASCV_DISC1_QHEAD_B () {0x50;}' unless defined(&ASCV_DISC1_QHEAD_B);
    eval 'sub ASCV_DISC_ENABLE_B () {0x52;}' unless defined(&ASCV_DISC_ENABLE_B);
    eval 'sub ASCV_CAN_TAGGED_QNG_B () {0x53;}' unless defined(&ASCV_CAN_TAGGED_QNG_B);
    eval 'sub ASCV_HOSTSCSI_ID_B () {0x55;}' unless defined(&ASCV_HOSTSCSI_ID_B);
    eval 'sub ASCV_MCODE_CNTL_B () {0x56;}' unless defined(&ASCV_MCODE_CNTL_B);
    eval 'sub ASCV_NULL_TARGET_B () {0x57;}' unless defined(&ASCV_NULL_TARGET_B);
    eval 'sub ASCV_FREE_Q_HEAD_W () {0x58;}' unless defined(&ASCV_FREE_Q_HEAD_W);
    eval 'sub ASCV_DONE_Q_TAIL_W () {0x5a;}' unless defined(&ASCV_DONE_Q_TAIL_W);
    eval 'sub ASCV_FREE_Q_HEAD_B () {( &ASCV_FREE_Q_HEAD_W+1);}' unless defined(&ASCV_FREE_Q_HEAD_B);
    eval 'sub ASCV_DONE_Q_TAIL_B () {( &ASCV_DONE_Q_TAIL_W+1);}' unless defined(&ASCV_DONE_Q_TAIL_B);
    eval 'sub ASCV_HOST_FLAG_B () {0x5d;}' unless defined(&ASCV_HOST_FLAG_B);
    eval 'sub ASCV_TOTAL_READY_Q_B () {0x64;}' unless defined(&ASCV_TOTAL_READY_Q_B);
    eval 'sub ASCV_VER_SERIAL_B () {0x65;}' unless defined(&ASCV_VER_SERIAL_B);
    eval 'sub ASCV_HALTCODE_SAVED_W () {0x66;}' unless defined(&ASCV_HALTCODE_SAVED_W);
    eval 'sub ASCV_WTM_FLAG_B () {0x68;}' unless defined(&ASCV_WTM_FLAG_B);
    eval 'sub ASCV_RISC_FLAG_B () {0x6a;}' unless defined(&ASCV_RISC_FLAG_B);
    eval 'sub ASCV_REQ_SG_LIST_QP () {0x6b;}' unless defined(&ASCV_REQ_SG_LIST_QP);
    eval 'sub ASC_HOST_FLAG_IN_ISR () {0x1;}' unless defined(&ASC_HOST_FLAG_IN_ISR);
    eval 'sub ASC_HOST_FLAG_ACK_INT () {0x2;}' unless defined(&ASC_HOST_FLAG_ACK_INT);
    eval 'sub ASC_RISC_FLAG_GEN_INT () {0x1;}' unless defined(&ASC_RISC_FLAG_GEN_INT);
    eval 'sub ASC_RISC_FLAG_REQ_SG_LIST () {0x2;}' unless defined(&ASC_RISC_FLAG_REQ_SG_LIST);
    eval 'sub ASC_IOP_CTRL () {0xf;}' unless defined(&ASC_IOP_CTRL);
    eval 'sub ASC_IOP_STATUS () {0xe;}' unless defined(&ASC_IOP_STATUS);
    eval 'sub ASC_IOP_INT_ACK () { &ASC_IOP_STATUS;}' unless defined(&ASC_IOP_INT_ACK);
    eval 'sub ASC_IOP_REG_IFC () {0xd;}' unless defined(&ASC_IOP_REG_IFC);
    eval 'sub ASC_IOP_SYN_OFFSET () {0xb;}' unless defined(&ASC_IOP_SYN_OFFSET);
    eval 'sub ASC_IOP_EXTRA_CONTROL () {0xd;}' unless defined(&ASC_IOP_EXTRA_CONTROL);
    eval 'sub ASC_IOP_REG_PC () {0xc;}' unless defined(&ASC_IOP_REG_PC);
    eval 'sub ASC_IOP_RAM_ADDR () {0xa;}' unless defined(&ASC_IOP_RAM_ADDR);
    eval 'sub ASC_IOP_RAM_DATA () {0x8;}' unless defined(&ASC_IOP_RAM_DATA);
    eval 'sub ASC_IOP_EEP_DATA () {0x6;}' unless defined(&ASC_IOP_EEP_DATA);
    eval 'sub ASC_IOP_EEP_CMD () {0x7;}' unless defined(&ASC_IOP_EEP_CMD);
    eval 'sub ASC_IOP_VERSION () {0x3;}' unless defined(&ASC_IOP_VERSION);
    eval 'sub ASC_IOP_CONFIG_HIGH () {0x4;}' unless defined(&ASC_IOP_CONFIG_HIGH);
    eval 'sub ASC_IOP_CONFIG_LOW () {0x2;}' unless defined(&ASC_IOP_CONFIG_LOW);
    eval 'sub ASC_IOP_SIG_BYTE () {0x1;}' unless defined(&ASC_IOP_SIG_BYTE);
    eval 'sub ASC_IOP_SIG_WORD () {0x;}' unless defined(&ASC_IOP_SIG_WORD);
    eval 'sub ASC_IOP_REG_DC1 () {0xe;}' unless defined(&ASC_IOP_REG_DC1);
    eval 'sub ASC_IOP_REG_DC0 () {0xc;}' unless defined(&ASC_IOP_REG_DC0);
    eval 'sub ASC_IOP_REG_SB () {0xb;}' unless defined(&ASC_IOP_REG_SB);
    eval 'sub ASC_IOP_REG_DA1 () {0xa;}' unless defined(&ASC_IOP_REG_DA1);
    eval 'sub ASC_IOP_REG_DA0 () {0x8;}' unless defined(&ASC_IOP_REG_DA0);
    eval 'sub ASC_IOP_REG_SC () {0x9;}' unless defined(&ASC_IOP_REG_SC);
    eval 'sub ASC_IOP_DMA_SPEED () {0x7;}' unless defined(&ASC_IOP_DMA_SPEED);
    eval 'sub ASC_IOP_REG_FLAG () {0x7;}' unless defined(&ASC_IOP_REG_FLAG);
    eval 'sub ASC_IOP_FIFO_H () {0x6;}' unless defined(&ASC_IOP_FIFO_H);
    eval 'sub ASC_IOP_FIFO_L () {0x4;}' unless defined(&ASC_IOP_FIFO_L);
    eval 'sub ASC_IOP_REG_ID () {0x5;}' unless defined(&ASC_IOP_REG_ID);
    eval 'sub ASC_IOP_REG_QP () {0x3;}' unless defined(&ASC_IOP_REG_QP);
    eval 'sub ASC_IOP_REG_IH () {0x2;}' unless defined(&ASC_IOP_REG_IH);
    eval 'sub ASC_IOP_REG_IX () {0x1;}' unless defined(&ASC_IOP_REG_IX);
    eval 'sub ASC_IOP_REG_AX () {0x;}' unless defined(&ASC_IOP_REG_AX);
    eval 'sub ASC_IFC_REG_LOCK () {0x;}' unless defined(&ASC_IFC_REG_LOCK);
    eval 'sub ASC_IFC_REG_UNLOCK () {0x9;}' unless defined(&ASC_IFC_REG_UNLOCK);
    eval 'sub ASC_IFC_WR_EN_FILTER () {0x10;}' unless defined(&ASC_IFC_WR_EN_FILTER);
    eval 'sub ASC_IFC_RD_NO_EEPROM () {0x10;}' unless defined(&ASC_IFC_RD_NO_EEPROM);
    eval 'sub ASC_IFC_SLEW_RATE () {0x20;}' unless defined(&ASC_IFC_SLEW_RATE);
    eval 'sub ASC_IFC_ACT_NEG () {0x40;}' unless defined(&ASC_IFC_ACT_NEG);
    eval 'sub ASC_IFC_INP_FILTER () {0x80;}' unless defined(&ASC_IFC_INP_FILTER);
    eval 'sub ASC_IFC_INIT_DEFAULT () {( &ASC_IFC_ACT_NEG |  &ASC_IFC_REG_UNLOCK);}' unless defined(&ASC_IFC_INIT_DEFAULT);
    eval 'sub SC_SEL () {0x80;}' unless defined(&SC_SEL);
    eval 'sub SC_BSY () {0x40;}' unless defined(&SC_BSY);
    eval 'sub SC_ACK () {0x20;}' unless defined(&SC_ACK);
    eval 'sub SC_REQ () {0x10;}' unless defined(&SC_REQ);
    eval 'sub SC_ATN () {0x8;}' unless defined(&SC_ATN);
    eval 'sub SC_IO () {0x4;}' unless defined(&SC_IO);
    eval 'sub SC_CD () {0x2;}' unless defined(&SC_CD);
    eval 'sub SC_MSG () {0x1;}' unless defined(&SC_MSG);
    eval 'sub SEC_SCSI_CTL () {0x80;}' unless defined(&SEC_SCSI_CTL);
    eval 'sub SEC_ACTIVE_NEGATE () {0x40;}' unless defined(&SEC_ACTIVE_NEGATE);
    eval 'sub SEC_SLEW_RATE () {0x20;}' unless defined(&SEC_SLEW_RATE);
    eval 'sub SEC_ENABLE_FILTER () {0x10;}' unless defined(&SEC_ENABLE_FILTER);
    eval 'sub ASC_HALT_EXTMSG_IN () {0x8000;}' unless defined(&ASC_HALT_EXTMSG_IN);
    eval 'sub ASC_HALT_CHK_CONDITION () {0x8100;}' unless defined(&ASC_HALT_CHK_CONDITION);
    eval 'sub ASC_HALT_SS_QUEUE_FULL () {0x8200;}' unless defined(&ASC_HALT_SS_QUEUE_FULL);
    eval 'sub ASC_HALT_DISABLE_ASYN_USE_SYN_FIX () {0x8300;}' unless defined(&ASC_HALT_DISABLE_ASYN_USE_SYN_FIX);
    eval 'sub ASC_HALT_ENABLE_ASYN_USE_SYN_FIX () {0x8400;}' unless defined(&ASC_HALT_ENABLE_ASYN_USE_SYN_FIX);
    eval 'sub ASC_HALT_SDTR_REJECTED () {0x4000;}' unless defined(&ASC_HALT_SDTR_REJECTED);
    eval 'sub ASC_MAX_QNO () {0xf8;}' unless defined(&ASC_MAX_QNO);
    eval 'sub ASC_DATA_SEC_BEG () {0x80;}' unless defined(&ASC_DATA_SEC_BEG);
    eval 'sub ASC_DATA_SEC_END () {0x80;}' unless defined(&ASC_DATA_SEC_END);
    eval 'sub ASC_CODE_SEC_BEG () {0x80;}' unless defined(&ASC_CODE_SEC_BEG);
    eval 'sub ASC_CODE_SEC_END () {0x80;}' unless defined(&ASC_CODE_SEC_END);
    eval 'sub ASC_QADR_BEG () {(0x4000);}' unless defined(&ASC_QADR_BEG);
    eval 'sub ASC_QADR_USED () {( &ASC_MAX_QNO * 64);}' unless defined(&ASC_QADR_USED);
    eval 'sub ASC_QADR_END () {0x7fff;}' unless defined(&ASC_QADR_END);
    eval 'sub ASC_QLAST_ADR () {0x7fc0;}' unless defined(&ASC_QLAST_ADR);
    eval 'sub ASC_QBLK_SIZE () {0x40;}' unless defined(&ASC_QBLK_SIZE);
    eval 'sub ASC_BIOS_DATA_QBEG () {0xf8;}' unless defined(&ASC_BIOS_DATA_QBEG);
    eval 'sub ASC_MIN_ACTIVE_QNO () {0x1;}' unless defined(&ASC_MIN_ACTIVE_QNO);
    eval 'sub ASC_QLINK_END () {0xff;}' unless defined(&ASC_QLINK_END);
    eval 'sub ASC_EEPROM_WORDS () {0x10;}' unless defined(&ASC_EEPROM_WORDS);
    eval 'sub ASC_MAX_MGS_LEN () {0x10;}' unless defined(&ASC_MAX_MGS_LEN);
    eval 'sub ASC_BIOS_ADDR_DEF () {0xdc00;}' unless defined(&ASC_BIOS_ADDR_DEF);
    eval 'sub ASC_BIOS_SIZE () {0x3800;}' unless defined(&ASC_BIOS_SIZE);
    eval 'sub ASC_BIOS_RAM_OFF () {0x3800;}' unless defined(&ASC_BIOS_RAM_OFF);
    eval 'sub ASC_BIOS_RAM_SIZE () {0x800;}' unless defined(&ASC_BIOS_RAM_SIZE);
    eval 'sub ASC_BIOS_MIN_ADDR () {0xc000;}' unless defined(&ASC_BIOS_MIN_ADDR);
    eval 'sub ASC_BIOS_MAX_ADDR () {0xec00;}' unless defined(&ASC_BIOS_MAX_ADDR);
    eval 'sub ASC_BIOS_BANK_SIZE () {0x400;}' unless defined(&ASC_BIOS_BANK_SIZE);
    eval 'sub ASC_MCODE_START_ADDR () {0x80;}' unless defined(&ASC_MCODE_START_ADDR);
    eval 'sub ASC_CFG0_HOST_INT_ON () {0x20;}' unless defined(&ASC_CFG0_HOST_INT_ON);
    eval 'sub ASC_CFG0_BIOS_ON () {0x40;}' unless defined(&ASC_CFG0_BIOS_ON);
    eval 'sub ASC_CFG0_VERA_BURST_ON () {0x80;}' unless defined(&ASC_CFG0_VERA_BURST_ON);
    eval 'sub ASC_CFG0_SCSI_PARITY_ON () {0x800;}' unless defined(&ASC_CFG0_SCSI_PARITY_ON);
    eval 'sub ASC_CFG1_SCSI_TARGET_ON () {0x80;}' unless defined(&ASC_CFG1_SCSI_TARGET_ON);
    eval 'sub ASC_CFG1_LRAM_8BITS_ON () {0x800;}' unless defined(&ASC_CFG1_LRAM_8BITS_ON);
    eval 'sub ASC_CFG_MSW_CLR_MASK () {0x3080;}' unless defined(&ASC_CFG_MSW_CLR_MASK);
    eval 'sub ASC_CSW_TEST1 () {0x8000;}' unless defined(&ASC_CSW_TEST1);
    eval 'sub ASC_CSW_AUTO_CONFIG () {0x4000;}' unless defined(&ASC_CSW_AUTO_CONFIG);
    eval 'sub ASC_CSW_RESERVED1 () {0x2000;}' unless defined(&ASC_CSW_RESERVED1);
    eval 'sub ASC_CSW_IRQ_WRITTEN () {0x1000;}' unless defined(&ASC_CSW_IRQ_WRITTEN);
    eval 'sub ASC_CSW_33MHZ_SELECTED () {0x800;}' unless defined(&ASC_CSW_33MHZ_SELECTED);
    eval 'sub ASC_CSW_TEST2 () {0x400;}' unless defined(&ASC_CSW_TEST2);
    eval 'sub ASC_CSW_TEST3 () {0x200;}' unless defined(&ASC_CSW_TEST3);
    eval 'sub ASC_CSW_RESERVED2 () {0x100;}' unless defined(&ASC_CSW_RESERVED2);
    eval 'sub ASC_CSW_DMA_DONE () {0x80;}' unless defined(&ASC_CSW_DMA_DONE);
    eval 'sub ASC_CSW_FIFO_RDY () {0x40;}' unless defined(&ASC_CSW_FIFO_RDY);
    eval 'sub ASC_CSW_EEP_READ_DONE () {0x20;}' unless defined(&ASC_CSW_EEP_READ_DONE);
    eval 'sub ASC_CSW_HALTED () {0x10;}' unless defined(&ASC_CSW_HALTED);
    eval 'sub ASC_CSW_SCSI_RESET_ACTIVE () {0x8;}' unless defined(&ASC_CSW_SCSI_RESET_ACTIVE);
    eval 'sub ASC_CSW_PARITY_ERR () {0x4;}' unless defined(&ASC_CSW_PARITY_ERR);
    eval 'sub ASC_CSW_SCSI_RESET_LATCH () {0x2;}' unless defined(&ASC_CSW_SCSI_RESET_LATCH);
    eval 'sub ASC_CSW_INT_PENDING () {0x1;}' unless defined(&ASC_CSW_INT_PENDING);
    eval 'sub ASC_CIW_CLR_SCSI_RESET_INT () {0x1000;}' unless defined(&ASC_CIW_CLR_SCSI_RESET_INT);
    eval 'sub ASC_CIW_INT_ACK () {0x100;}' unless defined(&ASC_CIW_INT_ACK);
    eval 'sub ASC_CIW_TEST1 () {0x200;}' unless defined(&ASC_CIW_TEST1);
    eval 'sub ASC_CIW_TEST2 () {0x400;}' unless defined(&ASC_CIW_TEST2);
    eval 'sub ASC_CIW_SEL_33MHZ () {0x800;}' unless defined(&ASC_CIW_SEL_33MHZ);
    eval 'sub ASC_CIW_IRQ_ACT () {0x1000;}' unless defined(&ASC_CIW_IRQ_ACT);
    eval 'sub ASC_CC_CHIP_RESET () {0x80;}' unless defined(&ASC_CC_CHIP_RESET);
    eval 'sub ASC_CC_SCSI_RESET () {0x40;}' unless defined(&ASC_CC_SCSI_RESET);
    eval 'sub ASC_CC_HALT () {0x20;}' unless defined(&ASC_CC_HALT);
    eval 'sub ASC_CC_SINGLE_STEP () {0x10;}' unless defined(&ASC_CC_SINGLE_STEP);
    eval 'sub ASC_CC_DMA_ABLE () {0x8;}' unless defined(&ASC_CC_DMA_ABLE);
    eval 'sub ASC_CC_TEST () {0x4;}' unless defined(&ASC_CC_TEST);
    eval 'sub ASC_CC_BANK_ONE () {0x2;}' unless defined(&ASC_CC_BANK_ONE);
    eval 'sub ASC_CC_DIAG () {0x1;}' unless defined(&ASC_CC_DIAG);
    eval 'sub ASC_1000_ID0W () {0x4c1;}' unless defined(&ASC_1000_ID0W);
    eval 'sub ASC_1000_ID0W_FIX () {0xc1;}' unless defined(&ASC_1000_ID0W_FIX);
    eval 'sub ASC_1000_ID1B () {0x25;}' unless defined(&ASC_1000_ID1B);
    eval 'sub ASC_EISA_BIG_IOP_GAP () {(0x1c30-0xc50);}' unless defined(&ASC_EISA_BIG_IOP_GAP);
    eval 'sub ASC_EISA_SMALL_IOP_GAP () {(0x20);}' unless defined(&ASC_EISA_SMALL_IOP_GAP);
    eval 'sub ASC_EISA_MIN_IOP_ADDR () {(0xc30);}' unless defined(&ASC_EISA_MIN_IOP_ADDR);
    eval 'sub ASC_EISA_MAX_IOP_ADDR () {(0xfc50);}' unless defined(&ASC_EISA_MAX_IOP_ADDR);
    eval 'sub ASC_EISA_REV_IOP_MASK () {(0xc83);}' unless defined(&ASC_EISA_REV_IOP_MASK);
    eval 'sub ASC_EISA_PID_IOP_MASK () {(0xc80);}' unless defined(&ASC_EISA_PID_IOP_MASK);
    eval 'sub ASC_EISA_CFG_IOP_MASK () {(0xc86);}' unless defined(&ASC_EISA_CFG_IOP_MASK);
    eval 'sub ASC_GET_EISA_SLOT {
        local($iop) = @_;
	    eval q((($iop) & 0xf000));
    }' unless defined(&ASC_GET_EISA_SLOT);
    eval 'sub ASC_EISA_ID_740 () {0x1745004;}' unless defined(&ASC_EISA_ID_740);
    eval 'sub ASC_EISA_ID_750 () {0x1755004;}' unless defined(&ASC_EISA_ID_750);
    eval 'sub ASC_INS_HALTINT () {0x6281;}' unless defined(&ASC_INS_HALTINT);
    eval 'sub ASC_INS_HALT () {0x6280;}' unless defined(&ASC_INS_HALT);
    eval 'sub ASC_INS_SINT () {0x6200;}' unless defined(&ASC_INS_SINT);
    eval 'sub ASC_INS_RFLAG_WTM () {0x7380;}' unless defined(&ASC_INS_RFLAG_WTM);
    eval 'sub ASC_GET_QDONE_IN_PROGRESS {
        local($iot, $ioh) = @_;
	    eval q( &AscReadLramByte(($iot), ($ioh),  &ASCV_Q_DONE_IN_PROGRESS_B));
    }' unless defined(&ASC_GET_QDONE_IN_PROGRESS);
    eval 'sub ASC_PUT_QDONE_IN_PROGRESS {
        local($iot, $ioh, $val) = @_;
	    eval q( &AscWriteLramByte(($iot), ($ioh),  &ASCV_Q_DONE_IN_PROGRESS_B, $val));
    }' unless defined(&ASC_PUT_QDONE_IN_PROGRESS);
    eval 'sub ASC_GET_VAR_FREE_QHEAD {
        local($iot, $ioh) = @_;
	    eval q( &AscReadLramWord(($iot), ($ioh),  &ASCV_FREE_Q_HEAD_W));
    }' unless defined(&ASC_GET_VAR_FREE_QHEAD);
    eval 'sub ASC_GET_VAR_DONE_QTAIL {
        local($iot, $ioh) = @_;
	    eval q( &AscReadLramWord(($iot), ($ioh),  &ASCV_DONE_Q_TAIL_W));
    }' unless defined(&ASC_GET_VAR_DONE_QTAIL);
    eval 'sub ASC_PUT_VAR_FREE_QHEAD {
        local($iot, $ioh, $val) = @_;
	    eval q( &AscWriteLramWord(($iot), ($ioh),  &ASCV_FREE_Q_HEAD_W, $val));
    }' unless defined(&ASC_PUT_VAR_FREE_QHEAD);
    eval 'sub ASC_PUT_VAR_DONE_QTAIL {
        local($iot, $ioh, $val) = @_;
	    eval q( &AscWriteLramWord(($iot), ($ioh),  &ASCV_DONE_Q_TAIL_W, $val));
    }' unless defined(&ASC_PUT_VAR_DONE_QTAIL);
    eval 'sub ASC_GET_RISC_VAR_FREE_QHEAD {
        local($iot, $ioh) = @_;
	    eval q( &AscReadLramByte(($iot), ($ioh),  &ASCV_NEXTRDY_B));
    }' unless defined(&ASC_GET_RISC_VAR_FREE_QHEAD);
    eval 'sub ASC_GET_RISC_VAR_DONE_QTAIL {
        local($iot, $ioh) = @_;
	    eval q( &AscReadLramByte(($iot), ($ioh),  &ASCV_DONENEXT_B));
    }' unless defined(&ASC_GET_RISC_VAR_DONE_QTAIL);
    eval 'sub ASC_PUT_RISC_VAR_FREE_QHEAD {
        local($iot, $ioh, $val) = @_;
	    eval q( &AscWriteLramByte(($iot), ($ioh),  &ASCV_NEXTRDY_B, $val));
    }' unless defined(&ASC_PUT_RISC_VAR_FREE_QHEAD);
    eval 'sub ASC_PUT_RISC_VAR_DONE_QTAIL {
        local($iot, $ioh, $val) = @_;
	    eval q( &AscWriteLramByte(($iot), ($ioh),  &ASCV_DONENEXT_B, $val));
    }' unless defined(&ASC_PUT_RISC_VAR_DONE_QTAIL);
    eval 'sub ASC_PUT_MCODE_SDTR_DONE_AT_ID {
        local($iot, $ioh, $id, $data) = @_;
	    eval q( &AscWriteLramByte(, , ( &ASCV_SDTR_DONE_BEG+$id), ($data)) ;);
    }' unless defined(&ASC_PUT_MCODE_SDTR_DONE_AT_ID);
    eval 'sub ASC_GET_MCODE_SDTR_DONE_AT_ID {
        local($iot, $ioh, $id) = @_;
	    eval q( &AscReadLramByte(, , ( &ASCV_SDTR_DONE_BEG+$id)) ;);
    }' unless defined(&ASC_GET_MCODE_SDTR_DONE_AT_ID);
    eval 'sub ASC_PUT_MCODE_INIT_SDTR_AT_ID {
        local($iot, $ioh, $id, $data) = @_;
	    eval q( &AscWriteLramByte(, , ( &ASCV_SDTR_DATA_BEG+$id), $data) ;);
    }' unless defined(&ASC_PUT_MCODE_INIT_SDTR_AT_ID);
    eval 'sub ASC_GET_MCODE_INIT_SDTR_AT_ID {
        local($iot, $ioh, $id) = @_;
	    eval q( &AscReadLramByte(, , ( &ASCV_SDTR_DATA_BEG+$id)) ;);
    }' unless defined(&ASC_GET_MCODE_INIT_SDTR_AT_ID);
    eval 'sub ASC_SYN_INDEX_TO_PERIOD {
        local($sc, $index) = @_;
	    eval q((($sc)-> $sdtr_period_tbl[ ($index) ]));
    }' unless defined(&ASC_SYN_INDEX_TO_PERIOD);
    eval 'sub ASC_GET_CHIP_SIGNATURE_BYTE {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_1(($iot), ($ioh),  &ASC_IOP_SIG_BYTE));
    }' unless defined(&ASC_GET_CHIP_SIGNATURE_BYTE);
    eval 'sub ASC_GET_CHIP_SIGNATURE_WORD {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_SIG_WORD));
    }' unless defined(&ASC_GET_CHIP_SIGNATURE_WORD);
    eval 'sub ASC_GET_CHIP_VER_NO {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_1(($iot), ($ioh),  &ASC_IOP_VERSION));
    }' unless defined(&ASC_GET_CHIP_VER_NO);
    eval 'sub ASC_GET_CHIP_CFG_LSW {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_CONFIG_LOW));
    }' unless defined(&ASC_GET_CHIP_CFG_LSW);
    eval 'sub ASC_GET_CHIP_CFG_MSW {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_CONFIG_HIGH));
    }' unless defined(&ASC_GET_CHIP_CFG_MSW);
    eval 'sub ASC_SET_CHIP_CFG_LSW {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_CONFIG_LOW, $data));
    }' unless defined(&ASC_SET_CHIP_CFG_LSW);
    eval 'sub ASC_SET_CHIP_CFG_MSW {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_CONFIG_HIGH, $data));
    }' unless defined(&ASC_SET_CHIP_CFG_MSW);
    eval 'sub ASC_GET_CHIP_EEP_CMD {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_1(($iot), ($ioh),  &ASC_IOP_EEP_CMD));
    }' unless defined(&ASC_GET_CHIP_EEP_CMD);
    eval 'sub ASC_SET_CHIP_EEP_CMD {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_1(($iot), ($ioh),  &ASC_IOP_EEP_CMD, $data));
    }' unless defined(&ASC_SET_CHIP_EEP_CMD);
    eval 'sub ASC_GET_CHIP_EEP_DATA {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_EEP_DATA));
    }' unless defined(&ASC_GET_CHIP_EEP_DATA);
    eval 'sub ASC_SET_CHIP_EEP_DATA {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_EEP_DATA, $data));
    }' unless defined(&ASC_SET_CHIP_EEP_DATA);
    eval 'sub ASC_GET_CHIP_LRAM_ADDR {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_RAM_ADDR));
    }' unless defined(&ASC_GET_CHIP_LRAM_ADDR);
    eval 'sub ASC_SET_CHIP_LRAM_ADDR {
        local($iot, $ioh, $addr) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_RAM_ADDR, $addr));
    }' unless defined(&ASC_SET_CHIP_LRAM_ADDR);
    eval 'sub ASC_GET_CHIP_LRAM_DATA {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_RAM_DATA));
    }' unless defined(&ASC_GET_CHIP_LRAM_DATA);
    eval 'sub ASC_SET_CHIP_LRAM_DATA {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_RAM_DATA, $data));
    }' unless defined(&ASC_SET_CHIP_LRAM_DATA);
    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
	eval 'sub ASC_GET_CHIP_LRAM_DATA_NO_SWAP {
	    local($iot, $ioh) = @_;
    	    eval q( &SWAPBYTES( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_RAM_DATA)));
	}' unless defined(&ASC_GET_CHIP_LRAM_DATA_NO_SWAP);
	eval 'sub ASC_SET_CHIP_LRAM_DATA_NO_SWAP {
	    local($iot, $ioh, $data) = @_;
    	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_RAM_DATA,  &SWAPBYTES($data)));
	}' unless defined(&ASC_SET_CHIP_LRAM_DATA_NO_SWAP);
    } else {
	eval 'sub ASC_GET_CHIP_LRAM_DATA_NO_SWAP {
	    local($iot, $ioh) = @_;
    	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_RAM_DATA));
	}' unless defined(&ASC_GET_CHIP_LRAM_DATA_NO_SWAP);
	eval 'sub ASC_SET_CHIP_LRAM_DATA_NO_SWAP {
	    local($iot, $ioh, $data) = @_;
    	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_RAM_DATA, $data));
	}' unless defined(&ASC_SET_CHIP_LRAM_DATA_NO_SWAP);
    }
    eval 'sub ASC_GET_CHIP_IFC {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_1(($iot), ($ioh),  &ASC_IOP_REG_IFC));
    }' unless defined(&ASC_GET_CHIP_IFC);
    eval 'sub ASC_SET_CHIP_IFC {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_1(($iot), ($ioh),  &ASC_IOP_REG_IFC, $data));
    }' unless defined(&ASC_SET_CHIP_IFC);
    eval 'sub ASC_GET_CHIP_STATUS {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_STATUS));
    }' unless defined(&ASC_GET_CHIP_STATUS);
    eval 'sub ASC_SET_CHIP_STATUS {
        local($iot, $ioh, $cs_val) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_STATUS, $cs_val));
    }' unless defined(&ASC_SET_CHIP_STATUS);
    eval 'sub ASC_GET_CHIP_CONTROL {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_1(($iot), ($ioh),  &ASC_IOP_CTRL));
    }' unless defined(&ASC_GET_CHIP_CONTROL);
    eval 'sub ASC_SET_CHIP_CONTROL {
        local($iot, $ioh, $cc_val) = @_;
	    eval q( &bus_space_write_1(($iot), ($ioh),  &ASC_IOP_CTRL, $cc_val));
    }' unless defined(&ASC_SET_CHIP_CONTROL);
    eval 'sub ASC_GET_CHIP_SYN {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_1(($iot), ($ioh),  &ASC_IOP_SYN_OFFSET));
    }' unless defined(&ASC_GET_CHIP_SYN);
    eval 'sub ASC_SET_CHIP_SYN {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_1(($iot), ($ioh),  &ASC_IOP_SYN_OFFSET, $data));
    }' unless defined(&ASC_SET_CHIP_SYN);
    eval 'sub ASC_SET_PC_ADDR {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_REG_PC, $data));
    }' unless defined(&ASC_SET_PC_ADDR);
    eval 'sub ASC_GET_PC_ADDR {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_REG_PC));
    }' unless defined(&ASC_GET_PC_ADDR);
    eval 'sub ASC_IS_INT_PENDING {
        local($iot, $ioh) = @_;
	    eval q(( &ASC_GET_CHIP_STATUS(($iot), ($ioh)) & ( &ASC_CSW_INT_PENDING |  &ASC_CSW_SCSI_RESET_LATCH)));
    }' unless defined(&ASC_IS_INT_PENDING);
    eval 'sub ASC_GET_CHIP_SCSI_ID {
        local($iot, $ioh) = @_;
	    eval q((( &ASC_GET_CHIP_CFG_LSW(($iot), ($ioh)) >> 8) &  &ASC_MAX_TID));
    }' unless defined(&ASC_GET_CHIP_SCSI_ID);
    eval 'sub ASC_GET_EXTRA_CONTROL {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_1(($iot), ($ioh),  &ASC_IOP_EXTRA_CONTROL));
    }' unless defined(&ASC_GET_EXTRA_CONTROL);
    eval 'sub ASC_SET_EXTRA_CONTROL {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_1(($iot), ($ioh),  &ASC_IOP_EXTRA_CONTROL, $data));
    }' unless defined(&ASC_SET_EXTRA_CONTROL);
    eval 'sub ASC_READ_CHIP_AX {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_REG_AX));
    }' unless defined(&ASC_READ_CHIP_AX);
    eval 'sub ASC_WRITE_CHIP_AX {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_REG_AX, $data));
    }' unless defined(&ASC_WRITE_CHIP_AX);
    eval 'sub ASC_READ_CHIP_IX {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_1(($iot), ($ioh),  &ASC_IOP_REG_IX));
    }' unless defined(&ASC_READ_CHIP_IX);
    eval 'sub ASC_WRITE_CHIP_IX {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_1(($iot), ($ioh),  &ASC_IOP_REG_IX, $data));
    }' unless defined(&ASC_WRITE_CHIP_IX);
    eval 'sub ASC_READ_CHIP_IH {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_REG_IH));
    }' unless defined(&ASC_READ_CHIP_IH);
    eval 'sub ASC_WRITE_CHIP_IH {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_REG_IH, $data));
    }' unless defined(&ASC_WRITE_CHIP_IH);
    eval 'sub ASC_READ_CHIP_QP {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_1(($iot), ($ioh),  &ASC_IOP_REG_QP));
    }' unless defined(&ASC_READ_CHIP_QP);
    eval 'sub ASC_WRITE_CHIP_QP {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_1(($iot), ($ioh),  &ASC_IOP_REG_QP, $data));
    }' unless defined(&ASC_WRITE_CHIP_QP);
    eval 'sub ASC_READ_CHIP_FIFO_L {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_REG_FIFO_L));
    }' unless defined(&ASC_READ_CHIP_FIFO_L);
    eval 'sub ASC_WRITE_CHIP_FIFO_L {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_REG_FIFO_L, $data));
    }' unless defined(&ASC_WRITE_CHIP_FIFO_L);
    eval 'sub ASC_READ_CHIP_FIFO_H {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_REG_FIFO_H));
    }' unless defined(&ASC_READ_CHIP_FIFO_H);
    eval 'sub ASC_WRITE_CHIP_FIFO_H {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_REG_FIFO_H, $data));
    }' unless defined(&ASC_WRITE_CHIP_FIFO_H);
    eval 'sub ASC_READ_CHIP_DMA_SPEED {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_1(($iot), ($ioh),  &ASC_IOP_DMA_SPEED));
    }' unless defined(&ASC_READ_CHIP_DMA_SPEED);
    eval 'sub ASC_WRITE_CHIP_DMA_SPEED {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_1(($iot), ($ioh),  &ASC_IOP_DMA_SPEED, $data));
    }' unless defined(&ASC_WRITE_CHIP_DMA_SPEED);
    eval 'sub ASC_READ_CHIP_DA0 {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_REG_DA0));
    }' unless defined(&ASC_READ_CHIP_DA0);
    eval 'sub ASC_WRITE_CHIP_DA0 {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_REG_DA0,  &data));
    }' unless defined(&ASC_WRITE_CHIP_DA0);
    eval 'sub ASC_READ_CHIP_DA1 {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_REG_DA1));
    }' unless defined(&ASC_READ_CHIP_DA1);
    eval 'sub ASC_WRITE_CHIP_DA1 {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_REG_DA1,  &data));
    }' unless defined(&ASC_WRITE_CHIP_DA1);
    eval 'sub ASC_READ_CHIP_DC0 {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_REG_DC0));
    }' unless defined(&ASC_READ_CHIP_DC0);
    eval 'sub ASC_WRITE_CHIP_DC0 {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_REG_DC0,  &data));
    }' unless defined(&ASC_WRITE_CHIP_DC0);
    eval 'sub ASC_READ_CHIP_DC1 {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &ASC_IOP_REG_DC1));
    }' unless defined(&ASC_READ_CHIP_DC1);
    eval 'sub ASC_WRITE_CHIP_DC1 {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &ASC_IOP_REG_DC1,  &data));
    }' unless defined(&ASC_WRITE_CHIP_DC1);
    eval 'sub ASC_READ_CHIP_DVC_ID {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_1(($iot), ($ioh),  &ASC_IOP_REG_ID));
    }' unless defined(&ASC_READ_CHIP_DVC_ID);
    eval 'sub ASC_WRITE_CHIP_DVC_ID {
        local($iot, $ioh, $data) = @_;
	    eval q( &bus_space_write_1(($iot), ($ioh),  &ASC_IOP_REG_ID, $data));
    }' unless defined(&ASC_WRITE_CHIP_DVC_ID);
}
1;
