# $OpenBSD: Logger.pm,v 1.2 2004/02/25 21:56:12 espie Exp $
#
# Copyright (c) 2003 Marc Espie.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE OPENBSD PROJECT AND CONTRIBUTORS
# ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OPENBSD
# PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

use strict;
use warnings;
package OpenBSD::Logger;

use OpenBSD::Temp;
use File::Temp;

my $log_handle;
my $log_base;
my $log_name;
my @annotations=();

sub log_as($)
{
	$log_base = shift;
}

sub logname()
{
	return $log_name;
}

sub logfile()
{
	if (!defined $log_handle) {
		($log_handle, $log_name) =  
		    File::Temp::tempfile("$log_base.XXXXXXXXXXX", DIR => $OpenBSD::Temp::tempbase);
	}
	return $log_handle;
}

sub annotate
{
	push(@annotations, @_);
}

sub log(@)
{
	my $fh = logfile();
	if (@annotations > 0) {
		print $fh @annotations;
		@annotations = ();
	}
	print $fh @_;
}

1;
