/*
 * logo.h: GIMP header image file format (INDEXED) for xglock
 */
#if !defined( lint ) && !defined( SABER )
static const char sccsid[] = "@(#)logo.h     1.0 99/11/16 xlockmore";
#endif
/* Copyright (c) E. Lassauge, 1999 <lassauge@mail.dotcom.fr> */

/*
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * Revision History:
 *
 *   Nov-99: Initial version.
 */


static unsigned int logo_width = 200;
static unsigned int logo_height = 72;

/*  Call this macro repeatedly.  After each use, the pixel data can be extracted  */

#define HEADER_PIXEL(data,pixel) {\
  pixel[0] = header_data_cmap[(unsigned char)data[0]][0]; \
  pixel[1] = header_data_cmap[(unsigned char)data[0]][1]; \
  pixel[2] = header_data_cmap[(unsigned char)data[0]][2]; \
  data ++; }

static char header_data_cmap[128][3] = {
	{  3,  3,  6},
	{ 66, 81, 82},
	{142,145,123},
	{204,219,231},
	{187,194,198},
	{ 79,107,146},
	{ 55, 62, 54},
	{151,176,203},
	{250,246,250},
	{ 39, 46, 43},
	{151,149,130},
	{ 95,122,155},
	{198,194,204},
	{230,220,231},
	{ 18, 34, 28},
	{146,158,172},
	{177,175,175},
	{125,123,115},
	{ 82, 78, 64},
	{205,206,207},
	{231,232,225},
	{ 24, 24, 27},
	{186,159,121},
	{  2, 18, 19},
	{107,105, 85},
	{144,131,103},
	{ 94, 90, 73},
	{139,168,197},
	{175,186,205},
	{118,121,134},
	{ 22,  7, 69},
	{214,209,210},
	{168,163,172},
	{251,240,249},
	{ 44, 67,100},
	{118,146,180},
	{ 95,107,119},
	{ 16,  6, 57},
	{112,133,159},
	{153,161,181},
	{ 82, 89,101},
	{188,185,184},
	{ 91, 89, 95},
	{192,220,244},
	{ 81, 81, 92},
	{106,106,113},
	{243,242,247},
	{131,148,175},
	{185,211,236},
	{211,201,212},
	{124,130,145},
	{149,145,156},
	{186,187,204},
	{ 58, 81,114},
	{198,201,223},
	{151,152,164},
	{241,230,238},
	{ 81, 67, 77},
	{201,209,230},
	{ 18,  3, 20},
	{215,206,220},
	{253,252,252},
	{164,190,217},
	{204,224,247},
	{ 18, 18,  4},
	{148,168,193},
	{ 62, 50, 87},
	{  7,  7, 39},
	{ 79, 66,100},
	{ 63, 65, 83},
	{162,175,197},
	{163,154,162},
	{ 98, 82,105},
	{172,197,222},
	{174,176,196},
	{143,135,116},
	{213,212,224},
	{113, 98,117},
	{185,197,220},
	{200,200,193},
	{129,138,155},
	{136,157,185},
	{115,114,120},
	{102,133,168},
	{168,169,192},
	{186,178,189},
	{227,214,226},
	{162,186,211},
	{ 52, 51, 48},
	{185,206,231},
	{ 24, 18, 52},
	{158,168,188},
	{219,235,247},
	{238,225,235},
	{238,238,228},
	{219,219,220},
	{ 68, 94,133},
	{100, 96, 86},
	{ 34, 34, 34},
	{129,143,162},
	{232,233,244},
	{154,159,169},
	{158,153,160},
	{195,189,205},
	{134,137,117},
	{ 88,113,150},
	{242,236,245},
	{  2,  4, 28},
	{ 66, 64, 55},
	{176,169,177},
	{217,224,246},
	{139,146,159},
	{ 19, 18, 21},
	{121,110, 90},
	{170,170,175},
	{ 38, 32, 68},
	{134,130,141},
	{218,222,236},
	{203,200,207},
	{182,176,190},
	{ 81, 98,107},
	{142,137,145},
	{162,160,167},
	{219,212,222},
	{164,182,203},
	{229,226,234},
	{ 96, 96,103},
	{115,108,114}
	};

static char header_data[] = {
	123,123,60,19,19,49,118,49,118,49,118,49,49,118,49,118,
	19,49,118,19,49,118,19,49,118,19,49,118,19,49,118,19,
	49,118,19,49,118,19,49,118,19,49,118,19,49,49,118,19,
	49,118,19,49,118,118,118,118,118,118,118,118,118,118,118,118,
	118,118,118,118,118,118,118,118,118,118,79,79,79,4,52,28,
	124,7,15,81,83,83,11,5,5,5,5,105,105,11,11,83,
	83,38,35,99,35,81,81,65,65,7,70,70,124,124,7,7,
	7,7,27,27,27,27,27,27,27,27,7,124,87,28,28,52,
	52,52,41,41,52,103,103,103,12,79,79,79,12,79,12,12,
	12,12,12,4,103,41,103,41,28,28,124,70,65,27,81,81,
	47,35,35,83,83,11,11,11,11,83,99,81,70,124,28,52,
	4,4,12,4,79,79,79,79,118,79,118,118,118,118,118,118,
	118,118,118,12,41,41,31,20,
	103,123,20,8,8,61,61,61,61,61,61,61,61,61,61,61,
	8,61,61,8,61,61,8,61,61,8,61,61,8,61,61,8,
	61,61,8,61,61,8,61,61,8,61,61,8,61,61,61,8,
	61,61,8,61,61,61,61,61,61,61,61,61,61,61,61,61,
	61,8,61,8,61,61,61,61,61,61,8,8,8,8,8,46,
	92,92,43,89,62,7,81,35,83,83,11,105,11,105,11,83,
	83,35,35,27,7,7,87,62,73,73,73,48,89,48,48,48,
	48,89,48,48,73,48,73,48,48,48,43,43,63,92,92,92,
	92,92,92,92,92,92,92,94,46,46,46,8,61,8,61,61,
	61,61,8,8,61,8,8,8,46,46,92,63,63,43,48,48,
	73,62,87,7,27,27,35,35,35,35,81,124,73,48,63,92,
	92,92,46,46,46,106,46,8,8,8,61,61,61,61,61,61,
	61,61,46,95,79,85,118,20,
	103,60,93,8,61,61,61,61,61,61,61,61,61,61,61,61,
	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,
	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,
	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,
	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,8,
	46,92,63,43,73,62,27,35,83,83,105,5,5,5,5,105,
	11,83,83,35,81,27,27,7,7,62,62,73,73,73,73,73,
	48,73,48,48,48,48,48,43,48,43,48,43,43,43,43,63,
	92,63,63,63,92,92,92,100,106,46,8,8,61,61,61,61,
	61,61,61,61,61,61,61,61,61,8,46,92,92,63,43,48,
	48,62,62,7,27,27,35,35,83,83,35,27,7,62,89,63,
	110,92,92,92,92,100,100,46,46,46,8,61,61,61,61,8,
	94,93,123,41,102,116,109,123,
	12,123,56,61,61,61,61,61,61,61,61,61,61,61,61,61,
	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,
	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,
	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,
	61,61,61,61,61,61,61,61,61,61,61,61,61,61,46,46,
	92,92,63,43,73,62,7,27,35,83,11,105,5,5,5,5,
	105,5,11,83,83,35,35,81,27,27,7,7,87,73,73,73,
	73,73,73,89,48,48,48,48,48,89,48,48,48,48,48,48,
	48,48,43,58,58,76,3,110,110,100,106,106,46,8,8,61,
	61,61,61,61,61,61,61,61,46,61,8,46,92,92,63,43,
	48,48,62,62,27,81,81,35,83,83,35,35,81,7,28,89,
	48,58,3,3,117,3,63,117,92,92,100,106,100,20,125,13,
	49,103,119,102,25,29,32,31,
	49,95,106,61,61,61,61,61,61,61,61,61,61,61,61,61,
	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,
	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,
	61,61,61,61,61,61,61,8,8,8,8,8,8,8,61,61,
	61,61,61,61,61,61,61,61,61,61,61,61,8,46,46,92,
	92,63,43,48,48,62,7,27,27,35,83,83,105,5,5,5,
	5,5,11,11,83,83,35,35,27,27,27,7,7,87,87,62,
	73,73,89,89,89,89,89,89,73,73,73,73,73,73,73,73,
	73,78,89,48,48,58,58,3,123,117,125,93,56,106,33,33,
	61,61,61,61,61,61,61,8,8,46,46,92,46,92,63,63,
	48,89,73,62,7,27,27,35,35,83,83,35,35,81,7,28,
	89,89,3,58,3,58,3,76,76,76,58,31,60,118,103,41,
	85,109,71,121,17,29,122,31,
	31,125,94,61,61,61,61,61,8,8,33,33,33,33,8,8,
	8,8,33,8,33,33,33,33,8,8,8,61,8,61,8,8,
	8,8,8,8,8,8,33,8,33,8,8,8,8,8,8,8,
	8,8,33,33,33,33,33,8,8,33,33,33,33,33,33,33,
	33,8,61,61,61,61,61,61,8,33,106,46,100,46,106,100,
	92,110,43,43,73,73,62,7,27,27,35,35,83,11,5,5,
	5,5,5,105,83,83,83,35,35,35,27,27,27,7,87,87,
	62,62,62,62,73,73,73,28,73,62,87,62,87,62,62,62,
	73,73,73,54,58,58,58,76,3,86,110,13,100,56,106,106,
	33,33,33,33,46,8,46,46,46,46,46,46,92,92,92,43,
	43,48,48,62,62,27,27,81,35,83,38,83,83,81,65,87,
	62,78,89,89,89,58,58,89,54,78,52,28,74,74,114,114,
	32,122,71,51,17,82,32,19,
	60,13,94,61,61,61,8,8,33,33,33,33,33,106,106,106,
	33,33,56,33,33,106,33,33,106,33,106,33,33,33,33,33,
	33,33,106,106,106,106,33,106,56,33,33,33,33,33,33,33,
	33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
	33,33,33,33,33,33,33,33,33,46,106,106,100,100,92,125,
	110,95,58,48,48,73,73,87,27,27,27,35,83,83,105,5,
	5,96,5,5,5,11,83,83,35,35,27,81,27,27,27,7,
	87,87,62,62,28,87,62,28,62,87,87,87,87,87,87,124,
	4,73,78,89,19,58,58,76,3,86,110,117,13,125,100,100,
	106,106,106,46,106,46,46,94,92,94,92,94,100,125,92,117,
	43,48,48,89,62,62,7,27,81,35,35,38,83,47,27,124,
	87,73,89,89,78,78,52,28,28,70,32,122,101,122,122,91,
	122,101,10,121,17,82,32,31,
	19,125,106,61,61,8,8,33,33,33,106,56,56,56,93,93,
	93,93,93,86,86,49,12,49,12,12,49,12,49,12,49,12,
	49,12,49,49,49,49,49,49,49,12,49,49,49,60,60,60,
	60,123,60,123,60,123,60,60,60,60,49,60,60,60,60,60,
	60,60,60,123,60,123,60,60,31,49,118,118,19,118,118,54,
	78,4,4,28,28,124,7,27,27,35,35,35,11,11,5,96,
	96,53,53,53,53,96,5,11,83,11,83,83,35,35,35,81,
	81,15,15,15,65,65,65,15,65,15,65,15,15,15,15,65,
	65,114,70,74,124,28,52,52,52,52,103,103,4,12,12,79,
	54,19,19,118,58,19,19,58,19,19,19,118,54,79,78,4,
	4,28,62,87,27,27,27,35,35,38,83,38,38,35,81,65,
	70,124,78,28,28,124,70,70,39,91,39,39,101,39,122,122,
	71,101,102,121,17,82,122,19,
	19,13,94,61,8,33,33,106,56,56,93,93,13,13,86,31,
	60,54,118,103,55,127,72,44,44,72,44,44,44,72,42,26,
	97,97,77,97,97,77,97,77,97,77,77,24,127,127,127,127,
	127,127,127,127,127,127,127,127,113,127,127,77,113,77,113,113,
	127,113,127,113,127,127,127,45,127,127,45,45,45,45,45,45,
	45,45,45,36,36,126,120,120,120,96,1,53,53,34,34,34,
	9,9,9,14,9,9,34,34,34,34,34,1,1,1,1,1,
	1,1,1,1,1,1,40,1,40,1,40,40,40,40,40,44,
	40,40,40,26,126,126,36,126,36,126,36,126,126,45,126,45,
	45,45,45,45,45,127,127,127,127,45,127,45,45,45,45,45,
	45,36,126,120,120,40,40,96,40,40,120,5,105,29,38,35,
	81,65,124,124,84,91,39,91,122,91,122,101,101,122,101,122,
	102,102,51,116,29,82,122,19,
	60,117,106,61,8,33,56,56,13,13,95,123,19,118,118,78,
	103,52,119,84,80,127,44,72,40,42,42,42,42,36,127,29,
	29,116,116,121,121,121,51,121,51,10,51,51,10,102,10,102,
	102,102,102,102,71,71,71,71,71,71,71,122,71,122,71,71,
	71,71,71,71,71,71,71,71,101,101,101,102,101,102,55,55,
	55,55,55,10,55,55,111,111,99,50,38,83,11,5,5,96,
	53,53,34,34,34,34,34,53,1,96,120,120,120,36,36,82,
	11,11,29,29,38,29,29,29,17,38,38,29,38,38,50,50,
	50,80,50,80,50,80,121,99,121,121,111,51,111,51,10,51,
	51,10,102,102,102,122,102,101,102,71,71,122,122,71,10,51,
	51,111,111,111,99,80,99,99,35,47,81,81,27,81,81,81,
	81,39,65,91,91,91,91,91,91,91,39,39,101,101,102,55,
	102,55,51,116,82,127,122,19,
	31,13,106,8,8,33,106,106,93,13,95,86,76,19,54,54,
	103,52,28,84,99,45,40,44,40,40,40,40,40,36,45,29,
	29,50,50,121,121,51,51,51,102,71,122,32,32,109,109,109,
	114,109,109,109,109,109,109,109,109,109,109,119,109,85,109,109,
	109,109,109,109,109,109,109,109,109,114,114,114,114,114,114,114,
	114,32,114,91,114,32,101,101,39,15,111,47,99,83,83,105,
	5,96,53,53,34,34,34,1,96,120,5,105,11,11,29,83,
	50,38,38,80,80,99,35,99,99,99,47,99,2,47,2,81,
	111,55,111,15,55,55,102,101,101,55,55,102,102,101,101,32,
	32,32,114,114,114,114,114,16,16,114,109,109,109,16,109,32,
	32,32,32,91,70,70,124,28,62,62,7,27,81,35,35,35,
	47,81,65,7,7,70,91,70,91,114,122,39,101,101,101,55,
	55,55,2,116,82,127,101,19,
	31,95,106,61,61,8,33,106,106,56,125,13,123,76,76,54,
	54,78,52,74,111,105,40,44,96,40,96,96,120,5,36,105,
	29,11,29,50,80,121,51,55,102,32,32,109,16,85,16,41,
	41,41,41,41,41,41,41,41,103,41,41,41,103,41,103,103,
	103,103,41,41,41,41,41,41,41,41,41,41,41,41,16,41,
	41,41,41,85,41,16,41,16,70,114,91,65,15,47,99,38,
	83,105,5,53,53,53,96,96,96,36,11,11,29,38,38,38,
	80,99,99,47,47,111,81,15,15,15,81,15,15,15,101,101,
	91,91,91,122,91,91,91,122,122,32,91,114,114,16,16,85,
	16,41,41,41,0,0,108,14,64,59,59,90,57,0,103,103,
	103,12,4,79,54,58,58,89,78,73,87,27,81,81,38,83,
	35,81,39,91,91,70,70,91,91,39,91,39,101,101,55,55,
	55,51,111,17,82,45,122,19,
	76,13,94,61,61,61,8,33,33,106,106,100,13,110,117,76,
	60,89,54,28,81,29,40,120,120,126,36,36,36,107,21,0,
	0,0,0,0,0,50,50,111,55,122,32,109,119,41,41,103,
	103,12,79,12,12,12,12,12,12,12,12,12,12,12,12,12,
	12,79,12,79,79,79,79,79,12,79,79,4,12,79,103,41,
	4,103,4,103,4,103,41,103,41,28,16,124,70,7,15,47,
	99,11,11,120,53,96,96,96,5,105,11,38,38,99,99,99,
	99,47,47,81,15,15,15,15,15,39,65,65,91,91,91,91,
	91,32,114,91,32,114,114,70,16,16,119,28,119,52,52,4,
	4,4,0,44,9,14,14,67,64,64,64,64,112,59,98,0,
	0,31,76,95,3,117,3,58,89,73,87,27,81,35,83,11,
	38,35,81,15,65,91,91,91,91,39,91,15,15,101,15,55,
	55,51,51,50,82,45,122,19,
	31,125,106,61,61,61,61,61,8,33,106,56,56,13,13,117,
	76,58,54,52,81,29,120,126,36,11,105,105,0,21,26,2,
	122,2,75,16,41,109,41,119,41,41,116,104,17,17,97,18,
	108,98,64,64,59,19,31,19,31,79,31,79,79,31,79,19,
	79,79,19,118,118,19,79,19,31,79,19,31,79,79,79,49,
	79,79,49,79,118,79,79,12,79,79,4,4,28,70,7,81,
	47,99,11,105,96,120,5,5,11,11,38,35,35,47,47,47,
	81,81,81,15,27,15,65,65,65,70,91,70,91,70,7,114,
	91,91,91,114,70,16,74,28,85,41,103,103,79,79,79,79,
	0,127,101,3,6,98,64,64,59,59,59,59,90,23,59,59,
	68,0,0,117,110,110,63,63,48,48,62,87,27,81,83,105,
	11,38,99,81,15,65,91,65,91,91,39,101,101,15,55,55,
	51,111,121,116,82,127,101,118,
	19,125,94,61,61,61,61,8,8,46,106,106,100,125,110,117,
	76,58,54,52,81,29,120,36,82,29,29,88,98,21,18,2,
	122,2,75,114,4,79,79,19,31,123,95,125,95,20,20,20,
	94,106,94,94,94,94,94,114,16,32,24,26,6,98,0,0,
	0,79,19,76,76,76,76,76,123,76,76,76,76,31,31,31,
	31,31,31,31,31,31,31,19,19,19,89,79,4,87,124,27,
	47,35,83,11,5,105,105,11,83,83,35,47,47,81,81,47,
	47,81,81,55,81,65,39,91,91,70,70,124,70,74,70,70,
	70,74,70,84,70,74,28,52,52,4,79,118,19,76,76,0,
	36,125,3,88,98,14,64,64,14,64,112,59,59,59,64,112,
	64,68,0,0,0,110,110,92,63,63,48,73,87,81,35,105,
	11,83,38,99,47,15,39,39,39,15,39,15,55,15,55,15,
	111,111,121,17,127,45,122,19,
	19,117,94,61,61,61,61,61,8,33,46,100,56,13,117,76,
	58,58,89,52,81,50,120,36,11,38,38,64,14,14,18,2,
	122,17,113,104,16,16,79,31,31,95,95,95,125,20,20,20,
	20,94,94,94,94,8,8,8,46,46,8,8,8,8,8,8,
	79,41,75,0,95,95,95,95,95,95,95,95,123,95,76,76,
	123,123,123,123,95,76,76,76,19,58,19,89,78,62,70,27,
	81,35,83,83,11,11,83,83,83,35,47,35,81,47,47,35,
	80,38,38,99,99,81,15,65,65,7,7,70,124,124,124,124,
	124,124,74,74,74,74,16,28,52,12,118,54,19,31,0,88,
	19,101,98,9,14,6,6,108,69,57,57,108,98,59,59,64,
	59,64,66,0,0,0,92,92,92,92,43,43,73,7,35,11,
	11,29,83,80,47,15,15,65,65,65,39,39,15,55,15,111,
	51,111,80,50,82,45,102,19,
	19,117,106,61,61,61,8,61,8,33,106,106,125,13,117,76,
	58,54,89,28,39,50,36,82,38,50,50,14,98,21,40,10,
	2,24,113,113,104,32,41,4,79,95,95,125,125,20,94,94,
	94,94,46,94,46,94,61,8,94,61,94,33,8,8,8,95,
	12,31,61,98,95,95,123,95,95,123,95,95,123,95,95,95,
	31,94,46,61,46,46,94,94,92,76,89,78,61,92,20,92,
	3,117,3,3,3,43,3,3,73,117,63,63,3,3,38,58,
	58,19,58,58,11,38,47,81,15,65,87,78,7,70,124,70,
	70,70,70,70,70,74,74,74,28,52,103,118,49,0,69,18,
	9,14,14,108,1,69,9,98,9,88,68,44,44,57,112,59,
	59,59,67,72,0,0,0,100,92,46,63,43,48,87,81,83,
	38,38,38,99,81,81,39,101,101,65,15,15,15,111,15,111,
	111,111,80,29,127,36,102,19,
	19,117,94,61,61,61,61,8,8,8,106,100,125,110,76,58,
	54,54,12,52,39,50,36,29,50,47,111,21,98,14,18,114,
	3,24,24,113,18,0,0,0,14,98,9,6,108,26,24,104,
	75,32,114,79,31,125,20,94,94,94,33,94,33,94,31,22,
	109,33,61,9,123,123,95,95,95,95,95,95,95,76,95,95,
	61,61,20,31,95,3,76,94,61,117,79,89,61,3,78,78,
	3,61,61,73,73,62,117,92,27,65,61,61,73,35,11,105,
	3,61,65,36,120,105,38,35,81,27,4,61,7,124,70,70,
	70,70,70,91,91,84,84,74,119,28,52,4,118,99,64,23,
	64,64,108,69,88,14,0,0,0,0,0,69,72,57,57,112,
	59,59,59,112,0,0,0,92,46,92,92,63,48,124,81,38,
	38,38,80,99,81,39,65,65,91,39,39,55,15,55,111,55,
	111,111,80,29,82,45,102,118,
	31,125,46,61,61,61,61,61,46,46,106,100,125,117,117,76,
	76,58,60,54,84,51,82,116,51,102,102,98,98,98,18,122,
	31,17,24,24,24,108,67,107,67,59,0,67,107,107,107,67,
	37,59,59,37,37,37,37,98,18,24,113,2,122,71,22,32,
	79,8,8,9,123,123,95,123,95,123,95,31,95,31,95,61,
	61,94,95,31,31,76,76,58,61,63,79,3,20,62,62,87,
	89,61,61,7,87,7,7,61,27,27,61,61,70,83,11,11,
	94,15,53,53,53,120,11,38,99,81,4,61,7,124,124,7,
	70,7,91,70,70,70,74,74,74,74,119,52,0,9,98,64,
	64,6,108,9,9,0,0,0,0,0,0,0,0,57,72,108,
	64,59,64,0,72,0,0,0,92,92,3,58,73,7,81,38,
	35,99,35,111,15,91,91,91,91,91,39,15,39,39,111,15,
	51,111,99,29,45,36,102,19,
	19,117,94,61,61,61,8,8,33,46,106,100,100,20,125,125,
	117,13,13,123,85,51,17,116,51,102,101,98,9,9,18,122,
	19,113,97,97,24,45,18,67,107,107,67,67,37,67,37,37,
	30,37,37,37,37,37,37,37,37,37,37,37,88,25,2,2,
	97,20,61,98,95,95,31,95,95,95,76,95,95,95,20,61,
	61,95,76,76,76,76,19,19,95,3,79,89,79,41,28,28,
	76,61,61,62,62,87,87,73,7,27,61,61,124,83,11,19,
	76,53,34,34,34,96,120,105,11,35,4,61,65,7,7,70,
	70,70,70,91,70,74,70,70,74,74,74,28,94,23,64,23,
	34,9,9,9,0,0,0,0,0,0,0,0,0,0,72,57,
	57,59,59,59,9,0,0,0,92,110,3,89,73,70,81,99,
	99,47,81,15,15,91,65,91,91,65,91,15,15,15,15,55,
	111,111,80,29,45,126,55,118,
	118,95,94,61,61,61,61,8,33,106,106,106,100,100,56,20,
	93,125,93,86,85,51,17,121,51,122,101,98,9,98,18,122,
	79,113,26,26,97,97,24,18,67,37,107,67,107,30,115,115,
	66,66,115,30,30,30,30,30,37,37,30,66,113,25,10,108,
	26,94,61,98,95,95,95,31,95,95,95,76,95,95,61,61,
	46,95,95,95,95,95,76,31,19,19,79,79,4,4,4,4,
	95,61,61,79,78,4,62,28,7,7,61,61,124,38,58,94,
	5,34,34,34,34,53,105,15,65,70,58,61,4,54,89,78,
	7,70,70,70,70,70,74,70,70,74,16,74,2,98,0,64,
	88,108,115,0,0,0,0,0,0,76,76,76,123,95,57,18,
	72,59,59,59,90,0,0,0,117,110,58,89,73,124,65,81,
	81,15,39,27,65,122,65,91,91,91,39,15,15,15,55,81,
	111,111,99,17,82,36,101,79,
	54,76,100,8,8,8,8,8,8,46,94,106,106,106,100,56,
	100,93,93,86,103,71,17,121,51,122,122,98,9,9,18,101,
	41,82,88,26,26,97,77,24,24,66,30,90,115,88,68,69,
	88,115,42,68,69,68,66,115,115,21,72,113,25,75,75,90,
	97,94,61,9,95,95,95,95,95,95,123,95,95,95,61,61,
	46,76,95,95,95,76,95,95,31,19,49,118,118,118,79,79,
	95,61,61,19,89,78,78,4,28,70,61,61,89,94,61,81,
	96,53,34,34,34,53,47,61,61,61,61,61,61,61,61,61,
	70,7,7,91,70,70,70,70,16,70,70,70,127,14,14,9,
	9,6,14,0,0,0,0,31,76,76,123,95,95,86,86,72,
	57,9,59,64,59,116,0,0,0,110,3,58,78,28,70,39,
	91,91,91,91,91,70,91,91,91,101,65,39,55,15,15,55,
	111,111,50,38,36,126,55,19,
	4,19,117,106,106,46,8,46,33,33,106,106,100,106,106,56,
	106,56,56,13,103,102,17,51,51,32,109,9,9,9,26,10,
	41,82,21,18,26,97,97,24,113,24,24,69,69,69,98,0,
	0,0,0,107,0,67,21,88,108,77,113,17,25,10,72,30,
	42,20,8,98,95,123,95,95,95,95,95,76,95,95,61,61,
	46,31,76,31,20,94,46,8,46,46,20,60,19,19,19,118,
	125,61,61,19,19,19,78,78,62,124,61,61,58,92,61,61,
	5,53,53,34,34,53,96,105,11,35,28,61,27,7,7,7,
	70,7,70,65,70,70,70,70,84,84,70,74,1,64,6,88,
	98,9,9,0,0,0,0,31,76,76,31,76,76,95,95,57,
	68,57,59,112,59,18,0,0,0,100,3,3,89,78,87,91,
	7,70,70,114,91,70,91,91,65,91,15,15,15,15,81,55,
	47,2,80,17,36,36,55,19,
	28,54,76,92,106,46,8,8,8,46,106,94,106,106,100,106,
	56,100,56,86,41,102,116,75,71,32,0,88,6,98,26,10,
	16,113,0,108,18,26,26,97,97,24,24,24,24,26,108,21,
	67,67,64,59,112,108,18,113,113,113,17,25,25,25,30,30,
	97,94,61,9,123,95,123,123,95,123,76,95,31,19,61,61,
	61,19,19,31,31,76,95,61,61,20,123,31,31,60,60,76,
	125,61,61,19,58,19,19,89,4,28,61,61,28,38,110,61,
	94,96,53,34,34,96,120,5,11,38,87,61,15,65,65,91,
	7,70,7,70,70,70,74,70,70,70,91,91,6,98,53,9,
	98,98,9,0,0,0,0,19,19,31,31,31,123,123,86,57,
	72,57,59,90,59,57,0,0,0,100,110,3,58,78,28,70,
	70,70,70,70,70,70,91,91,91,101,65,15,81,111,55,47,
	47,99,80,29,45,24,55,118,
	28,78,76,110,100,100,46,46,33,8,33,33,106,33,106,94,
	56,56,56,13,41,102,17,2,102,32,98,108,6,9,26,10,
	16,24,107,21,18,26,26,26,26,26,97,97,97,24,97,97,
	97,97,24,113,17,113,113,113,113,17,17,25,75,113,30,30,
	26,94,46,9,76,95,95,76,95,95,76,76,31,79,20,61,
	61,76,79,19,19,19,31,61,61,125,95,123,123,95,76,76,
	20,61,61,95,76,19,19,79,4,28,61,61,4,35,35,94,
	61,78,53,53,53,96,96,11,11,38,87,61,81,39,27,65,
	65,70,70,70,70,70,70,70,70,70,70,7,44,1,1,9,
	9,98,6,0,0,0,12,118,12,118,118,19,60,31,123,57,
	127,57,21,90,64,57,0,0,0,92,110,3,48,78,87,91,
	7,70,70,70,70,70,91,91,65,101,65,101,15,15,47,111,
	111,99,80,29,36,120,101,79,
	52,54,76,110,100,106,46,33,8,8,8,8,33,33,106,106,
	106,56,93,86,41,55,17,121,102,0,98,108,6,9,40,10,
	16,24,0,59,98,18,18,18,18,18,18,72,26,26,97,97,
	24,113,113,113,32,94,61,94,31,17,75,25,12,61,33,17,
	97,94,8,9,19,19,95,95,95,76,76,76,19,19,118,61,
	61,61,19,118,49,19,31,61,61,20,76,95,95,76,123,123,
	20,61,61,123,95,76,19,54,78,4,61,61,28,35,83,47,
	61,61,73,53,53,96,5,105,11,38,124,61,27,65,65,7,
	7,7,124,87,124,70,70,70,7,91,70,70,36,126,69,9,
	9,14,108,0,0,0,74,119,52,52,103,12,118,49,60,115,
	116,57,98,30,59,57,0,0,0,92,63,58,78,73,70,65,
	91,91,70,70,70,70,91,91,65,65,15,15,15,81,15,47,
	111,99,80,29,45,126,55,19,
	28,54,3,110,100,100,8,8,8,61,8,8,33,33,106,106,
	56,56,56,13,41,71,17,121,102,0,14,18,108,9,26,10,
	16,126,107,0,59,88,18,18,57,18,57,18,18,18,26,26,
	24,113,113,19,46,8,46,94,33,94,25,103,8,46,122,12,
	41,20,94,98,24,42,50,41,95,95,76,95,19,19,54,19,
	8,61,8,117,54,19,117,61,61,20,95,95,95,95,95,76,
	94,61,61,20,123,31,76,19,54,54,61,61,125,47,38,11,
	58,61,61,54,5,96,5,11,83,38,35,47,81,39,65,65,
	7,7,7,7,7,7,91,70,7,70,7,70,97,36,1,69,
	9,23,9,0,0,0,91,84,84,74,85,52,103,12,49,115,
	51,66,115,98,64,57,0,0,0,110,3,89,28,124,91,15,
	27,39,70,91,70,7,70,70,39,65,39,65,15,15,81,111,
	47,99,104,29,36,36,55,19,
	28,54,58,110,92,92,106,106,106,33,33,33,33,33,106,56,
	106,56,93,13,41,102,17,111,10,0,98,18,18,6,26,101,
	41,45,0,0,0,59,88,57,108,108,108,108,57,18,26,26,
	97,24,17,20,94,20,41,113,122,125,95,8,8,16,21,17,
	12,109,17,21,6,26,40,26,41,31,76,31,31,58,118,49,
	118,110,8,61,61,61,8,94,125,76,95,95,95,95,125,46,
	46,8,46,46,46,76,76,19,110,94,94,20,110,3,35,76,
	58,58,89,54,58,38,5,5,105,83,38,35,47,81,27,65,
	65,91,7,70,7,70,7,70,70,70,70,82,40,57,69,6,
	108,108,66,66,9,9,66,9,88,9,9,9,9,6,6,108,
	6,6,6,108,1,1,26,99,0,92,3,89,73,124,7,15,
	101,65,91,91,70,91,91,91,91,70,39,15,101,15,81,55,
	111,99,99,29,45,97,55,118,
	52,78,58,117,110,125,100,106,106,33,33,33,33,106,106,56,
	56,93,93,86,103,102,29,121,55,0,98,97,26,6,97,114,
	41,45,0,107,0,0,0,88,108,108,108,108,57,57,18,26,
	97,113,17,95,20,94,6,88,102,114,94,94,46,32,0,98,
	16,97,88,9,97,122,16,97,29,76,95,76,31,31,19,19,
	19,49,58,31,76,31,76,76,95,76,95,95,76,76,95,95,
	76,95,95,95,95,123,123,123,19,78,78,28,70,81,35,35,
	11,105,5,5,96,96,96,5,5,11,83,35,35,81,27,65,
	7,65,7,7,7,7,70,70,124,124,82,9,108,108,69,66,
	88,88,88,9,88,115,115,115,115,9,98,9,9,9,9,9,
	6,34,6,108,1,108,1,18,15,0,0,54,28,124,70,27,
	65,65,91,65,91,91,91,91,39,65,39,39,15,15,15,55,
	47,111,80,29,82,36,55,118,
	4,49,123,110,125,100,100,100,106,106,33,106,106,106,106,56,
	56,56,93,13,41,102,17,111,10,64,14,24,97,6,24,114,
	19,29,107,0,0,0,0,59,88,88,108,88,108,18,18,18,
	97,97,82,31,95,20,40,0,98,122,125,12,20,20,122,114,
	75,108,88,88,26,91,16,82,1,79,31,95,76,19,58,19,
	19,19,19,60,31,31,76,123,76,76,31,31,76,31,76,31,
	123,31,123,123,123,123,123,76,19,54,4,28,70,65,81,38,
	83,11,5,96,96,96,96,96,5,11,11,83,35,35,81,81,
	27,7,65,65,7,7,7,7,70,70,64,112,112,112,64,64,
	64,59,64,112,59,64,59,64,64,23,23,23,23,23,23,23,
	23,23,23,23,23,64,23,64,14,0,0,0,73,28,70,101,
	65,91,65,91,65,65,39,91,39,91,101,15,101,55,55,55,
	111,2,80,29,45,126,55,19,
	118,76,117,93,100,100,100,56,106,106,106,106,106,106,106,56,
	56,56,93,86,41,102,17,121,55,64,9,24,24,1,24,124,
	31,17,107,107,0,0,0,59,21,88,108,88,108,108,18,26,
	26,97,24,103,19,95,4,18,40,31,10,25,2,16,16,10,
	26,18,6,88,18,45,50,26,6,41,58,95,31,31,60,60,
	76,60,31,31,31,31,31,31,31,31,60,31,31,31,31,31,
	31,60,31,60,31,31,31,123,76,54,54,52,124,70,27,47,
	83,11,5,96,53,53,53,53,96,105,11,83,35,35,81,81,
	81,27,65,65,65,70,7,7,70,70,23,64,112,64,112,112,
	64,112,64,64,112,64,112,59,64,23,64,23,64,23,64,23,
	64,23,64,0,64,23,64,112,14,0,0,0,78,62,124,91,
	65,91,39,91,91,39,101,39,101,101,101,55,15,55,15,111,
	111,111,80,29,45,126,55,19,
	19,76,125,106,56,100,93,100,106,106,33,106,106,106,56,56,
	56,93,93,13,41,102,17,121,55,64,9,24,17,1,113,41,
	95,10,107,107,107,0,0,64,59,88,88,108,108,108,57,18,
	26,97,97,10,79,76,76,76,95,4,17,17,17,17,17,113,
	26,40,18,108,6,1,18,88,108,28,19,76,76,76,76,76,
	31,123,76,31,123,31,123,123,31,31,31,123,123,31,31,31,
	31,60,31,31,31,31,123,60,19,19,54,89,52,124,91,81,
	38,11,105,96,53,53,53,53,96,5,105,83,83,35,35,81,
	27,27,27,65,7,65,70,70,7,70,112,112,23,64,67,23,
	112,112,112,64,59,64,112,23,112,64,23,64,23,64,23,64,
	23,64,23,112,23,112,23,59,14,0,0,0,89,28,124,7,
	70,91,65,65,101,15,65,101,15,101,15,15,55,55,55,55,
	51,111,80,17,82,45,55,118,
	31,95,100,46,106,106,125,100,56,106,33,106,106,106,106,56,
	56,93,93,86,41,71,17,121,10,0,88,17,82,1,17,4,
	20,10,107,0,107,107,0,64,59,9,108,88,108,108,57,18,
	57,18,97,97,24,75,2,75,25,113,17,25,113,17,113,24,
	97,126,40,18,108,6,6,98,44,52,4,12,118,118,54,19,
	60,60,76,31,123,31,31,123,123,123,31,123,31,31,123,31,
	31,31,123,123,123,123,123,123,76,19,118,54,4,62,70,65,
	35,38,105,5,96,53,53,53,96,5,11,83,83,35,81,81,
	27,65,27,65,65,65,65,70,91,70,64,59,112,64,112,64,
	67,64,112,112,112,64,64,112,67,23,64,67,64,23,67,23,
	67,23,64,23,64,67,64,64,14,0,0,0,58,89,28,70,
	7,70,65,39,39,15,15,101,101,39,101,15,15,55,55,55,
	111,51,99,17,45,36,101,118,
	76,13,100,8,8,106,106,106,106,106,33,106,106,106,56,93,
	93,56,93,86,41,102,17,121,55,0,9,104,104,40,17,79,
	94,102,107,107,107,0,67,64,59,21,88,108,88,108,108,57,
	57,57,26,97,97,24,24,113,113,113,113,17,113,113,24,26,
	45,82,97,40,18,69,88,88,50,124,28,28,52,103,4,103,
	54,118,118,118,60,60,60,123,60,60,31,49,60,49,49,60,
	31,123,123,123,95,95,95,76,76,19,54,54,78,78,28,65,
	81,35,11,5,96,96,96,53,5,5,11,83,35,35,81,81,
	15,27,65,65,7,7,7,70,7,70,112,112,64,67,64,64,
	64,67,64,112,64,67,64,64,64,23,23,64,23,64,23,64,
	23,64,67,64,23,64,23,67,14,0,0,0,43,48,73,28,
	124,91,91,65,15,15,15,15,15,101,101,101,101,15,101,101,
	55,10,111,29,82,24,102,19,
	76,13,100,8,8,46,33,33,33,33,33,106,106,56,106,56,
	93,13,13,86,41,55,17,2,102,0,88,104,17,26,17,79,
	94,32,107,107,107,107,67,21,0,64,98,108,88,108,108,108,
	18,88,108,26,26,97,97,24,24,113,113,113,24,97,26,18,
	26,17,82,45,42,44,57,120,39,70,70,74,124,28,28,52,
	52,103,12,12,49,49,49,60,31,49,60,49,19,49,49,49,
	19,31,123,123,123,123,95,123,123,31,54,118,78,78,28,84,
	27,47,83,11,5,5,96,96,5,105,11,83,35,81,81,81,
	27,39,65,65,91,91,70,70,70,70,98,90,98,98,115,112,
	90,112,98,21,115,98,115,21,115,14,21,14,9,9,14,98,
	14,14,14,21,14,14,14,14,9,0,0,0,110,63,48,78,
	62,70,39,39,65,101,101,39,39,101,101,15,101,101,101,101,
	55,51,111,17,127,36,102,19,
	31,125,106,61,61,8,33,33,33,33,33,106,56,56,93,93,
	93,93,93,86,41,102,17,121,101,0,6,2,104,120,104,19,
	46,16,107,107,0,107,64,21,59,59,21,88,108,88,88,6,
	26,18,108,108,18,26,97,26,97,97,97,97,26,26,18,18,
	18,29,17,82,24,97,36,80,65,91,70,70,70,74,74,28,
	52,52,103,118,118,60,60,60,60,60,60,19,49,49,118,60,
	60,31,123,123,95,95,95,95,76,76,76,54,12,78,28,124,
	65,47,80,11,105,5,5,96,5,11,83,83,35,35,81,81,
	81,15,65,7,7,70,91,70,70,70,97,120,97,120,97,120,
	44,120,126,44,44,44,120,120,1,68,44,68,68,44,18,68,
	44,72,72,68,72,72,72,126,126,0,0,0,92,3,19,4,
	28,16,91,91,101,101,91,101,39,101,101,101,101,102,101,102,
	55,55,51,50,82,24,101,19,
	19,125,94,61,61,8,8,33,33,33,106,106,56,56,56,93,
	20,93,13,86,41,102,50,121,102,0,9,2,104,26,104,19,
	8,16,0,107,107,107,112,98,0,59,21,21,88,108,88,108,
	18,97,113,97,98,108,57,18,26,18,26,26,18,18,57,108,
	57,18,26,45,127,82,47,91,91,91,91,91,70,74,28,119,
	52,103,103,118,49,60,31,123,123,31,60,60,19,49,49,60,
	31,123,123,95,13,95,13,95,123,31,19,54,78,52,62,84,
	65,81,35,11,105,5,5,5,105,11,83,83,35,81,81,27,
	27,39,65,91,7,7,70,70,70,70,50,45,127,127,36,36,
	126,126,126,126,126,126,44,18,120,72,72,72,72,77,126,126,
	126,126,77,77,77,77,77,77,29,0,0,0,117,58,54,28,
	28,70,91,32,91,122,122,122,122,122,122,122,122,122,32,122,
	71,55,51,116,82,45,102,19,
	19,95,106,61,8,8,33,33,33,33,106,106,106,56,93,56,
	93,93,93,13,41,102,17,2,102,0,88,2,10,97,104,31,
	46,16,107,107,107,107,112,9,21,64,88,88,18,18,72,26,
	113,77,24,18,88,98,98,88,88,57,57,18,57,57,18,108,
	108,18,26,24,29,27,91,65,91,91,91,91,74,74,74,52,
	52,12,118,118,49,31,31,123,31,60,60,60,60,31,31,125,
	46,31,95,86,95,95,95,95,95,19,49,54,78,52,124,70,
	39,47,35,38,83,83,83,87,62,83,35,35,81,81,81,39,
	65,65,65,91,70,70,70,70,70,70,126,44,97,40,120,120,
	97,120,44,44,1,18,69,44,18,44,68,68,44,68,44,68,
	44,72,72,44,72,72,72,126,126,0,0,0,58,54,4,52,
	74,114,122,91,122,122,91,32,84,84,32,84,32,109,32,109,
	32,71,102,116,17,127,122,19,
	19,95,106,61,61,61,8,33,33,33,33,106,106,106,56,56,
	56,93,13,86,41,10,17,111,10,0,88,10,10,24,104,31,
	8,16,107,107,107,107,21,18,72,113,113,25,25,113,113,72,
	57,26,113,97,26,57,88,9,98,21,64,64,21,98,98,9,
	98,108,97,9,39,65,91,7,7,70,70,91,70,74,74,123,
	100,100,106,106,106,106,13,31,46,94,94,94,106,123,61,61,
	61,123,123,123,123,95,95,123,123,76,49,54,78,78,28,124,
	65,39,81,47,35,81,61,61,3,81,81,81,81,65,65,65,
	65,70,7,91,91,70,70,70,70,70,120,126,126,97,120,120,
	120,120,44,97,120,44,120,1,18,66,44,72,72,72,68,72,
	126,72,72,72,77,77,77,77,120,0,0,0,58,54,52,74,
	74,84,122,122,39,32,32,84,109,109,109,109,109,109,109,32,
	32,71,51,121,17,127,122,60,
	118,95,100,8,8,8,46,33,33,33,33,33,106,106,56,93,
	93,125,93,86,85,102,17,121,10,0,6,10,2,24,104,95,
	8,79,107,67,9,126,116,109,22,22,22,25,72,98,21,98,
	98,88,108,97,97,26,18,108,88,98,21,64,64,59,64,112,
	9,122,95,98,65,7,70,91,70,70,70,91,70,74,28,28,
	12,100,61,61,46,31,60,31,123,46,61,20,123,76,95,61,
	61,95,95,123,86,31,123,123,76,19,19,118,4,28,74,124,
	91,27,39,81,47,81,28,61,117,81,81,39,65,91,65,91,
	70,70,91,91,7,84,91,70,70,74,97,126,97,36,97,120,
	97,44,44,44,44,44,44,120,44,44,44,44,44,44,72,44,
	68,72,77,42,72,72,72,126,126,0,0,0,58,78,52,28,
	74,84,32,32,32,32,32,109,84,109,109,109,109,109,109,109,
	32,32,71,116,17,127,122,19,
	49,95,106,61,8,8,8,33,33,33,106,106,106,106,56,93,
	93,13,13,86,85,51,17,121,55,0,6,10,2,24,104,31,
	20,101,88,29,51,12,95,94,10,72,90,59,59,59,21,21,
	98,21,98,98,98,98,98,98,21,21,64,59,98,59,37,30,
	18,79,20,98,91,70,70,70,70,70,74,74,124,74,74,74,
	52,103,94,61,61,13,123,123,125,61,20,95,123,95,95,61,
	61,76,123,31,123,31,31,31,19,54,118,103,52,28,124,7,
	91,65,65,65,65,65,78,61,125,91,65,84,7,70,70,70,
	91,70,91,39,91,91,91,91,91,84,44,40,120,40,18,44,
	44,18,69,44,1,44,18,1,44,68,44,68,44,68,44,68,
	68,68,68,72,72,72,72,44,44,0,0,0,58,54,103,28,
	74,74,84,84,84,84,84,109,109,109,109,109,109,109,32,32,
	32,71,51,75,82,127,122,19,
	19,95,20,33,33,33,106,33,106,106,106,56,56,93,93,93,
	93,93,13,123,41,102,17,121,10,0,6,15,10,97,104,31,
	126,88,21,127,55,45,18,115,98,88,98,98,98,98,21,21,
	98,98,98,98,21,64,21,64,21,21,21,21,90,59,30,37,
	18,31,56,98,91,7,70,70,70,70,124,70,74,74,74,74,
	52,52,54,61,61,61,123,95,61,20,95,123,95,123,95,61,
	61,31,76,123,31,31,31,19,49,118,12,54,52,28,28,74,
	70,70,70,70,70,70,54,61,125,70,124,70,84,84,84,91,
	84,39,39,39,55,55,55,55,55,15,82,26,120,120,120,44,
	44,44,44,1,44,18,44,120,40,44,72,44,72,44,72,72,
	68,68,68,72,44,44,126,77,127,0,0,107,123,58,54,103,
	41,74,109,84,16,16,16,109,74,109,84,109,32,109,109,32,
	71,71,51,116,29,77,71,19,
	118,86,100,33,33,33,106,33,56,56,56,56,56,93,93,13,
	13,13,13,123,85,102,17,51,102,0,14,10,10,36,104,41,
	6,98,67,0,107,107,67,90,21,115,21,115,112,21,21,90,
	90,112,112,90,112,90,112,90,90,90,115,90,30,30,30,30,
	18,95,94,9,91,91,70,70,70,74,70,70,70,70,74,74,
	28,52,103,19,61,61,106,61,93,123,95,95,95,95,95,61,
	61,95,123,123,123,106,33,33,61,56,60,118,12,103,52,54,
	100,61,61,8,19,28,19,61,100,74,76,125,100,110,84,84,
	91,39,39,55,51,111,121,111,51,47,82,82,36,97,120,97,
	44,1,44,44,44,126,18,44,44,68,69,44,44,68,72,68,
	18,44,72,72,126,77,77,77,36,0,0,0,93,13,76,49,
	12,103,119,119,119,74,119,109,109,109,32,32,32,122,122,122,
	102,51,121,17,127,126,102,19,
	118,123,93,33,33,33,33,56,106,56,56,93,13,13,13,86,
	86,86,86,60,85,51,17,121,10,114,0,104,2,24,17,24,
	98,108,108,40,40,18,18,18,44,26,72,42,26,18,57,18,
	108,57,57,57,57,57,18,18,42,72,77,82,17,121,2,101,
	16,20,46,98,91,70,91,84,70,84,74,70,84,84,91,84,
	74,119,52,103,95,61,61,8,76,76,95,123,95,123,95,61,
	61,31,76,95,61,46,60,49,20,61,8,49,49,118,13,61,
	106,118,13,61,61,103,76,61,100,52,103,8,76,119,84,84,
	84,84,122,39,15,51,99,111,111,15,40,36,44,126,44,1,
	44,1,44,18,44,44,1,44,1,68,68,68,72,57,72,68,
	72,44,68,72,44,44,72,126,44,0,0,0,106,13,123,76,
	118,12,41,41,119,119,74,16,84,84,32,32,101,102,55,51,
	121,80,50,127,36,126,111,79,
	19,86,56,33,33,106,33,56,56,56,93,93,13,86,13,13,
	86,86,86,60,41,51,17,121,102,109,16,104,2,120,26,24,
	32,79,41,16,114,91,32,41,79,95,95,76,79,49,4,41,
	41,16,16,114,16,114,16,85,41,4,79,31,123,13,20,20,
	94,46,8,98,91,70,70,91,70,91,84,91,91,91,39,39,
	84,74,74,28,54,61,61,61,20,60,123,31,123,123,95,61,
	61,123,31,20,61,13,60,49,60,61,61,20,60,60,61,61,
	60,49,49,123,123,118,95,61,56,76,106,103,85,28,119,119,
	84,84,84,84,32,39,71,39,55,39,44,40,1,1,69,69,
	18,40,1,1,18,69,1,108,6,68,108,69,68,68,68,68,
	68,68,68,72,69,72,69,72,44,0,0,0,106,93,95,123,
	118,118,103,41,85,119,109,109,32,32,101,71,55,51,51,111,
	121,116,50,36,126,120,51,79,
	19,95,56,33,33,33,56,56,56,56,93,93,93,93,13,86,
	13,13,13,86,85,71,17,51,10,32,91,17,2,120,17,19,
	41,16,114,114,114,114,41,19,125,20,125,20,125,95,76,31,
	19,79,19,79,79,19,19,19,76,95,95,125,20,20,20,46,
	46,46,8,9,65,91,91,70,7,70,91,84,39,39,91,91,
	84,84,74,41,8,19,94,61,61,123,31,31,123,31,31,61,
	61,123,123,61,61,125,60,60,60,8,61,106,60,13,61,61,
	49,118,49,49,49,12,123,61,46,61,61,12,52,85,52,52,
	103,52,52,74,74,74,84,91,84,91,126,44,44,1,1,1,
	44,1,44,1,69,44,1,69,69,66,66,68,66,68,68,66,
	68,68,68,68,68,72,68,44,126,0,0,0,33,106,13,31,
	60,103,103,41,41,119,74,109,84,91,122,55,51,55,111,80,
	80,50,50,82,126,126,51,79,
	19,13,106,33,33,33,33,56,56,56,56,56,93,93,93,93,
	93,93,13,86,85,71,17,111,102,114,16,17,104,26,17,79,
	41,16,32,32,16,41,31,20,94,94,20,20,20,20,20,20,
	117,125,95,125,95,125,20,125,20,20,20,20,94,94,94,46,
	8,46,8,9,70,124,84,70,84,91,91,91,91,32,39,91,
	91,84,28,46,19,28,103,61,61,61,31,60,31,123,123,61,
	61,60,31,61,61,20,60,49,60,46,61,46,60,13,61,61,
	49,49,12,49,12,49,86,61,100,20,61,106,103,52,103,103,
	12,103,103,103,52,74,74,91,39,39,36,44,120,126,120,44,
	120,97,120,120,120,97,97,44,44,57,72,72,57,72,72,72,
	72,44,72,77,72,72,126,68,36,0,0,0,61,94,125,31,
	19,103,41,85,119,16,84,32,122,71,55,55,111,80,121,80,
	116,50,29,82,120,126,111,118,
	49,123,93,33,33,56,56,56,56,56,56,56,93,93,56,93,
	93,93,13,86,41,51,17,75,10,32,114,26,24,1,24,79,
	41,16,16,16,4,19,95,20,94,94,94,94,94,94,20,20,
	20,20,20,20,95,95,31,31,19,79,79,79,79,41,16,16,
	16,41,114,37,70,70,124,70,124,70,70,84,91,91,84,84,
	84,28,8,76,52,52,52,118,61,61,8,49,31,49,60,61,
	61,123,31,8,61,33,60,123,60,106,61,13,31,13,61,61,
	13,49,49,49,60,118,95,61,106,103,61,61,100,103,103,12,
	12,54,54,103,52,28,74,84,84,91,44,1,18,44,40,6,
	1,108,69,18,44,69,69,1,108,69,57,57,68,44,57,72,
	68,68,18,68,72,68,66,66,44,0,0,0,8,106,13,31,
	118,103,85,74,109,32,84,122,39,55,55,51,111,121,80,50,
	50,29,11,36,126,120,111,79,
	118,31,13,56,106,56,56,56,56,56,56,56,56,93,93,93,
	93,93,93,86,85,51,17,121,102,32,16,64,1,26,1,24,
	17,17,24,26,24,1,26,10,114,114,41,41,16,4,4,79,
	79,79,19,95,31,41,114,16,41,41,4,79,19,98,124,124,
	70,70,16,70,74,74,74,74,74,70,74,84,74,70,84,74,
	76,46,8,41,103,12,103,12,94,61,61,94,123,60,86,61,
	61,123,31,13,61,61,13,123,123,61,94,60,60,60,46,61,
	61,123,60,20,106,49,100,61,46,12,60,61,61,13,12,54,
	49,12,78,103,52,28,74,74,84,84,23,64,112,23,64,64,
	64,23,64,112,64,112,64,112,64,59,59,59,112,59,59,59,
	59,59,37,59,59,59,64,64,90,0,0,0,100,125,76,118,
	12,28,109,84,32,101,102,55,55,15,111,111,99,80,50,50,
	38,29,82,36,126,126,111,54,
	12,60,13,56,56,56,56,93,93,56,93,93,93,93,93,93,
	13,93,13,86,85,102,17,121,10,109,114,16,41,0,88,120,
	104,104,24,113,101,108,26,20,20,20,20,95,95,95,31,31,
	95,19,31,3,95,95,79,79,4,41,114,122,109,21,124,70,
	70,74,124,74,70,74,84,74,74,74,74,74,74,85,52,123,
	100,100,100,106,60,12,118,106,106,106,46,106,94,93,94,46,
	46,106,60,60,95,46,61,106,8,56,49,49,49,49,49,106,
	8,61,8,93,60,13,106,106,106,125,31,106,106,106,13,12,
	12,12,103,103,52,74,74,74,70,70,112,64,59,64,64,64,
	112,64,64,64,67,64,67,64,64,64,59,64,59,64,59,64,
	59,64,59,64,59,64,59,59,112,0,0,0,117,58,54,103,
	74,74,39,39,39,55,39,15,55,47,111,111,80,80,50,50,
	50,29,29,36,120,120,111,118,
	12,60,13,56,56,56,56,93,93,93,93,93,93,13,93,93,
	93,86,93,60,85,102,17,121,102,109,16,16,41,41,41,41,
	0,88,24,24,24,9,98,88,88,6,6,6,6,6,6,88,
	6,6,6,108,108,26,108,108,18,18,18,18,97,0,124,124,
	74,70,84,84,84,74,84,84,84,119,74,85,85,52,103,103,
	103,12,12,12,49,49,49,49,60,49,123,60,123,60,60,60,
	60,49,60,49,60,60,49,49,49,49,49,49,49,49,49,49,
	60,60,60,31,60,19,19,49,118,118,118,54,12,78,103,12,
	103,103,28,85,28,74,74,74,74,84,112,23,64,64,59,23,
	64,112,64,64,64,64,64,64,59,59,64,59,64,59,64,59,
	64,59,64,59,112,59,64,59,112,0,0,0,76,89,78,52,
	74,84,39,39,39,81,55,81,55,55,47,47,111,99,80,38,
	38,38,29,36,126,126,111,79,
	49,86,93,33,33,33,56,56,93,93,86,93,86,93,86,93,
	86,93,93,86,85,51,17,2,102,32,109,16,85,16,41,85,
	41,124,0,23,97,14,21,21,64,64,64,64,64,21,98,98,
	9,9,88,9,97,0,70,65,65,65,91,70,70,91,70,70,
	70,84,70,84,84,84,84,74,74,74,119,74,28,85,103,103,
	12,103,49,49,49,60,60,60,60,123,60,123,60,60,86,60,
	60,60,60,60,49,49,49,49,49,49,49,49,49,49,49,60,
	60,60,31,60,60,49,118,54,12,12,103,103,52,103,52,52,
	52,28,119,119,74,74,74,74,70,74,64,64,64,64,64,59,
	64,67,112,64,64,59,64,64,64,64,59,64,59,23,59,64,
	59,23,59,23,59,64,59,59,112,0,0,0,58,54,78,28,
	70,91,39,55,15,15,55,15,15,15,55,47,111,99,80,80,
	50,50,29,82,120,126,111,19,
	49,86,93,33,33,56,56,56,93,56,93,93,93,93,93,93,
	93,86,93,86,41,102,17,121,102,114,109,109,16,109,114,32,
	91,122,101,55,24,24,18,9,21,64,64,64,64,14,98,98,
	9,6,108,26,24,26,0,0,91,91,91,91,70,91,91,91,
	91,84,91,91,91,84,84,84,84,74,74,74,52,119,52,103,
	103,103,54,49,49,49,60,60,60,60,31,123,123,60,60,60,
	86,60,60,60,60,49,12,12,12,12,49,12,49,49,60,60,
	60,60,60,60,60,118,54,12,103,52,52,28,119,28,119,74,
	119,74,74,74,74,74,84,74,74,74,112,112,59,64,64,64,
	64,64,64,67,64,23,64,112,64,59,23,59,64,59,112,0,
	112,59,64,59,64,59,64,64,90,0,0,0,58,89,28,28,
	124,91,39,39,15,15,15,15,55,15,15,51,111,111,99,99,
	80,80,38,82,36,126,111,79,
	49,123,56,33,33,33,93,93,93,93,93,86,93,93,93,93,
	13,93,13,86,85,51,17,121,10,32,122,122,122,122,0,6,
	108,9,6,9,1,24,17,26,108,88,9,88,6,18,24,2,
	10,114,114,16,91,25,41,31,79,40,0,65,91,39,39,91,
	65,65,65,91,39,91,65,84,70,84,74,74,74,52,52,103,
	12,12,12,118,60,60,60,60,31,123,123,31,86,31,86,31,
	60,86,60,60,60,49,49,12,12,103,12,12,49,49,49,49,
	60,60,60,49,49,12,103,52,52,52,28,85,28,119,74,119,
	74,74,74,74,84,84,74,109,84,84,0,64,23,64,64,64,
	23,64,64,64,64,64,67,64,67,112,59,112,59,59,59,64,
	59,64,59,67,112,112,112,90,0,0,0,0,58,54,73,28,
	70,91,39,15,55,15,55,39,39,81,55,15,47,55,55,111,
	99,80,38,29,36,126,55,19,
	49,60,13,56,56,93,93,86,13,86,13,13,86,86,86,86,
	13,86,86,60,119,51,29,116,111,101,55,55,111,111,26,75,
	75,25,6,64,21,21,23,14,14,98,9,6,26,17,16,31,
	20,94,20,20,95,20,20,94,94,46,94,10,65,91,91,39,
	91,39,91,84,91,91,84,84,70,84,84,74,119,52,52,103,
	103,12,49,54,60,19,60,60,60,31,123,123,60,31,60,60,
	60,31,60,60,60,60,49,49,49,49,49,49,49,49,49,49,
	49,12,118,103,103,103,52,74,119,74,84,84,74,74,74,74,
	74,74,84,74,74,84,74,74,74,74,74,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,48,78,28,74,
	70,91,39,39,39,91,39,39,55,39,55,15,51,47,55,111,
	111,121,50,29,36,126,111,19,
	103,49,86,13,13,13,86,86,13,86,86,86,86,86,86,86,
	123,123,76,49,84,121,82,50,80,111,111,99,99,80,80,0,
	9,26,24,108,88,17,2,122,41,19,95,125,94,94,94,94,
	94,94,94,94,46,46,94,125,117,95,10,127,91,91,91,70,
	84,70,84,70,84,84,70,84,84,74,74,84,74,85,103,103,
	12,49,12,49,49,60,60,60,123,60,60,31,60,31,60,60,
	123,86,86,123,86,86,60,60,49,49,49,12,103,103,103,103,
	41,52,119,52,74,74,84,84,91,84,84,84,32,39,32,39,
	32,84,84,84,84,74,74,74,74,74,74,74,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,58,54,73,124,
	70,39,39,39,55,39,55,15,39,55,47,55,111,111,111,99,
	80,80,50,29,126,36,55,118,
	103,49,86,93,93,93,86,93,86,86,13,86,86,86,86,86,
	123,60,58,54,114,80,45,29,50,38,50,50,50,38,80,50,
	99,99,0,14,0,14,21,98,98,9,9,9,9,9,108,88,
	88,6,88,14,67,0,0,91,91,91,91,91,91,70,70,70,
	74,74,74,28,74,74,28,28,74,52,52,52,52,103,12,49,
	12,49,49,60,60,60,60,60,86,60,60,60,60,86,123,123,
	123,31,31,31,31,31,49,49,49,12,118,12,103,52,28,74,
	74,28,74,124,74,124,74,124,84,70,84,91,84,84,84,84,
	84,84,84,119,74,74,74,28,28,52,52,28,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,58,78,103,74,
	70,91,39,39,15,15,55,15,55,15,51,47,55,99,111,111,
	80,80,50,29,36,126,10,118,
	103,49,86,93,93,93,93,93,93,13,86,86,86,86,60,123,
	123,58,49,4,39,50,36,36,29,50,50,50,38,50,50,80,
	80,111,15,15,101,91,70,70,114,70,16,74,74,74,74,28,
	124,74,28,28,28,28,70,70,74,70,70,74,28,74,74,28,
	52,28,52,52,78,103,103,103,12,12,12,54,49,49,60,49,
	60,60,60,60,60,60,86,60,86,86,123,86,31,123,31,60,
	60,31,31,19,118,118,118,54,12,78,78,4,28,28,28,28,
	28,124,28,28,62,28,62,52,62,28,28,28,28,74,74,74,
	85,119,52,85,52,85,52,52,52,28,78,52,28,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,54,58,78,28,28,
	70,39,39,55,15,55,81,55,55,55,55,55,111,111,121,111,
	80,116,50,127,36,126,55,19,
	49,60,13,93,56,93,93,86,86,86,86,86,86,60,60,60,
	49,54,12,52,55,29,36,36,82,38,38,80,99,99,47,47,
	15,39,91,70,70,74,74,124,74,74,124,28,28,28,28,52,
	28,52,28,28,28,52,28,28,28,52,28,28,52,78,103,52,
	78,54,78,54,54,54,49,54,54,60,60,60,76,76,123,123,
	60,123,60,86,86,86,86,86,123,123,31,123,31,60,19,19,
	54,54,78,54,78,78,78,78,78,78,52,73,52,73,52,73,
	28,62,62,28,73,52,73,78,78,78,78,78,78,12,78,103,
	54,103,103,103,52,103,52,52,52,52,78,78,78,78,78,4,
	78,4,78,52,78,52,78,4,78,78,78,78,78,78,78,4,
	78,52,78,52,52,78,52,78,78,78,78,54,54,78,28,74,
	84,39,39,55,55,15,55,55,55,15,55,55,51,55,111,51,
	111,80,50,82,36,126,51,118,
	49,86,93,56,56,93,93,93,93,93,86,86,86,86,60,118,
	54,103,52,70,47,82,120,36,11,50,80,99,47,27,91,70,
	124,62,78,78,78,78,78,52,78,78,52,78,78,78,52,78,
	78,78,52,103,4,78,78,78,78,89,54,54,54,54,58,58,
	58,58,76,76,76,76,117,86,117,117,123,117,123,13,117,13,
	13,13,13,86,86,86,86,86,60,123,76,58,58,58,89,54,
	54,89,54,78,78,89,78,89,78,73,89,73,89,73,89,78,
	89,78,78,78,73,78,78,78,78,54,54,58,60,76,123,123,
	123,76,60,54,49,54,54,54,54,58,54,58,58,58,58,58,
	58,58,58,58,58,58,58,58,60,58,76,58,60,58,58,58,
	58,58,54,58,89,54,89,54,54,54,58,54,54,78,52,74,
	74,84,39,39,39,71,39,55,15,55,55,55,55,55,55,51,
	111,121,80,29,45,126,55,19,
	49,86,93,33,33,33,56,93,93,93,86,86,60,58,12,103,
	52,28,74,114,99,82,40,45,29,80,47,39,70,124,4,89,
	89,58,3,3,58,58,58,58,54,58,54,54,54,58,54,54,
	54,54,54,54,58,58,58,60,58,58,76,3,76,76,117,117,
	13,125,93,100,56,100,56,56,56,100,56,106,100,56,56,100,
	93,93,125,13,13,117,76,76,60,58,76,58,58,58,58,48,
	89,48,89,48,89,89,89,73,89,89,89,89,89,89,89,89,
	89,89,89,89,89,54,54,58,58,76,117,110,125,100,100,106,
	106,106,100,13,13,13,13,13,110,110,13,13,100,110,100,110,
	125,110,125,110,125,110,117,110,110,110,110,110,110,13,117,117,
	117,117,117,123,117,76,117,76,76,76,76,117,123,60,54,52,
	74,84,84,122,39,122,39,122,39,39,39,39,39,102,39,102,
	55,51,121,29,127,36,10,19,
	49,13,106,8,33,33,56,93,13,86,60,54,12,52,52,124,
	74,91,91,101,80,29,36,50,111,114,124,4,78,54,58,58,
	76,117,110,110,125,125,100,125,110,13,110,117,117,123,117,123,
	123,117,117,117,110,13,125,100,93,100,100,100,100,100,106,106,
	46,8,8,8,8,8,61,61,61,61,61,61,8,8,8,46,
	106,100,100,92,110,110,3,76,3,76,58,58,3,3,3,3,
	3,3,43,43,43,43,48,43,43,48,43,48,48,48,58,48,
	58,3,58,76,58,76,76,117,13,100,56,106,46,8,61,61,
	61,61,8,8,8,8,46,46,33,46,46,8,46,8,46,46,
	46,46,106,106,100,56,106,106,106,106,106,106,106,106,106,106,
	106,106,106,106,100,106,100,100,100,100,100,100,100,117,60,54,
	103,85,84,109,84,84,84,32,32,32,32,32,32,32,32,122,
	101,102,51,116,82,45,101,118,
	118,31,13,106,56,13,123,60,12,12,52,52,74,84,84,122,
	32,39,39,122,55,51,111,91,4,76,76,76,117,76,110,110,
	110,100,100,106,106,46,46,8,8,106,106,106,46,100,106,100,
	106,56,56,106,46,106,46,46,46,46,46,8,8,8,8,8,
	8,8,8,8,8,8,8,61,8,8,8,61,8,46,46,92,
	46,92,100,110,110,110,110,110,63,110,110,117,117,3,117,63,
	110,63,110,63,63,63,63,43,63,43,63,63,63,63,110,110,
	110,110,117,110,110,125,93,100,106,46,8,8,8,8,8,8,
	8,61,61,8,8,61,8,8,8,8,8,8,8,8,8,8,
	8,61,8,8,8,46,46,46,8,8,8,61,61,61,61,8,
	8,61,61,61,8,8,8,8,8,8,8,8,33,100,13,76,
	54,103,119,119,109,109,74,109,74,109,84,84,84,84,84,109,
	32,101,55,121,82,127,122,19,
	119,103,58,76,76,54,54,103,103,52,85,74,119,84,84,84,
	32,84,109,84,84,84,109,85,52,54,12,12,103,12,103,103,
	12,12,79,54,118,118,118,118,118,118,118,118,118,118,118,118,
	12,118,118,118,79,54,118,118,118,118,118,118,54,118,79,54,
	118,79,118,79,54,79,4,12,4,4,4,52,28,52,28,28,
	28,52,28,4,4,4,73,28,28,28,74,74,74,74,74,28,
	28,28,28,28,73,73,73,73,73,4,73,4,4,4,4,52,
	52,103,103,103,103,54,118,118,118,118,118,118,118,118,118,54,
	118,79,12,54,79,12,79,118,12,79,12,118,79,118,118,118,
	79,118,118,118,118,19,118,118,118,118,118,118,118,118,118,19,
	118,118,118,118,118,118,118,118,118,118,118,118,58,60,76,76,
	118,103,74,84,74,84,109,84,109,84,109,84,109,32,32,122,
	102,55,51,116,82,45,102,19,
	74,52,78,60,58,49,49,58,54,49,54,12,12,103,103,52,
	85,85,52,85,85,85,119,119,109,109,109,84,109,109,16,109,
	109,109,109,119,119,119,119,119,85,85,119,119,119,119,109,85,
	119,109,119,119,85,119,41,85,41,41,52,41,41,119,74,16,
	74,91,91,122,39,39,39,39,15,15,15,15,15,15,81,15,
	81,55,81,15,81,15,15,15,55,15,15,15,55,55,51,55,
	15,55,15,55,55,55,55,15,39,101,39,91,91,91,84,84,
	84,84,74,16,74,16,74,85,119,119,119,119,119,119,119,119,
	16,74,119,16,74,109,84,16,84,16,84,16,74,119,119,119,
	85,41,41,103,41,103,103,41,41,41,85,85,119,85,119,85,
	85,85,85,85,85,85,119,16,109,109,84,122,122,39,122,91,
	101,101,122,102,122,101,101,71,122,102,71,102,122,71,71,71,
	51,51,116,17,77,24,55,118,
	119,103,60,123,86,117,86,123,86,123,86,60,60,49,49,49,
	103,103,103,85,119,109,109,109,109,109,119,109,109,109,109,109,
	109,109,119,109,109,109,109,109,109,109,109,109,32,109,109,109,
	32,109,32,122,122,122,122,39,122,122,122,122,122,91,122,101,
	101,15,55,15,111,111,111,47,111,111,111,111,99,99,80,80,
	99,47,99,47,99,47,47,111,47,47,111,47,111,111,47,111,
	111,15,55,15,55,15,55,101,101,122,122,122,32,109,32,109,
	109,16,16,16,119,119,119,119,119,16,109,109,109,109,109,109,
	109,109,109,109,109,109,109,109,109,109,109,32,109,84,109,109,
	109,109,109,109,109,109,109,109,32,32,122,122,71,71,71,122,
	71,71,122,122,122,122,122,71,122,101,55,55,55,55,111,51,
	51,55,111,111,51,51,55,55,102,39,71,122,32,122,122,71,
	71,102,121,116,127,45,102,19,
	12,49,13,100,93,93,93,13,13,13,13,86,86,60,12,12,
	103,119,109,109,32,32,32,32,109,109,109,109,109,32,32,109,
	32,32,32,32,32,32,32,32,32,32,71,32,71,102,55,51,
	51,51,51,121,121,80,116,116,80,80,80,99,99,111,111,47,
	111,111,47,111,47,99,111,47,99,47,99,99,99,99,99,80,
	80,80,80,80,121,99,111,111,111,55,51,55,55,55,55,55,
	55,55,55,15,102,101,101,122,122,32,32,32,84,109,109,109,
	109,109,109,109,109,109,109,109,109,109,109,109,32,109,32,109,
	109,32,32,32,32,32,32,32,32,32,32,71,71,71,122,32,
	71,32,71,32,71,71,71,71,71,71,51,71,51,51,51,51,
	51,51,51,51,51,51,102,102,51,102,55,55,15,55,55,15,
	51,55,55,55,55,102,102,122,122,32,32,32,32,32,32,32,
	71,71,51,121,82,127,122,19,
	49,123,93,33,33,106,56,93,93,13,86,60,49,12,85,109,
	32,32,71,71,32,71,71,32,71,32,71,71,71,71,71,71,
	71,71,71,51,71,51,51,51,121,51,51,121,121,121,116,80,
	50,50,50,50,29,29,11,29,82,29,29,50,50,38,80,80,
	38,80,80,80,80,80,80,50,80,50,80,80,80,80,80,80,
	121,80,121,121,111,111,111,51,51,111,55,111,51,51,51,51,
	51,55,55,102,102,71,71,102,122,122,122,122,32,32,32,109,
	32,109,32,109,32,32,122,71,71,71,71,71,71,71,71,71,
	71,71,71,71,71,51,71,51,51,51,51,51,51,51,51,51,
	71,51,71,51,71,71,51,71,51,71,51,51,51,51,51,51,
	51,51,51,51,51,51,51,51,51,51,51,55,55,55,55,55,
	55,55,55,55,102,102,71,71,122,122,32,32,32,32,32,32,
	122,71,102,116,82,127,122,19,
	19,95,93,33,33,56,56,93,86,60,49,103,109,109,71,71,
	51,71,51,71,51,71,71,51,71,51,102,51,51,51,51,51,
	51,121,51,121,121,121,116,121,116,50,50,50,29,29,29,29,
	29,29,82,11,29,82,29,11,29,11,29,29,50,29,50,50,
	50,50,38,50,38,80,80,50,80,80,116,116,80,121,111,121,
	121,111,121,121,121,51,121,51,51,51,51,51,51,111,51,51,
	111,121,51,51,51,51,51,51,51,51,71,102,102,71,51,71,
	102,51,102,51,51,51,51,121,121,121,121,121,121,116,121,116,
	121,121,121,121,51,121,51,121,51,51,51,51,121,51,121,121,
	121,121,121,121,121,51,121,51,51,51,51,51,51,51,51,121,
	121,121,121,121,121,121,51,51,51,51,51,51,51,51,51,51,
	51,51,51,51,51,55,55,102,71,102,102,71,71,71,71,102,
	51,51,121,17,127,97,55,118,
	49,86,93,33,56,93,86,49,103,119,109,71,71,51,51,51,
	121,121,121,121,121,121,51,121,51,51,51,51,51,121,121,121,
	121,121,121,116,116,29,50,29,29,29,29,29,29,29,29,82,
	82,82,29,82,82,11,82,82,29,29,29,50,29,38,29,29,
	50,50,50,50,50,116,50,80,50,116,80,50,121,116,121,121,
	121,121,121,111,51,121,51,51,121,121,121,121,121,121,80,121,
	116,121,116,116,80,121,121,121,121,121,121,121,121,121,121,121,
	121,116,116,25,116,116,17,17,17,17,17,17,17,17,116,116,
	29,116,116,116,116,116,116,116,116,116,116,116,116,116,116,29,
	29,116,29,116,29,116,116,116,116,116,116,116,116,116,116,116,
	116,116,29,116,29,116,116,116,116,121,121,116,116,80,116,116,
	80,121,121,121,121,121,51,121,121,51,51,121,121,121,121,121,
	116,116,29,45,126,42,51,118,
	12,118,60,13,49,41,109,71,51,116,116,116,17,116,113,116,
	82,116,29,17,29,17,29,29,29,17,82,29,29,29,82,82,
	82,82,82,82,45,45,45,45,45,45,45,126,45,126,36,36,
	36,126,36,36,45,36,36,45,36,36,45,36,45,45,82,36,
	45,127,82,82,127,127,82,82,82,82,29,82,29,29,17,29,
	29,29,29,29,29,29,29,29,29,29,29,82,82,82,127,127,
	45,127,127,127,45,127,127,82,127,127,113,82,113,82,127,127,
	127,127,77,77,77,77,77,77,77,77,77,77,77,127,77,77,
	127,77,127,77,127,127,77,127,77,127,77,77,77,77,77,77,
	77,45,77,45,45,77,45,77,45,77,77,77,77,77,77,126,
	77,126,77,126,77,77,77,45,45,45,82,127,82,127,82,82,
	127,82,82,82,82,82,29,82,82,82,82,82,82,127,45,127,
	45,45,45,42,44,44,121,79,
	109,109,122,102,121,17,127,77,77,77,77,77,77,77,77,77,
	77,77,72,77,126,126,77,126,42,77,126,77,42,42,126,126,
	126,42,40,42,126,42,42,42,42,42,40,42,40,126,72,42,
	42,126,42,42,42,126,126,126,126,126,126,126,126,126,126,126,
	126,126,126,126,36,126,126,126,126,126,97,126,126,126,126,126,
	126,126,97,126,97,42,126,42,126,42,42,126,42,40,42,42,
	42,40,42,42,42,42,126,72,77,126,126,77,72,77,72,72,
	72,72,72,72,72,72,72,72,72,72,72,77,77,77,77,77,
	42,77,42,126,42,42,126,42,42,42,42,126,42,40,40,42,
	40,40,42,40,42,40,42,40,42,40,40,40,40,40,42,44,
	72,44,44,44,44,40,40,40,42,42,40,42,42,42,42,42,
	42,42,42,126,42,42,42,126,126,42,126,126,40,126,40,126,
	42,42,42,42,44,44,111,79
	};
