/*
 *Copyright (C) 1994-2000 The XFree86 Project, Inc. All Rights Reserved.
 *
 *Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 *"Software"), to deal in the Software without restriction, including
 *without limitation the rights to use, copy, modify, merge, publish,
 *distribute, sublicense, and/or sell copies of the Software, and to
 *permit persons to whom the Software is furnished to do so, subject to
 *the following conditions:
 *
 *The above copyright notice and this permission notice shall be
 *included in all copies or substantial portions of the Software.
 *
 *THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *NONINFRINGEMENT. IN NO EVENT SHALL THE XFREE86 PROJECT BE LIABLE FOR
 *ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 *CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 *WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *Except as contained in this notice, the name of the XFree86 Project
 *shall not be used in advertising or otherwise to promote the sale, use
 *or other dealings in this Software without prior written authorization
 *from the XFree86 Project.
 *
 * Authors:	Harold L Hunt II
 */
/* $XFree86: xc/programs/Xserver/hw/xwin/winblock.c,v 1.7 2003/07/29 21:25:16 dawes Exp $ */

#include "win.h"

/* See Porting Layer Definition - p. 6 */
void
winBlockHandler (int nScreen,
		 pointer pBlockData,
		 pointer pTimeout,
		 pointer pReadMask)
{
  winScreenPriv((ScreenPtr)pBlockData);
  MSG			msg;

  /* Signal threaded modules to begin */
  if (pScreenPriv != NULL && !pScreenPriv->fServerStarted)
    {
      int		iReturn;
      
      ErrorF ("winBlockHandler - Releasing pmServerStarted\n");

      /* Flag that modules are to be started */
      pScreenPriv->fServerStarted = TRUE;

      /* Unlock the mutex for threaded modules */
      iReturn = pthread_mutex_unlock (&pScreenPriv->pmServerStarted);
      if (iReturn != 0)
	{
	  ErrorF ("winBlockHandler - pthread_mutex_unlock () failed: %d\n",
		  iReturn);
	  goto winBlockHandler_ProcessMessages; 
	}

      ErrorF ("winBlockHandler - pthread_mutex_unlock () returned\n");
    }

winBlockHandler_ProcessMessages:

  /* Process all messages on our queue */
  while (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE))
    {
      if ((g_hDlgDepthChange == 0
	   || !IsDialogMessage (g_hDlgDepthChange, &msg))
	  && (g_hDlgExit == 0
	      || !IsDialogMessage (g_hDlgExit, &msg)))
	{
	  DispatchMessage (&msg);
	}
    }
    winReorderWindowsMultiWindow ((ScreenPtr)pBlockData);
}
