require '_h2ph_pre.ph';

require 'machine/endian.ph';
unless(defined(&BBSIZE)) {
    sub BBSIZE () {	1024;}
}
unless(defined(&SBSIZE)) {
    sub SBSIZE () {	1024;}
}
unless(defined(&BBOFF)) {
    sub BBOFF () {	((0));}
}
unless(defined(&SBOFF)) {
    sub SBOFF () {	(( &BBOFF +  &BBSIZE));}
}
unless(defined(&BBLOCK)) {
    sub BBLOCK () {	((0));}
}
unless(defined(&SBLOCK)) {
    sub SBLOCK () {	(( &BBLOCK +  &BBSIZE /  &DEV_BSIZE));}
}
unless(defined(&LOG_MINBSIZE)) {
    sub LOG_MINBSIZE () {	10;}
}
unless(defined(&MINBSIZE)) {
    sub MINBSIZE () {	(1<<  &LOG_MINBSIZE);}
}
unless(defined(&MAXMNTLEN)) {
    sub MAXMNTLEN () {	512;}
}
unless(defined(&MINFREE)) {
    sub MINFREE () {	5;}
}
unless(defined(&E2FS_MAGIC)) {
    sub E2FS_MAGIC () {	0xef53;}
}
unless(defined(&E2FS_REV0)) {
    sub E2FS_REV0 () {	0;}
}
unless(defined(&E2FS_REV1)) {
    sub E2FS_REV1 () {	1;}
}
unless(defined(&EXT2F_COMPAT_PREALLOC)) {
    sub EXT2F_COMPAT_PREALLOC () {	0x0001;}
}
unless(defined(&EXT2F_ROCOMPAT_SPARSESUPER)) {
    sub EXT2F_ROCOMPAT_SPARSESUPER () {	0x0001;}
}
unless(defined(&EXT2F_ROCOMPAT_LARGEFILE)) {
    sub EXT2F_ROCOMPAT_LARGEFILE () {	0x0002;}
}
unless(defined(&EXT2F_ROCOMPAT_BTREE_DIR)) {
    sub EXT2F_ROCOMPAT_BTREE_DIR () {	0x0004;}
}
unless(defined(&EXT2F_INCOMPAT_COMP)) {
    sub EXT2F_INCOMPAT_COMP () {	0x0001;}
}
unless(defined(&EXT2F_INCOMPAT_FTYPE)) {
    sub EXT2F_INCOMPAT_FTYPE () {	0x0002;}
}
unless(defined(&EXT2F_COMPAT_SUPP)) {
    sub EXT2F_COMPAT_SUPP () {	0x0000;}
}
unless(defined(&EXT2F_ROCOMPAT_SUPP)) {
    sub EXT2F_ROCOMPAT_SUPP () {	 &EXT2F_ROCOMPAT_SPARSESUPER;}
}
unless(defined(&EXT2F_INCOMPAT_SUPP)) {
    sub EXT2F_INCOMPAT_SUPP () {	 &EXT2F_INCOMPAT_FTYPE;}
}
unless(defined(&E2FS_OS_LINUX)) {
    sub E2FS_OS_LINUX () {	0;}
}
unless(defined(&E2FS_OS_HURD)) {
    sub E2FS_OS_HURD () {	1;}
}
unless(defined(&E2FS_OS_MASIX)) {
    sub E2FS_OS_MASIX () {	2;}
}
unless(defined(&E2FS_ISCLEAN)) {
    sub E2FS_ISCLEAN () {	0x01;}
}
unless(defined(&E2FS_ERRORS)) {
    sub E2FS_ERRORS () {	0x02;}
}
unless(defined(&h2fs16)) {
    sub h2fs16 {
	local($x) = @_;
	eval q( &htole16($x));
    }
}
unless(defined(&h2fs32)) {
    sub h2fs32 {
	local($x) = @_;
	eval q( &htole32($x));
    }
}
unless(defined(&fs2h16)) {
    sub fs2h16 {
	local($x) = @_;
	eval q( &letoh16($x));
    }
}
unless(defined(&fs2h32)) {
    sub fs2h32 {
	local($x) = @_;
	eval q( &letoh32($x));
    }
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : 0)) {
    eval 'sub e2fs_sbload {
        local($old, $new) = @_;
	    eval q( &memcpy(($new), ($old),  &SBSIZE););
    }' unless defined(&e2fs_sbload);
    eval 'sub e2fs_cgload {
        local($old, $new, $size) = @_;
	    eval q( &memcpy(($new), ($old), ($size)););
    }' unless defined(&e2fs_cgload);
    eval 'sub e2fs_sbsave {
        local($old, $new) = @_;
	    eval q( &memcpy(($new), ($old),  &SBSIZE););
    }' unless defined(&e2fs_sbsave);
    eval 'sub e2fs_cgsave {
        local($old, $new, $size) = @_;
	    eval q( &memcpy(($new), ($old), ($size)););
    }' unless defined(&e2fs_cgsave);
} else {
    eval 'sub e2fs_sbload {
        local($old, $new) = @_;
	    eval q( &e2fs_sb_bswap(($old), ($new)));
    }' unless defined(&e2fs_sbload);
    eval 'sub e2fs_cgload {
        local($old, $new, $size) = @_;
	    eval q( &e2fs_cg_bswap(($old), ($new), ($size)););
    }' unless defined(&e2fs_cgload);
    eval 'sub e2fs_sbsave {
        local($old, $new) = @_;
	    eval q( &e2fs_sb_bswap(($old), ($new)));
    }' unless defined(&e2fs_sbsave);
    eval 'sub e2fs_cgsave {
        local($old, $new, $size) = @_;
	    eval q( &e2fs_cg_bswap(($old), ($new), ($size)););
    }' unless defined(&e2fs_cgsave);
}
unless(defined(&fsbtodb)) {
    sub fsbtodb {
	local($fs, $b) = @_;
	eval q((($b) << ($fs)-> &e2fs_fsbtodb));
    }
}
unless(defined(&dbtofsb)) {
    sub dbtofsb {
	local($fs, $b) = @_;
	eval q((($b) >> ($fs)-> &e2fs_fsbtodb));
    }
}
unless(defined(&ino_to_cg)) {
    sub ino_to_cg {
	local($fs, $x) = @_;
	eval q(((($x) - 1) / ($fs)-> ($e2fs->{e2fs_ipg})));
    }
}
unless(defined(&ino_to_fsba)) {
    sub ino_to_fsba {
	local($fs, $x) = @_;
	eval q((($fs)-> ($e2fs_gd[ino_to_cg($fs, x)]->{e$xt2bgd_i_tables}) + ((($x)-1) % ($fs)-> ($e2fs->{e2fs_ipg}))/($fs)-> &e2fs_ipb));
    }
}
unless(defined(&ino_to_fsbo)) {
    sub ino_to_fsbo {
	local($fs, $x) = @_;
	eval q(((($x)-1) % ($fs)-> &e2fs_ipb));
    }
}
unless(defined(&dtog)) {
    sub dtog {
	local($fs, $d) = @_;
	eval q(((($d) - ($fs)-> ($e2fs->{e2fs_first_dblock})) / ($fs)-> ($e2fs->{e2fs_fpg})));
    }
}
unless(defined(&dtogd)) {
    sub dtogd {
	local($fs, $d) = @_;
	eval q(((($d) - ($fs)-> ($e2fs->{e2fs_first_dblock})) % ($fs)-> ($e2fs->{e2fs_fpg})));
    }
}
unless(defined(&blkoff)) {
    sub blkoff {
	local($fs, $loc) = @_;
	eval q((($loc) & ($fs)-> &e2fs_qbmask));
    }
}
unless(defined(&lblktosize)) {
    sub lblktosize {
	local($fs, $blk) = @_;
	eval q((($blk) << ($fs)-> &e2fs_bshift));
    }
}
unless(defined(&lblkno)) {
    sub lblkno {
	local($fs, $loc) = @_;
	eval q((($loc) >> ($fs)-> &e2fs_bshift));
    }
}
unless(defined(&blkroundup)) {
    sub blkroundup {
	local($fs, $size) = @_;
	eval q(((($size) + ($fs)-> &e2fs_qbmask) & ($fs)-> &e2fs_bmask));
    }
}
unless(defined(&fragroundup)) {
    sub fragroundup {
	local($fs, $size) = @_;
	eval q(((($size) + ($fs)-> &e2fs_qbmask) & ($fs)-> &e2fs_bmask));
    }
}
unless(defined(&freespace)) {
    sub freespace {
	local($fs) = @_;
	eval q((($fs)-> ($e2fs->{e2fs_fbcount}) - ($fs)-> ($e2fs->{e2fs_rbcount})));
    }
}
unless(defined(&NINDIR)) {
    sub NINDIR {
	local($fs) = @_;
	eval q((($fs)-> &e2fs_bsize / $sizeof{ &u_int32_t}));
    }
}
1;
