require '_h2ph_pre.ph';

unless(defined(&D_TAPE)) {
    sub D_TAPE () {	1;}
}
unless(defined(&D_DISK)) {
    sub D_DISK () {	2;}
}
unless(defined(&D_TTY)) {
    sub D_TTY () {	3;}
}
unless(defined(&D_KQFILTER)) {
    sub D_KQFILTER () {	0x00010000;}
}
if(defined(&_KERNEL)) {
    eval 'sub dev_type_open {
        local($n) = @_;
	    eval q(\'int\' $n  &__P(( &dev_t, \'int\', \'int\', \'struct proc\' *)));
    }' unless defined(&dev_type_open);
    eval 'sub dev_type_close {
        local($n) = @_;
	    eval q(\'int\' $n  &__P(( &dev_t, \'int\', \'int\', \'struct proc\' *)));
    }' unless defined(&dev_type_close);
    eval 'sub dev_type_strategy {
        local($n) = @_;
	    eval q( &void $n  &__P());
    }' unless defined(&dev_type_strategy);
    eval 'sub dev_type_ioctl {
        local($n) = @_;
	    eval q(\'int\' $n  &__P(( &dev_t, \'u_long\', \'caddr_t\', \'int\', \'struct proc\' *)));
    }' unless defined(&dev_type_ioctl);
    eval 'sub dev_decl {
        local($n,$t) = @_;
	    eval q( &__CONCAT( &dev_type_,$t)( &__CONCAT($n,$t)));
    }' unless defined(&dev_decl);
    eval 'sub dev_init {
        local($c,$n,$t) = @_;
	    eval q((($c) > 0?  &__CONCAT($n,$t) : ( &__CONCAT( &dev_type_,$t)((*)))  &enxio));
    }' unless defined(&dev_init);
}
if(defined(&_KERNEL)) {
    eval 'sub dev_type_dump {
        local($n) = @_;
	    eval q(\'int\' $n  &__P(( &dev_t,  &daddr_t, \'caddr_t\',  &size_t)));
    }' unless defined(&dev_type_dump);
    eval 'sub dev_type_size {
        local($n) = @_;
	    eval q(\'int\' $n  &__P(( &dev_t)));
    }' unless defined(&dev_type_size);
    eval 'sub dev_size_init {
        local($c,$n) = @_;
	    eval q(($c > 0?  &__CONCAT($n, &size) : 0));
    }' unless defined(&dev_size_init);
    eval 'sub bdev_decl {
        local($n) = @_;
	    eval q( &dev_decl($n, &open);  &dev_decl($n, &close);  &dev_decl($n, &strategy);  &dev_decl($n, &ioctl);  &dev_decl($n, &dump);  &dev_decl($n, &size));
    }' unless defined(&bdev_decl);
    eval 'sub bdev_disk_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &strategy),  &dev_init($c,$n, &ioctl),  &dev_init($c,$n, &dump),  &dev_size_init($c,$n),  &D_DISK });
    }' unless defined(&bdev_disk_init);
    eval 'sub bdev_tape_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &strategy),  &dev_init($c,$n, &ioctl),  &dev_init($c,$n, &dump), 0,  &D_TAPE });
    }' unless defined(&bdev_tape_init);
    eval 'sub bdev_swap_init {
        local($c,$n) = @_;
	    eval q({ ( &dev_type_open((*)))  &enodev, ( &dev_type_close((*)))  &enodev,  &dev_init($c,$n, &strategy), ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_dump((*)))  &enodev, 0});
    }' unless defined(&bdev_swap_init);
    eval 'sub bdev_lkm_dummy () {
        eval q({ ( &dev_type_open((*)))  &lkmenodev, ( &dev_type_close((*)))  &enodev, ( &dev_type_strategy((*)))  &enodev, ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_dump((*)))  &enodev, 0});
    }' unless defined(&bdev_lkm_dummy);
    eval 'sub bdev_notdef () {
        eval q({ ( &dev_type_open((*)))  &enodev, ( &dev_type_close((*)))  &enodev, ( &dev_type_strategy((*)))  &enodev, ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_dump((*)))  &enodev, 0});
    }' unless defined(&bdev_notdef);
}
if(defined(&_KERNEL)) {
    eval 'sub dev_type_read {
        local($n) = @_;
	    eval q(\'int\' $n  &__P(( &dev_t, \'struct uio\' *, \'int\')));
    }' unless defined(&dev_type_read);
    eval 'sub dev_type_write {
        local($n) = @_;
	    eval q(\'int\' $n  &__P(( &dev_t, \'struct uio\' *, \'int\')));
    }' unless defined(&dev_type_write);
    eval 'sub dev_type_stop {
        local($n) = @_;
	    eval q(\'int\' $n  &__P((\'struct tty\' *, \'int\')));
    }' unless defined(&dev_type_stop);
    eval 'sub dev_type_tty {
        local($n) = @_;
	    eval q(\'struct tty\' *$n  &__P(( &dev_t)));
    }' unless defined(&dev_type_tty);
    eval 'sub dev_type_select {
        local($n) = @_;
	    eval q(\'int\' $n  &__P(( &dev_t, \'int\', \'struct proc\' *)));
    }' unless defined(&dev_type_select);
    eval 'sub dev_type_mmap {
        local($n) = @_;
	    eval q(\'int\' $n  &__P(( &dev_t, \'int\', \'int\')));
    }' unless defined(&dev_type_mmap);
    eval 'sub dev_type_kqfilter {
        local($n) = @_;
	    eval q(\'int\' $n  &__P(( &dev_t, \'struct knote\' *)));
    }' unless defined(&dev_type_kqfilter);
    eval 'sub cdev_decl {
        local($n) = @_;
	    eval q( &dev_decl($n, &open);  &dev_decl($n, &close);  &dev_decl($n, &read);  &dev_decl($n, &write);  &dev_decl($n, &ioctl);  &dev_decl($n, &stop);  &dev_decl($n, &tty);  &dev_decl($n, &select);  &dev_decl($n, &mmap);  &dev_decl($n, &kqfilter));
    }' unless defined(&cdev_decl);
    eval 'sub cdev_disk_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &seltrue, ( &dev_type_mmap((*)))  &enodev,  &D_DISK });
    }' unless defined(&cdev_disk_init);
    eval 'sub cdev_tape_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &seltrue, ( &dev_type_mmap((*)))  &enodev,  &D_TAPE });
    }' unless defined(&cdev_tape_init);
    eval 'sub cdev_scanner_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read), ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &nullop, 0,  &seltrue, ( &dev_type_mmap((*)))  &enodev, 0});
    }' unless defined(&cdev_scanner_init);
    eval 'sub cdev_tty_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl),  &dev_init($c,$n, &stop),  &dev_init($c,$n, &tty),  &ttselect, ( &dev_type_mmap((*)))  &enodev,  &D_TTY |  &D_KQFILTER,  &ttkqfilter });
    }' unless defined(&cdev_tty_init);
    eval 'sub cdev_mouse_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read), ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &select), ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_mouse_init);
    eval 'sub cdev_mousewr_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &select), ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_mousewr_init);
    eval 'sub cdev_lkm_dummy () {
        eval q({ ( &dev_type_open((*)))  &lkmenodev, ( &dev_type_close((*)))  &enodev, ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev, ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_stop((*)))  &enodev, 0,  &seltrue, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_lkm_dummy);
    eval 'sub cdev_notdef () {
        eval q({ ( &dev_type_open((*)))  &enodev, ( &dev_type_close((*)))  &enodev, ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev, ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_stop((*)))  &enodev, 0,  &seltrue, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_notdef);
    eval 'sub cdev_cn_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl),  &dev_init($c,$n, &stop), 0,  &dev_init($c,$n, &select), ( &dev_type_mmap((*)))  &enodev,  &D_TTY |  &D_KQFILTER,  &dev_init($c,$n, &kqfilter) });
    }' unless defined(&cdev_cn_init);
    eval 'sub cdev_ctty_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open), ( &dev_type_close((*)))  &nullop,  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &nullop, 0,  &dev_init($c,$n, &select), ( &dev_type_mmap((*)))  &enodev,  &D_TTY |  &D_KQFILTER,  &ttkqfilter });
    }' unless defined(&cdev_ctty_init);
    eval 'sub cdev_mm_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &seltrue,  &dev_init($c,$n, &mmap) });
    }' unless defined(&cdev_mm_init);
    eval 'sub cdev_crypto_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0, ( &dev_type_select((*)))  &enodev, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_crypto_init);
    eval 'sub cdev_swap_init {
        local($c,$n) = @_;
	    eval q({ ( &dev_type_open((*)))  &nullop, ( &dev_type_close((*)))  &nullop,  &dev_init($c,$n, &read),  &dev_init($c,$n, &write), ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_stop((*)))  &enodev, 0, ( &dev_type_select((*)))  &enodev, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_swap_init);
    eval 'sub cdev_ptc_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &nullop,  &dev_init($c,$n, &tty),  &dev_init($c,$n, &select), ( &dev_type_mmap((*)))  &enodev,  &D_TTY |  &D_KQFILTER,  &ttkqfilter });
    }' unless defined(&cdev_ptc_init);
    eval 'sub cdev_log_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read), ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &select), ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_log_init);
    eval 'sub cdev_fd_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open), ( &dev_type_close((*)))  &enodev, ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev, ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_stop((*)))  &enodev, 0, ( &dev_type_select((*)))  &enodev, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_fd_init);
    eval 'sub cdev_bpftun_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &select), ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_bpftun_init);
    eval 'sub cdev_lkm_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0, ( &dev_type_select((*)))  &enodev, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_lkm_init);
    eval 'sub cdev_ch_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0, ( &dev_type_select((*)))  &enodev, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_ch_init);
    eval 'sub cdev_uk_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0, ( &dev_type_select((*)))  &enodev, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_uk_init);
    eval 'sub cdev_ses_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0, ( &dev_type_select((*)))  &enodev, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_ses_init);
    eval 'sub cdev_ss_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read), ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &seltrue, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_ss_init);
    eval 'sub cdev_fb_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0, ( &dev_type_select((*)))  &enodev,  &dev_init($c,$n, &mmap) });
    }' unless defined(&cdev_fb_init);
    eval 'sub cdev_audio_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &select),  &dev_init($c,$n, &mmap) });
    }' unless defined(&cdev_audio_init);
    eval 'sub cdev_midi_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &select), ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_midi_init);
    eval 'sub cdev_svr4_net_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open), ( &dev_type_close((*)))  &enodev, ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev, ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_stop((*)))  &nullop, 0, ( &dev_type_select((*)))  &enodev, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_svr4_net_init);
    eval 'sub cdev_xfs_init {
        local($c, $n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &select), ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_xfs_init);
    eval 'sub cdev_ksyms_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read), ( &dev_type_write((*)))  &enodev, ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_stop((*)))  &enodev, 0,  &seltrue, ( &dev_type_mmap((*)))  &enodev, 0});
    }' unless defined(&cdev_ksyms_init);
    eval 'sub cdev_wsdisplay_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl),  &dev_init($c,$n, &stop),  &dev_init($c,$n, &tty),  &ttselect,  &dev_init($c,$n, &mmap),  &D_KQFILTER,  &dev_init($c,$n, &kqfilter) });
    }' unless defined(&cdev_wsdisplay_init);
    eval 'sub cdev_random_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &select), ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_random_init);
    eval 'sub cdev_usb_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &select), ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_usb_init);
    eval 'sub cdev_ulpt_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev,  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0, ( &dev_type_select((*)))  &enodev, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_ulpt_init);
    eval 'sub cdev_pf_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0, ( &dev_type_select((*)))  &enodev, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_pf_init);
    eval 'sub cdev_usbdev_init {
        local($c,$n) = @_;
	    eval q( &cdev_random_init($c,$n));
    }' unless defined(&cdev_usbdev_init);
    eval 'sub cdev_ugen_init {
        local($c,$n) = @_;
	    eval q( &cdev_random_init($c,$n));
    }' unless defined(&cdev_ugen_init);
    eval 'sub cdev_pci_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0, ( &dev_type_select((*)))  &enodev, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_pci_init);
    eval 'sub cdev_iop_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0, ( &dev_type_select((*)))  &enodev, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_iop_init);
    eval 'sub cdev_radio_init {
        local($c,$n) = @_;
	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0, ( &dev_type_select((*)))  &enodev, ( &dev_type_mmap((*)))  &enodev });
    }' unless defined(&cdev_radio_init);
}
if(defined(&_KERNEL)) {
}
unless(defined(&SW_FREED)) {
    sub SW_FREED () {	0x01;}
}
unless(defined(&SW_SEQUENTIAL)) {
    sub SW_SEQUENTIAL () {	0x02;}
}
unless(defined(&sw_freed)) {
    sub sw_freed () {	 &sw_flags;}
}
if(defined(&_KERNEL)) {
    unless(defined(&LKM)) {
	eval 'sub NLKM () {0;}' unless defined(&NLKM);
	eval 'sub lkmenodev () { &enodev;}' unless defined(&lkmenodev);
    } else {
	eval 'sub NLKM () {1;}' unless defined(&NLKM);
    }
    eval 'sub ptstty () { &ptytty;}' unless defined(&ptstty);
    eval 'sub ptsioctl () { &ptyioctl;}' unless defined(&ptsioctl);
    eval 'sub ptctty () { &ptytty;}' unless defined(&ptctty);
    eval 'sub ptcioctl () { &ptyioctl;}' unless defined(&ptcioctl);
    if(defined(&COMPAT_SVR4)) {
	eval 'sub NSVR4_NET () {1;}' unless defined(&NSVR4_NET);
    } else {
	eval 'sub NSVR4_NET () {0;}' unless defined(&NSVR4_NET);
    }
}
1;
