require '_h2ph_pre.ph';

unless(defined(&BOOT_ELF)) {
    sub BOOT_ELF () {	1;}
}
if(defined(&__sparc_v9__)) {
    eval 'sub ELFSIZE () {64;}' unless defined(&ELFSIZE);
} else {
    eval 'sub ELFSIZE () {32;}' unless defined(&ELFSIZE);
}
unless(defined(&LOAD_KERNEL)) {
    sub LOAD_KERNEL () {	 &LOAD_ALL;}
}
unless(defined(&COUNT_KERNEL)) {
    sub COUNT_KERNEL () {	 &COUNT_ALL;}
}
if(defined(&_STANDALONE)) {
    eval 'sub LOADADDR {
        local($a) = @_;
	    eval q(((($a) & 0x0fffffff) +  &offset));
    }' unless defined(&LOADADDR);
    eval 'sub ALIGNENTRY {
        local($a) = @_;
	    eval q((($a)));
    }' unless defined(&ALIGNENTRY);
    eval 'sub READ {
        local($f, $b, $c) = @_;
	    eval q( &read(,  &LOADADDR($b), ($c)));
    }' unless defined(&READ);
    eval 'sub BCOPY {
        local($s, $d, $c) = @_;
	    eval q( &memcpy( &LOADADDR, ($s), ($c)));
    }' unless defined(&BCOPY);
    eval 'sub BZERO {
        local($d, $c) = @_;
	    eval q( &memset( &LOADADDR($d), 0, ($c)));
    }' unless defined(&BZERO);
    eval 'sub WARN {
        local($a) = @_;
	    eval q(( &printf $a,  &printf(( &errno ? \\": %s\\\\n\\" : \\"\\\\n\\"),  &strerror( &errno))));
    }' unless defined(&WARN);
    eval 'sub PROGRESS {
        local($a) = @_;
	    eval q(  &printf $a);
    }' unless defined(&PROGRESS);
    eval 'sub ALLOC {
        local($a) = @_;
	    eval q( &alloc($a));
    }' unless defined(&ALLOC);
    eval 'sub FREE {
        local($a, $b) = @_;
	    eval q( &free($a, $b));
    }' unless defined(&FREE);
    eval 'sub OKMAGIC {
        local($a) = @_;
	    eval q((($a) ==  &OMAGIC));
    }' unless defined(&OKMAGIC);
} else {
    eval 'sub LOADADDR {
        local($a) = @_;
	    eval q(((($a)) +  &offset));
    }' unless defined(&LOADADDR);
    eval 'sub ALIGNENTRY {
        local($a) = @_;
	    eval q((($a)));
    }' unless defined(&ALIGNENTRY);
    eval 'sub READ {
        local($f, $b, $c) = @_;
	    eval q( &read(,  &LOADADDR($b), ($c)));
    }' unless defined(&READ);
    eval 'sub BCOPY {
        local($s, $d, $c) = @_;
	    eval q( &memcpy( &LOADADDR, ($s), ($c)));
    }' unless defined(&BCOPY);
    eval 'sub BZERO {
        local($d, $c) = @_;
	    eval q( &memset( &LOADADDR($d), 0, ($c)));
    }' unless defined(&BZERO);
    eval 'sub WARN {
        local($a) = @_;
	    eval q( &warn $a);
    }' unless defined(&WARN);
    eval 'sub PROGRESS {
        local($a) = @_;
	    eval q();
    }' unless defined(&PROGRESS);
    eval 'sub ALLOC {
        local($a) = @_;
	    eval q( &malloc($a));
    }' unless defined(&ALLOC);
    eval 'sub FREE {
        local($a, $b) = @_;
	    eval q( &free($a));
    }' unless defined(&FREE);
    eval 'sub OKMAGIC {
        local($a) = @_;
	    eval q((($a) ==  &OMAGIC));
    }' unless defined(&OKMAGIC);
}
1;
