require '_h2ph_pre.ph';

unless(defined(&_CPU_H_)) {
    eval 'sub _CPU_H_ () {1;}' unless defined(&_CPU_H_);
    eval 'sub CPU_BOOTED_KERNEL () {1;}' unless defined(&CPU_BOOTED_KERNEL);
    eval 'sub CPU_MAXID () {2;}' unless defined(&CPU_MAXID);
    eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { "booted_kernel",  &CTLTYPE_STRING }, };}' unless defined(&CTL_MACHDEP_NAMES);
    if(defined(&_KERNEL)) {
	require 'machine/psl.ph';
	require 'machine/reg.ph';
	require 'machine/intr.ph';
	require 'sparc64/sparc64/intreg.ph';
	eval 'sub CP_USER () {0;}' unless defined(&CP_USER);
	eval 'sub CP_NICE () {1;}' unless defined(&CP_NICE);
	eval 'sub CP_SYS () {2;}' unless defined(&CP_SYS);
	eval 'sub CP_INTR () {3;}' unless defined(&CP_INTR);
	eval 'sub CP_IDLE () {4;}' unless defined(&CP_IDLE);
	eval 'sub CPUSTATES () {5;}' unless defined(&CPUSTATES);
	if(1) {
	    eval 'sub curcpu () {
	        eval q(( &cpu_info_store));
	    }' unless defined(&curcpu);
	} else {
	    eval 'sub curcpu () {
	        eval q(( &CPUINFO_VA));
	    }' unless defined(&curcpu);
	}
	eval 'sub cpu_swapin {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&cpu_swapin);
	eval 'sub cpu_swapout {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&cpu_swapout);
	eval 'sub cpu_wait {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&cpu_wait);
	if(1) {
	    eval 'sub cpu_number () {
	        eval q(0);
	    }' unless defined(&cpu_number);
	} else {
	    eval 'sub cpu_number () {
	        eval q(( &curcpu()-> &ci_number));
	    }' unless defined(&cpu_number);
	}
	eval 'sub CLKF_USERMODE {
	    local($framep) = @_;
    	    eval q(((($framep)-> ($t->{tf_tstate}) &  &TSTATE_PRIV) == 0));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_BASEPRI {
	    local($framep) = @_;
    	    eval q(((($framep)-> ($t->{tf_oldpil})) == 0));
	}' unless defined(&CLKF_BASEPRI);
	eval 'sub CLKF_PC {
	    local($framep) = @_;
    	    eval q((($framep)-> ($t->{tf_pc})));
	}' unless defined(&CLKF_PC);
	eval 'sub CLKF_INTR {
	    local($framep) = @_;
    	    eval q(((! &CLKF_USERMODE) && ((-> ($t->{tf_kstack}) <  &EINTSTACK) && (-> ($t->{tf_kstack}) >  &INTSTACK))));
	}' unless defined(&CLKF_INTR);
	if(defined(&DEPRECATED)) {
	    eval 'sub SIR_NET () {0;}' unless defined(&SIR_NET);
	    eval 'sub SIR_CLOCK () {1;}' unless defined(&SIR_CLOCK);
	}
	if(0) {
	    eval 'sub setsoftint () {
	        eval q( &send_softint(-1,  &IPL_SOFTINT,  &soft01intr));
	    }' unless defined(&setsoftint);
	    eval 'sub setsoftnet () {
	        eval q( &send_softint(-1,  &IPL_SOFTNET,  &soft01net));
	    }' unless defined(&setsoftnet);
	} else {
	}
	eval 'sub need_resched () {
	    eval q(( &want_resched = 1,  &want_ast = 1));
	}' unless defined(&need_resched);
	eval 'sub need_proftick {
	    local($p) = @_;
    	    eval q((($p)-> &p_flag |=  &P_OWEUPC,  &want_ast = 1));
	}' unless defined(&need_proftick);
	eval 'sub signotify {
	    local($p) = @_;
    	    eval q(( &want_ast = 1));
	}' unless defined(&signotify);
	if(0) {
	} else {
	    eval 'sub write_all_windows () {
	        eval q( &__asm  &__volatile(\\"flushw\\" : : ));
	    }' unless defined(&write_all_windows);
	    eval 'sub write_user_windows () {
	        eval q( &__asm  &__volatile(\\"flushw\\" : : ));
	    }' unless defined(&write_user_windows);
	}
	if(defined(&KGDB)) {
	}
	if(defined(&KGDB)) {
	}
    }
}
1;
