require '_h2ph_pre.ph';

unless(defined(&_MACHINE)) {
    sub _MACHINE () {	"mvme68k";}
}
unless(defined(&MACHINE)) {
    sub MACHINE () {	"mvme68k";}
}
unless(defined(&_MACHINE_ARCH)) {
    sub _MACHINE_ARCH () {	"m68k";}
}
unless(defined(&MACHINE_ARCH)) {
    sub MACHINE_ARCH () {	"m68k";}
}
unless(defined(&MID_MACHINE)) {
    sub MID_MACHINE () {	 &MID_M68K;}
}
unless(defined(&ALIGNBYTES)) {
    sub ALIGNBYTES () {	($sizeof{'int'} - 1);}
}
unless(defined(&ALIGN)) {
    sub ALIGN {
	local($p) = @_;
	eval q(((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES));
    }
}
unless(defined(&PGSHIFT)) {
    sub PGSHIFT () {	12;}
}
unless(defined(&NBPG)) {
    sub NBPG () {	(1<<  &PGSHIFT);}
}
unless(defined(&PGOFSET)) {
    sub PGOFSET () {	( &NBPG-1);}
}
unless(defined(&PAGE_SHIFT)) {
    sub PAGE_SHIFT () {	12;}
}
unless(defined(&PAGE_SIZE)) {
    sub PAGE_SIZE () {	(1<<  &PAGE_SHIFT);}
}
unless(defined(&PAGE_MASK)) {
    sub PAGE_MASK () {	( &PAGE_SIZE - 1);}
}
unless(defined(&NPTEPG)) {
    sub NPTEPG () {	( &NBPG/($sizeof{ &pt_entry_t}));}
}
unless(defined(&SEGSHIFT)) {
    sub SEGSHIFT () {	22;}
}
unless(defined(&NBSEG)) {
    sub NBSEG () {	(1<<  &SEGSHIFT);}
}
unless(defined(&SEGOFSET)) {
    sub SEGOFSET () {	( &NBSEG-1);}
}
unless(defined(&KERNBASE)) {
    sub KERNBASE () {	0x00000000;}
}
unless(defined(&KERNTEXTOFF)) {
    sub KERNTEXTOFF () {	0x00010000;}
}
unless(defined(&BTOPKERNBASE)) {
    sub BTOPKERNBASE () {	( &KERNBASE >>  &PGSHIFT);}
}
unless(defined(&DEV_BSHIFT)) {
    sub DEV_BSHIFT () {	9;}
}
unless(defined(&DEV_BSIZE)) {
    sub DEV_BSIZE () {	(1<<  &DEV_BSHIFT);}
}
unless(defined(&BLKDEV_IOSIZE)) {
    sub BLKDEV_IOSIZE () {	2048;}
}
unless(defined(&MAXPHYS)) {
    sub MAXPHYS () {	(64* 1024);}
}
unless(defined(&SSIZE)) {
    sub SSIZE () {	1;}
}
unless(defined(&SINCR)) {
    sub SINCR () {	1;}
}
unless(defined(&UPAGES)) {
    sub UPAGES () {	2;}
}
unless(defined(&USPACE)) {
    sub USPACE () {	( &UPAGES *  &NBPG);}
}
unless(defined(&MSIZE)) {
    sub MSIZE () {	256;}
}
unless(defined(&MCLSHIFT)) {
    sub MCLSHIFT () {	11;}
}
unless(defined(&MCLBYTES)) {
    sub MCLBYTES () {	(1<<  &MCLSHIFT);}
}
unless(defined(&MCLOFSET)) {
    sub MCLOFSET () {	( &MCLBYTES - 1);}
}
unless(defined(&NMBCLUSTERS)) {
    if(defined(&GATEWAY)) {
	eval 'sub NMBCLUSTERS () {2048;}' unless defined(&NMBCLUSTERS);
    } else {
	eval 'sub NMBCLUSTERS () {1024;}' unless defined(&NMBCLUSTERS);
    }
}
unless(defined(&MSGBUFSIZE)) {
    sub MSGBUFSIZE () {	4096;}
}
unless(defined(&NKMEMCLUSTERS)) {
    eval 'sub NKMEMCLUSTERS () {(2048* 1024/  &PAGE_SIZE);}' unless defined(&NKMEMCLUSTERS);
}
unless(defined(&ctod)) {
    sub ctod {
	local($x) = @_;
	eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&dtoc)) {
    sub dtoc {
	local($x) = @_;
	eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&ctob)) {
    sub ctob {
	local($x) = @_;
	eval q((($x) <<  &PGSHIFT));
    }
}
unless(defined(&btoc)) {
    sub btoc {
	local($x) = @_;
	eval q(((($x) +  &PGOFSET) >>  &PGSHIFT));
    }
}
unless(defined(&dbtob)) {
    sub dbtob {
	local($x) = @_;
	eval q((($x) <<  &DEV_BSHIFT));
    }
}
unless(defined(&btodb)) {
    sub btodb {
	local($x) = @_;
	eval q((($x) >>  &DEV_BSHIFT));
    }
}
unless(defined(&bdbtofsb)) {
    sub bdbtofsb {
	local($bn) = @_;
	eval q((($bn) / ( &BLKDEV_IOSIZE /  &DEV_BSIZE)));
    }
}
unless(defined(&m68k_round_page)) {
    sub m68k_round_page {
	local($x) = @_;
	eval q((((($x)) +  &PGOFSET) & ~ &PGOFSET));
    }
}
unless(defined(&m68k_trunc_page)) {
    sub m68k_trunc_page {
	local($x) = @_;
	eval q((($x) & ~ &PGOFSET));
    }
}
unless(defined(&m68k_btop)) {
    sub m68k_btop {
	local($x) = @_;
	eval q((($x) >>  &PGSHIFT));
    }
}
unless(defined(&m68k_ptob)) {
    sub m68k_ptob {
	local($x) = @_;
	eval q((($x) <<  &PGSHIFT));
    }
}
require 'machine/psl.ph';
require 'machine/intr.ph';
if(defined(&_KERNEL)) {
    eval 'sub DELAY {
        local($n) = @_;
	    eval q( &delay($n));
    }' unless defined(&DELAY);
}
if(defined(&COMPAT_HPUX)) {
    eval 'sub HPMMMASK () {0xf0000000;}' unless defined(&HPMMMASK);
    eval 'sub ISHPMMADDR {
        local($v) = @_;
	    eval q((( ($curproc->{p_md}->{md_flags}) &  &MDP_HPUXMMAP)  && ( &  &HPMMMASK)  && (($v) &  &HPMMMASK) !=  &HPMMMASK));
    }' unless defined(&ISHPMMADDR);
    eval 'sub HPMMBASEADDR {
        local($v) = @_;
	    eval q((($v) & ~ &HPMMMASK));
    }' unless defined(&HPMMBASEADDR);
}
1;
