require '_h2ph_pre.ph';

unless(defined(&_RF__RF_THREADSTUFF_H_)) {
    eval 'sub _RF__RF_THREADSTUFF_H_ () {1;}' unless defined(&_RF__RF_THREADSTUFF_H_);
    require 'rf_types.ph';
    require 'sys/types.ph';
    require 'sys/param.ph';
    if(defined(&_KERNEL)) {
	require 'sys/systm.ph';
	require 'sys/proc.ph';
	require 'sys/kthread.ph';
    }
    eval 'sub rf_create_managed_mutex {
        local($a,$b) = @_;
	    eval q( &_rf_create_managed_mutex($a,$b, &__FILE__, &__LINE__));
    }' unless defined(&rf_create_managed_mutex);
    eval 'sub rf_create_managed_cond {
        local($a,$b) = @_;
	    eval q( &_rf_create_managed_cond($a,$b, &__FILE__, &__LINE__));
    }' unless defined(&rf_create_managed_cond);
    eval 'sub rf_init_managed_threadgroup {
        local($a,$b) = @_;
	    eval q( &_rf_init_managed_threadgroup($a,$b, &__FILE__, &__LINE__));
    }' unless defined(&rf_init_managed_threadgroup);
    eval 'sub rf_init_threadgroup {
        local($a) = @_;
	    eval q( &_rf_init_threadgroup($a, &__FILE__, &__LINE__));
    }' unless defined(&rf_init_threadgroup);
    eval 'sub rf_destroy_threadgroup {
        local($a) = @_;
	    eval q( &_rf_destroy_threadgroup($a, &__FILE__, &__LINE__));
    }' unless defined(&rf_destroy_threadgroup);
    require 'sys/lock.ph';
    eval 'sub decl_simple_lock_data {
        local($a,$b) = @_;
	    eval q($a \'struct simplelock\' $b;);
    }' unless defined(&decl_simple_lock_data);
    eval 'sub simple_lock_addr {
        local($a) = @_;
	    eval q((($a)));
    }' unless defined(&simple_lock_addr);
    eval 'sub RF_DECLARE_MUTEX {
        local($_m_) = @_;
	    eval q( &decl_simple_lock_data(,($_m_)));
    }' unless defined(&RF_DECLARE_MUTEX);
    eval 'sub RF_DECLARE_STATIC_MUTEX {
        local($_m_) = @_;
	    eval q( &decl_simple_lock_data( &static,($_m_)));
    }' unless defined(&RF_DECLARE_STATIC_MUTEX);
    eval 'sub RF_DECLARE_EXTERN_MUTEX {
        local($_m_) = @_;
	    eval q( &decl_simple_lock_data( &extern,($_m_)));
    }' unless defined(&RF_DECLARE_EXTERN_MUTEX);
    eval 'sub RF_DECLARE_COND {
        local($_c_) = @_;
	    eval q(\'int\' $_c_;);
    }' unless defined(&RF_DECLARE_COND);
    eval 'sub RF_DECLARE_STATIC_COND {
        local($_c_) = @_;
	    eval q( &static \'int\' $_c_;);
    }' unless defined(&RF_DECLARE_STATIC_COND);
    eval 'sub RF_DECLARE_EXTERN_COND {
        local($_c_) = @_;
	    eval q( &extern \'int\' $_c_;);
    }' unless defined(&RF_DECLARE_EXTERN_COND);
    eval 'sub RF_LOCK_MUTEX {
        local($_m_) = @_;
	    eval q( &simple_lock(($_m_)));
    }' unless defined(&RF_LOCK_MUTEX);
    eval 'sub RF_UNLOCK_MUTEX {
        local($_m_) = @_;
	    eval q( &simple_unlock(($_m_)));
    }' unless defined(&RF_UNLOCK_MUTEX);
    eval 'sub RF_WAIT_COND {
        local($_c_,$_m_) = @_;
	    eval q({  &RF_UNLOCK_MUTEX($_m_);  &tsleep(&$_c_,  &PRIBIO, \\"rfwcond\\", 0);  &RF_LOCK_MUTEX($_m_); });
    }' unless defined(&RF_WAIT_COND);
    eval 'sub RF_SIGNAL_COND {
        local($_c_) = @_;
	    eval q( &wakeup(($_c_)));
    }' unless defined(&RF_SIGNAL_COND);
    eval 'sub RF_BROADCAST_COND {
        local($_c_) = @_;
	    eval q( &wakeup(($_c_)));
    }' unless defined(&RF_BROADCAST_COND);
    eval 'sub RF_CREATE_THREAD {
        local($_handle_, $_func_, $_arg_, $_name_) = @_;
	    eval q( &kthread_create(( &void (*)  &__P()), ($_arg_), ($_handle_), $_name_));
    }' unless defined(&RF_CREATE_THREAD);
    eval 'sub RF_THREADGROUP_STARTED {
        local($_g_) = @_;
	    eval q({  &RF_LOCK_MUTEX(($_g_)-> &mutex); ($_g_)-> &created++;  &RF_UNLOCK_MUTEX(($_g_)-> &mutex); });
    }' unless defined(&RF_THREADGROUP_STARTED);
    eval 'sub RF_THREADGROUP_RUNNING {
        local($_g_) = @_;
	    eval q({  &RF_LOCK_MUTEX(($_g_)-> &mutex); ($_g_)-> &running++;  &RF_UNLOCK_MUTEX(($_g_)-> &mutex);  &RF_SIGNAL_COND(($_g_)-> &cond); });
    }' unless defined(&RF_THREADGROUP_RUNNING);
    eval 'sub RF_THREADGROUP_DONE {
        local($_g_) = @_;
	    eval q({  &RF_LOCK_MUTEX(($_g_)-> &mutex); ($_g_)-> &shutdown++;  &RF_UNLOCK_MUTEX(($_g_)-> &mutex);  &RF_SIGNAL_COND(($_g_)-> &cond); });
    }' unless defined(&RF_THREADGROUP_DONE);
    eval 'sub RF_THREADGROUP_WAIT_START {
        local($_g_) = @_;
	    eval q({  &RF_LOCK_MUTEX(($_g_)-> &mutex);  &while(($_g_)-> &running < ($_g_)-> &created) {  &RF_WAIT_COND(($_g_)-> &cond, ($_g_)-> &mutex); }  &RF_UNLOCK_MUTEX(($_g_)-> &mutex); });
    }' unless defined(&RF_THREADGROUP_WAIT_START);
    if(!defined( &__NetBSD__)  && !defined( &__OpenBSD__)) {
	eval 'sub RF_THREADGROUP_WAIT_STOP {
	    local($_g_) = @_;
    	    eval q({  &RF_LOCK_MUTEX(($_g_)-> &mutex);  &RF_ASSERT(($_g_)-> &running == ($_g_)-> &created);  &while(($_g_)-> &shutdown < ($_g_)-> &running) {  &RF_WAIT_COND(($_g_)-> &cond, ($_g_)-> &mutex); }  &RF_UNLOCK_MUTEX(($_g_)-> &mutex); });
	}' unless defined(&RF_THREADGROUP_WAIT_STOP);
    } else {
	eval 'sub RF_THREADGROUP_WAIT_STOP {
	    local($_g_) = @_;
    	    eval q({  &RF_LOCK_MUTEX(($_g_)-> &mutex);  &while(($_g_)-> &shutdown < ($_g_)-> &running) {  &RF_WAIT_COND(($_g_)-> &cond, ($_g_)-> &mutex); }  &RF_UNLOCK_MUTEX(($_g_)-> &mutex); });
	}' unless defined(&RF_THREADGROUP_WAIT_STOP);
    }
}
1;
