require '_h2ph_pre.ph';

unless(defined(&PPB_REG_BASE0)) {
    sub PPB_REG_BASE0 () {	0x10;}
}
unless(defined(&PPB_REG_BASE1)) {
    sub PPB_REG_BASE1 () {	0x14;}
}
unless(defined(&PPB_REG_BUSINFO)) {
    sub PPB_REG_BUSINFO () {	0x18;}
}
unless(defined(&PPB_REG_IOSTATUS)) {
    sub PPB_REG_IOSTATUS () {	0x1c;}
}
unless(defined(&PPB_REG_MEM)) {
    sub PPB_REG_MEM () {	0x20;}
}
unless(defined(&PPB_REG_PREFMEM)) {
    sub PPB_REG_PREFMEM () {	0x24;}
}
unless(defined(&PPB_REG_PREFBASE_HI32)) {
    sub PPB_REG_PREFBASE_HI32 () {	0x28;}
}
unless(defined(&PPB_REG_PREFLIM_HI32)) {
    sub PPB_REG_PREFLIM_HI32 () {	0x2c;}
}
unless(defined(&PPB_REG_IO_HI)) {
    sub PPB_REG_IO_HI () {	0x30;}
}
unless(defined(&PPB_REG_BRIDGECONTROL)) {
    sub PPB_REG_BRIDGECONTROL () {	 &PCI_INTERRUPT_REG;}
}
unless(defined(&PPB_BUSINFO_PRIMARY)) {
    sub PPB_BUSINFO_PRIMARY {
	local($bir) = @_;
	eval q((($bir >> 0) & 0xff));
    }
}
unless(defined(&PPB_BUSINFO_SECONDARY)) {
    sub PPB_BUSINFO_SECONDARY {
	local($bir) = @_;
	eval q((($bir >> 8) & 0xff));
    }
}
unless(defined(&PPB_BUSINFO_SUBORDINATE)) {
    sub PPB_BUSINFO_SUBORDINATE {
	local($bir) = @_;
	eval q((($bir >> 16) & 0xff));
    }
}
unless(defined(&PPB_BUSINFO_SECLAT)) {
    sub PPB_BUSINFO_SECLAT {
	local($bir) = @_;
	eval q((($bir >> 24) & 0xff));
    }
}
unless(defined(&PPB_INTERRUPT_SWIZZLE)) {
    sub PPB_INTERRUPT_SWIZZLE {
	local($pin, $device) = @_;
	eval q((((($pin) + ($device) - 1) % 4) + 1));
    }
}
1;
