require '_h2ph_pre.ph';

unless(defined(&_ALTQ_ALTQ_VAR_H_)) {
    eval 'sub _ALTQ_ALTQ_VAR_H_ () {1;}' unless defined(&_ALTQ_ALTQ_VAR_H_);
    if(defined(&_KERNEL)) {
	require 'sys/param.ph';
	require 'sys/kernel.ph';
	require 'sys/queue.ph';
	eval 'sub ACC_FILTER_TABLESIZE () {(256+1);}' unless defined(&ACC_FILTER_TABLESIZE);
	eval 'sub ACC_FILTER_MASK () {( &ACC_FILTER_TABLESIZE - 2);}' unless defined(&ACC_FILTER_MASK);
	eval 'sub ACC_WILDCARD_INDEX () {( &ACC_FILTER_TABLESIZE - 1);}' unless defined(&ACC_WILDCARD_INDEX);
	if(defined(&__GNUC__)) {
	    eval 'sub ACC_GET_HASH_INDEX {
	        local($addr) = @_;
    		eval q(({\'int\'  &x = ($addr) + (($addr) >> 16); ( &x + ( &x >> 8)) &  &ACC_FILTER_MASK;}));
	    }' unless defined(&ACC_GET_HASH_INDEX);
	} else {
	    eval 'sub ACC_GET_HASH_INDEX {
	        local($addr) = @_;
    		eval q(((($addr) + (($addr) >> 8) + (($addr) >> 16) + (($addr) >> 24)) &  &ACC_FILTER_MASK));
	    }' unless defined(&ACC_GET_HASH_INDEX);
	}
	eval 'sub ACC_GET_HINDEX {
	    local($handle) = @_;
    	    eval q((($handle) >> 20));
	}' unless defined(&ACC_GET_HINDEX);
	eval 'sub FIMB4_PROTO () {0x0001;}' unless defined(&FIMB4_PROTO);
	eval 'sub FIMB4_TOS () {0x0002;}' unless defined(&FIMB4_TOS);
	eval 'sub FIMB4_DADDR () {0x0004;}' unless defined(&FIMB4_DADDR);
	eval 'sub FIMB4_SADDR () {0x0008;}' unless defined(&FIMB4_SADDR);
	eval 'sub FIMB4_DPORT () {0x0010;}' unless defined(&FIMB4_DPORT);
	eval 'sub FIMB4_SPORT () {0x0020;}' unless defined(&FIMB4_SPORT);
	eval 'sub FIMB4_GPI () {0x0040;}' unless defined(&FIMB4_GPI);
	eval 'sub FIMB4_ALL () {0x007f;}' unless defined(&FIMB4_ALL);
	eval 'sub FIMB6_PROTO () {0x0100;}' unless defined(&FIMB6_PROTO);
	eval 'sub FIMB6_TCLASS () {0x0200;}' unless defined(&FIMB6_TCLASS);
	eval 'sub FIMB6_DADDR () {0x0400;}' unless defined(&FIMB6_DADDR);
	eval 'sub FIMB6_SADDR () {0x0800;}' unless defined(&FIMB6_SADDR);
	eval 'sub FIMB6_DPORT () {0x1000;}' unless defined(&FIMB6_DPORT);
	eval 'sub FIMB6_SPORT () {0x2000;}' unless defined(&FIMB6_SPORT);
	eval 'sub FIMB6_GPI () {0x4000;}' unless defined(&FIMB6_GPI);
	eval 'sub FIMB6_FLABEL () {0x8000;}' unless defined(&FIMB6_FLABEL);
	eval 'sub FIMB6_ALL () {0xff00;}' unless defined(&FIMB6_ALL);
	eval 'sub FIMB_ALL () {( &FIMB4_ALL| &FIMB6_ALL);}' unless defined(&FIMB_ALL);
	eval 'sub FIMB4_PORTS () {( &FIMB4_DPORT| &FIMB4_SPORT| &FIMB4_GPI);}' unless defined(&FIMB4_PORTS);
	eval 'sub FIMB6_PORTS () {( &FIMB6_DPORT| &FIMB6_SPORT| &FIMB6_GPI);}' unless defined(&FIMB6_PORTS);
	if(defined( &__i386__)  && !defined( &ALTQ_NOPCC)) {
	    require 'machine/cpufunc.ph';
	    eval 'sub read_machclk () {
	        eval q( &rdtsc());
	    }' unless defined(&read_machclk);
	    if(defined(&__OpenBSD__)) {
	    }
	}
 elsif(defined( &__alpha__)  && !defined( &ALTQ_NOPCC)) {
	} else {
	    eval 'sub MACHCLK_SHIFT () {8;}' unless defined(&MACHCLK_SHIFT);
	}
	if(defined(&ALTQ_DEBUG)) {
	    if(defined(&__STDC__)) {
		eval 'sub ASSERT {
		    local($e) = @_;
    		    eval q(( ? 0:  &altq_assert( &__FILE__,  &__LINE__, $e)));
		}' unless defined(&ASSERT);
	    } else {
		eval 'sub ASSERT {
		    local($e) = @_;
    		    eval q(( ? 0:  &altq_assert( &__FILE__,  &__LINE__, \\"e\\")));
		}' unless defined(&ASSERT);
	    }
	} else {
	    eval 'sub ASSERT {
	        local($e) = @_;
    		eval q((0));
	    }' unless defined(&ASSERT);
	}
	if(defined( &__FreeBSD__)  && ((defined(&__FreeBSD__) ? &__FreeBSD__ : 0) < 3)) {
	} else {
	}
	undef(&TAILQ_LAST) if defined(&TAILQ_LAST);
	eval 'sub TAILQ_LAST {
	    local($head, $headname) = @_;
    	    eval q((*(((($head)-> &tqh_last))-> &tqh_last)));
	}' unless defined(&TAILQ_LAST);
	unless(defined(&TAILQ_EMPTY)) {
	    eval 'sub TAILQ_EMPTY {
	        local($head) = @_;
    		eval q((($head)-> &tqh_first ==  &NULL));
	    }' unless defined(&TAILQ_EMPTY);
	}
	unless(defined(&TAILQ_FOREACH)) {
	    eval 'sub TAILQ_FOREACH {
	        local($var, $head, $field) = @_;
    		eval q( &for ($var =  &TAILQ_FIRST($head); $var; $var =  &TAILQ_NEXT($var, $field)));
	    }' unless defined(&TAILQ_FOREACH);
	}
	if(((defined(&__FreeBSD_version) ? &__FreeBSD_version : 0) > 300000) || defined( &__NetBSD__)) {
	    require 'sys/callout.ph';
	    eval 'sub CALLOUT_INIT {
	        local($c) = @_;
    		eval q( &callout_init(($c)));
	    }' unless defined(&CALLOUT_INIT);
	    eval 'sub CALLOUT_RESET {
	        local($c,$t,$f,$a) = @_;
    		eval q( &callout_reset(($c),($t),($f),($a)));
	    }' unless defined(&CALLOUT_RESET);
	    eval 'sub CALLOUT_STOP {
	        local($c) = @_;
    		eval q( &callout_stop(($c)));
	    }' unless defined(&CALLOUT_STOP);
	    unless(defined(&CALLOUT_INITIALIZER)) {
		eval 'sub CALLOUT_INITIALIZER () {{ { {  &NULL } }, 0,  &NULL,  &NULL, 0};}' unless defined(&CALLOUT_INITIALIZER);
	    }
	}
 elsif(defined( &__OpenBSD__)) {
	    require 'sys/timeout.ph';
	    eval 'sub CALLOUT_INIT {
	        local($c) = @_;
    		eval q( &do {  &bzero(($c), $sizeof{($c)}); }  &while (0));
	    }' unless defined(&CALLOUT_INIT);
	    eval 'sub CALLOUT_RESET {
	        local($c,$t,$f,$a) = @_;
    		eval q( &do {  &if (! &timeout_initialized(($c)-> &c_to))  &timeout_set(($c)-> &c_to, ($f), ($a));  &timeout_add(($c)-> &c_to, ($t)); }  &while (0));
	    }' unless defined(&CALLOUT_RESET);
	    eval 'sub CALLOUT_STOP {
	        local($c) = @_;
    		eval q( &timeout_del(($c)-> &c_to));
	    }' unless defined(&CALLOUT_STOP);
	    eval 'sub CALLOUT_INITIALIZER () {{ { {  &NULL },  &NULL,  &NULL, 0, 0} };}' unless defined(&CALLOUT_INITIALIZER);
	} else {
	    eval 'sub CALLOUT_INIT {
	        local($c) = @_;
    		eval q( &do {  &bzero(($c), $sizeof{($c)}); }  &while (0));
	    }' unless defined(&CALLOUT_INIT);
	    eval 'sub CALLOUT_RESET {
	        local($c,$t,$f,$a) = @_;
    		eval q( &do { ($c)-> &c_arg = ($a); ($c)-> &c_func = ($f);  &timeout(($f),($a),($t)); }  &while (0));
	    }' unless defined(&CALLOUT_RESET);
	    eval 'sub CALLOUT_STOP {
	        local($c) = @_;
    		eval q( &untimeout(($c)-> &c_func,($c)-> &c_arg));
	    }' unless defined(&CALLOUT_STOP);
	    eval 'sub CALLOUT_INITIALIZER () {{  &NULL,  &NULL };}' unless defined(&CALLOUT_INITIALIZER);
	}
	if(!defined( &__FreeBSD__)) {
	}
	eval 'sub m_pktlen {
	    local($m) = @_;
    	    eval q((($m)-> ($m_pkthdr->{len})));
	}' unless defined(&m_pktlen);
    }
}
1;
