require '_h2ph_pre.ph';

unless(defined(&_I386_DB_MACHDEP_H_)) {
    eval 'sub _I386_DB_MACHDEP_H_ () {1;}' unless defined(&_I386_DB_MACHDEP_H_);
    require 'sys/param.ph';
    require 'vm/vm.ph';
    require 'machine/trap.ph';
    eval 'sub DDB_REGS () {( &ddb_regs);}' unless defined(&DDB_REGS);
    eval 'sub PC_REGS {
        local($regs) = @_;
	    eval q((($regs)-> &tf_eip));
    }' unless defined(&PC_REGS);
    eval 'sub BKPT_INST () {0xcc;}' unless defined(&BKPT_INST);
    eval 'sub BKPT_SIZE () {(1);}' unless defined(&BKPT_SIZE);
    eval 'sub BKPT_SET {
        local($inst) = @_;
	    eval q(( &BKPT_INST));
    }' unless defined(&BKPT_SET);
    eval 'sub FIXUP_PC_AFTER_BREAK {
        local($regs) = @_;
	    eval q((($regs)-> &tf_eip -=  &BKPT_SIZE));
    }' unless defined(&FIXUP_PC_AFTER_BREAK);
    eval 'sub db_clear_single_step {
        local($regs) = @_;
	    eval q((($regs)-> &tf_eflags &= ~ &PSL_T));
    }' unless defined(&db_clear_single_step);
    eval 'sub db_set_single_step {
        local($regs) = @_;
	    eval q((($regs)-> &tf_eflags |=  &PSL_T));
    }' unless defined(&db_set_single_step);
    eval 'sub IS_BREAKPOINT_TRAP {
        local($type, $code) = @_;
	    eval q((($type) ==  &T_BPTFLT));
    }' unless defined(&IS_BREAKPOINT_TRAP);
    eval 'sub IS_WATCHPOINT_TRAP {
        local($type, $code) = @_;
	    eval q((($type) ==  &T_TRCTRAP  && ($code) & 15));
    }' unless defined(&IS_WATCHPOINT_TRAP);
    eval 'sub I_CALL () {0xe8;}' unless defined(&I_CALL);
    eval 'sub I_CALLI () {0xff;}' unless defined(&I_CALLI);
    eval 'sub I_RET () {0xc3;}' unless defined(&I_RET);
    eval 'sub I_IRET () {0xcf;}' unless defined(&I_IRET);
    eval 'sub inst_trap_return {
        local($ins) = @_;
	    eval q(((($ins)&0xff) ==  &I_IRET));
    }' unless defined(&inst_trap_return);
    eval 'sub inst_return {
        local($ins) = @_;
	    eval q(((($ins)&0xff) ==  &I_RET));
    }' unless defined(&inst_return);
    eval 'sub inst_call {
        local($ins) = @_;
	    eval q(((($ins)&0xff) ==  &I_CALL || ((($ins)&0xff) ==  &I_CALLI  && (($ins)&0x3800) == 0x1000)));
    }' unless defined(&inst_call);
    eval 'sub inst_load {
        local($ins) = @_;
	    eval q(0);
    }' unless defined(&inst_load);
    eval 'sub inst_store {
        local($ins) = @_;
	    eval q(0);
    }' unless defined(&inst_store);
    eval 'sub DB_ACCESS_LEVEL () {2;}' unless defined(&DB_ACCESS_LEVEL);
    eval 'sub DB_CHECK_ACCESS {
        local($addr,$size,$task) = @_;
	    eval q( &db_check_access($addr,$size,$task));
    }' unless defined(&DB_CHECK_ACCESS);
    eval 'sub DB_PHYS_EQ {
        local($task1,$addr1,$task2,$addr2) = @_;
	    eval q( &db_phys_eq($task1,$addr1,$task2,$addr2));
    }' unless defined(&DB_PHYS_EQ);
    eval 'sub DB_VALID_KERN_ADDR {
        local($addr) = @_;
	    eval q((($addr) >=  &VM_MIN_KERNEL_ADDRESS  && ($addr) <  &VM_MAX_KERNEL_ADDRESS));
    }' unless defined(&DB_VALID_KERN_ADDR);
    eval 'sub DB_VALID_ADDRESS {
        local($addr,$user) = @_;
	    eval q(((!($user)  &&  &DB_VALID_KERN_ADDR($addr)) || (($user)  && ($addr) <  &VM_MAX_ADDRESS)));
    }' unless defined(&DB_VALID_ADDRESS);
    if(0) {
    }
    eval 'sub DB_TASK_NAME {
        local($task) = @_;
	    eval q( &db_task_name($task));
    }' unless defined(&DB_TASK_NAME);
    eval 'sub DB_TASK_NAME_TITLE () {"COMMAND		";}' unless defined(&DB_TASK_NAME_TITLE);
    eval 'sub DB_TASK_NAME_LEN () {23;}' unless defined(&DB_TASK_NAME_LEN);
    eval 'sub DB_NULL_TASK_NAME () {"?		      ";}' unless defined(&DB_NULL_TASK_NAME);
    eval 'sub KGDB_NUMREGS () {14;}' unless defined(&KGDB_NUMREGS);
    eval 'sub KGDB_BUFLEN () {512;}' unless defined(&KGDB_BUFLEN);
    if(0) {
    }
    eval 'sub db_thread_fp_used {
        local($thread) = @_;
	    eval q((($thread)-> ($pcb->{ims}->{ifps}) != 0));
    }' unless defined(&db_thread_fp_used);
}
1;
