require '_h2ph_pre.ph';

unless(defined(&_I386_BUS_H_)) {
    eval 'sub _I386_BUS_H_ () {1;}' unless defined(&_I386_BUS_H_);
    require 'machine/pio.ph';
    eval 'sub I386_BUS_SPACE_IO () {0;}' unless defined(&I386_BUS_SPACE_IO);
    eval 'sub I386_BUS_SPACE_MEM () {1;}' unless defined(&I386_BUS_SPACE_MEM);
    eval 'sub bus_space_read_1 {
        local($t, $h, $o) = @_;
	    eval q(( ==  &I386_BUS_SPACE_IO ? ( &inb( + )) : (*(($h) + ($o)))));
    }' unless defined(&bus_space_read_1);
    eval 'sub bus_space_read_2 {
        local($t, $h, $o) = @_;
	    eval q(( ==  &I386_BUS_SPACE_IO ? ( &inw( + )) : (*(($h) + ($o)))));
    }' unless defined(&bus_space_read_2);
    eval 'sub bus_space_read_4 {
        local($t, $h, $o) = @_;
	    eval q(( ==  &I386_BUS_SPACE_IO ? ( &inl( + )) : (*(($h) + ($o)))));
    }' unless defined(&bus_space_read_4);
    if(0) {
	eval 'sub bus_space_read_8 {
	    local($t, $h, $o) = @_;
    	    eval q(!!!  &bus_space_read_8  &unimplemented !!!);
	}' unless defined(&bus_space_read_8);
    }
    eval 'sub bus_space_read_multi_1 {
        local($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &I386_BUS_SPACE_IO) {  &insb(($h) + ($o), ($a), ($cnt)); }  &else { &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &__asm  &__volatile(\\"								cld					;			1:	movb (%2),%%al				;				stosb					;				loop 1b\\" : \\"+D\\" ( &_addr), \\"+c\\" ( &_cnt) : \\"r\\" (($h) + ($o)) : \\"%eax\\", \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_read_multi_1);
    eval 'sub bus_space_read_multi_2 {
        local($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &I386_BUS_SPACE_IO) {  &insw(($h) + ($o), ($a), ($cnt)); }  &else { &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &__asm  &__volatile(\\"								cld					;			1:	movw (%2),%%ax				;				stosw					;				loop 1b\\" : \\"+D\\" ( &_addr), \\"+c\\" ( &_cnt) : \\"r\\" (($h) + ($o)) : \\"%eax\\", \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_read_multi_2);
    eval 'sub bus_space_read_multi_4 {
        local($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &I386_BUS_SPACE_IO) {  &insl(($h) + ($o), ($a), ($cnt)); }  &else { &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &__asm  &__volatile(\\"								cld					;			1:	movl (%2),%%eax				;				stosl					;				loop 1b\\" : \\"+D\\" ( &_addr), \\"+c\\" ( &_cnt) : \\"r\\" (($h) + ($o)) : \\"%eax\\", \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_read_multi_4);
    if(0) {
	eval 'sub bus_space_read_multi_8 () {!!!  &bus_space_read_multi_8  &unimplemented !!!;}' unless defined(&bus_space_read_multi_8);
    }
    eval 'sub bus_space_read_raw_multi_2 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_multi_2(, , , ($a), ($c) >> 1));
    }' unless defined(&bus_space_read_raw_multi_2);
    eval 'sub bus_space_read_raw_multi_4 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_multi_4(, , , ($a), ($c) >> 2));
    }' unless defined(&bus_space_read_raw_multi_4);
    if(0) {
	eval 'sub bus_space_read_raw_multi_8 () {!!!  &bus_space_read_raw_multi_8  &unimplemented !!!;}' unless defined(&bus_space_read_raw_multi_8);
    }
    eval 'sub bus_space_read_region_1 {
        local($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do { \'int\'  &_cnt = ($cnt);  &void * &_addr = ($a); \'int\'  &_port = ($h)+($o);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	inb %w2,%%al				;				stosb					;				incl %2					;				loop 1b\\" : \\"+D\\" ( &_addr), \\"+c\\" ( &_cnt), \\"+d\\" ( &_port) :: \\"%eax\\", \\"memory\\", \\"cc\\"); }  &else  &i386_space_copy( &_port,  &_addr, 1,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_read_region_1);
    eval 'sub bus_space_read_region_2 {
        local($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do { \'int\'  &_cnt = ($cnt);  &void * &_addr = ($a); \'int\'  &_port = ($h)+($o);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	inw %w2,%%ax				;				stosw					;				addl $2,%2				;				loop 1b\\" : \\"+D\\" ( &_addr), \\"+c\\" ( &_cnt), \\"+d\\" ( &_port) :: \\"%eax\\", \\"memory\\", \\"cc\\"); }  &else  &i386_space_copy( &_port,  &_addr, 2,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_read_region_2);
    eval 'sub bus_space_read_region_4 {
        local($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do { \'int\'  &_cnt = ($cnt);  &void * &_addr = ($a); \'int\'  &_port = ($h)+($o);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	inl %w2,%%eax				;				stosl					;				addl $4,%2				;				loop 1b\\" : \\"+D\\" ( &_addr), \\"+c\\" ( &_cnt), \\"+d\\" ( &_port) :: \\"%eax\\", \\"memory\\", \\"cc\\"); }  &else  &i386_space_copy( &_port,  &_addr, 4,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_read_region_4);
    if(0) {
	eval 'sub bus_space_read_region_8 () {!!!  &bus_space_read_region_8  &unimplemented !!!;}' unless defined(&bus_space_read_region_8);
    }
    eval 'sub bus_space_read_raw_region_2 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_region_2(, , , ($a), ($c) >> 1));
    }' unless defined(&bus_space_read_raw_region_2);
    eval 'sub bus_space_read_raw_region_4 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_region_4(, , , ($a), ($c) >> 2));
    }' unless defined(&bus_space_read_raw_region_4);
    if(0) {
	eval 'sub bus_space_read_raw_region_8 () {!!!  &bus_space_read_raw_region_8  &unimplemented !!!;}' unless defined(&bus_space_read_raw_region_8);
    }
    eval 'sub bus_space_write_1 {
        local($t, $h, $o, $v) = @_;
	    eval q( &do {  &if ( ==  &I386_BUS_SPACE_IO)  &outb( + , );  &else ((*(($h) + ($o)) = ($v))); }  &while (0));
    }' unless defined(&bus_space_write_1);
    eval 'sub bus_space_write_2 {
        local($t, $h, $o, $v) = @_;
	    eval q( &do {  &if ( ==  &I386_BUS_SPACE_IO)  &outw( + , );  &else ((*(($h) + ($o)) = ($v))); }  &while (0));
    }' unless defined(&bus_space_write_2);
    eval 'sub bus_space_write_4 {
        local($t, $h, $o, $v) = @_;
	    eval q( &do {  &if ( ==  &I386_BUS_SPACE_IO)  &outl( + , );  &else ((*(($h) + ($o)) = ($v))); }  &while (0));
    }' unless defined(&bus_space_write_4);
    if(0) {
	eval 'sub bus_space_write_8 () {!!!  &bus_space_write_8  &not  &implemented !!!;}' unless defined(&bus_space_write_8);
    }
    eval 'sub bus_space_write_multi_1 {
        local($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &I386_BUS_SPACE_IO) {  &outsb(($h) + ($o), ($a), ($cnt)); }  &else { &const  &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &__asm  &__volatile(\\"								cld					;			1:	lodsb					;				movb %%al,(%2)				;				loop 1b\\" : \\"+S\\" ( &_addr), \\"+c\\" ( &_cnt) : \\"r\\" (($h) + ($o)) : \\"%eax\\", \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_write_multi_1);
    eval 'sub bus_space_write_multi_2 {
        local($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &I386_BUS_SPACE_IO) {  &outsw(($h) + ($o), ($a), ($cnt)); }  &else { &const  &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &__asm  &__volatile(\\"								cld					;			1:	lodsw					;				movw %%ax,(%2)				;				loop 1b\\" : \\"+S\\" ( &_addr), \\"+c\\" ( &_cnt) : \\"r\\" (($h) + ($o)) : \\"%eax\\", \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_write_multi_2);
    eval 'sub bus_space_write_multi_4 {
        local($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &I386_BUS_SPACE_IO) {  &outsl(($h) + ($o), ($a), ($cnt)); }  &else { &const  &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &__asm  &__volatile(\\"								cld					;			1:	lodsl					;				movl %%eax,(%2)				;				loop 1b\\" : \\"+S\\" ( &_addr), \\"+c\\" ( &_cnt) : \\"r\\" (($h) + ($o)) : \\"%eax\\", \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_write_multi_4);
    if(0) {
	eval 'sub bus_space_write_multi_8 {
	    local($t, $h, $o, $a, $c) = @_;
    	    eval q(!!!  &bus_space_write_multi_8  &unimplemented !!!);
	}' unless defined(&bus_space_write_multi_8);
    }
    eval 'sub bus_space_write_raw_multi_2 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_multi_2(, , , ($a), ($c) >> 1));
    }' unless defined(&bus_space_write_raw_multi_2);
    eval 'sub bus_space_write_raw_multi_4 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_multi_4(, , , ($a), ($c) >> 2));
    }' unless defined(&bus_space_write_raw_multi_4);
    if(0) {
	eval 'sub bus_space_write_raw_multi_8 () {!!!  &bus_space_write_raw_multi_8  &unimplemented !!!;}' unless defined(&bus_space_write_raw_multi_8);
    }
    eval 'sub bus_space_write_region_1 {
        local($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do { \'int\'  &_port = ($h)+($o);  &const  &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	lodsb					;				outb %%al,%w0				;				incl %0					;				loop 1b\\" : \\"+d\\" ( &_port), \\"+S\\" ( &_addr), \\"+c\\" ( &_cnt) :: \\"%eax\\", \\"memory\\", \\"cc\\"); }  &else  &i386_space_copy( &_addr,  &_port, 1,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_write_region_1);
    eval 'sub bus_space_write_region_2 {
        local($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do { \'int\'  &_port = ($h)+($o);  &const  &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	lodsw					;				outw %%ax,%w0				;				addl $2,%0				;				loop 1b\\" : \\"+d\\" ( &_port), \\"+S\\" ( &_addr), \\"+c\\" ( &_cnt) :: \\"%eax\\", \\"memory\\", \\"cc\\"); }  &else  &i386_space_copy( &_addr,  &_port, 2,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_write_region_2);
    eval 'sub bus_space_write_region_4 {
        local($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do { \'int\'  &_port = ($h)+($o);  &const  &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	lodsl					;				outl %%eax,%w0				;				addl $4,%0				;				loop 1b\\" : \\"+d\\" ( &_port), \\"+S\\" ( &_addr), \\"+c\\" ( &_cnt) :: \\"%eax\\", \\"memory\\", \\"cc\\"); }  &else  &i386_space_copy( &_addr,  &_port, 4,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_write_region_4);
    if(0) {
	eval 'sub bus_space_write_region_8 () {!!!  &bus_space_write_region_8  &unimplemented !!!;}' unless defined(&bus_space_write_region_8);
    }
    eval 'sub bus_space_write_raw_region_2 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_region_2(, , , ($a), ($c) >> 1));
    }' unless defined(&bus_space_write_raw_region_2);
    eval 'sub bus_space_write_raw_region_4 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_region_4(, , , ($a), ($c) >> 2));
    }' unless defined(&bus_space_write_raw_region_4);
    if(0) {
	eval 'sub bus_space_write_raw_region_8 () {!!!  &bus_space_write_raw_region_8  &unimplemented !!!;}' unless defined(&bus_space_write_raw_region_8);
    }
    eval 'sub bus_space_set_multi_1 {
        local($t, $h, $o, $v, $cnt) = @_;
	    eval q( &do { \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	outb %b2, %w1				;				loop 1b\\" : \\"+c\\" ( &_cnt) : \\"d\\" (($h) + ($o)), \\"a\\" (($v)) : \\"cc\\"); }  &else {  &__asm  &__volatile(\\"								cld					;			1:	movb %b2, (%1)				;				loop 1b\\" : \\"+c\\" ( &_cnt) : \\"D\\" (($h) + ($o)), \\"a\\" (($v)) : \\"cc\\", \\"memory\\"); } }  &while (0));
    }' unless defined(&bus_space_set_multi_1);
    eval 'sub bus_space_set_multi_2 {
        local($t, $h, $o, $v, $cnt) = @_;
	    eval q( &do { \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	outw %w2, %w1				;				loop 1b\\" : \\"+c\\" ( &_cnt) : \\"d\\" (($h) + ($o)), \\"a\\" (($v)) : \\"cc\\"); }  &else {  &__asm  &__volatile(\\"								cld					;			1:	movw %w2, (%1)				;				loop 1b\\" : \\"+c\\" ( &_cnt) : \\"D\\" (($h) + ($o)), \\"a\\" (($v)) : \\"cc\\", \\"memory\\"); } }  &while (0));
    }' unless defined(&bus_space_set_multi_2);
    eval 'sub bus_space_set_multi_4 {
        local($t, $h, $o, $v, $cnt) = @_;
	    eval q( &do { \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	outl %2,%w1				;				loop 1b\\" : \\"+c\\" ( &_cnt) : \\"d\\" (($h) + ($o)), \\"a\\" (($v)) : \\"cc\\"); }  &else {  &__asm  &__volatile(\\"								cld					;			1:	movl %2,(%1)				;				loop 1b\\" : \\"+c\\" ( &_cnt) : \\"D\\" (($h) + ($o)), \\"a\\" (($v)) : \\"cc\\", \\"memory\\"); } }  &while (0));
    }' unless defined(&bus_space_set_multi_4);
    if(0) {
	eval 'sub bus_space_set_multi_8 () {!!!  &bus_space_set_multi_8  &unimplemented !!!;}' unless defined(&bus_space_set_multi_8);
    }
    eval 'sub bus_space_set_region_1 {
        local($t, $h, $o, $v, $cnt) = @_;
	    eval q( &do { \'int\'  &_port = ($h)+($o); \'int\'  &_cnt = ($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"							1:	outb %%al,%w0				;				incl %0					;				loop 1b\\" : \\"+d\\" ( &_port), \\"+c\\" ( &_cnt) : \\"a\\" (($v)) : \\"cc\\"); }  &else {  &__asm  &__volatile(\\"								cld					;				repne					;				stosb\\" : \\"+D\\" ( &_port), \\"+c\\" ( &_cnt) : \\"a\\" (($v)) : \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_set_region_1);
    eval 'sub bus_space_set_region_2 {
        local($t, $h, $o, $v, $cnt) = @_;
	    eval q( &do { \'int\'  &_port = ($h)+($o); \'int\'  &_cnt = ($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"							1:	outw %%ax,%w0				;				addl $2, %0				;				loop 1b\\" : \\"+d\\" ( &_port), \\"+c\\" ( &_cnt) : \\"a\\" (($v)) : \\"cc\\"); }  &else {  &__asm  &__volatile(\\"								cld					;				repne					;				stosw\\" : \\"+D\\" ( &_port), \\"+c\\" ( &_cnt) : \\"a\\" (($v)) : \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_set_region_2);
    eval 'sub bus_space_set_region_4 {
        local($t, $h, $o, $v, $cnt) = @_;
	    eval q( &do { \'int\'  &_port = ($h)+($o); \'int\'  &_cnt = ($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"							1:	outl %%eax,%w0				;				addl $4, %0				;				loop 1b\\" : \\"+d\\" ( &_port), \\"+c\\" ( &_cnt) : \\"a\\" (($v)) : \\"cc\\"); }  &else {  &__asm  &__volatile(\\"								cld					;				repne					;				stosl\\" : \\"+D\\" ( &_port), \\"+c\\" ( &_cnt) : \\"a\\" (($v)) : \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_set_region_4);
    if(0) {
	eval 'sub bus_space_set_region_8 () {!!!  &bus_space_set_region_8  &unimplemented !!!;}' unless defined(&bus_space_set_region_8);
    }
    eval 'sub bus_space_copy_1 {
        local($t, $h1, $o1, $h2, $o2, $cnt) = @_;
	    eval q( &do { \'int\'  &_port1 = ($h1)+($o1); \'int\'  &_port2 = ($h2)+($o2); \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"							1:	movl %w1,%%dx				;				inb  %%dx,%%al				;				movl %w0,%%dx				;				outb %%al,%%dx				;				incl %0					;				incl %1					;				loop 1b\\" : \\"+D\\" ( &_port2), \\"+S\\" ( &_port1), \\"+c\\" (( &_cnt)) :: \\"%edx\\", \\"%eax\\", \\"cc\\"); }  &else  &i386_space_copy( &_port1,  &_port2, 1,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_copy_1);
    eval 'sub bus_space_copy_2 {
        local($t, $h1, $o1, $h2, $o2, $cnt) = @_;
	    eval q( &do { \'int\'  &_port1 = ($h1)+($o1); \'int\'  &_port2 = ($h2)+($o2); \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"							1:	movl %w1,%%dx				;				inw  %%dx,%%ax				;				movl %w0,%%dx				;				outw %%ax,%%dx				;				addl $2, %0				;				addl $2, %1				;				loop 1b\\" : \\"+D\\" ( &_port2), \\"+S\\" ( &_port1), \\"+c\\" (( &_cnt)) :: \\"%edx\\", \\"%eax\\", \\"cc\\"); }  &else  &i386_space_copy( &_port1,  &_port2, 2,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_copy_2);
    eval 'sub bus_space_copy_4 {
        local($t, $h1, $o1, $h2, $o2, $cnt) = @_;
	    eval q( &do { \'int\'  &_port1 = ($h1)+($o1); \'int\'  &_port2 = ($h2)+($o2); \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"							1:	movl %w1,%%dx				;				inl  %%dx,%%eax				;				movl %w0,%%dx				;				outl %%eax,%%dx				;				addl $4, %0				;				addl $4, %1				;				loop 1b\\" : \\"+D\\" ( &_port2), \\"+S\\" ( &_port1), \\"+c\\" (( &_cnt)) :: \\"%edx\\", \\"%eax\\", \\"cc\\"); }  &else  &i386_space_copy( &_port1,  &_port2, 4,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_copy_4);
    if(0) {
	eval 'sub bus_space_copy_8 () {!!!  &bus_space_copy_8  &unimplemented !!!;}' unless defined(&bus_space_copy_8);
    }
    eval 'sub i386_space_copy1 {
        local($a1, $a2, $cnt, $movs, $df) = @_;
	    eval q( &__asm  &__volatile($df \\"\\\\n\\\\trep\\\\n\\\\t\\" $movs : \\"+S\\" ($a1), \\"+D\\" ($a2), \\"+c\\" ($cnt) :: \\"memory\\", \\"cc\\"););
    }' unless defined(&i386_space_copy1);
    eval 'sub i386_space_copy {
        local($a1, $a2, $sz, $cnt) = @_;
	    eval q( &do {  &if ( < ($a2)) { $a1 += (($cnt) - 1) * ($sz); $a2 += (($cnt) - 1) * ($sz);  &switch ($sz) {  &case 1:  &i386_space_copy1($a1,$a2,$cnt,\\"movsb\\",\\"std\\"); &break;  &case 2:  &i386_space_copy1($a1,$a2,$cnt,\\"movsw\\",\\"std\\"); &break;  &case 4:  &i386_space_copy1($a1,$a2,$cnt,\\"movsl\\",\\"std\\"); &break; } }  &else  &switch ($sz) {  &case 1:  &i386_space_copy1($a1,$a2,$cnt,\\"movsb\\",\\"cld\\"); &break;  &case 2:  &i386_space_copy1($a1,$a2,$cnt,\\"movsw\\",\\"cld\\"); &break;  &case 4:  &i386_space_copy1($a1,$a2,$cnt,\\"movsl\\",\\"cld\\"); &break; } }  &while (0));
    }' unless defined(&i386_space_copy);
    eval 'sub bus_space_barrier {
        local($t, $h, $o, $l, $f) = @_;
	    eval q(((, , , , ($f))));
    }' unless defined(&bus_space_barrier);
    eval 'sub BUS_SPACE_BARRIER_READ () {0x01;}' unless defined(&BUS_SPACE_BARRIER_READ);
    eval 'sub BUS_SPACE_BARRIER_WRITE () {0x02;}' unless defined(&BUS_SPACE_BARRIER_WRITE);
    eval 'sub BUS_BARRIER_READ () { &BUS_SPACE_BARRIER_READ;}' unless defined(&BUS_BARRIER_READ);
    eval 'sub BUS_BARRIER_WRITE () { &BUS_SPACE_BARRIER_WRITE;}' unless defined(&BUS_BARRIER_WRITE);
    eval 'sub BUS_DMA_WAITOK () {0x00;}' unless defined(&BUS_DMA_WAITOK);
    eval 'sub BUS_DMA_NOWAIT () {0x01;}' unless defined(&BUS_DMA_NOWAIT);
    eval 'sub BUS_DMA_ALLOCNOW () {0x02;}' unless defined(&BUS_DMA_ALLOCNOW);
    eval 'sub BUS_DMA_COHERENT () {0x04;}' unless defined(&BUS_DMA_COHERENT);
    eval 'sub BUS_DMA_BUS1 () {0x10;}' unless defined(&BUS_DMA_BUS1);
    eval 'sub BUS_DMA_BUS2 () {0x20;}' unless defined(&BUS_DMA_BUS2);
    eval 'sub BUS_DMA_BUS3 () {0x40;}' unless defined(&BUS_DMA_BUS3);
    eval 'sub BUS_DMA_BUS4 () {0x80;}' unless defined(&BUS_DMA_BUS4);
    eval("sub BUS_DMASYNC_PREREAD () { 0; }") unless defined(&BUS_DMASYNC_PREREAD);
    eval("sub BUS_DMASYNC_POSTREAD () { 1; }") unless defined(&BUS_DMASYNC_POSTREAD);
    eval("sub BUS_DMASYNC_PREWRITE () { 2; }") unless defined(&BUS_DMASYNC_PREWRITE);
    eval("sub BUS_DMASYNC_POSTWRITE () { 3; }") unless defined(&BUS_DMASYNC_POSTWRITE);
    eval 'sub bus_dmamap_create {
        local($t, $s, $n, $m, $b, $f, $p) = @_;
	    eval q((*($t)-> &_dmamap_create)(($t), ($s), ($n), ($m), ($b), ($f), ($p)));
    }' unless defined(&bus_dmamap_create);
    eval 'sub bus_dmamap_destroy {
        local($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_destroy)(($t), ($p)));
    }' unless defined(&bus_dmamap_destroy);
    eval 'sub bus_dmamap_load {
        local($t, $m, $b, $s, $p, $f) = @_;
	    eval q((*($t)-> &_dmamap_load)(($t), ($m), ($b), ($s), ($p), ($f)));
    }' unless defined(&bus_dmamap_load);
    eval 'sub bus_dmamap_load_mbuf {
        local($t, $m, $b, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_mbuf)(($t), ($m), ($b), ($f)));
    }' unless defined(&bus_dmamap_load_mbuf);
    eval 'sub bus_dmamap_load_uio {
        local($t, $m, $u, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_uio)(($t), ($m), ($u), ($f)));
    }' unless defined(&bus_dmamap_load_uio);
    eval 'sub bus_dmamap_load_raw {
        local($t, $m, $sg, $n, $s, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_raw)(($t), ($m), ($sg), ($n), ($s), ($f)));
    }' unless defined(&bus_dmamap_load_raw);
    eval 'sub bus_dmamap_unload {
        local($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_unload)(($t), ($p)));
    }' unless defined(&bus_dmamap_unload);
    eval 'sub bus_dmamap_sync {
        local($t, $p, $o) = @_;
	    eval q((-> &_dmamap_sync ? (*-> &_dmamap_sync)(, , ) : 0));
    }' unless defined(&bus_dmamap_sync);
    eval 'sub bus_dmamem_alloc {
        local($t, $s, $a, $b, $sg, $n, $r, $f) = @_;
	    eval q((*($t)-> &_dmamem_alloc)(($t), ($s), ($a), ($b), ($sg), ($n), ($r), ($f)));
    }' unless defined(&bus_dmamem_alloc);
    eval 'sub bus_dmamem_free {
        local($t, $sg, $n) = @_;
	    eval q((*($t)-> &_dmamem_free)(($t), ($sg), ($n)));
    }' unless defined(&bus_dmamem_free);
    eval 'sub bus_dmamem_map {
        local($t, $sg, $n, $s, $k, $f) = @_;
	    eval q((*($t)-> &_dmamem_map)(($t), ($sg), ($n), ($s), ($k), ($f)));
    }' unless defined(&bus_dmamem_map);
    eval 'sub bus_dmamem_unmap {
        local($t, $k, $s) = @_;
	    eval q((*($t)-> &_dmamem_unmap)(($t), ($k), ($s)));
    }' unless defined(&bus_dmamem_unmap);
    eval 'sub bus_dmamem_mmap {
        local($t, $sg, $n, $o, $p, $f) = @_;
	    eval q((*($t)-> &_dmamem_mmap)(($t), ($sg), ($n), ($o), ($p), ($f)));
    }' unless defined(&bus_dmamem_mmap);
    if(defined(&_I386_BUS_DMA_PRIVATE)) {
    }
}
1;
