require '_h2ph_pre.ph';

unless(defined(&KUE_CONFIG_NO)) {
    sub KUE_CONFIG_NO () {	1;}
}
unless(defined(&KUE_IFACE_IDX)) {
    sub KUE_IFACE_IDX () {	0;}
}
unless(defined(&KUE_CMD_GET_ETHER_DESCRIPTOR)) {
    sub KUE_CMD_GET_ETHER_DESCRIPTOR () {	0x00;}
}
unless(defined(&KUE_CMD_SET_MCAST_FILTERS)) {
    sub KUE_CMD_SET_MCAST_FILTERS () {	0x01;}
}
unless(defined(&KUE_CMD_SET_PKT_FILTER)) {
    sub KUE_CMD_SET_PKT_FILTER () {	0x02;}
}
unless(defined(&KUE_CMD_GET_ETHERSTATS)) {
    sub KUE_CMD_GET_ETHERSTATS () {	0x03;}
}
unless(defined(&KUE_CMD_GET_GPIO)) {
    sub KUE_CMD_GET_GPIO () {	0x04;}
}
unless(defined(&KUE_CMD_SET_GPIO)) {
    sub KUE_CMD_SET_GPIO () {	0x05;}
}
unless(defined(&KUE_CMD_SET_MAC)) {
    sub KUE_CMD_SET_MAC () {	0x06;}
}
unless(defined(&KUE_CMD_GET_MAC)) {
    sub KUE_CMD_GET_MAC () {	0x07;}
}
unless(defined(&KUE_CMD_SET_URB_SIZE)) {
    sub KUE_CMD_SET_URB_SIZE () {	0x08;}
}
unless(defined(&KUE_CMD_SET_SOFS)) {
    sub KUE_CMD_SET_SOFS () {	0x09;}
}
unless(defined(&KUE_CMD_SET_EVEN_PKTS)) {
    sub KUE_CMD_SET_EVEN_PKTS () {	0x0a;}
}
unless(defined(&KUE_CMD_SEND_SCAN)) {
    sub KUE_CMD_SEND_SCAN () {	0xff;}
}
unless(defined(&KUE_ETHERSTATS)) {
    sub KUE_ETHERSTATS {
	local($x) = @_;
	eval q((*( &u_int32_t *)($x)-> ($kue_desc->{kue_etherstats})));
    }
}
unless(defined(&KUE_MAXSEG)) {
    sub KUE_MAXSEG {
	local($x) = @_;
	eval q((*( &u_int16_t *)($x)-> ($kue_desc->{kue_maxseg})));
    }
}
unless(defined(&KUE_MCFILTCNT)) {
    sub KUE_MCFILTCNT {
	local($x) = @_;
	eval q(((*( &u_int16_t *)($x)-> ($kue_desc->{kue_mcastfilt})) & 0x7fff));
    }
}
unless(defined(&KUE_MCFILT)) {
    sub KUE_MCFILT {
	local($x, $y) = @_;
	eval q(( ($sc->{kue_mcfilters[$y * ETHER_ADDR_LEN]})));
    }
}
unless(defined(&KUE_STAT_TX_OK)) {
    sub KUE_STAT_TX_OK () {	0x00000001;}
}
unless(defined(&KUE_STAT_RX_OK)) {
    sub KUE_STAT_RX_OK () {	0x00000002;}
}
unless(defined(&KUE_STAT_TX_ERR)) {
    sub KUE_STAT_TX_ERR () {	0x00000004;}
}
unless(defined(&KUE_STAT_RX_ERR)) {
    sub KUE_STAT_RX_ERR () {	0x00000008;}
}
unless(defined(&KUE_STAT_RX_NOBUF)) {
    sub KUE_STAT_RX_NOBUF () {	0x00000010;}
}
unless(defined(&KUE_STAT_TX_UCAST_BYTES)) {
    sub KUE_STAT_TX_UCAST_BYTES () {	0x00000020;}
}
unless(defined(&KUE_STAT_TX_UCAST_FRAMES)) {
    sub KUE_STAT_TX_UCAST_FRAMES () {	0x00000040;}
}
unless(defined(&KUE_STAT_TX_MCAST_BYTES)) {
    sub KUE_STAT_TX_MCAST_BYTES () {	0x00000080;}
}
unless(defined(&KUE_STAT_TX_MCAST_FRAMES)) {
    sub KUE_STAT_TX_MCAST_FRAMES () {	0x00000100;}
}
unless(defined(&KUE_STAT_TX_BCAST_BYTES)) {
    sub KUE_STAT_TX_BCAST_BYTES () {	0x00000200;}
}
unless(defined(&KUE_STAT_TX_BCAST_FRAMES)) {
    sub KUE_STAT_TX_BCAST_FRAMES () {	0x00000400;}
}
unless(defined(&KUE_STAT_RX_UCAST_BYTES)) {
    sub KUE_STAT_RX_UCAST_BYTES () {	0x00000800;}
}
unless(defined(&KUE_STAT_RX_UCAST_FRAMES)) {
    sub KUE_STAT_RX_UCAST_FRAMES () {	0x00001000;}
}
unless(defined(&KUE_STAT_RX_MCAST_BYTES)) {
    sub KUE_STAT_RX_MCAST_BYTES () {	0x00002000;}
}
unless(defined(&KUE_STAT_RX_MCAST_FRAMES)) {
    sub KUE_STAT_RX_MCAST_FRAMES () {	0x00004000;}
}
unless(defined(&KUE_STAT_RX_BCAST_BYTES)) {
    sub KUE_STAT_RX_BCAST_BYTES () {	0x00008000;}
}
unless(defined(&KUE_STAT_RX_BCAST_FRAMES)) {
    sub KUE_STAT_RX_BCAST_FRAMES () {	0x00010000;}
}
unless(defined(&KUE_STAT_RX_CRCERR)) {
    sub KUE_STAT_RX_CRCERR () {	0x00020000;}
}
unless(defined(&KUE_STAT_TX_QUEUE_LENGTH)) {
    sub KUE_STAT_TX_QUEUE_LENGTH () {	0x00040000;}
}
unless(defined(&KUE_STAT_RX_ALIGNERR)) {
    sub KUE_STAT_RX_ALIGNERR () {	0x00080000;}
}
unless(defined(&KUE_STAT_TX_SINGLECOLL)) {
    sub KUE_STAT_TX_SINGLECOLL () {	0x00100000;}
}
unless(defined(&KUE_STAT_TX_MULTICOLL)) {
    sub KUE_STAT_TX_MULTICOLL () {	0x00200000;}
}
unless(defined(&KUE_STAT_TX_DEFERRED)) {
    sub KUE_STAT_TX_DEFERRED () {	0x00400000;}
}
unless(defined(&KUE_STAT_TX_MAXCOLLS)) {
    sub KUE_STAT_TX_MAXCOLLS () {	0x00800000;}
}
unless(defined(&KUE_STAT_RX_OVERRUN)) {
    sub KUE_STAT_RX_OVERRUN () {	0x01000000;}
}
unless(defined(&KUE_STAT_TX_UNDERRUN)) {
    sub KUE_STAT_TX_UNDERRUN () {	0x02000000;}
}
unless(defined(&KUE_STAT_TX_SQE_ERR)) {
    sub KUE_STAT_TX_SQE_ERR () {	0x04000000;}
}
unless(defined(&KUE_STAT_TX_CARRLOSS)) {
    sub KUE_STAT_TX_CARRLOSS () {	0x08000000;}
}
unless(defined(&KUE_STAT_RX_LATECOLL)) {
    sub KUE_STAT_RX_LATECOLL () {	0x10000000;}
}
unless(defined(&KUE_RXFILT_PROMISC)) {
    sub KUE_RXFILT_PROMISC () {	0x0001;}
}
unless(defined(&KUE_RXFILT_ALLMULTI)) {
    sub KUE_RXFILT_ALLMULTI () {	0x0002;}
}
unless(defined(&KUE_RXFILT_UNICAST)) {
    sub KUE_RXFILT_UNICAST () {	0x0004;}
}
unless(defined(&KUE_RXFILT_BROADCAST)) {
    sub KUE_RXFILT_BROADCAST () {	0x0008;}
}
unless(defined(&KUE_RXFILT_MULTICAST)) {
    sub KUE_RXFILT_MULTICAST () {	0x0010;}
}
unless(defined(&KUE_TIMEOUT)) {
    sub KUE_TIMEOUT () {	1000;}
}
unless(defined(&ETHER_ALIGN)) {
    sub ETHER_ALIGN () {	2;}
}
unless(defined(&KUE_BUFSZ)) {
    sub KUE_BUFSZ () {	1536;}
}
unless(defined(&KUE_MIN_FRAMELEN)) {
    sub KUE_MIN_FRAMELEN () {	60;}
}
unless(defined(&KUE_RX_LIST_CNT)) {
    sub KUE_RX_LIST_CNT () {	1;}
}
unless(defined(&KUE_TX_LIST_CNT)) {
    sub KUE_TX_LIST_CNT () {	1;}
}
unless(defined(&KUE_CTL_READ)) {
    sub KUE_CTL_READ () {	0x01;}
}
unless(defined(&KUE_CTL_WRITE)) {
    sub KUE_CTL_WRITE () {	0x02;}
}
unless(defined(&KUE_WARM_REV)) {
    sub KUE_WARM_REV () {	0x0202;}
}
unless(defined(&KUE_ENDPT_RX)) {
    sub KUE_ENDPT_RX () {	0x0;}
}
unless(defined(&KUE_ENDPT_TX)) {
    sub KUE_ENDPT_TX () {	0x1;}
}
unless(defined(&KUE_ENDPT_INTR)) {
    sub KUE_ENDPT_INTR () {	0x2;}
}
unless(defined(&KUE_ENDPT_MAX)) {
    sub KUE_ENDPT_MAX () {	0x3;}
}
if(defined( &__FreeBSD__) || defined( &__OpenBSD__)) {
    eval 'sub GET_IFP {
        local($sc) = @_;
	    eval q((($sc)-> ($arpcom->{ac_if})));
    }' unless defined(&GET_IFP);
}
 elsif(defined( &__NetBSD__)) {
    if((defined(&NRND) ? &NRND : 0) > 0) {
    }
    eval 'sub GET_IFP {
        local($sc) = @_;
	    eval q((($sc)-> ($kue_ec->{ec_if})));
    }' unless defined(&GET_IFP);
}
1;
