require '_h2ph_pre.ph';

unless(defined(&NATSEMI_CTRL1)) {
    sub NATSEMI_CTRL1 () {	0x40;}
}
unless(defined(&NATSEMI_CTRL1_SWRST)) {
    sub NATSEMI_CTRL1_SWRST () {	0x04;}
}
unless(defined(&NATSEMI_CTRL1_IDEPWR)) {
    sub NATSEMI_CTRL1_IDEPWR () {	0x08;}
}
unless(defined(&NATSEMI_CTRL1_CH1INTMAP)) {
    sub NATSEMI_CTRL1_CH1INTMAP () {	0x10;}
}
unless(defined(&NATSEMI_CTRL1_CH2INTMAP)) {
    sub NATSEMI_CTRL1_CH2INTMAP () {	0x20;}
}
unless(defined(&NATSEMI_CTRL1_INTAMASK)) {
    sub NATSEMI_CTRL1_INTAMASK () {	0x40;}
}
unless(defined(&NATSEMI_CTRL1_IDWR)) {
    sub NATSEMI_CTRL1_IDWR () {	0x80;}
}
unless(defined(&NATSEMI_CTRL2)) {
    sub NATSEMI_CTRL2 () {	0x41;}
}
unless(defined(&NATSEMI_CTRL2_CH1MASK)) {
    sub NATSEMI_CTRL2_CH1MASK () {	0x01;}
}
unless(defined(&NATSEMI_CTRL2_CH2MASK)) {
    sub NATSEMI_CTRL2_CH2MASK () {	0x02;}
}
unless(defined(&NATSEMI_CTRL2_BARDIS)) {
    sub NATSEMI_CTRL2_BARDIS () {	0x04;}
}
unless(defined(&NATSEMI_CTRL2_WATCHDOG)) {
    sub NATSEMI_CTRL2_WATCHDOG () {	0x08;}
}
unless(defined(&NATSEMI_CTRL2_BUF1BYP)) {
    sub NATSEMI_CTRL2_BUF1BYP () {	0x10;}
}
unless(defined(&NATSEMI_CTRL2_BYF2BYP)) {
    sub NATSEMI_CTRL2_BYF2BYP () {	0x20;}
}
unless(defined(&NATSEMI_CTRL2_IDE1MAP)) {
    sub NATSEMI_CTRL2_IDE1MAP () {	0x40;}
}
unless(defined(&NATSEMI_CTRL2_IDE2MAP)) {
    sub NATSEMI_CTRL2_IDE2MAP () {	0x80;}
}
unless(defined(&NATSEMI_CHMASK)) {
    sub NATSEMI_CHMASK {
	local($chn) = @_;
	eval q(( &NATSEMI_CTRL2_CH1MASK << ($chn)));
    }
}
unless(defined(&NATSEMI_CTRL3)) {
    sub NATSEMI_CTRL3 () {	0x42;}
}
unless(defined(&NATSEMI_CTRL3_CH1PREDIS)) {
    sub NATSEMI_CTRL3_CH1PREDIS () {	0x01;}
}
unless(defined(&NATSEMI_CTRL3_CH2PREDIS)) {
    sub NATSEMI_CTRL3_CH2PREDIS () {	0x02;}
}
unless(defined(&NATSEMI_CTRL3_RSTIDLE)) {
    sub NATSEMI_CTRL3_RSTIDLE () {	0x04;}
}
unless(defined(&NATSEMI_CTRL3_C1D1DMARQ)) {
    sub NATSEMI_CTRL3_C1D1DMARQ () {	0x10;}
}
unless(defined(&NATSEMI_CTRL3_C1D2DMARQ)) {
    sub NATSEMI_CTRL3_C1D2DMARQ () {	0x20;}
}
unless(defined(&NATSEMI_CTRL3_C2D1DMARQ)) {
    sub NATSEMI_CTRL3_C2D1DMARQ () {	0x40;}
}
unless(defined(&NATSEMI_CTRL3_C2D2DMARQ)) {
    sub NATSEMI_CTRL3_C2D2DMARQ () {	0x80;}
}
unless(defined(&NATSEMI_WBS)) {
    sub NATSEMI_WBS () {	0x43;}
}
unless(defined(&NATSEMI_WBS_WB1NMPTY)) {
    sub NATSEMI_WBS_WB1NMPTY () {	0x01;}
}
unless(defined(&NATSEMI_WBS_WB2NMPTY)) {
    sub NATSEMI_WBS_WB2NMPTY () {	0x02;}
}
unless(defined(&NATSEMI_C1D1DRT)) {
    sub NATSEMI_C1D1DRT () {	0x44;}
}
unless(defined(&NATSEMI_C1D1DWT)) {
    sub NATSEMI_C1D1DWT () {	0x45;}
}
unless(defined(&NATSEMI_C1D2DRT)) {
    sub NATSEMI_C1D2DRT () {	0x48;}
}
unless(defined(&NATSEMI_C1D2DWT)) {
    sub NATSEMI_C1D2DWT () {	0x49;}
}
unless(defined(&NATSEMI_C2D1DRT)) {
    sub NATSEMI_C2D1DRT () {	0x4c;}
}
unless(defined(&NATSEMI_C2D1DWT)) {
    sub NATSEMI_C2D1DWT () {	0x4d;}
}
unless(defined(&NATSEMI_C2D2DRT)) {
    sub NATSEMI_C2D2DRT () {	0x50;}
}
unless(defined(&NATSEMI_C2D2DWT)) {
    sub NATSEMI_C2D2DWT () {	0x51;}
}
unless(defined(&NATSEMI_CCBT)) {
    sub NATSEMI_CCBT () {	0x54;}
}
unless(defined(&NATSEMI_SECT)) {
    sub NATSEMI_SECT () {	0x55;}
}
unless(defined(&NATSEMI_SECT_C1UNUSED)) {
    sub NATSEMI_SECT_C1UNUSED () {	0x0f;}
}
unless(defined(&NATSEMI_SECT_C1_512)) {
    sub NATSEMI_SECT_C1_512 () {	0x0e;}
}
unless(defined(&NATSEMI_SECT_C1_1024)) {
    sub NATSEMI_SECT_C1_1024 () {	0x0c;}
}
unless(defined(&NATSEMI_SECT_C1_2048)) {
    sub NATSEMI_SECT_C1_2048 () {	0x08;}
}
unless(defined(&NATSEMI_SECT_C1_4096)) {
    sub NATSEMI_SECT_C1_4096 () {	0x00;}
}
unless(defined(&NATSEMI_SECT_C2UNUSED)) {
    sub NATSEMI_SECT_C2UNUSED () {	0xf0;}
}
unless(defined(&NATSEMI_SECT_C2_512)) {
    sub NATSEMI_SECT_C2_512 () {	0xe0;}
}
unless(defined(&NATSEMI_SECT_C2_1024)) {
    sub NATSEMI_SECT_C2_1024 () {	0xc0;}
}
unless(defined(&NATSEMI_SECT_C2_2048)) {
    sub NATSEMI_SECT_C2_2048 () {	0x80;}
}
unless(defined(&NATSEMI_SECT_C2_4096)) {
    sub NATSEMI_SECT_C2_4096 () {	0x00;}
}
unless(defined(&NATSEMI_RTREG)) {
    sub NATSEMI_RTREG {
	local($c,$d) = @_;
	eval q((0x44 + ($c * 8) + ($d * 4) + 0));
    }
}
unless(defined(&NATSEMI_WTREG)) {
    sub NATSEMI_WTREG {
	local($c,$d) = @_;
	eval q((0x44 + ($c * 8) + ($d * 4) + 1));
    }
}
1;
