require '_h2ph_pre.ph';

unless(defined(&FXP_NTXCB)) {
    sub FXP_NTXCB () {	128;}
}
unless(defined(&FXP_NRFABUFS)) {
    sub FXP_NRFABUFS () {	64;}
}
unless(defined(&FXPF_HAS_RESUME_BUG)) {
    sub FXPF_HAS_RESUME_BUG () {	0x08;}
}
unless(defined(&FXPF_FIX_RESUME_BUG)) {
    sub FXPF_FIX_RESUME_BUG () {	0x10;}
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_2(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&FXP_RXMAP_GET)) {
    sub FXP_RXMAP_GET {
	local($sc) = @_;
	eval q((($sc)-> $sc_rxmaps[($sc)-> &sc_rxfree++]));
    }
}
unless(defined(&FXP_RXMAP_PUT)) {
    sub FXP_RXMAP_PUT {
	local($sc,$map) = @_;
	eval q((($sc)-> $sc_rxmaps[--($sc)-> &sc_rxfree] = ($map)));
    }
}
if(defined(&__HAS_NEW_BUS_DMAMAP_SYNC)) {
    eval 'sub fxp_bus_dmamap_sync {
        local($t, $m, $o, $l, $p) = @_;
	    eval q( &bus_dmamap_sync(($t), ($m), ($o), ($l), ($p)));
    }' unless defined(&fxp_bus_dmamap_sync);
} else {
    eval 'sub fxp_bus_dmamap_sync {
        local($t, $m, $o, $l, $p) = @_;
	    eval q( &bus_dmamap_sync(($t), ($m), ($p)));
    }' unless defined(&fxp_bus_dmamap_sync);
}
unless(defined(&FXP_TXCB_SYNC)) {
    sub FXP_TXCB_SYNC {
	local($sc, $txs, $p) = @_;
	eval q( &fxp_bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &tx_cb_map, ($txs)-> &tx_off, $sizeof{'struct fxp_cb_tx'}, ($p)));
    }
}
unless(defined(&FXP_MCS_SYNC)) {
    sub FXP_MCS_SYNC {
	local($sc, $p) = @_;
	eval q( &fxp_bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &tx_cb_map,  &offsetof('struct fxp_ctrl',  ($u->{mcs})), $sizeof{'struct fxp_cb_mcs'}, ($p)));
    }
}
unless(defined(&FXP_IAS_SYNC)) {
    sub FXP_IAS_SYNC {
	local($sc, $p) = @_;
	eval q( &fxp_bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &tx_cb_map,  &offsetof('struct fxp_ctrl',  ($u->{ias})), $sizeof{'struct fxp_cb_ias'}, ($p)));
    }
}
unless(defined(&FXP_CFG_SYNC)) {
    sub FXP_CFG_SYNC {
	local($sc, $p) = @_;
	eval q( &fxp_bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &tx_cb_map,  &offsetof('struct fxp_ctrl',  ($u->{cfg})), $sizeof{'struct fxp_cb_config'}, ($p)));
    }
}
unless(defined(&FXP_MBUF_SYNC)) {
    sub FXP_MBUF_SYNC {
	local($sc, $m, $p) = @_;
	eval q( &fxp_bus_dmamap_sync(($sc)-> &sc_dmat, ($m), 0, ($m)-> &dm_mapsize, ($p)));
    }
}
1;
