require '_h2ph_pre.ph';

unless(defined(&_ADVANSYS_WIDE_LIBRARY_H_)) {
    eval 'sub _ADVANSYS_WIDE_LIBRARY_H_ () {1;}' unless defined(&_ADVANSYS_WIDE_LIBRARY_H_);
    eval 'sub ADW_LIB_VERSION_MAJOR () {5;}' unless defined(&ADW_LIB_VERSION_MAJOR);
    eval 'sub ADW_LIB_VERSION_MINOR () {8;}' unless defined(&ADW_LIB_VERSION_MINOR);
    eval 'sub ADW_TENTHS {
        local($num, $den) = @_;
	    eval q((((10* (($num)/($den))) > ((($num) * 10)/($den))) ? 0: (((($num) * 10)/($den)) - (10* (($num)/($den))))));
    }' unless defined(&ADW_TENTHS);
    eval 'sub ADW_SCSI_RESET_HOLD_TIME_US () {60;}' unless defined(&ADW_SCSI_RESET_HOLD_TIME_US);
    eval 'sub ADW_EEP_DVC_CFG_BEGIN () {(0x00);}' unless defined(&ADW_EEP_DVC_CFG_BEGIN);
    eval 'sub ADW_EEP_DVC_CFG_END () {(0x15);}' unless defined(&ADW_EEP_DVC_CFG_END);
    eval 'sub ADW_EEP_DVC_CTL_BEGIN () {(0x16);}' unless defined(&ADW_EEP_DVC_CTL_BEGIN);
    eval 'sub ADW_EEP_MAX_WORD_ADDR () {(0x1e);}' unless defined(&ADW_EEP_MAX_WORD_ADDR);
    eval 'sub ADW_EEP_DELAY_MS () {100;}' unless defined(&ADW_EEP_DELAY_MS);
    eval 'sub ADW_EEPROM_BIG_ENDIAN () {0x8000;}' unless defined(&ADW_EEPROM_BIG_ENDIAN);
    eval 'sub ADW_EEPROM_BIOS_ENABLE () {0x4000;}' unless defined(&ADW_EEPROM_BIOS_ENABLE);
    eval 'sub ADW_EEPROM_TERM_POL () {0x2000;}' unless defined(&ADW_EEPROM_TERM_POL);
    eval 'sub ADW_EEPROM_BIG_ENDIAN () {0x8000;}' unless defined(&ADW_EEPROM_BIG_ENDIAN);
    eval 'sub ADW_EEPROM_BIOS_ENABLE () {0x4000;}' unless defined(&ADW_EEPROM_BIOS_ENABLE);
    eval 'sub ADW_EEPROM_TERM_POL () {0x2000;}' unless defined(&ADW_EEPROM_TERM_POL);
    eval 'sub ADW_EEPROM_CIS_LD () {0x2000;}' unless defined(&ADW_EEPROM_CIS_LD);
    eval 'sub ADW_EEPROM_INTAB () {0x0800;}' unless defined(&ADW_EEPROM_INTAB);
    eval 'sub ADW_EEP_CMD_READ () {0x80;}' unless defined(&ADW_EEP_CMD_READ);
    eval 'sub ADW_EEP_CMD_WRITE () {0x40;}' unless defined(&ADW_EEP_CMD_WRITE);
    eval 'sub ADW_EEP_CMD_WRITE_ABLE () {0x30;}' unless defined(&ADW_EEP_CMD_WRITE_ABLE);
    eval 'sub ADW_EEP_CMD_WRITE_DISABLE () {0x00;}' unless defined(&ADW_EEP_CMD_WRITE_DISABLE);
    eval 'sub ADW_EEP_CMD_DONE () {0x0200;}' unless defined(&ADW_EEP_CMD_DONE);
    eval 'sub ADW_EEP_CMD_DONE_ERR () {0x0001;}' unless defined(&ADW_EEP_CMD_DONE_ERR);
    eval 'sub EEP_CFG_WORD_BIG_ENDIAN () {0x8000;}' unless defined(&EEP_CFG_WORD_BIG_ENDIAN);
    eval 'sub BIOS_CTRL_BIOS () {0x0001;}' unless defined(&BIOS_CTRL_BIOS);
    eval 'sub BIOS_CTRL_EXTENDED_XLAT () {0x0002;}' unless defined(&BIOS_CTRL_EXTENDED_XLAT);
    eval 'sub BIOS_CTRL_GT_2_DISK () {0x0004;}' unless defined(&BIOS_CTRL_GT_2_DISK);
    eval 'sub BIOS_CTRL_BIOS_REMOVABLE () {0x0008;}' unless defined(&BIOS_CTRL_BIOS_REMOVABLE);
    eval 'sub BIOS_CTRL_BOOTABLE_CD () {0x0010;}' unless defined(&BIOS_CTRL_BOOTABLE_CD);
    eval 'sub BIOS_CTRL_MULTIPLE_LUN () {0x0040;}' unless defined(&BIOS_CTRL_MULTIPLE_LUN);
    eval 'sub BIOS_CTRL_DISPLAY_MSG () {0x0080;}' unless defined(&BIOS_CTRL_DISPLAY_MSG);
    eval 'sub BIOS_CTRL_NO_SCAM () {0x0100;}' unless defined(&BIOS_CTRL_NO_SCAM);
    eval 'sub BIOS_CTRL_RESET_SCSI_BUS () {0x0200;}' unless defined(&BIOS_CTRL_RESET_SCSI_BUS);
    eval 'sub BIOS_CTRL_INIT_VERBOSE () {0x0800;}' unless defined(&BIOS_CTRL_INIT_VERBOSE);
    eval 'sub BIOS_CTRL_SCSI_PARITY () {0x1000;}' unless defined(&BIOS_CTRL_SCSI_PARITY);
    eval 'sub BIOS_CTRL_AIPP_DIS () {0x2000;}' unless defined(&BIOS_CTRL_AIPP_DIS);
    eval 'sub ADW_3550_MEMSIZE () {0x2000;}' unless defined(&ADW_3550_MEMSIZE);
    eval 'sub ADW_3550_IOLEN () {0x40;}' unless defined(&ADW_3550_IOLEN);
    eval 'sub ADW_38C0800_MEMSIZE () {0x4000;}' unless defined(&ADW_38C0800_MEMSIZE);
    eval 'sub ADW_38C0800_IOLEN () {0x100;}' unless defined(&ADW_38C0800_IOLEN);
    eval 'sub ADW_38C1600_MEMSIZE () {0x8000;}' unless defined(&ADW_38C1600_MEMSIZE);
    eval 'sub ADW_38C1600_IOLEN () {0x100;}' unless defined(&ADW_38C1600_IOLEN);
    eval 'sub ADW_38C1600_MEMLEN () {0x1000;}' unless defined(&ADW_38C1600_MEMLEN);
    eval 'sub IOPB_INTR_STATUS_REG () {0x00;}' unless defined(&IOPB_INTR_STATUS_REG);
    eval 'sub IOPB_CHIP_ID_1 () {0x01;}' unless defined(&IOPB_CHIP_ID_1);
    eval 'sub IOPB_INTR_ENABLES () {0x02;}' unless defined(&IOPB_INTR_ENABLES);
    eval 'sub IOPB_CHIP_TYPE_REV () {0x03;}' unless defined(&IOPB_CHIP_TYPE_REV);
    eval 'sub IOPB_RES_ADDR_4 () {0x04;}' unless defined(&IOPB_RES_ADDR_4);
    eval 'sub IOPB_RES_ADDR_5 () {0x05;}' unless defined(&IOPB_RES_ADDR_5);
    eval 'sub IOPB_RAM_DATA () {0x06;}' unless defined(&IOPB_RAM_DATA);
    eval 'sub IOPB_RES_ADDR_7 () {0x07;}' unless defined(&IOPB_RES_ADDR_7);
    eval 'sub IOPB_FLAG_REG () {0x08;}' unless defined(&IOPB_FLAG_REG);
    eval 'sub IOPB_RES_ADDR_9 () {0x09;}' unless defined(&IOPB_RES_ADDR_9);
    eval 'sub IOPB_RISC_CSR () {0x0a;}' unless defined(&IOPB_RISC_CSR);
    eval 'sub IOPB_RES_ADDR_B () {0x0b;}' unless defined(&IOPB_RES_ADDR_B);
    eval 'sub IOPB_RES_ADDR_C () {0x0c;}' unless defined(&IOPB_RES_ADDR_C);
    eval 'sub IOPB_RES_ADDR_D () {0x0d;}' unless defined(&IOPB_RES_ADDR_D);
    eval 'sub IOPB_SOFT_OVER_WR () {0x0e;}' unless defined(&IOPB_SOFT_OVER_WR);
    eval 'sub IOPB_RES_ADDR_F () {0x0f;}' unless defined(&IOPB_RES_ADDR_F);
    eval 'sub IOPB_MEM_CFG () {0x10;}' unless defined(&IOPB_MEM_CFG);
    eval 'sub IOPB_RES_ADDR_11 () {0x11;}' unless defined(&IOPB_RES_ADDR_11);
    eval 'sub IOPB_GPIO_DATA () {0x12;}' unless defined(&IOPB_GPIO_DATA);
    eval 'sub IOPB_RES_ADDR_13 () {0x13;}' unless defined(&IOPB_RES_ADDR_13);
    eval 'sub IOPB_FLASH_PAGE () {0x14;}' unless defined(&IOPB_FLASH_PAGE);
    eval 'sub IOPB_RES_ADDR_15 () {0x15;}' unless defined(&IOPB_RES_ADDR_15);
    eval 'sub IOPB_GPIO_CNTL () {0x16;}' unless defined(&IOPB_GPIO_CNTL);
    eval 'sub IOPB_RES_ADDR_17 () {0x17;}' unless defined(&IOPB_RES_ADDR_17);
    eval 'sub IOPB_FLASH_DATA () {0x18;}' unless defined(&IOPB_FLASH_DATA);
    eval 'sub IOPB_RES_ADDR_19 () {0x19;}' unless defined(&IOPB_RES_ADDR_19);
    eval 'sub IOPB_RES_ADDR_1A () {0x1a;}' unless defined(&IOPB_RES_ADDR_1A);
    eval 'sub IOPB_RES_ADDR_1B () {0x1b;}' unless defined(&IOPB_RES_ADDR_1B);
    eval 'sub IOPB_RES_ADDR_1C () {0x1c;}' unless defined(&IOPB_RES_ADDR_1C);
    eval 'sub IOPB_RES_ADDR_1D () {0x1d;}' unless defined(&IOPB_RES_ADDR_1D);
    eval 'sub IOPB_RES_ADDR_1E () {0x1e;}' unless defined(&IOPB_RES_ADDR_1E);
    eval 'sub IOPB_RES_ADDR_1F () {0x1f;}' unless defined(&IOPB_RES_ADDR_1F);
    eval 'sub IOPB_DMA_CFG0 () {0x20;}' unless defined(&IOPB_DMA_CFG0);
    eval 'sub IOPB_DMA_CFG1 () {0x21;}' unless defined(&IOPB_DMA_CFG1);
    eval 'sub IOPB_TICKLE () {0x22;}' unless defined(&IOPB_TICKLE);
    eval 'sub IOPB_DMA_REG_WR () {0x23;}' unless defined(&IOPB_DMA_REG_WR);
    eval 'sub IOPB_SDMA_STATUS () {0x24;}' unless defined(&IOPB_SDMA_STATUS);
    eval 'sub IOPB_SCSI_BYTE_CNT () {0x25;}' unless defined(&IOPB_SCSI_BYTE_CNT);
    eval 'sub IOPB_HOST_BYTE_CNT () {0x26;}' unless defined(&IOPB_HOST_BYTE_CNT);
    eval 'sub IOPB_BYTE_LEFT_TO_XFER () {0x27;}' unless defined(&IOPB_BYTE_LEFT_TO_XFER);
    eval 'sub IOPB_BYTE_TO_XFER_0 () {0x28;}' unless defined(&IOPB_BYTE_TO_XFER_0);
    eval 'sub IOPB_BYTE_TO_XFER_1 () {0x29;}' unless defined(&IOPB_BYTE_TO_XFER_1);
    eval 'sub IOPB_BYTE_TO_XFER_2 () {0x2a;}' unless defined(&IOPB_BYTE_TO_XFER_2);
    eval 'sub IOPB_BYTE_TO_XFER_3 () {0x2b;}' unless defined(&IOPB_BYTE_TO_XFER_3);
    eval 'sub IOPB_ACC_GRP () {0x2c;}' unless defined(&IOPB_ACC_GRP);
    eval 'sub IOPB_RES_ADDR_2D () {0x2d;}' unless defined(&IOPB_RES_ADDR_2D);
    eval 'sub IOPB_DEV_ID () {0x2e;}' unless defined(&IOPB_DEV_ID);
    eval 'sub IOPB_RES_ADDR_2F () {0x2f;}' unless defined(&IOPB_RES_ADDR_2F);
    eval 'sub IOPB_SCSI_DATA () {0x30;}' unless defined(&IOPB_SCSI_DATA);
    eval 'sub IOPB_RES_ADDR_31 () {0x31;}' unless defined(&IOPB_RES_ADDR_31);
    eval 'sub IOPB_RES_ADDR_32 () {0x32;}' unless defined(&IOPB_RES_ADDR_32);
    eval 'sub IOPB_SCSI_DATA_HSHK () {0x33;}' unless defined(&IOPB_SCSI_DATA_HSHK);
    eval 'sub IOPB_SCSI_CTRL () {0x34;}' unless defined(&IOPB_SCSI_CTRL);
    eval 'sub IOPB_RES_ADDR_35 () {0x35;}' unless defined(&IOPB_RES_ADDR_35);
    eval 'sub IOPB_RES_ADDR_36 () {0x36;}' unless defined(&IOPB_RES_ADDR_36);
    eval 'sub IOPB_RES_ADDR_37 () {0x37;}' unless defined(&IOPB_RES_ADDR_37);
    eval 'sub IOPB_RAM_BIST () {0x38;}' unless defined(&IOPB_RAM_BIST);
    eval 'sub IOPB_PLL_TEST () {0x39;}' unless defined(&IOPB_PLL_TEST);
    eval 'sub IOPB_PCI_INT_CFG () {0x3a;}' unless defined(&IOPB_PCI_INT_CFG);
    eval 'sub IOPB_RES_ADDR_3B () {0x3b;}' unless defined(&IOPB_RES_ADDR_3B);
    eval 'sub IOPB_RFIFO_CNT () {0x3c;}' unless defined(&IOPB_RFIFO_CNT);
    eval 'sub IOPB_RES_ADDR_3D () {0x3d;}' unless defined(&IOPB_RES_ADDR_3D);
    eval 'sub IOPB_RES_ADDR_3E () {0x3e;}' unless defined(&IOPB_RES_ADDR_3E);
    eval 'sub IOPB_RES_ADDR_3F () {0x3f;}' unless defined(&IOPB_RES_ADDR_3F);
    eval 'sub IOPW_CHIP_ID_0 () {0x00;}' unless defined(&IOPW_CHIP_ID_0);
    eval 'sub IOPW_CTRL_REG () {0x02;}' unless defined(&IOPW_CTRL_REG);
    eval 'sub IOPW_RAM_ADDR () {0x04;}' unless defined(&IOPW_RAM_ADDR);
    eval 'sub IOPW_RAM_DATA () {0x06;}' unless defined(&IOPW_RAM_DATA);
    eval 'sub IOPW_RES_ADDR_08 () {0x08;}' unless defined(&IOPW_RES_ADDR_08);
    eval 'sub IOPW_RISC_CSR () {0x0a;}' unless defined(&IOPW_RISC_CSR);
    eval 'sub IOPW_SCSI_CFG0 () {0x0c;}' unless defined(&IOPW_SCSI_CFG0);
    eval 'sub IOPW_SCSI_CFG1 () {0x0e;}' unless defined(&IOPW_SCSI_CFG1);
    eval 'sub IOPW_RES_ADDR_10 () {0x10;}' unless defined(&IOPW_RES_ADDR_10);
    eval 'sub IOPW_SEL_MASK () {0x12;}' unless defined(&IOPW_SEL_MASK);
    eval 'sub IOPW_RES_ADDR_14 () {0x14;}' unless defined(&IOPW_RES_ADDR_14);
    eval 'sub IOPW_FLASH_ADDR () {0x16;}' unless defined(&IOPW_FLASH_ADDR);
    eval 'sub IOPW_RES_ADDR_18 () {0x18;}' unless defined(&IOPW_RES_ADDR_18);
    eval 'sub IOPW_EE_CMD () {0x1a;}' unless defined(&IOPW_EE_CMD);
    eval 'sub IOPW_EE_DATA () {0x1c;}' unless defined(&IOPW_EE_DATA);
    eval 'sub IOPW_SFIFO_CNT () {0x1e;}' unless defined(&IOPW_SFIFO_CNT);
    eval 'sub IOPW_RES_ADDR_20 () {0x20;}' unless defined(&IOPW_RES_ADDR_20);
    eval 'sub IOPW_Q_BASE () {0x22;}' unless defined(&IOPW_Q_BASE);
    eval 'sub IOPW_QP () {0x24;}' unless defined(&IOPW_QP);
    eval 'sub IOPW_IX () {0x26;}' unless defined(&IOPW_IX);
    eval 'sub IOPW_SP () {0x28;}' unless defined(&IOPW_SP);
    eval 'sub IOPW_PC () {0x2a;}' unless defined(&IOPW_PC);
    eval 'sub IOPW_RES_ADDR_2C () {0x2c;}' unless defined(&IOPW_RES_ADDR_2C);
    eval 'sub IOPW_RES_ADDR_2E () {0x2e;}' unless defined(&IOPW_RES_ADDR_2E);
    eval 'sub IOPW_SCSI_DATA () {0x30;}' unless defined(&IOPW_SCSI_DATA);
    eval 'sub IOPW_SCSI_DATA_HSHK () {0x32;}' unless defined(&IOPW_SCSI_DATA_HSHK);
    eval 'sub IOPW_SCSI_CTRL () {0x34;}' unless defined(&IOPW_SCSI_CTRL);
    eval 'sub IOPW_HSHK_CFG () {0x36;}' unless defined(&IOPW_HSHK_CFG);
    eval 'sub IOPW_SXFR_STATUS () {0x36;}' unless defined(&IOPW_SXFR_STATUS);
    eval 'sub IOPW_SXFR_CNTL () {0x38;}' unless defined(&IOPW_SXFR_CNTL);
    eval 'sub IOPW_SXFR_CNTH () {0x3a;}' unless defined(&IOPW_SXFR_CNTH);
    eval 'sub IOPW_RES_ADDR_3C () {0x3c;}' unless defined(&IOPW_RES_ADDR_3C);
    eval 'sub IOPW_RFIFO_DATA () {0x3e;}' unless defined(&IOPW_RFIFO_DATA);
    eval 'sub IOPDW_RES_ADDR_0 () {0x00;}' unless defined(&IOPDW_RES_ADDR_0);
    eval 'sub IOPDW_RAM_DATA () {0x04;}' unless defined(&IOPDW_RAM_DATA);
    eval 'sub IOPDW_RES_ADDR_8 () {0x08;}' unless defined(&IOPDW_RES_ADDR_8);
    eval 'sub IOPDW_RES_ADDR_C () {0x0c;}' unless defined(&IOPDW_RES_ADDR_C);
    eval 'sub IOPDW_RES_ADDR_10 () {0x10;}' unless defined(&IOPDW_RES_ADDR_10);
    eval 'sub IOPDW_COMMA () {0x14;}' unless defined(&IOPDW_COMMA);
    eval 'sub IOPDW_COMMB () {0x18;}' unless defined(&IOPDW_COMMB);
    eval 'sub IOPDW_RES_ADDR_1C () {0x1c;}' unless defined(&IOPDW_RES_ADDR_1C);
    eval 'sub IOPDW_SDMA_ADDR0 () {0x20;}' unless defined(&IOPDW_SDMA_ADDR0);
    eval 'sub IOPDW_SDMA_ADDR1 () {0x24;}' unless defined(&IOPDW_SDMA_ADDR1);
    eval 'sub IOPDW_SDMA_COUNT () {0x28;}' unless defined(&IOPDW_SDMA_COUNT);
    eval 'sub IOPDW_SDMA_ERROR () {0x2c;}' unless defined(&IOPDW_SDMA_ERROR);
    eval 'sub IOPDW_RDMA_ADDR0 () {0x30;}' unless defined(&IOPDW_RDMA_ADDR0);
    eval 'sub IOPDW_RDMA_ADDR1 () {0x34;}' unless defined(&IOPDW_RDMA_ADDR1);
    eval 'sub IOPDW_RDMA_COUNT () {0x38;}' unless defined(&IOPDW_RDMA_COUNT);
    eval 'sub IOPDW_RDMA_ERROR () {0x3c;}' unless defined(&IOPDW_RDMA_ERROR);
    eval 'sub ADW_CHIP_ID_BYTE () {0x25;}' unless defined(&ADW_CHIP_ID_BYTE);
    eval 'sub ADW_CHIP_ID_WORD () {0x04c1;}' unless defined(&ADW_CHIP_ID_WORD);
    eval 'sub ADW_SC_SCSI_BUS_RESET () {0x2000;}' unless defined(&ADW_SC_SCSI_BUS_RESET);
    eval 'sub ADW_INTR_ENABLE_HOST_INTR () {0x01;}' unless defined(&ADW_INTR_ENABLE_HOST_INTR);
    eval 'sub ADW_INTR_ENABLE_SEL_INTR () {0x02;}' unless defined(&ADW_INTR_ENABLE_SEL_INTR);
    eval 'sub ADW_INTR_ENABLE_DPR_INTR () {0x04;}' unless defined(&ADW_INTR_ENABLE_DPR_INTR);
    eval 'sub ADW_INTR_ENABLE_RTA_INTR () {0x08;}' unless defined(&ADW_INTR_ENABLE_RTA_INTR);
    eval 'sub ADW_INTR_ENABLE_RMA_INTR () {0x10;}' unless defined(&ADW_INTR_ENABLE_RMA_INTR);
    eval 'sub ADW_INTR_ENABLE_RST_INTR () {0x20;}' unless defined(&ADW_INTR_ENABLE_RST_INTR);
    eval 'sub ADW_INTR_ENABLE_DPE_INTR () {0x40;}' unless defined(&ADW_INTR_ENABLE_DPE_INTR);
    eval 'sub ADW_INTR_ENABLE_GLOBAL_INTR () {0x80;}' unless defined(&ADW_INTR_ENABLE_GLOBAL_INTR);
    eval 'sub ADW_INTR_STATUS_INTRA () {0x01;}' unless defined(&ADW_INTR_STATUS_INTRA);
    eval 'sub ADW_INTR_STATUS_INTRB () {0x02;}' unless defined(&ADW_INTR_STATUS_INTRB);
    eval 'sub ADW_INTR_STATUS_INTRC () {0x04;}' unless defined(&ADW_INTR_STATUS_INTRC);
    eval 'sub ADW_RISC_CSR_STOP () {(0x0000);}' unless defined(&ADW_RISC_CSR_STOP);
    eval 'sub ADW_RISC_TEST_COND () {(0x2000);}' unless defined(&ADW_RISC_TEST_COND);
    eval 'sub ADW_RISC_CSR_RUN () {(0x4000);}' unless defined(&ADW_RISC_CSR_RUN);
    eval 'sub ADW_RISC_CSR_SINGLE_STEP () {(0x8000);}' unless defined(&ADW_RISC_CSR_SINGLE_STEP);
    eval 'sub ADW_CTRL_REG_HOST_INTR () {0x0100;}' unless defined(&ADW_CTRL_REG_HOST_INTR);
    eval 'sub ADW_CTRL_REG_SEL_INTR () {0x0200;}' unless defined(&ADW_CTRL_REG_SEL_INTR);
    eval 'sub ADW_CTRL_REG_DPR_INTR () {0x0400;}' unless defined(&ADW_CTRL_REG_DPR_INTR);
    eval 'sub ADW_CTRL_REG_RTA_INTR () {0x0800;}' unless defined(&ADW_CTRL_REG_RTA_INTR);
    eval 'sub ADW_CTRL_REG_RMA_INTR () {0x1000;}' unless defined(&ADW_CTRL_REG_RMA_INTR);
    eval 'sub ADW_CTRL_REG_RES_BIT14 () {0x2000;}' unless defined(&ADW_CTRL_REG_RES_BIT14);
    eval 'sub ADW_CTRL_REG_DPE_INTR () {0x4000;}' unless defined(&ADW_CTRL_REG_DPE_INTR);
    eval 'sub ADW_CTRL_REG_POWER_DONE () {0x8000;}' unless defined(&ADW_CTRL_REG_POWER_DONE);
    eval 'sub ADW_CTRL_REG_ANY_INTR () {0xff00;}' unless defined(&ADW_CTRL_REG_ANY_INTR);
    eval 'sub ADW_CTRL_REG_CMD_RESET () {0x00c6;}' unless defined(&ADW_CTRL_REG_CMD_RESET);
    eval 'sub ADW_CTRL_REG_CMD_WR_IO_REG () {0x00c5;}' unless defined(&ADW_CTRL_REG_CMD_WR_IO_REG);
    eval 'sub ADW_CTRL_REG_CMD_RD_IO_REG () {0x00c4;}' unless defined(&ADW_CTRL_REG_CMD_RD_IO_REG);
    eval 'sub ADW_CTRL_REG_CMD_WR_PCI_CFG_SPACE () {0x00c3;}' unless defined(&ADW_CTRL_REG_CMD_WR_PCI_CFG_SPACE);
    eval 'sub ADW_CTRL_REG_CMD_RD_PCI_CFG_SPACE () {0x00c2;}' unless defined(&ADW_CTRL_REG_CMD_RD_PCI_CFG_SPACE);
    eval 'sub ADW_TICKLE_NOP () {0x00;}' unless defined(&ADW_TICKLE_NOP);
    eval 'sub ADW_TICKLE_A () {0x01;}' unless defined(&ADW_TICKLE_A);
    eval 'sub ADW_TICKLE_B () {0x02;}' unless defined(&ADW_TICKLE_B);
    eval 'sub ADW_TICKLE_C () {0x03;}' unless defined(&ADW_TICKLE_C);
    eval 'sub ADW_SCSI_CTRL_RSTOUT () {0x2000;}' unless defined(&ADW_SCSI_CTRL_RSTOUT);
    eval 'sub ADW_IS_INT_PENDING {
        local($iot, $ioh) = @_;
	    eval q(( &ADW_READ_WORD_REGISTER(($iot), ($ioh),  &IOPW_CTRL_REG) &  &ADW_CTRL_REG_HOST_INTR));
    }' unless defined(&ADW_IS_INT_PENDING);
    eval 'sub ADW_TIMER_MODEAB () {0xc000;}' unless defined(&ADW_TIMER_MODEAB);
    eval 'sub ADW_PARITY_EN () {0x2000;}' unless defined(&ADW_PARITY_EN);
    eval 'sub ADW_EVEN_PARITY () {0x1000;}' unless defined(&ADW_EVEN_PARITY);
    eval 'sub ADW_WD_LONG () {0x0800;}' unless defined(&ADW_WD_LONG);
    eval 'sub ADW_QUEUE_128 () {0x0400;}' unless defined(&ADW_QUEUE_128);
    eval 'sub ADW_PRIM_MODE () {0x0100;}' unless defined(&ADW_PRIM_MODE);
    eval 'sub ADW_SCAM_EN () {0x0080;}' unless defined(&ADW_SCAM_EN);
    eval 'sub ADW_SEL_TMO_LONG () {0x0040;}' unless defined(&ADW_SEL_TMO_LONG);
    eval 'sub ADW_CFRM_ID () {0x0020;}' unless defined(&ADW_CFRM_ID);
    eval 'sub ADW_OUR_ID_EN () {0x0010;}' unless defined(&ADW_OUR_ID_EN);
    eval 'sub ADW_OUR_ID () {0x000f;}' unless defined(&ADW_OUR_ID);
    eval 'sub ADW_BIG_ENDIAN () {0x8000;}' unless defined(&ADW_BIG_ENDIAN);
    eval 'sub ADW_TERM_POL () {0x2000;}' unless defined(&ADW_TERM_POL);
    eval 'sub ADW_SLEW_RATE () {0x1000;}' unless defined(&ADW_SLEW_RATE);
    eval 'sub ADW_FILTER_SEL () {0x0c00;}' unless defined(&ADW_FILTER_SEL);
    eval 'sub ADW_FLTR_DISABLE () {0x0000;}' unless defined(&ADW_FLTR_DISABLE);
    eval 'sub ADW_FLTR_11_TO_20NS () {0x0800;}' unless defined(&ADW_FLTR_11_TO_20NS);
    eval 'sub ADW_FLTR_21_TO_39NS () {0x0c00;}' unless defined(&ADW_FLTR_21_TO_39NS);
    eval 'sub ADW_ACTIVE_DBL () {0x0200;}' unless defined(&ADW_ACTIVE_DBL);
    eval 'sub ADW_DIFF_MODE () {0x0100;}' unless defined(&ADW_DIFF_MODE);
    eval 'sub ADW_DIFF_SENSE () {0x0080;}' unless defined(&ADW_DIFF_SENSE);
    eval 'sub ADW_TERM_CTL_SEL () {0x0040;}' unless defined(&ADW_TERM_CTL_SEL);
    eval 'sub ADW_TERM_CTL () {0x0030;}' unless defined(&ADW_TERM_CTL);
    eval 'sub ADW_TERM_CTL_H () {0x0020;}' unless defined(&ADW_TERM_CTL_H);
    eval 'sub ADW_TERM_CTL_L () {0x0010;}' unless defined(&ADW_TERM_CTL_L);
    eval 'sub ADW_CABLE_DETECT () {0x000f;}' unless defined(&ADW_CABLE_DETECT);
    eval 'sub ADW_DIS_TERM_DRV () {0x4000;}' unless defined(&ADW_DIS_TERM_DRV);
    eval 'sub ADW_HVD_LVD_SE () {0x1c00;}' unless defined(&ADW_HVD_LVD_SE);
    eval 'sub ADW_HVD () {0x1000;}' unless defined(&ADW_HVD);
    eval 'sub ADW_LVD () {0x0800;}' unless defined(&ADW_LVD);
    eval 'sub ADW_SE () {0x0400;}' unless defined(&ADW_SE);
    eval 'sub ADW_TERM_LVD () {0x00c0;}' unless defined(&ADW_TERM_LVD);
    eval 'sub ADW_TERM_LVD_HI () {0x0080;}' unless defined(&ADW_TERM_LVD_HI);
    eval 'sub ADW_TERM_LVD_LO () {0x0040;}' unless defined(&ADW_TERM_LVD_LO);
    eval 'sub ADW_TERM_SE () {0x0030;}' unless defined(&ADW_TERM_SE);
    eval 'sub ADW_TERM_SE_HI () {0x0020;}' unless defined(&ADW_TERM_SE_HI);
    eval 'sub ADW_TERM_SE_LO () {0x0010;}' unless defined(&ADW_TERM_SE_LO);
    eval 'sub ADW_C_DET_LVD () {0x000c;}' unless defined(&ADW_C_DET_LVD);
    eval 'sub ADW_C_DET3 () {0x0008;}' unless defined(&ADW_C_DET3);
    eval 'sub ADW_C_DET2 () {0x0004;}' unless defined(&ADW_C_DET2);
    eval 'sub ADW_C_DET_SE () {0x0003;}' unless defined(&ADW_C_DET_SE);
    eval 'sub ADW_C_DET1 () {0x0002;}' unless defined(&ADW_C_DET1);
    eval 'sub ADW_C_DET0 () {0x0001;}' unless defined(&ADW_C_DET0);
    eval 'sub CABLE_ILLEGAL_A () {0x7;}' unless defined(&CABLE_ILLEGAL_A);
    eval 'sub CABLE_ILLEGAL_B () {0xb;}' unless defined(&CABLE_ILLEGAL_B);
    eval 'sub ADW_BIOS_EN () {0x40;}' unless defined(&ADW_BIOS_EN);
    eval 'sub ADW_FAST_EE_CLK () {0x20;}' unless defined(&ADW_FAST_EE_CLK);
    eval 'sub ADW_RAM_SZ () {0x1c;}' unless defined(&ADW_RAM_SZ);
    eval 'sub ADW_RAM_SZ_2KB () {0x00;}' unless defined(&ADW_RAM_SZ_2KB);
    eval 'sub ADW_RAM_SZ_4KB () {0x04;}' unless defined(&ADW_RAM_SZ_4KB);
    eval 'sub ADW_RAM_SZ_8KB () {0x08;}' unless defined(&ADW_RAM_SZ_8KB);
    eval 'sub ADW_RAM_SZ_16KB () {0x0c;}' unless defined(&ADW_RAM_SZ_16KB);
    eval 'sub ADW_RAM_SZ_32KB () {0x10;}' unless defined(&ADW_RAM_SZ_32KB);
    eval 'sub ADW_RAM_SZ_64KB () {0x14;}' unless defined(&ADW_RAM_SZ_64KB);
    eval 'sub BC_THRESH_ENB () {0x80;}' unless defined(&BC_THRESH_ENB);
    eval 'sub FIFO_THRESH () {0x70;}' unless defined(&FIFO_THRESH);
    eval 'sub FIFO_THRESH_16B () {0x00;}' unless defined(&FIFO_THRESH_16B);
    eval 'sub FIFO_THRESH_32B () {0x20;}' unless defined(&FIFO_THRESH_32B);
    eval 'sub FIFO_THRESH_48B () {0x30;}' unless defined(&FIFO_THRESH_48B);
    eval 'sub FIFO_THRESH_64B () {0x40;}' unless defined(&FIFO_THRESH_64B);
    eval 'sub FIFO_THRESH_80B () {0x50;}' unless defined(&FIFO_THRESH_80B);
    eval 'sub FIFO_THRESH_96B () {0x60;}' unless defined(&FIFO_THRESH_96B);
    eval 'sub FIFO_THRESH_112B () {0x70;}' unless defined(&FIFO_THRESH_112B);
    eval 'sub START_CTL () {0x0c;}' unless defined(&START_CTL);
    eval 'sub START_CTL_TH () {0x00;}' unless defined(&START_CTL_TH);
    eval 'sub START_CTL_ID () {0x04;}' unless defined(&START_CTL_ID);
    eval 'sub START_CTL_THID () {0x08;}' unless defined(&START_CTL_THID);
    eval 'sub START_CTL_EMFU () {0x0c;}' unless defined(&START_CTL_EMFU);
    eval 'sub READ_CMD () {0x03;}' unless defined(&READ_CMD);
    eval 'sub READ_CMD_MR () {0x00;}' unless defined(&READ_CMD_MR);
    eval 'sub READ_CMD_MRL () {0x02;}' unless defined(&READ_CMD_MRL);
    eval 'sub READ_CMD_MRM () {0x03;}' unless defined(&READ_CMD_MRM);
    eval 'sub RAM_TEST_MODE () {0x80;}' unless defined(&RAM_TEST_MODE);
    eval 'sub PRE_TEST_MODE () {0x40;}' unless defined(&PRE_TEST_MODE);
    eval 'sub NORMAL_MODE () {0x00;}' unless defined(&NORMAL_MODE);
    eval 'sub RAM_TEST_DONE () {0x10;}' unless defined(&RAM_TEST_DONE);
    eval 'sub RAM_TEST_STATUS () {0x0f;}' unless defined(&RAM_TEST_STATUS);
    eval 'sub RAM_TEST_HOST_ERROR () {0x08;}' unless defined(&RAM_TEST_HOST_ERROR);
    eval 'sub RAM_TEST_INTRAM_ERROR () {0x04;}' unless defined(&RAM_TEST_INTRAM_ERROR);
    eval 'sub RAM_TEST_RISC_ERROR () {0x02;}' unless defined(&RAM_TEST_RISC_ERROR);
    eval 'sub RAM_TEST_SCSI_ERROR () {0x01;}' unless defined(&RAM_TEST_SCSI_ERROR);
    eval 'sub RAM_TEST_SUCCESS () {0x00;}' unless defined(&RAM_TEST_SUCCESS);
    eval 'sub PRE_TEST_VALUE () {0x05;}' unless defined(&PRE_TEST_VALUE);
    eval 'sub NORMAL_VALUE () {0x00;}' unless defined(&NORMAL_VALUE);
    eval 'sub INTAB_LD () {0x80;}' unless defined(&INTAB_LD);
    eval 'sub TOTEMPOLE () {0x02;}' unless defined(&TOTEMPOLE);
    eval 'sub INTAB () {0x01;}' unless defined(&INTAB);
    eval 'sub ADW_MAX_TID () {15;}' unless defined(&ADW_MAX_TID);
    eval 'sub ADW_MAX_LUN () {7;}' unless defined(&ADW_MAX_LUN);
    eval 'sub ADW_TRUE () {1;}' unless defined(&ADW_TRUE);
    eval 'sub ADW_FALSE () {0;}' unless defined(&ADW_FALSE);
    eval 'sub ADW_NOERROR () {1;}' unless defined(&ADW_NOERROR);
    eval 'sub ADW_SUCCESS () {1;}' unless defined(&ADW_SUCCESS);
    eval 'sub ADW_BUSY () {0;}' unless defined(&ADW_BUSY);
    eval 'sub ADW_ERROR () {(-1);}' unless defined(&ADW_ERROR);
    eval 'sub ADW_WARN_BUSRESET_ERROR () {0x0001;}' unless defined(&ADW_WARN_BUSRESET_ERROR);
    eval 'sub ADW_WARN_EEPROM_CHKSUM () {0x0002;}' unless defined(&ADW_WARN_EEPROM_CHKSUM);
    eval 'sub ADW_WARN_EEPROM_TERMINATION () {0x0004;}' unless defined(&ADW_WARN_EEPROM_TERMINATION);
    eval 'sub ADW_WARN_SET_PCI_CONFIG_SPACE () {0x0080;}' unless defined(&ADW_WARN_SET_PCI_CONFIG_SPACE);
    eval 'sub ADW_WARN_ERROR () {0xffff;}' unless defined(&ADW_WARN_ERROR);
    eval 'sub ADW_IERR_WRITE_EEPROM () {0x0001;}' unless defined(&ADW_IERR_WRITE_EEPROM);
    eval 'sub ADW_IERR_MCODE_CHKSUM () {0x0002;}' unless defined(&ADW_IERR_MCODE_CHKSUM);
    eval 'sub ADW_IERR_NO_CARRIER () {0x0004;}' unless defined(&ADW_IERR_NO_CARRIER);
    eval 'sub ADW_IERR_START_STOP_CHIP () {0x0008;}' unless defined(&ADW_IERR_START_STOP_CHIP);
    eval 'sub ADW_IERR_CHIP_VERSION () {0x0040;}' unless defined(&ADW_IERR_CHIP_VERSION);
    eval 'sub ADW_IERR_SET_SCSI_ID () {0x0080;}' unless defined(&ADW_IERR_SET_SCSI_ID);
    eval 'sub ADW_IERR_HVD_DEVICE () {0x0100;}' unless defined(&ADW_IERR_HVD_DEVICE);
    eval 'sub ADW_IERR_BAD_SIGNATURE () {0x0200;}' unless defined(&ADW_IERR_BAD_SIGNATURE);
    eval 'sub ADW_IERR_ILLEGAL_CONNECTION () {0x0400;}' unless defined(&ADW_IERR_ILLEGAL_CONNECTION);
    eval 'sub ADW_IERR_SINGLE_END_DEVICE () {0x0800;}' unless defined(&ADW_IERR_SINGLE_END_DEVICE);
    eval 'sub ADW_IERR_REVERSED_CABLE () {0x1000;}' unless defined(&ADW_IERR_REVERSED_CABLE);
    eval 'sub ADW_IERR_BIST_PRE_TEST () {0x2000;}' unless defined(&ADW_IERR_BIST_PRE_TEST);
    eval 'sub ADW_IERR_BIST_RAM_TEST () {0x4000;}' unless defined(&ADW_IERR_BIST_RAM_TEST);
    eval 'sub ADW_IERR_BAD_CHIPTYPE () {0x8000;}' unless defined(&ADW_IERR_BAD_CHIPTYPE);
    eval 'sub BIOS_CODESEG () {0x54;}' unless defined(&BIOS_CODESEG);
    eval 'sub BIOS_CODELEN () {0x56;}' unless defined(&BIOS_CODELEN);
    eval 'sub BIOS_SIGNATURE () {0x58;}' unless defined(&BIOS_SIGNATURE);
    eval 'sub BIOS_VERSION () {0x5a;}' unless defined(&BIOS_VERSION);
    eval 'sub ADW_CHIP_ASC3550 () {0x01;}' unless defined(&ADW_CHIP_ASC3550);
    eval 'sub ADW_CHIP_ASC38C0800 () {0x02;}' unless defined(&ADW_CHIP_ASC38C0800);
    eval 'sub ADW_CHIP_ASC38C1600 () {0x03;}' unless defined(&ADW_CHIP_ASC38C1600);
    eval 'sub NO_OF_SG_PER_BLOCK () {15;}' unless defined(&NO_OF_SG_PER_BLOCK);
    eval 'sub CCB_HASH_SIZE () {32;}' unless defined(&CCB_HASH_SIZE);
    eval 'sub CCB_HASH_SHIFT () {9;}' unless defined(&CCB_HASH_SHIFT);
    eval 'sub CCB_HASH {
        local($x) = @_;
	    eval q((((($x)) >>  &CCB_HASH_SHIFT) & ( &CCB_HASH_SIZE - 1)));
    }' unless defined(&CCB_HASH);
    eval 'sub QD_NO_STATUS () {0x00;}' unless defined(&QD_NO_STATUS);
    eval 'sub QD_NO_ERROR () {0x01;}' unless defined(&QD_NO_ERROR);
    eval 'sub QD_ABORTED_BY_HOST () {0x02;}' unless defined(&QD_ABORTED_BY_HOST);
    eval 'sub QD_WITH_ERROR () {0x04;}' unless defined(&QD_WITH_ERROR);
    eval 'sub QHSTA_NO_ERROR () {0x00;}' unless defined(&QHSTA_NO_ERROR);
    eval 'sub QHSTA_M_SEL_TIMEOUT () {0x11;}' unless defined(&QHSTA_M_SEL_TIMEOUT);
    eval 'sub QHSTA_M_DATA_OVER_RUN () {0x12;}' unless defined(&QHSTA_M_DATA_OVER_RUN);
    eval 'sub QHSTA_M_UNEXPECTED_BUS_FREE () {0x13;}' unless defined(&QHSTA_M_UNEXPECTED_BUS_FREE);
    eval 'sub QHSTA_M_QUEUE_ABORTED () {0x15;}' unless defined(&QHSTA_M_QUEUE_ABORTED);
    eval 'sub QHSTA_M_SXFR_SDMA_ERR () {0x16;}' unless defined(&QHSTA_M_SXFR_SDMA_ERR);
    eval 'sub QHSTA_M_SXFR_SXFR_PERR () {0x17;}' unless defined(&QHSTA_M_SXFR_SXFR_PERR);
    eval 'sub QHSTA_M_RDMA_PERR () {0x18;}' unless defined(&QHSTA_M_RDMA_PERR);
    eval 'sub QHSTA_M_SXFR_OFF_UFLW () {0x19;}' unless defined(&QHSTA_M_SXFR_OFF_UFLW);
    eval 'sub QHSTA_M_SXFR_OFF_OFLW () {0x20;}' unless defined(&QHSTA_M_SXFR_OFF_OFLW);
    eval 'sub QHSTA_M_SXFR_WD_TMO () {0x21;}' unless defined(&QHSTA_M_SXFR_WD_TMO);
    eval 'sub QHSTA_M_SXFR_DESELECTED () {0x22;}' unless defined(&QHSTA_M_SXFR_DESELECTED);
    eval 'sub QHSTA_M_SXFR_XFR_OFLW () {0x12;}' unless defined(&QHSTA_M_SXFR_XFR_OFLW);
    eval 'sub QHSTA_M_SXFR_XFR_PH_ERR () {0x24;}' unless defined(&QHSTA_M_SXFR_XFR_PH_ERR);
    eval 'sub QHSTA_M_SXFR_UNKNOWN_ERROR () {0x25;}' unless defined(&QHSTA_M_SXFR_UNKNOWN_ERROR);
    eval 'sub QHSTA_M_SCSI_BUS_RESET () {0x30;}' unless defined(&QHSTA_M_SCSI_BUS_RESET);
    eval 'sub QHSTA_M_SCSI_BUS_RESET_UNSOL () {0x31;}' unless defined(&QHSTA_M_SCSI_BUS_RESET_UNSOL);
    eval 'sub QHSTA_M_BUS_DEVICE_RESET () {0x32;}' unless defined(&QHSTA_M_BUS_DEVICE_RESET);
    eval 'sub QHSTA_M_DIRECTION_ERR () {0x35;}' unless defined(&QHSTA_M_DIRECTION_ERR);
    eval 'sub QHSTA_M_DIRECTION_ERR_HUNG () {0x36;}' unless defined(&QHSTA_M_DIRECTION_ERR_HUNG);
    eval 'sub QHSTA_M_WTM_TIMEOUT () {0x41;}' unless defined(&QHSTA_M_WTM_TIMEOUT);
    eval 'sub QHSTA_M_BAD_CMPL_STATUS_IN () {0x42;}' unless defined(&QHSTA_M_BAD_CMPL_STATUS_IN);
    eval 'sub QHSTA_M_NO_AUTO_REQ_SENSE () {0x43;}' unless defined(&QHSTA_M_NO_AUTO_REQ_SENSE);
    eval 'sub QHSTA_M_AUTO_REQ_SENSE_FAIL () {0x44;}' unless defined(&QHSTA_M_AUTO_REQ_SENSE_FAIL);
    eval 'sub QHSTA_M_INVALID_DEVICE () {0x45;}' unless defined(&QHSTA_M_INVALID_DEVICE);
    eval 'sub QHSTA_M_FROZEN_TIDQ () {0x46;}' unless defined(&QHSTA_M_FROZEN_TIDQ);
    eval 'sub QHSTA_M_SGBACKUP_ERROR () {0x47;}' unless defined(&QHSTA_M_SGBACKUP_ERROR);
    eval 'sub SCSI_STATUS_GOOD () {0x00;}' unless defined(&SCSI_STATUS_GOOD);
    eval 'sub SCSI_STATUS_CHECK_CONDITION () {0x02;}' unless defined(&SCSI_STATUS_CHECK_CONDITION);
    eval 'sub SCSI_STATUS_CONDITION_MET () {0x04;}' unless defined(&SCSI_STATUS_CONDITION_MET);
    eval 'sub SCSI_STATUS_TARGET_BUSY () {0x08;}' unless defined(&SCSI_STATUS_TARGET_BUSY);
    eval 'sub SCSI_STATUS_INTERMID () {0x10;}' unless defined(&SCSI_STATUS_INTERMID);
    eval 'sub SCSI_STATUS_INTERMID_COND_MET () {0x14;}' unless defined(&SCSI_STATUS_INTERMID_COND_MET);
    eval 'sub SCSI_STATUS_RSERV_CONFLICT () {0x18;}' unless defined(&SCSI_STATUS_RSERV_CONFLICT);
    eval 'sub SCSI_STATUS_CMD_TERMINATED () {0x22;}' unless defined(&SCSI_STATUS_CMD_TERMINATED);
    eval 'sub SCSI_STATUS_QUEUE_FULL () {0x28;}' unless defined(&SCSI_STATUS_QUEUE_FULL);
    eval 'sub SCSI_STATUS_ACA_ACTIVE () {0x30;}' unless defined(&SCSI_STATUS_ACA_ACTIVE);
    eval 'sub IDLE_CMD_COMPLETED () {0;}' unless defined(&IDLE_CMD_COMPLETED);
    eval 'sub IDLE_CMD_STOP_CHIP () {0x0001;}' unless defined(&IDLE_CMD_STOP_CHIP);
    eval 'sub IDLE_CMD_STOP_CHIP_SEND_INT () {0x0002;}' unless defined(&IDLE_CMD_STOP_CHIP_SEND_INT);
    eval 'sub IDLE_CMD_SEND_INT () {0x0004;}' unless defined(&IDLE_CMD_SEND_INT);
    eval 'sub IDLE_CMD_ABORT () {0x0008;}' unless defined(&IDLE_CMD_ABORT);
    eval 'sub IDLE_CMD_DEVICE_RESET () {0x0010;}' unless defined(&IDLE_CMD_DEVICE_RESET);
    eval 'sub IDLE_CMD_SCSI_RESET_START () {0x0020;}' unless defined(&IDLE_CMD_SCSI_RESET_START);
    eval 'sub IDLE_CMD_SCSI_RESET_END () {0x0040;}' unless defined(&IDLE_CMD_SCSI_RESET_END);
    eval 'sub IDLE_CMD_SCSIREQ () {0x0080;}' unless defined(&IDLE_CMD_SCSIREQ);
    eval 'sub IDLE_CMD_STATUS_SUCCESS () {0x0001;}' unless defined(&IDLE_CMD_STATUS_SUCCESS);
    eval 'sub IDLE_CMD_STATUS_FAILURE () {0x0002;}' unless defined(&IDLE_CMD_STATUS_FAILURE);
    eval 'sub ADW_NOWAIT () {0x01;}' unless defined(&ADW_NOWAIT);
    eval 'sub SCSI_WAIT_10_SEC () {10;}' unless defined(&SCSI_WAIT_10_SEC);
    eval 'sub SCSI_WAIT_100_MSEC () {100;}' unless defined(&SCSI_WAIT_100_MSEC);
    eval 'sub SCSI_US_PER_MSEC () {1000;}' unless defined(&SCSI_US_PER_MSEC);
    eval 'sub SCSI_MS_PER_SEC () {1000;}' unless defined(&SCSI_MS_PER_SEC);
    eval 'sub SCSI_MAX_RETRY () {10;}' unless defined(&SCSI_MAX_RETRY);
    eval 'sub ADW_ASYNC_RDMA_FAILURE () {0x01;}' unless defined(&ADW_ASYNC_RDMA_FAILURE);
    eval 'sub ADW_ASYNC_SCSI_BUS_RESET_DET () {0x02;}' unless defined(&ADW_ASYNC_SCSI_BUS_RESET_DET);
    eval 'sub ADW_ASYNC_CARRIER_READY_FAILURE () {0x03;}' unless defined(&ADW_ASYNC_CARRIER_READY_FAILURE);
    eval 'sub ADW_HOST_SCSI_BUS_RESET () {0x80;}' unless defined(&ADW_HOST_SCSI_BUS_RESET);
    eval 'sub ADW_READ_BYTE_REGISTER {
        local($iot, $ioh, $reg_off) = @_;
	    eval q( &bus_space_read_1(($iot), ($ioh), ($reg_off)));
    }' unless defined(&ADW_READ_BYTE_REGISTER);
    eval 'sub ADW_WRITE_BYTE_REGISTER {
        local($iot, $ioh, $reg_off, $byte) = @_;
	    eval q( &bus_space_write_1(($iot), ($ioh), ($reg_off), ($byte)));
    }' unless defined(&ADW_WRITE_BYTE_REGISTER);
    eval 'sub ADW_READ_WORD_REGISTER {
        local($iot, $ioh, $reg_off) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh), ($reg_off)));
    }' unless defined(&ADW_READ_WORD_REGISTER);
    eval 'sub ADW_WRITE_WORD_REGISTER {
        local($iot, $ioh, $reg_off, $word) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh), ($reg_off), ($word)));
    }' unless defined(&ADW_WRITE_WORD_REGISTER);
    eval 'sub ADW_WRITE_DWORD_REGISTER {
        local($iot, $ioh, $reg_off, $dword) = @_;
	    eval q( &bus_space_write_4(($iot), ($ioh), ($reg_off), ($dword)));
    }' unless defined(&ADW_WRITE_DWORD_REGISTER);
    eval 'sub ADW_READ_BYTE_LRAM {
        local($iot, $ioh, $addr, $byte) = @_;
	    eval q( &do {  &bus_space_write_2(($iot), ($ioh),  &IOPW_RAM_ADDR, ($addr)); ($byte) =  &bus_space_read_1(($iot), ($ioh),  &IOPB_RAM_DATA); }  &while (0));
    }' unless defined(&ADW_READ_BYTE_LRAM);
    eval 'sub ADW_WRITE_BYTE_LRAM {
        local($iot, $ioh, $addr, $byte) = @_;
	    eval q( &do {  &bus_space_write_2(($iot), ($ioh),  &IOPW_RAM_ADDR, ($addr));  &bus_space_write_1(($iot), ($ioh),  &IOPB_RAM_DATA, ($byte)); }  &while (0));
    }' unless defined(&ADW_WRITE_BYTE_LRAM);
    eval 'sub ADW_READ_WORD_LRAM {
        local($iot, $ioh, $addr, $word) = @_;
	    eval q( &do {  &bus_space_write_2(($iot), ($ioh),  &IOPW_RAM_ADDR, ($addr)); ($word) =  &bus_space_read_2(($iot), ($ioh),  &IOPW_RAM_DATA); }  &while (0));
    }' unless defined(&ADW_READ_WORD_LRAM);
    eval 'sub ADW_WRITE_WORD_LRAM {
        local($iot, $ioh, $addr, $word) = @_;
	    eval q( &do {  &bus_space_write_2(($iot), ($ioh),  &IOPW_RAM_ADDR, ($addr));  &bus_space_write_2(($iot), ($ioh),  &IOPW_RAM_DATA, ($word)); }  &while (0));
    }' unless defined(&ADW_WRITE_WORD_LRAM);
    eval 'sub ADW_WRITE_DWORD_LRAM {
        local($iot, $ioh, $addr, $dword) = @_;
	    eval q( &do {  &bus_space_write_2(, ,  &IOPW_RAM_ADDR, );  &bus_space_write_2(, ,  &IOPW_RAM_DATA, ( & 0xffff));  &bus_space_write_2(, ,  &IOPW_RAM_ADDR, + 2);  &bus_space_write_2(, ,  &IOPW_RAM_DATA, (($dword >> 16) & 0xffff)); }  &while (0));
    }' unless defined(&ADW_WRITE_DWORD_LRAM);
    eval 'sub ADW_READ_WORD_AUTO_INC_LRAM {
        local($iot, $ioh) = @_;
	    eval q( &bus_space_read_2(($iot), ($ioh),  &IOPW_RAM_DATA));
    }' unless defined(&ADW_READ_WORD_AUTO_INC_LRAM);
    eval 'sub ADW_WRITE_WORD_AUTO_INC_LRAM {
        local($iot, $ioh, $word) = @_;
	    eval q( &bus_space_write_2(($iot), ($ioh),  &IOPW_RAM_DATA, ($word)));
    }' unless defined(&ADW_WRITE_WORD_AUTO_INC_LRAM);
    eval 'sub ADW_FIND_SIGNATURE {
        local($iot, $ioh) = @_;
	    eval q(((( &ADW_READ_BYTE_REGISTER(($iot), ($ioh),  &IOPB_CHIP_ID_1) ==  &ADW_CHIP_ID_BYTE)  && ( &ADW_READ_WORD_REGISTER(($iot), ($ioh),  &IOPW_CHIP_ID_0) ==  &ADW_CHIP_ID_WORD)) ?  &ADW_TRUE :  &ADW_FALSE));
    }' unless defined(&ADW_FIND_SIGNATURE);
    eval 'sub ADW_GET_CHIP_VERSION {
        local($iot, $ioh, $bus_type) = @_;
	    eval q( &ADW_READ_BYTE_REGISTER(($iot), ($ioh),  &IOPB_CHIP_TYPE_REV));
    }' unless defined(&ADW_GET_CHIP_VERSION);
    eval 'sub ADW_ABORT_CCB {
        local($sc, $ccb_ptr) = @_;
	    eval q( &AdwSendIdleCmd(,  &IDLE_CMD_ABORT, ($ccb_ptr)-> &hashkey));
    }' unless defined(&ADW_ABORT_CCB);
    eval 'sub ADW_RESET_DEVICE {
        local($sc, $target_id) = @_;
	    eval q( &AdwSendIdleCmd(,  &IDLE_CMD_DEVICE_RESET, ($target_id), 0));
    }' unless defined(&ADW_RESET_DEVICE);
    eval 'sub ADW_SCSI_BIT_ID_TYPE () { &u_int16_t;}' unless defined(&ADW_SCSI_BIT_ID_TYPE);
    eval 'sub ADW_SCAN_LUN () {0x01;}' unless defined(&ADW_SCAN_LUN);
    eval 'sub ADW_CAPINFO_NOLUN () {0x02;}' unless defined(&ADW_CAPINFO_NOLUN);
    eval 'sub ADW_TID_TO_TIDMASK {
        local($tid) = @_;
	    eval q((0x01 << (($tid) &  &ADW_MAX_TID)));
    }' unless defined(&ADW_TID_TO_TIDMASK);
    eval 'sub INQ_CLOCKING_ST_ONLY () {0x0;}' unless defined(&INQ_CLOCKING_ST_ONLY);
    eval 'sub INQ_CLOCKING_DT_ONLY () {0x1;}' unless defined(&INQ_CLOCKING_DT_ONLY);
    eval 'sub INQ_CLOCKING_ST_AND_DT () {0x3;}' unless defined(&INQ_CLOCKING_ST_AND_DT);
}
1;
