/*	$OpenBSD: mbavar.h,v 1.3 1997/05/29 00:05:00 niklas Exp $ */
/*	$NetBSD: mbavar.h,v 1.4 1996/04/08 18:39:01 ragge Exp $ */
/*
 * Copyright (c) 1994 Ludd, University of Lule}, Sweden
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed at Ludd, University of Lule}.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/device.h>

#define MBCR_INIT	1
#define	MBCR_IE		(1<<2)
#define	MBDS_DPR	(1<<8)
#define	MBSR_NED	(1<<18)
#define	MBDT_MOH	(1<<13)
#define	MBDT_TYPE	511
#define MBDT_TAP	(1<<14)

#define	CLOSED		0
#define	WANTOPEN	1
#define	RDLABEL		2
#define	OPEN		3
#define	OPENRAW		4

#define	MAXMBADEV	8	/* Max units per MBA */

/*
 * Devices that have different device drivers.
 */
enum	mb_devices {
	MB_RP,	/* RM/RP disk */
	MB_TU,	/* TM03 based tape, ex. TU45 or TU77 */
	MB_MT	/* TU78 tape */
};

/*
 * Current state of the adapter.
 */
enum    sc_state {
	SC_AUTOCONF,
	SC_ACTIVE,
	SC_IDLE
};

/*
 * Return value after a finished data transfer, from device driver.
 */
enum	xfer_action {
	XFER_RESTART,
	XFER_FINISH
};

/*
 * Info passed do unit device driver during autoconfig.
 */
struct	mba_attach_args {
	int	unit;
        int	type;
	char	*name;
	enum	mb_devices devtyp;
};

/*
 * Common struct used to communicate between the mba device driver
 * and the unit device driver.
 */
struct	mba_device {
	struct	mba_device *md_back;	/* linked list of runnable devices */
	    /* Start routine to be called by mbastart. */
	void	(*md_start) __P((struct mba_device *));
	    /* Routine to be called after attn intr */
	int	(*md_attn)__P((struct mba_device *));
	    /* Call after xfer finish */
	enum	xfer_action (*md_finish) __P((struct mba_device *, int, int *));
	void	*md_softc;	/* Backpointer to this units softc. */
	struct	mba_softc *md_mba;
	struct	buf md_q;	/* Buffer head for transfers */
};

struct	mba_softc {
	struct  device sc_dev;
	struct  ivec_dsp sc_dsp;	/* Interrupt catch routine */
	struct  mba_regs *sc_mbareg;
	struct	mba_device *sc_first, *sc_last;
	enum    sc_state sc_state;
	int	sc_physnr;		/* Physical number of this mba */
	struct	mba_device *sc_md[MAXMBADEV];
};

struct  mbaunit {
	int     nr;
	char    *name;
	enum	mb_devices devtyp;
};

/* Common prototypes */
void	mbaqueue __P((struct mba_device *));

