if (defined &_KERNEL) {
    if (!defined &_LOCORE) {
	require 'machine/cpu.ph';
    }
}
unless(defined(&MACHINE)) {
sub MACHINE () {"powerpc";}
}
unless(defined(&_MACHINE)) {
sub _MACHINE () { &powerpc;}
}
unless(defined(&MACHINE_ARCH)) {
sub MACHINE_ARCH () {"powerpc";}
}
unless(defined(&_MACHINE_ARCH)) {
sub _MACHINE_ARCH () { &powerpc;}
}
unless(defined(&MID_MACHINE)) {
sub MID_MACHINE () {0;}
}
unless(defined(&ALIGNBYTES)) {
sub ALIGNBYTES () {($sizeof{ &double} - 1);}
}
unless(defined(&ALIGN)) {
sub ALIGN {
    local($p) = @_;
    eval "((($p) +  &ALIGNBYTES)  ~ &ALIGNBYTES)";
}
}
unless(defined(&PGSHIFT)) {
sub PGSHIFT () {12;}
}
unless(defined(&NBPG)) {
sub NBPG () {4096;}
}
unless(defined(&PGOFSET)) {
sub PGOFSET () {( &NBPG - 1);}
}
unless(defined(&DEV_BSHIFT)) {
sub DEV_BSHIFT () {9;}
}
unless(defined(&DEV_BSIZE)) {
sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}
}
unless(defined(&BLKDEV_IOSIZE)) {
sub BLKDEV_IOSIZE () { &NBPG;}
}
unless(defined(&MAXPHYS)) {
sub MAXPHYS () {(64* 1024);}
}
unless(defined(&CLSIZELOG2)) {
sub CLSIZELOG2 () {0;}
}
unless(defined(&CLSIZE)) {
sub CLSIZE () {(1<<  &CLSIZELOG2);}
}
unless(defined(&UPAGES)) {
sub UPAGES () {4;}
}
unless(defined(&USPACE)) {
sub USPACE () {( &UPAGES *  &NBPG);}
}
unless(defined(&KERNBASE)) {
sub KERNBASE () {0x100000;}
}
unless(defined(&MSIZE)) {
sub MSIZE () {128;}
}
unless(defined(&MCLSHIFT)) {
sub MCLSHIFT () {11;}
}
unless(defined(&MCLBYTES)) {
sub MCLBYTES () {(1<<  &MCLSHIFT);}
}
unless(defined(&MCLOFSET)) {
sub MCLOFSET () {( &MCLBYTES - 1);}
}
if (!defined &NMBCLUSTERS) {
    if (defined &GATEWAY) {
	eval 'sub NMBCLUSTERS () {2048;}' unless defined(&NMBCLUSTERS);
    }
    else {
	eval 'sub NMBCLUSTERS () {1024;}' unless defined(&NMBCLUSTERS);
    }
}
if (!defined &NKMEMCLUSTERS) {
    eval 'sub NKMEMCLUSTERS () {(128* 1024* 1024/  &CLBYTES);}' unless defined(&NKMEMCLUSTERS);
}
unless(defined(&ctod)) {
sub ctod {
    local($x) = @_;
    eval "(($x) << ( &PGSHIFT -  &DEV_BSHIFT))";
}
}
unless(defined(&dtoc)) {
sub dtoc {
    local($x) = @_;
    eval "(($x) >> ( &PGSHIFT -  &DEV_BSHIFT))";
}
}
unless(defined(&ctob)) {
sub ctob {
    local($x) = @_;
    eval "(($x) <<  &PGSHIFT)";
}
}
unless(defined(&btoc)) {
sub btoc {
    local($x) = @_;
    eval "((($x) +  &PGOFSET) >>  &PGSHIFT)";
}
}
unless(defined(&dbtob)) {
sub dbtob {
    local($x) = @_;
    eval "(($x) <<  &DEV_BSHIFT)";
}
}
unless(defined(&btodb)) {
sub btodb {
    local($x) = @_;
    eval "(($x) >>  &DEV_BSHIFT)";
}
}
unless(defined(&powerpc_btop)) {
sub powerpc_btop {
    local($x) = @_;
    eval "(($x) >>  &PGSHIFT)";
}
}
unless(defined(&powerpc_ptob)) {
sub powerpc_ptob {
    local($x) = @_;
    eval "(($x) <<  &PGSHIFT)";
}
}
unless(defined(&SEGMENT_LENGTH)) {
sub SEGMENT_LENGTH () {0x10000000;}
}
unless(defined(&SEGMENT_MASK)) {
sub SEGMENT_MASK () {0xf0000000;}
}
unless(defined(&USER_SR)) {
sub USER_SR () {13;}
}
unless(defined(&KERNEL_SR)) {
sub KERNEL_SR () {14;}
}
unless(defined(&KERNEL_SEGMENT)) {
sub KERNEL_SEGMENT () {(0xfffff0 +  &KERNEL_SR);}
}
unless(defined(&EMPTY_SEGMENT)) {
sub EMPTY_SEGMENT () {0xfffff0;}
}
unless(defined(&USER_ADDR)) {
sub USER_ADDR () {(( &void *)( &USER_SR <<  &ADDR_SR_SHFT));}
}
if (!defined &HTABENTS) {
    eval 'sub HTABENTS () {1024;}' unless defined(&HTABENTS);
}
if (!defined &NPMAPS) {
    eval 'sub NPMAPS () {32768;}' unless defined(&NPMAPS);
}
unless(defined(&ovbcopy)) {
sub ovbcopy () { &bcopy;}
}
1;
