.\" $Id: kxd.man,v 1.1 1998/03/25 14:48:59 art Exp $
.\"
.Dd September 27, 1996
.Dt KXD 8
.Os KTH-KRB
.Sh NAME
.Nm kxd
.Nd
securely forward X conections
.Sh SYNOPSIS
.Ar kxd
.Op Fl t
.Op Fl i
.Op Fl p Ar port
.Sh DESCRIPTION
This is the daemon for
.Nm kx .
.Pp
Options supported by
.Nm kxd :
.Bl -tag -width Ds
.It Fl t
TCP.  Normally
.Nm kxd
will only listen for X connections on a UNIX socket, but some machines
(for example, Cray) have X libraries that are not able to use UNIX
sockets and thus you need to use TCP to talk to the pseudo-xserver
created by
.Nm kxd.
This option decreases the security significantly and should only be
used when it is necessary and you have considered the consequences of
doing so.
.It Fl i
Interactive.  Do not expect to be started by
.Nm inetd,
but allocate and listen to the socket yourself.  Handy for testing
and debugging.
.It Fl p
Port.  Listen on the port
.Ar port .
Only usable with
.Fl i .
.El

.Sh EXAMPLES
Put the following in
.Pa /etc/inetd.conf :
.Bd -literal
kx	stream	tcp	nowait	root	/usr/athena/libexec/kxd	kxd
.Ed
.Sh SEE ALSO
.Xr kx 1 ,
.Xr rxtelnet 1 ,
.Xr rxterm 1
