/*	$OpenBSD$	*/
/*	$NetBSD: tp_trace.h,v 1.7 1996/02/13 22:12:23 christos Exp $	*/

/*-
 * Copyright (c) 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)tp_trace.h	8.1 (Berkeley) 6/10/93
 */

/***********************************************************
		Copyright IBM Corporation 1987

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of IBM not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/*
 * ARGO Project, Computer Sciences Dept., University of Wisconsin - Madison
 */
/*
 * Definitions needed for the protocol trace mechanism.
 */

#ifndef _NETISO_TP_TRACE_H_
#define _NETISO_TP_TRACE_H_


#define TPPTsendack	1
#define TPPTgotack	2
#define TPPTXack	3
#define TPPTgotXack	4
#define TPPTack		5
#define TPPTindicate	6
#define TPPTusrreq	7
#define TPPTmisc	8
#define TPPTpcb		9
#define TPPTref		10
#define TPPTtpduin	11
#define TPPTparam	12
#define TPPTertpdu	13
#define TPPTdriver	14
#define TPPTtpduout	15

#include <netiso/tp_pcb.h>

/* this #if is to avoid lint */

#if  defined(TP_TRACEFILE)||!defined(_KERNEL)

#include <netiso/tp_tpdu.h>

#define TPTRACE_STRLEN 50


/* for packet tracing */
struct tp_timeval {
	SeqNum          tptv_seq;
	u_int           tptv_kind;
	u_int           tptv_window;
	u_int           tptv_size;
};

struct tp_Trace {
	u_int           tpt_event;
	u_int           tpt_arg;
	u_int           tpt_arg2;
	int             tpt_tseq;
	struct timeval  tpt_time;
	union {
		struct inpcb    tpt_Inpcb;	/* protocol control block */
		struct tp_ref   tpt_Ref;	/* ref part of pcb */
		struct tpdu     tpt_Tpdu;	/* header */
		struct tp_refinfo tpt_Param;	/* ?? bytes, make sure <
						 * 128?? */
		struct tp_timeval tpt_Time;
		struct {
			u_int           tptm_2;
			u_int           tptm_3;
			u_int           tptm_4;
			u_int           tptm_5;
			char            tpt_Str[TPTRACE_STRLEN];
			u_int           tptm_1;
		}               tptmisc;
		u_char          tpt_Ertpdu;	/* use rest of structure */
	}               tpt_stuff;
};
#define tpt_inpcb tpt_stuff.tpt_Inpcb
#define tpt_pcb tpt_stuff.tpt_Pcb
#define tpt_ref tpt_stuff.tpt_Ref
#define tpt_tpdu tpt_stuff.tpt_Tpdu
#define tpt_param tpt_stuff.tpt_Param
#define tpt_ertpdu tpt_stuff.tpt_Ertpdu
#define tpt_str tpt_stuff.tptmisc.tpt_Str
#define tpt_m1 tpt_stuff.tptmisc.tptm_1
#define tpt_m2 tpt_stuff.tptmisc.tptm_2
#define tpt_m3 tpt_stuff.tptmisc.tptm_3
#define tpt_m4 tpt_stuff.tptmisc.tptm_4
#define tpt_m5 tpt_stuff.tptmisc.tptm_5

#define tpt_seq tpt_stuff.tpt_Time.tptv_seq
#define tpt_kind tpt_stuff.tpt_Time.tptv_kind
#define tpt_window tpt_stuff.tpt_Time.tptv_window
#define tpt_size tpt_stuff.tpt_Time.tptv_size

#endif				/* defined(TP_TRACEFILE)||!defined(_KERNEL) */


#ifdef TPPT

#define TPTRACEN 300

#define tptrace(A,B,C,D,E,F) \
	tpTrace((struct tp_pcb *)0,\
	(u_int)(A),(u_int)(B),(u_int)(C),(u_int)(D),(u_int)(E),(u_int)(F))

#define tptraceTPCB(A,B,C,D,E,F) \
	tpTrace(tpcb,\
	(u_int)(A),(u_int)(B),(u_int)(C),(u_int)(D),(u_int)(E),(u_int)(F))

extern void     tpTrace();
extern struct tp_Trace tp_Trace[];
extern u_char   tp_traceflags[];
int             tp_Tracen = 0;

#else				/* TPPT */

/***********************************************
 * NO TPPT TRACE STUFF
 **********************************************/
#define TPTRACEN 1

#define tptrace(A,B,C,D,E,F) 0
#define tptraceTPCB(A,B,C,D,E,F) 0

#endif				/* TPPT */

#endif				/* _NETISO_TP_TRACE_H_ */
