/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DataFlavor
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 8367026044764648243L;
    public static final DataFlavor plainTextFlavor;
    public static final DataFlavor stringFlavor;
    public static final DataFlavor javaFileListFlavor;
    public static final DataFlavor imageFlavor;
    public static final String javaSerializedObjectMimeType = "application/x-java-serialized-object";
    public static final String javaJVMLocalObjectMimeType = "application/x-java-jvm-local-objectref";
    public static final String javaRemoteObjectMimeType = "application/x-java-remote-object";
    private final String mimeType;
    private final Class representationClass;
    private String humanPresentableName;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$nio$ByteBuffer;
    static /* synthetic */ Class class$java$nio$CharBuffer;

    protected static final Class tryToLoadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (Exception exception) {
            if (classLoader != null) {
                return classLoader.loadClass(className);
            }
            throw new ClassNotFoundException(className);
        }
    }

    private static final Class getRepresentationClassFromMime(String mimeString, ClassLoader classLoader) {
        String classname = DataFlavor.getParameter("class", mimeString);
        if (classname != null) {
            try {
                return DataFlavor.tryToLoadClass(classname, classLoader);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("classname: " + e.getMessage());
            }
        }
        Class clazz = class$java$io$InputStream;
        if (clazz == null) {
            clazz = class$java$io$InputStream = DataFlavor.class("[Ljava.io.InputStream;", false);
        }
        return clazz;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Class getRepresentationClass() {
        return this.representationClass;
    }

    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    public String getPrimaryType() {
        int idx = this.mimeType.indexOf("/");
        if (idx == -1) {
            return this.mimeType;
        }
        return this.mimeType.substring(0, idx);
    }

    public String getSubType() {
        int start = this.mimeType.indexOf("/");
        if (start == -1) {
            return "";
        }
        int end = this.mimeType.indexOf(";", start + 1);
        if (end == -1) {
            return this.mimeType.substring(start + 1);
        }
        return this.mimeType.substring(start + 1, end);
    }

    private static final String getParameter(String paramName, String mimeString) {
        int idx = mimeString.indexOf(paramName + '=');
        if (idx == -1) {
            return null;
        }
        String value = mimeString.substring(idx + paramName.length() + 1);
        if ((idx = value.indexOf(" ")) == -1) {
            return value;
        }
        return value.substring(0, idx);
    }

    public String getParameter(String paramName) {
        if ("humanPresentableName".equals(paramName)) {
            return this.getHumanPresentableName();
        }
        return DataFlavor.getParameter(paramName, this.mimeType);
    }

    public void setHumanPresentableName(String humanPresentableName) {
        this.humanPresentableName = humanPresentableName;
    }

    public boolean isMimeTypeEqual(String mimeType) {
        String mime = this.getMimeType();
        int i = mime.indexOf(";");
        if (i != -1) {
            mime = mime.substring(0, i);
        }
        if ((i = mimeType.indexOf(";")) != -1) {
            mimeType = mimeType.substring(0, i);
        }
        return mime.equals(mimeType);
    }

    public final boolean isMimeTypeEqual(DataFlavor flavor) {
        return this.isMimeTypeEqual(flavor.getMimeType());
    }

    public boolean isMimeTypeSerializedObject() {
        return this.mimeType.startsWith(javaSerializedObjectMimeType);
    }

    public boolean isRepresentationClassInputStream() {
        return this.representationClass.getName().equals("java.io.InputStream");
    }

    public boolean isRepresentationClassSerializable() {
        Class[] interfaces = this.representationClass.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].getName().equals("java.io.Serializable")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isRepresentationClassRemote() {
        Class clazz = class$java$rmi$Remote;
        if (clazz == null) {
            clazz = class$java$rmi$Remote = DataFlavor.class("[Ljava.rmi.Remote;", false);
        }
        return clazz.isAssignableFrom(this.representationClass);
    }

    public boolean isFlavorSerializedObjectType() {
        return this.mimeType.startsWith(javaSerializedObjectMimeType);
    }

    public boolean isFlavorRemoteObjectType() {
        return this.mimeType.startsWith(javaRemoteObjectMimeType);
    }

    public boolean isFlavorJavaFileListType() {
        return this.mimeType.equals(DataFlavor.javaFileListFlavor.mimeType) && this.representationClass.equals(DataFlavor.javaFileListFlavor.representationClass);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(DataFlavor flavor) {
        if (flavor == null) {
            return false;
        }
        if (!this.mimeType.toLowerCase().equals(flavor.mimeType.toLowerCase())) {
            return false;
        }
        return this.representationClass.equals(flavor.representationClass);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataFlavor)) {
            return false;
        }
        return this.equals((DataFlavor)obj);
    }

    public boolean equals(String str) {
        return this.isMimeTypeEqual(str);
    }

    public int hashCode() {
        return this.mimeType.toLowerCase().hashCode() ^ this.representationClass.hashCode();
    }

    public boolean match(DataFlavor dataFlavor) {
        return this.equals(dataFlavor);
    }

    protected String normalizeMimeTypeParameter(String name, String value) {
        return name + '=' + value;
    }

    protected String normalizeMimeType(String type) {
        return type;
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
    }

    public String toString() {
        return this.getClass().getName() + "[representationClass=" + this.getRepresentationClass().getName() + ",mimeType=" + this.getMimeType() + ",humanPresentableName=" + this.getHumanPresentableName() + ']';
    }

    public static final DataFlavor getTextPlainUnicodeFlavor() {
        return plainTextFlavor;
    }

    public final Class getDefaultRepresentationClass() {
        Class clazz = class$java$io$InputStream;
        if (clazz == null) {
            clazz = class$java$io$InputStream = DataFlavor.class("[Ljava.io.InputStream;", false);
        }
        return clazz;
    }

    public final String getDefaultRepresentationClassAsString() {
        return this.getDefaultRepresentationClass().getName();
    }

    public static final DataFlavor selectBestTextFlavor(DataFlavor[] availableFlavors) {
        int i = 0;
        while (i < availableFlavors.length) {
            Class c;
            DataFlavor df;
            block14: {
                block13: {
                    df = availableFlavors[i];
                    c = df.representationClass;
                    Class clazz = class$java$io$Reader;
                    if (clazz == null) {
                        clazz = DataFlavor.class("[Ljava.io.Reader;", false);
                    }
                    if (clazz.isAssignableFrom(c)) break block13;
                    Class clazz2 = class$java$lang$String;
                    if (clazz2 == null) {
                        clazz2 = DataFlavor.class("[Ljava.lang.String;", false);
                    }
                    if (!clazz2.isAssignableFrom(c)) break block14;
                }
                return df;
            }
            Class clazz = class$java$io$InputStream;
            if (clazz == null) {
                clazz = DataFlavor.class("[Ljava.io.InputStream;", false);
            }
            if (clazz.isAssignableFrom(c) && "text".equals(df.getPrimaryType())) {
                String encoding = availableFlavors[i].getParameter("charset");
                if (encoding == null) {
                    encoding = "us-ascii";
                }
                InputStreamReader r = null;
                try {
                    r = new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), encoding);
                }
                catch (UnsupportedEncodingException uee) {
                    // empty catch block
                }
                if (r != null) {
                    return df;
                }
            }
            ++i;
        }
        return null;
    }

    public Reader getReaderForText(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (!transferable.isDataFlavorSupported(this)) {
            throw new UnsupportedFlavorException(this);
        }
        Class clazz = class$java$io$Reader;
        if (clazz == null) {
            clazz = class$java$io$Reader = DataFlavor.class("[Ljava.io.Reader;", false);
        }
        if (clazz.isAssignableFrom(this.representationClass)) {
            return (Reader)transferable.getTransferData(this);
        }
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = DataFlavor.class("[Ljava.lang.String;", false);
        }
        if (clazz2.isAssignableFrom(this.representationClass)) {
            return new StringReader((String)transferable.getTransferData(this));
        }
        Class clazz3 = class$java$io$InputStream;
        if (clazz3 == null) {
            clazz3 = class$java$io$InputStream = DataFlavor.class("[Ljava.io.InputStream;", false);
        }
        if (clazz3.isAssignableFrom(this.representationClass) && "text".equals(this.getPrimaryType())) {
            InputStream in = (InputStream)transferable.getTransferData(this);
            String encoding = this.getParameter("charset");
            if (encoding == null) {
                encoding = "us-ascii";
            }
            return new InputStreamReader(in, encoding);
        }
        throw new UnsupportedFlavorException(this);
    }

    public boolean isRepresentationClassByteBuffer() {
        Class clazz = class$java$nio$ByteBuffer;
        if (clazz == null) {
            clazz = class$java$nio$ByteBuffer = DataFlavor.class("[Ljava.nio.ByteBuffer;", false);
        }
        return clazz.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassCharBuffer() {
        Class clazz = class$java$nio$CharBuffer;
        if (clazz == null) {
            clazz = class$java$nio$CharBuffer = DataFlavor.class("[Ljava.nio.CharBuffer;", false);
        }
        return clazz.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassReader() {
        Class clazz = class$java$io$Reader;
        if (clazz == null) {
            clazz = class$java$io$Reader = DataFlavor.class("[Ljava.io.Reader;", false);
        }
        return clazz.isAssignableFrom(this.representationClass);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public DataFlavor() {
        this.mimeType = null;
        this.representationClass = null;
        this.humanPresentableName = null;
    }

    private DataFlavor(Class representationClass, String mimeType, String humanPresentableName) {
        this.representationClass = representationClass;
        this.mimeType = mimeType;
        this.humanPresentableName = humanPresentableName != null ? humanPresentableName : mimeType;
    }

    public DataFlavor(Class representationClass, String humanPresentableName) {
        this(representationClass, "application/x-java-serialized-object; class=" + representationClass.getName(), humanPresentableName);
    }

    public DataFlavor(String mimeType, String humanPresentableName, ClassLoader classLoader) throws ClassNotFoundException {
        this(DataFlavor.getRepresentationClassFromMime(mimeType, classLoader), mimeType, humanPresentableName);
    }

    public DataFlavor(String mimeType, String humanPresentableName) {
        this(DataFlavor.getRepresentationClassFromMime(mimeType, null), mimeType, humanPresentableName);
    }

    public DataFlavor(String mimeType) throws ClassNotFoundException {
        this(mimeType, null);
    }

    static {
        Class clazz = class$java$io$InputStream;
        if (clazz == null) {
            clazz = class$java$io$InputStream = DataFlavor.class("[Ljava.io.InputStream;", false);
        }
        plainTextFlavor = new DataFlavor(clazz, "text/plain; charset=unicode", "plain unicode text");
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = DataFlavor.class("[Ljava.lang.String;", false);
        }
        stringFlavor = new DataFlavor(clazz2, "Java Unicode String");
        Class clazz3 = class$java$util$List;
        if (clazz3 == null) {
            clazz3 = class$java$util$List = DataFlavor.class("[Ljava.util.List;", false);
        }
        javaFileListFlavor = new DataFlavor(clazz3, "application/x-java-file-list; class=java.util.List", "Java File List");
        Class clazz4 = class$java$awt$Image;
        if (clazz4 == null) {
            clazz4 = class$java$awt$Image = DataFlavor.class("[Ljava.awt.Image;", false);
        }
        imageFlavor = new DataFlavor(clazz4, "Java Image");
    }
}

