/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UndoableEditSupport {
    protected int updateLevel;
    protected CompoundEdit compoundEdit;
    protected Vector listeners;
    protected Object realSource;

    public String toString() {
        return super.toString() + " updateLevel: " + this.updateLevel + " listeners: " + this.listeners + " compoundEdit: " + this.compoundEdit;
    }

    public synchronized void addUndoableEditListener(UndoableEditListener val) {
        this.listeners.add(val);
    }

    public synchronized void removeUndoableEditListener(UndoableEditListener val) {
        this.listeners.removeElement(val);
    }

    public synchronized UndoableEditListener[] getUndoableEditListeners() {
        Object[] result = new UndoableEditListener[this.listeners.size()];
        return (UndoableEditListener[])this.listeners.toArray(result);
    }

    protected void _postEdit(UndoableEdit edit) {
        if (this.listeners.isEmpty()) {
            return;
        }
        UndoableEditEvent event = new UndoableEditEvent(this.realSource, edit);
        Iterator iter = ((Vector)this.listeners.clone()).iterator();
        while (iter.hasNext()) {
            ((UndoableEditListener)iter.next()).undoableEditHappened(event);
        }
    }

    public synchronized void postEdit(UndoableEdit edit) {
        if (this.compoundEdit != null) {
            this.compoundEdit.addEdit(edit);
        } else {
            this._postEdit(edit);
        }
    }

    public int getUpdateLevel() {
        return this.updateLevel;
    }

    public synchronized void beginUpdate() {
        if (this.compoundEdit == null) {
            this.compoundEdit = this.createCompoundEdit();
        }
        ++this.updateLevel;
    }

    protected CompoundEdit createCompoundEdit() {
        return new CompoundEdit();
    }

    public synchronized void endUpdate() {
        if (this.updateLevel == 0) {
            throw new IllegalStateException();
        }
        if (--this.updateLevel > 0) {
            return;
        }
        this.compoundEdit.end();
        this._postEdit(this.compoundEdit);
        this.compoundEdit = null;
    }

    private final /* synthetic */ void this() {
        this.listeners = new Vector();
    }

    public UndoableEditSupport() {
        this.this();
        this.realSource = this;
    }

    public UndoableEditSupport(Object realSource) {
        this.this();
        if (realSource == null) {
            realSource = this;
        }
        this.realSource = realSource;
    }
}

