require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ARM32_FRAME_H_)) {
    eval 'sub _ARM32_FRAME_H_ () {1;}' unless defined(&_ARM32_FRAME_H_);
    require 'arm/frame.ph';
    unless(defined(&_LOCORE)) {
	if(defined(&_KERNEL)) {
	}
    } else {
	require './arm/arm32/opt_compat_netbsd.ph';
	require './arm/arm32/opt_execfmt.ph';
	require './arm/arm32/opt_multiprocessor.ph';
	require './arm/arm32/opt_cpuoptions.ph';
	require './arm/arm32/opt_arm_debug.ph';
	require './arm/arm32/opt_cputypes.ph';
	require './arm/arm32/opt_dtrace.ph';
	require 'arm/locore.ph';
	if(defined(&_ARM_ARCH_4T)) {
	    eval 'sub B_CF_CONTROL {
	        my($rX) = @_;
    		eval q(;  &ldr  &ip, [$rX,  &CF_CONTROL] ;  &bx  &ip);
	    }' unless defined(&B_CF_CONTROL);
	} else {
	    eval 'sub B_CF_CONTROL {
	        my($rX) = @_;
    		eval q(;  &ldr  &pc, [$rX,  &CF_CONTROL]);
	    }' unless defined(&B_CF_CONTROL);
	}
	if(defined(&_ARM_ARCH_5T)) {
	    eval 'sub BL_CF_CONTROL {
	        my($rX) = @_;
    		eval q(;  &ldr  &ip, [$rX,  &CF_CONTROL] ;  &blx  &ip);
	    }' unless defined(&BL_CF_CONTROL);
	} else {
	    eval 'sub BL_CF_CONTROL {
	        my($rX) = @_;
    		eval q(;  &mov  &lr,  &pc ;  &ldr  &pc, [$rX,  &CF_CONTROL]);
	    }' unless defined(&BL_CF_CONTROL);
	}
	if(defined(&__HAVE_FAST_SOFTINTS)  && !defined(&__HAVE_PIC_FAST_SOFTINTS)) {
	    eval 'sub DO_PENDING_SOFTINTS () { &ldr  &r0, [ &r4,  &CI_INTR_DEPTH] ;  &cmp  &r0, 0;  &bne 10 &f ;  &ldr  &r0, [ &r4,  &CI_CPL] ;  &ldr  &r1, [ &r4,  &CI_SOFTINTS] ;  &lsrs  &r0,  &r1,  &r0 ;  &blne  &_C_LABEL( &dosoftints) ;10:;}' unless defined(&DO_PENDING_SOFTINTS);
	} else {
	    eval 'sub DO_PENDING_SOFTINTS () {1;}' unless defined(&DO_PENDING_SOFTINTS);
	}
	if(defined(&_ARM_ARCH_6)) {
	    eval 'sub GET_CPSR {
	        my($rb) = @_;
    		eval q();
	    }' unless defined(&GET_CPSR);
	    eval 'sub CPSID_I {
	        my($ra,$rb) = @_;
    		eval q( &cpsid  &i);
	    }' unless defined(&CPSID_I);
	    eval 'sub CPSIE_I {
	        my($ra,$rb) = @_;
    		eval q( &cpsie  &i);
	    }' unless defined(&CPSIE_I);
	} else {
	    eval 'sub GET_CPSR {
	        my($rb) = @_;
    		eval q( &mrs $rb,  &cpsr);
	    }' unless defined(&GET_CPSR);
	    eval 'sub CPSID_I {
	        my($ra,$rb) = @_;
    		eval q( &orr $ra, $rb, ( &IF32_bits) ;  &msr  &cpsr_c, $ra);
	    }' unless defined(&CPSID_I);
	    eval 'sub CPSIE_I {
	        my($ra,$rb) = @_;
    		eval q( &bic $ra, $rb, ( &IF32_bits) ;  &msr  &cpsr_c, $ra);
	    }' unless defined(&CPSIE_I);
	}
	eval 'sub DO_PENDING_AST {
	    my($lbl) = @_;
    	    eval q(;1:  &ldr  &r1, [ &r5,  &L_MD_ASTPENDING] ;  &tst  &r1, 1;  &beq $lbl ;  &bic  &r0,  &r1, 1;  &str  &r0, [ &r5,  &L_MD_ASTPENDING] ;  &CPSIE_I( &r6,  &r6) ;  &mov  &r0,  &sp ;  &bl  &_C_LABEL( &ast) ;  &CPSID_I( &r0,  &r6) ;  &b 1 &b);
	}' unless defined(&DO_PENDING_AST);
	if(defined(&EXEC_AOUT)) {
	    eval 'sub AST_ALIGNMENT_FAULT_LOCALS () {. &Laflt_cpufuncs: ; . &word  &_C_LABEL( &cpufuncs);}' unless defined(&AST_ALIGNMENT_FAULT_LOCALS);
	    eval 'sub ENABLE_ALIGNMENT_FAULTS () { &and  &r7,  &r0, ( &PSR_MODE) ;  &cmp  &r7, ( &PSR_USR32_MODE) ;  &GET_CURX( &r4,  &r5) ;  &bne 1 &f ;  &ldr  &r1, [ &r5,  &L_MD_FLAGS] ;  &tst  &r1,  &MDLWP_NOALIGNFLT ;  &beq 1 &f ;  &ldr  &r2, . &Laflt_cpufuncs ;  &ldr  &r1, [ &r4,  &CI_CTRL] ;  &mov  &r0, -1;  &BL_CF_CONTROL( &r2) ;1:;}' unless defined(&ENABLE_ALIGNMENT_FAULTS);
	    eval 'sub DO_AST_AND_RESTORE_ALIGNMENT_FAULTS () { &DO_PENDING_SOFTINTS ;  &GET_CPSR( &r6) ;  &CPSID_I( &r1,  &r6) ;  &cmp  &r7, ( &PSR_USR32_MODE) ;  &bne 3 &f ;  &DO_PENDING_AST(2 &f) ;2:  &ldr  &r1, [ &r4,  &CI_CURLWP] ;  &ldr  &r0, [ &r1,  &L_MD_FLAGS] ;  &tst  &r0,  &MDLWP_NOALIGNFLT ;  &beq 3 &f ;  &ldr  &r1, [ &r4,  &CI_CTRL] ;  &ldr  &r2, . &Laflt_cpufuncs ;  &mov  &r0, -1;  &bic  &r1,  &r1,  &CPU_CONTROL_AFLT_ENABLE ;  &BL_CF_CONTROL( &r2) ;3:;}' unless defined(&DO_AST_AND_RESTORE_ALIGNMENT_FAULTS);
	} else {
	    eval 'sub AST_ALIGNMENT_FAULT_LOCALS () {1;}' unless defined(&AST_ALIGNMENT_FAULT_LOCALS);
	    eval 'sub ENABLE_ALIGNMENT_FAULTS () { &and  &r7,  &r0, ( &PSR_MODE) ;  &GET_CURX( &r4,  &r5);}' unless defined(&ENABLE_ALIGNMENT_FAULTS);
	    eval 'sub DO_AST_AND_RESTORE_ALIGNMENT_FAULTS () { &DO_PENDING_SOFTINTS ;  &GET_CPSR( &r6) ;  &CPSID_I( &r1,  &r6) ;  &cmp  &r7, ( &PSR_USR32_MODE) ;  &bne 2 &f ;  &DO_PENDING_AST(2 &f) ;2:;}' unless defined(&DO_AST_AND_RESTORE_ALIGNMENT_FAULTS);
	}
	unless(defined(&_ARM_ARCH_6)) {
	    if(defined(&ARM_LOCK_CAS_DEBUG)) {
		eval 'sub LOCK_CAS_DEBUG_LOCALS () {. &L_lock_cas_restart: ; . &word  &_C_LABEL( &_lock_cas_restart);}' unless defined(&LOCK_CAS_DEBUG_LOCALS);
		if(defined(&__ARMEB__)) {
		    eval 'sub LOCK_CAS_DEBUG_COUNT_RESTART () { &ble 99 &f ;  &ldr  &r0, . &L_lock_cas_restart ;  &ldmia  &r0, { &r1- &r2} ;  &adds  &r2,  &r2, 1;  &adc  &r1,  &r1, 0;  &stmia  &r0, { &r1- &r2};}' unless defined(&LOCK_CAS_DEBUG_COUNT_RESTART);
		} else {
		    eval 'sub LOCK_CAS_DEBUG_COUNT_RESTART () { &ble 99 &f ;  &ldr  &r0, . &L_lock_cas_restart ;  &ldmia  &r0, { &r1- &r2} ;  &adds  &r1,  &r1, 1;  &adc  &r2,  &r2, 0;  &stmia  &r0, { &r1- &r2};}' unless defined(&LOCK_CAS_DEBUG_COUNT_RESTART);
		}
	    } else {
		eval 'sub LOCK_CAS_DEBUG_LOCALS () {1;}' unless defined(&LOCK_CAS_DEBUG_LOCALS);
		eval 'sub LOCK_CAS_DEBUG_COUNT_RESTART () {1;}' unless defined(&LOCK_CAS_DEBUG_COUNT_RESTART);
	    }
	    eval 'sub LOCK_CAS_CHECK_LOCALS () {. &L_lock_cas: ; . &word  &_C_LABEL( &_lock_cas) ;. &L_lock_cas_end: ; . &word  &_C_LABEL( &_lock_cas_end) ; &LOCK_CAS_DEBUG_LOCALS;}' unless defined(&LOCK_CAS_CHECK_LOCALS);
	    eval 'sub LOCK_CAS_CHECK () { &ldr  &r0, [ &sp] ;  &and  &r0,  &r0, ( &PSR_MODE) ;  &cmp  &r0, ( &PSR_SVC32_MODE) ;  &bne 99 &f ;  &ldr  &r0, [ &sp, ( &TF_PC)] ;  &ldr  &r1, . &L_lock_cas_end ;  &cmp  &r0,  &r1 ;  &bge 99 &f ;  &ldr  &r1, . &L_lock_cas ;  &cmp  &r0,  &r1 ;  &strgt  &r1, [ &sp, ( &TF_PC)] ;  &LOCK_CAS_DEBUG_COUNT_RESTART ;99:;}' unless defined(&LOCK_CAS_CHECK);
	} else {
	    eval 'sub LOCK_CAS_CHECK () {1;}' unless defined(&LOCK_CAS_CHECK);
	    eval 'sub LOCK_CAS_CHECK_LOCALS () {1;}' unless defined(&LOCK_CAS_CHECK_LOCALS);
	}
	if(defined(&CPU_SA110)) {
	    eval 'sub PUSHUSERREGS () { &stmia  &sp, { &r0- &r12};  &add  &r0,  &sp, ( &TF_USR_SP- &TF_R0);  &stmia  &r0, { &r13- &r14}^;}' unless defined(&PUSHUSERREGS);
	} else {
	    eval 'sub PUSHUSERREGS () { &stmia  &sp, { &r0- &r14}^;}' unless defined(&PUSHUSERREGS);
	}
	eval 'sub PUSHFRAME () { &str  &lr, [ &sp, -4]!;  &sub  &sp,  &sp, ( &TF_PC- &TF_R0);  &PUSHUSERREGS;  &mov  &r0,  &r0;  &mrs  &r0,  &spsr;  &str  &r0, [ &sp, - &TF_R0]!;}' unless defined(&PUSHFRAME);
	eval 'sub PUSHIDLEFRAME () { &str  &lr, [ &sp, -4]!;  &str  &r6, [ &sp, ( &TF_R6- &TF_PC)]!;  &str  &r4, [ &sp, ( &TF_R4- &TF_R6)]!;  &mrs  &r0,  &cpsr;  &str  &r0, [ &sp, (- &TF_R4)]!;}' unless defined(&PUSHIDLEFRAME);
	eval 'sub PUSHSWITCHFRAME {
	    my($rX) = @_;
    	    eval q( &mov  &ip,  &sp;  &sub  &sp,  &sp, ( &TRAPFRAMESIZE- &TF_R12);  &push { &r4- &r11};  &sub  &sp,  &sp,  &TF_R4;  &str  &ip, [ &sp,  &TF_SVC_SP];  &str  &lr, [ &sp,  &TF_SVC_LR];  &str  &lr, [ &sp,  &TF_PC];  &mrs $rX,  &cpsr;  &str $rX, [ &sp,  &TF_SPSR]);
	}' unless defined(&PUSHSWITCHFRAME);
	eval 'sub PUSHSWITCHFRAME1 () { &mov  &ip,  &sp;  &sub  &sp,  &sp, ( &TRAPFRAMESIZE- &TF_R8);  &push { &r4- &r7};  &sub  &sp,  &sp,  &TF_R4;  &str  &ip, [ &sp,  &TF_SVC_SP];  &str  &lr, [ &sp,  &TF_SVC_LR];  &str  &lr, [ &sp,  &TF_PC];}' unless defined(&PUSHSWITCHFRAME1);
	if(defined(&_ARM_ARCH_DWORD_OK)  && (defined(&__ARM_EABI__) ? &__ARM_EABI__ : undef)) {
	    eval 'sub PUSHSWITCHFRAME2 () { &strd  &r10, [ &sp,  &TF_R10];  &strd  &r8, [ &sp,  &TF_R8];  &mrs  &r0,  &cpsr;  &str  &r0, [ &sp,  &TF_SPSR];}' unless defined(&PUSHSWITCHFRAME2);
	} else {
	    eval 'sub PUSHSWITCHFRAME2 () { &add  &r0,  &sp,  &TF_R8;  &stmia  &r0, { &r8- &r11};  &mrs  &r0,  &cpsr;  &str  &r0, [ &sp,  &TF_SPSR];}' unless defined(&PUSHSWITCHFRAME2);
	}
	eval 'sub PULLFRAME () { &ldr  &r0, [ &sp],  &TF_R0;  &msr  &spsr_fsxc,  &r0;  &ldmia  &sp, { &r0- &r14}^;  &mov  &r0,  &r0;  &add  &sp,  &sp, ( &TF_PC- &TF_R0);  &ldr  &lr, [ &sp], 4;}' unless defined(&PULLFRAME);
	eval 'sub PULLIDLEFRAME () { &add  &sp,  &sp,  &TF_R4;  &ldr  &r4, [ &sp], ( &TF_R6- &TF_R4);  &ldr  &r6, [ &sp], ( &TF_PC- &TF_R6);  &ldr  &lr, [ &sp], 4;}' unless defined(&PULLIDLEFRAME);
	eval 'sub PULLSWITCHFRAME () { &add  &sp,  &sp,  &TF_R4;  &pop { &r4- &r11};  &add  &sp,  &sp, ( &TF_PC- &TF_R12);  &ldr  &lr, [ &sp], 4;;}' unless defined(&PULLSWITCHFRAME);
	if(defined(&_ARM_ARCH_6)) {
	    eval 'sub SET_CPSR_MODE {
	        my($tmp, $mode) = @_;
    		eval q( &cps ($mode));
	    }' unless defined(&SET_CPSR_MODE);
	} else {
	    eval 'sub SET_CPSR_MODE {
	        my($tmp, $mode) = @_;
    		eval q( &mrs $tmp,  &cpsr;  &bic $tmp, $tmp, ( &PSR_MODE);  &orr $tmp, $tmp, ($mode);  &msr  &cpsr_c, $tmp);
	    }' unless defined(&SET_CPSR_MODE);
	}
	eval 'sub PUSHXXXREGSANDSWITCH () { &stmdb  &sp, { &r0- &r3};  &mov  &r0,  &lr;  &mov  &r1,  &sp;  &mrs  &r3,  &spsr;  &SET_CPSR_MODE( &r2,  &PSR_SVC32_MODE);}' unless defined(&PUSHXXXREGSANDSWITCH);
	if(defined(&KDTRACE_HOOKS)) {
	    eval 'sub PUSHDTRACEGAP () { &and  &r2,  &r3, ( &PSR_MODE);  &cmp  &r2, ( &PSR_SVC32_MODE);  &mov  &r2,  &sp;  &subeq  &r2,  &r2, (4* 16);;}' unless defined(&PUSHDTRACEGAP);
	} else {
	    eval 'sub PUSHDTRACEGAP () { &mov  &r2,  &sp;}' unless defined(&PUSHDTRACEGAP);
	}
	eval 'sub PUSHTRAPFRAME {
	    my($rX) = @_;
    	    eval q( &bic  &r2, $rX, 7;  &str  &r0, [ &r2, -4]!;  &stmdb  &r2!, { &sp,  &lr};  &mov  &sp,  &r2;  &msr  &spsr_fsxc,  &r3;  &ldmdb  &r1, { &r0- &r3};  &sub  &sp,  &sp, ( &TF_SVC_SP- &TF_R0);  &PUSHUSERREGS;  &mov  &r0,  &r0;  &mrs  &r0,  &spsr;  &str  &r0, [ &sp, - &TF_R0]!);
	}' unless defined(&PUSHTRAPFRAME);
	eval 'sub PUSHFRAMEINSVC () { &PUSHXXXREGSANDSWITCH;  &PUSHTRAPFRAME( &sp);}' unless defined(&PUSHFRAMEINSVC);
	eval 'sub PULLFRAMEFROMSVCANDEXIT () { &ldr  &r0, [ &sp],  &TF_R0;  &msr  &spsr_fsxc,  &r0;  &ldmia  &sp, { &r0- &r14}^;  &mov  &r0,  &r0;  &add  &sp,  &sp, ( &TF_SVC_SP- &TF_R0);  &ldmia  &sp, { &sp,  &lr,  &pc}^;}' unless defined(&PULLFRAMEFROMSVCANDEXIT);
    }
}
1;
