require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ALTQ_ALTQ_JOBS_H_)) {
    eval 'sub _ALTQ_ALTQ_JOBS_H_ () {1;}' unless defined(&_ALTQ_ALTQ_JOBS_H_);
    require 'altq/altq.ph';
    require 'altq/altq_classq.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub JOBS_MAXPRI () {16;}' unless defined(&JOBS_MAXPRI);
    eval 'sub SCALE_RATE () {32;}' unless defined(&SCALE_RATE);
    eval 'sub SCALE_LOSS () {32;}' unless defined(&SCALE_LOSS);
    eval 'sub SCALE_SHARE () {16;}' unless defined(&SCALE_SHARE);
    eval 'sub GRANULARITY () {1000000;}' unless defined(&GRANULARITY);
    eval 'sub ALTQ_INFINITY () { &LLONG_MAX;}' unless defined(&ALTQ_INFINITY);
    eval 'sub tslist_first {
        my($s) = @_;
	    eval q( &TAILQ_FIRST($s));
    }' unless defined(&tslist_first);
    eval 'sub tslist_last {
        my($s) = @_;
	    eval q( &TAILQ_LAST($s,  &_timestamps));
    }' unless defined(&tslist_last);
    eval 'sub tslist_empty {
        my($s) = @_;
	    eval q( &TAILQ_EMPTY($s));
    }' unless defined(&tslist_empty);
    eval 'sub secs_to_ticks {
        my($x) = @_;
	    eval q((($x) *  &machclk_freq));
    }' unless defined(&secs_to_ticks);
    eval 'sub ticks_to_secs {
        my($x) = @_;
	    eval q((($x) /  &machclk_freq));
    }' unless defined(&ticks_to_secs);
    eval 'sub invsecs_to_invticks {
        my($x) = @_;
	    eval q( &ticks_to_secs($x));
    }' unless defined(&invsecs_to_invticks);
    eval 'sub invticks_to_invsecs {
        my($x) = @_;
	    eval q( &secs_to_ticks($x));
    }' unless defined(&invticks_to_invsecs);
    eval 'sub bits_to_bytes {
        my($x) = @_;
	    eval q((($x) >> 3));
    }' unless defined(&bits_to_bytes);
    eval 'sub bytes_to_bits {
        my($x) = @_;
	    eval q((($x) << 3));
    }' unless defined(&bytes_to_bits);
    eval 'sub scale_rate {
        my($x) = @_;
	    eval q((($x) <<  &SCALE_RATE));
    }' unless defined(&scale_rate);
    eval 'sub unscale_rate {
        my($x) = @_;
	    eval q((($x) >>  &SCALE_RATE));
    }' unless defined(&unscale_rate);
    eval 'sub bps_to_internal {
        my($x) = @_;
	    eval q(( &invsecs_to_invticks( &bits_to_bytes( &scale_rate($x)))));
    }' unless defined(&bps_to_internal);
    eval 'sub internal_to_bps {
        my($x) = @_;
	    eval q(( &unscale_rate( &invticks_to_invsecs( &bytes_to_bits($x)))));
    }' unless defined(&internal_to_bps);
    eval 'sub delay_diff {
        my($x, $y) = @_;
	    eval q((($x >= $y)?($x - $y):(( &ULLONG_MAX-$y)+$x+1)));
    }' unless defined(&delay_diff);
    eval 'sub PKTCNTR_SUB {
        my($cntr, $len) = @_;
	    eval q( &do { ($cntr)-> &packets--; ($cntr)-> &bytes -= $len; }  &while ( 0));
    }' unless defined(&PKTCNTR_SUB);
    eval 'sub PKTCNTR_RESET {
        my($cntr) = @_;
	    eval q( &do { ($cntr)-> &packets = 0; ($cntr)-> &bytes = 0; }  &while ( 0));
    }' unless defined(&PKTCNTR_RESET);
    eval 'sub JOCF_CLEARDSCP () {0x10;}' unless defined(&JOCF_CLEARDSCP);
    eval 'sub JOCF_DEFAULTCLASS () {0x1000;}' unless defined(&JOCF_DEFAULTCLASS);
    eval 'sub JOBS_NULLCLASS_HANDLE () {0;}' unless defined(&JOBS_NULLCLASS_HANDLE);
    if(defined(&ALTQ3_CLFIER_COMPAT)) {
    }
    eval 'sub JOBS_IF_ATTACH () { &_IOW(ord(\'Q\'), 1, \'struct jobs_attach\');}' unless defined(&JOBS_IF_ATTACH);
    eval 'sub JOBS_IF_DETACH () { &_IOW(ord(\'Q\'), 2, \'struct jobs_interface\');}' unless defined(&JOBS_IF_DETACH);
    eval 'sub JOBS_ENABLE () { &_IOW(ord(\'Q\'), 3, \'struct jobs_interface\');}' unless defined(&JOBS_ENABLE);
    eval 'sub JOBS_DISABLE () { &_IOW(ord(\'Q\'), 4, \'struct jobs_interface\');}' unless defined(&JOBS_DISABLE);
    eval 'sub JOBS_CLEAR () { &_IOW(ord(\'Q\'), 6, \'struct jobs_interface\');}' unless defined(&JOBS_CLEAR);
    eval 'sub JOBS_ADD_CLASS () { &_IOWR(ord(\'Q\'), 7, \'struct jobs_add_class\');}' unless defined(&JOBS_ADD_CLASS);
    eval 'sub JOBS_DEL_CLASS () { &_IOW(ord(\'Q\'), 8, \'struct jobs_delete_class\');}' unless defined(&JOBS_DEL_CLASS);
    eval 'sub JOBS_MOD_CLASS () { &_IOW(ord(\'Q\'), 9, \'struct jobs_modify_class\');}' unless defined(&JOBS_MOD_CLASS);
    eval 'sub JOBS_ADD_FILTER () { &_IOWR(ord(\'Q\'), 10, \'struct jobs_add_filter\');}' unless defined(&JOBS_ADD_FILTER);
    eval 'sub JOBS_DEL_FILTER () { &_IOW(ord(\'Q\'), 11, \'struct jobs_delete_filter\');}' unless defined(&JOBS_DEL_FILTER);
    eval 'sub JOBS_GETSTATS () { &_IOWR(ord(\'Q\'), 12, \'struct jobs_class_stats\');}' unless defined(&JOBS_GETSTATS);
    if(defined(&_KERNEL)) {
	if(defined(&ALTQ3_CLFIER_COMPAT)) {
	}
    }
    if(defined(&__cplusplus)) {
    }
}
1;
