/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;

public class BasicIconFactory
implements Serializable {
    static final long serialVersionUID = 5605588811185324383L;
    private static CheckBoxIcon checkBoxIcon;
    private static RadioButtonIcon radioButtonIcon;

    public static Icon getMenuItemCheckIcon() {
        return new Icon(){

            public final int getIconHeight() {
                return 13;
            }

            public final int getIconWidth() {
                return 13;
            }

            public final void paintIcon(Component c, Graphics g, int x, int y) {
                Color saved = g.getColor();
                g.setColor(Color.BLACK);
                g.drawLine(3 + x, 5 + y, 3 + x, 9 + y);
                g.drawLine(4 + x, 5 + y, 4 + x, 9 + y);
                g.drawLine(5 + x, 7 + y, 9 + x, 3 + y);
                g.drawLine(5 + x, 8 + y, 9 + x, 4 + y);
                g.setColor(saved);
            }
        };
    }

    public static Icon getMenuItemArrowIcon() {
        return new DummyIcon();
    }

    public static Icon getMenuArrowIcon() {
        return new Icon(){

            public final int getIconHeight() {
                return 8;
            }

            public final int getIconWidth() {
                return 4;
            }

            public final void paintIcon(Component c, Graphics g, int x, int y) {
                Color saved = g.getColor();
                g.setColor(Color.BLACK);
                int i = 0;
                while (i < 4) {
                    g.drawLine(x + i, y + i, x + i, y + 7 - i);
                    ++i;
                }
                g.setColor(saved);
            }
        };
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        return new CheckBoxMenuItemIcon();
    }

    public static Icon getRadioButtonMenuItemIcon() {
        return BasicIconFactory.getRadioButtonIcon();
    }

    public static Icon createEmptyFrameIcon() {
        return new DummyIcon();
    }

    private static class DummyIcon
    implements Icon {
        public int getIconHeight() {
            return 10;
        }

        public int getIconWidth() {
            return 10;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color save = g.getColor();
            g.setColor(c.getForeground());
            g.drawRect(x, y, 10, 10);
            g.setColor(save);
        }

        private DummyIcon() {
        }
    }

    static class CheckBoxIcon
    implements Icon {
        public int getIconHeight() {
            return 13;
        }

        public int getIconWidth() {
            return 13;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        CheckBoxIcon() {
        }
    }

    static class RadioButtonIcon
    implements Icon {
        public int getIconHeight() {
            return 13;
        }

        public int getIconWidth() {
            return 13;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        RadioButtonIcon() {
        }
    }

    static class CheckBoxMenuItemIcon
    implements Icon {
        public int getIconHeight() {
            return 9;
        }

        public int getIconWidth() {
            return 9;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)c;
            if (item.isSelected()) {
                g.setColor(Color.black);
                g.drawLine(x + 1, y + 3, x + 1, y + 4);
                g.drawLine(x + 2, y + 4, x + 2, y + 5);
                int i = 0;
                while (i < 5) {
                    g.drawLine(x + 3 + i, y + 5 - i, x + 3 + i, y + 6 - i);
                    ++i;
                }
            }
        }

        CheckBoxMenuItemIcon() {
        }
    }
}

