LogTo( "gap3.log" );
RequirePackage( "ctbllib" );

# for name in LIBLIST.firstnames do
#   Print( name, "\n" );
#   Print( CharTable( name ), "\n" );
# od;

TEST := function( name )
    Print( name, "\n" );
    Print( IsCharTable( CharTable( name ) ), "\n" );
end;

TEST2 := function( name, prime )
    Print( name, " mod ", prime, "\n" );
    Print( IsCharTable( CharTable( name ) mod prime ), "\n" );
end;

TEST("(2xA6).2_3");
TEST("2.A10");
TEST("2.A10.2");
TEST("2.A11");
TEST("2.A11.2");
TEST("2.A12");
TEST("2.A12.2");
TEST("2.A13");
TEST("2.A13.2");
TEST("2.A14.2");
TEST("2.A15.2");
TEST("2.A16.2");
TEST("2.A17.2");
TEST("2.A18.2");
TEST("2.A5");
TEST("2.A5.2");
TEST("2.A6");
TEST("2.A6.2_1");
TEST("2.A6.2_2");
TEST("2.A7");
TEST("2.A7.2");
TEST("Isoclinic(2.A7.2)");
TEST("2.A8");
TEST("2.A8.2");
TEST("Isoclinic(2.A8.2)");
TEST("2.A9");
TEST("2.A9.2");
TEST("2F4(2)'M7");
TEST("3.A6");
TEST("3.A6.2^2");
TEST("3.A6.2_1");
TEST("3.A6.2_2");
TEST("3.A6.2_3");
TEST("3.A7");
TEST("3.A7.2");
TEST("4.A6.2_3");
TEST("6.A6");
TEST("6.A6.2_1");
TEST("6.A6.2_2");
TEST("6.A7");
TEST("6.A7.2");
TEST("A10");
TEST("A10.2");
TEST("A11");
TEST("A11.2");
TEST("A12");
TEST("A12.2");
TEST("A13");
TEST("A13.2");
TEST("A14");
TEST("A5");
TEST("A5.2");
TEST("A6.2_1M2");
TEST("A6");
TEST("A6.2^2");
TEST("A6.2_1");
TEST("A6.2_2");
TEST("A6.2_3");
TEST("A7");
TEST("A7.2");
TEST("A8");
TEST("A8.2");
TEST("A9");
TEST("A9.2");
TEST("M12M4");
TEST("A14.2");
TEST("A15.2");
TEST("A16.2");
TEST("A17");
TEST("A17.2");
TEST("A18.2");
TEST("4Y6.A6");
TEST("12.A6.2_3");
TEST("2.F4(2)");
TEST("2.F4(2).2");
TEST("2.(2xF4(2)).2");
TEST("2.G2(4)");
TEST("2.G2(4).2");
TEST("2.Sz(8)");
TEST("2^2.Sz(8)");
TEST("2^2.Sz(8).3");
TEST("3.G2(3)");
TEST("3.G2(3).2");
TEST("F4(2)");
TEST("F4(2).2");
TEST("G2(3)");
TEST("G2(3).2");
TEST("G2(4)");
TEST("G2(4).2");
TEST("G2(5)");
TEST("R(27)");
TEST("R(27).3");
TEST("Sz(32)");
TEST("Sz(32).5");
TEST("Sz(8)");
TEST("Sz(8).3");
TEST("3^(1+10):U5(2):2");
TEST("3^5:U4(2)");
TEST("3^7:O7(3)");
TEST("2^7:S6(2)");
TEST("2^8:O8+(2)");
TEST("2^8:S8(2)");
TEST("2.Co1");
TEST("2.J2");
TEST("2.J2.2");
TEST("3.J3");
TEST("3.J3.2");
TEST("Co1");
TEST("Co2");
TEST("Co3");
TEST("J1");
TEST("J2");
TEST("J2.2");
TEST("J3");
TEST("J3.2");
TEST("J4");
TEST("E6(2)");
TEST("2.Fi22");
TEST("2.Fi22.2");
TEST("3.Fi22");
TEST("3.Fi22.2");
TEST("6.Fi22");
TEST("6.Fi22.2");
TEST("Fi22");
TEST("Fi22.2");
TEST("3.F3+");
TEST("3.F3+.2");
TEST("F3+");
TEST("F3+.2");
TEST("Fi23");
TEST("P1/G1/L1/V1/ext2");
TEST("P1/G1/L1/V1/ext3");
TEST("P1/G1/L1/V1/ext4");
TEST("P1/G1/L1/V1/ext5");
TEST("P1/G1/L1/V1/ext6");
TEST("P1/G1/L1/V2/ext3");
TEST("P1/G1/L1/V2/ext6");
TEST("P1/G2/L1/V1/ext2");
TEST("P1/G2/L1/V1/ext3");
TEST("P1/G2/L1/V1/ext4");
TEST("P1/G2/L1/V2/ext2");
TEST("P1/G2/L1/V2/ext4");
TEST("P1/G2/L2/V2/ext2");
TEST("P1/G2/L2/V2/ext4");
TEST("P1/G3/L2/V1/ext2");
TEST("P1/G3/L2/V1/ext3");
TEST("P11/G1/L1/V1/ext2");
TEST("P11/G1/L1/V1/ext3");
TEST("P11/G1/L1/V1/ext4");
TEST("P11/G1/L1/V2/ext2");
TEST("P11/G1/L1/V2/ext4");
TEST("P11/G1/L1/V3/ext2");
TEST("P11/G1/L1/V3/ext4");
TEST("P11/G2/L1/V1/ext2");
TEST("P11/G2/L1/V1/ext3");
TEST("P11/G2/L1/V2/ext2");
TEST("P11/G3/L1/V1/ext2");
TEST("P11/G3/L1/V1/ext3");
TEST("P11/G3/L1/V2/ext3");
TEST("P11/G3/L3/V1/ext2");
TEST("P11/G3/L3/V2/ext3");
TEST("P11/G3/L4/V2/ext2");
TEST("P11/G3/L4/V2/ext3");
TEST("P11/G3/L4/V3/ext2");
TEST("P11/G4/L1/V1/ext2");
TEST("P11/G4/L1/V1/ext3");
TEST("P12/G1/L2/V1/ext2");
TEST("P12/G1/L2/V1/ext3");
TEST("P13/G1/L2/V1/ext2");
TEST("P13/G1/L2/V1/ext3");
TEST("P13/G1/L6/V1/ext2");
TEST("P2/G1/L1/V1/ext2");
TEST("P2/G1/L1/V1/ext3");
TEST("P2/G2/L1/V1/ext2");
TEST("P2/G2/L1/V1/ext3");
TEST("P2/G2/L1/V2/ext2");
TEST("P21/G1/L1/V1/ext2");
TEST("P21/G1/L1/V1/ext3");
TEST("P21/G1/L1/V1/ext4");
TEST("P21/G1/L3/V2/ext3");
TEST("P21/G2/L1/V1/ext2");
TEST("P21/G2/L1/V2/ext2");
TEST("P21/G2/L1/V3/ext2");
TEST("P21/G2/L2/V1/ext2");
TEST("P21/G2/L2/V2/ext2");
TEST("P21/G2/L2/V3/ext2");
TEST("P21/G2/L5/V2/ext2");
TEST("P21/G3/L2/V1/ext2");
TEST("P21/G3/L5/V1/ext2");
TEST("P27/G1/L1/V1/ext2");
TEST("P27/G1/L1/V1/ext3");
TEST("P27/G1/L1/V1/ext4");
TEST("P31/G1/L1/V1/ext2");
TEST("P31/G1/L1/V1/ext3");
TEST("P41/G1/L1/V1/ext2");
TEST("P41/G1/L1/V1/ext3");
TEST("P41/G1/L1/V2/ext2");
TEST("P41/G1/L1/V3/ext3");
TEST("P41/G1/L1/V4/ext2");
TEST("P41/G1/L1/V4/ext3");
TEST("P41/G2/L1/V1/ext2");
TEST("P41/G2/L1/V1/ext3");
TEST("P43/G1/L1/V1/ext2");
TEST("P43/G2/L1/V1/ext2");
TEST("P43/G3/L1/V1/ext2");
TEST("P43/G3/L1/V2/ext2");
TEST("P48/G1/L1/V1/ext2");
TEST("P48/G1/L1/V2/ext2");
TEST("P49/G1/L1/V1/ext2");
TEST("P49/G1/L1/V1/ext3");
TEST("P49/G1/L1/V2/ext3");
TEST("P50/G1/L1/V1/ext2");
TEST("P50/G1/L1/V1/ext3");
TEST("P50/G1/L1/V1/ext4");
TEST("S3");
TEST("2.S3");
TEST("Sym4");
TEST("2.Sym4");
TEST("D8");
TEST("2.D8");
TEST("7:3");
TEST("2x7:3");
TEST("C4");
TEST("C6");
TEST("3^2:2");
TEST("3^(1+2)_+:2");
TEST("3^2:4");
TEST("2^3.S3");
TEST("2^3.D8");
TEST("2^3.S4v1");
TEST("2^3.S4v2");
TEST("2xSym4");
TEST("D8x2");
TEST("2^2:S4");
TEST("(A4x3):2");
TEST("S3x2");
TEST("(A5x3):2");
TEST("2^4:(3x3):2");
TEST("2^3:7");
TEST("2^3");
TEST("S3xS3");
TEST("3^(1+2):4");
TEST("4^2:3");
TEST("3^2");
TEST("3^(1+2)_+");
TEST("2.2^4:3");
TEST("2.L2(11)");
TEST("2.L2(11).2");
TEST("2.L2(13)");
TEST("2.L2(13).2");
TEST("2.L2(17)");
TEST("2.L2(17).2");
TEST("2.L2(19)");
TEST("2.L2(19).2");
TEST("2.L2(23)");
TEST("2.L2(23).2");
TEST("2.L2(25)");
TEST("2.L2(25).2_1");
TEST("2.L2(25).2_2");
TEST("2.L2(27)");
TEST("2.L2(27).2");
TEST("2.L2(27).3");
TEST("2.L2(27).6");
TEST("2.L2(29)");
TEST("2.L2(29).2");
TEST("2.L2(31)");
TEST("2.L2(31).2");
TEST("J3M3");
TEST("L2(11)");
TEST("L2(11).2");
TEST("M12.2M3");
TEST("L2(13)");
TEST("L2(13).2");
TEST("L2(16)");
TEST("L2(16).2");
TEST("L2(16).4");
TEST("L2(17)");
TEST("L2(17).2");
TEST("L2(19)");
TEST("L2(19).2");
TEST("L2(23)");
TEST("L2(23).2");
TEST("L2(25)");
TEST("L2(25).2^2");
TEST("L2(25).2_1");
TEST("L2(25).2_2");
TEST("L2(25).2_3");
TEST("L2(27)");
TEST("L2(27).2");
TEST("L2(27).3");
TEST("L2(27).6");
TEST("L2(29)");
TEST("L2(29).2");
TEST("L2(31)");
TEST("L2(31).2");
TEST("L2(32)");
TEST("L2(32).5");
TEST("L2(8)");
TEST("L2(8).3");
TEST("ONM8");
TEST("2.L2(49)");
TEST("2.L2(49).2_1");
TEST("2.L2(49).2_2");
TEST("2.L2(81)");
TEST("2.L2(81).2_1");
TEST("2.L2(81).2_2");
TEST("2.L2(81).4_1");
TEST("L2(49)");
TEST("L2(49).2_1");
TEST("L2(49).2_2");
TEST("L2(49).2_3");
TEST("L2(81)");
TEST("L2(81).2_1");
TEST("L2(81).2_2");
TEST("L2(81).2_3");
TEST("L2(81).4_1");
TEST("L2(81).4_2");
TEST("12_1.L3(4)");
TEST("12_1.L3(4).2_1");
TEST("12_1.L3(4).2_2");
TEST("12_1.L3(4).2_3");
TEST("12_2.L3(4)");
TEST("12_2.L3(4).2_1");
TEST("12_2.L3(4).2_2");
TEST("12_2.L3(4).2_3");
TEST("2.L3(4)");
TEST("2.L3(4).2_1");
TEST("Isoclinic(2.L3(4).2_1)");
TEST("2.L3(4).2_2");
TEST("2.L3(4).2_3");
TEST("2^2.L3(4)");
TEST("3.L3(4)");
TEST("3.L3(4).2^2");
TEST("3.L3(4).2_1");
TEST("3.L3(4).2_2");
TEST("3.L3(4).2_3");
TEST("3.L3(4).3");
TEST("3.L3(4).6");
TEST("4_1.L3(4)");
TEST("4_1.L3(4).2_1");
TEST("4_1.L3(4).2_2");
TEST("4_1.L3(4).2_3");
TEST("4_2.L3(4)");
TEST("4_2.L3(4).2_1");
TEST("4_2.L3(4).2_2");
TEST("4_2.L3(4).2_3");
TEST("6.L3(4)");
TEST("6.L3(4).2_1");
TEST("6.L3(4).2_2");
TEST("6.L3(4).2_3");
TEST("L3(4)");
TEST("L3(4).2^2");
TEST("L3(4).2_1");
TEST("L3(4).2_2");
TEST("L3(4).2_3");
TEST("L3(4).3");
TEST("L3(4).3.2_2");
TEST("L3(4).3.2_3");
TEST("L3(4).6");
TEST("(2^2x3).L3(4)");
TEST("2^2.L3(4).2_2");
TEST("2.L3(2)");
TEST("2.L3(2).2");
TEST("2F4(2)'M2");
TEST("3.L3(7)");
TEST("3.L3(7).2");
TEST("3.L3(7).3");
TEST("L3(2)");
TEST("L3(2).2");
TEST("L3(3)");
TEST("L3(3).2");
TEST("G2(3)M6");
TEST("L3(5)");
TEST("L3(5).2");
TEST("L3(7)");
TEST("L3(7).2");
TEST("L3(7).3");
TEST("L3(8)");
TEST("L3(8).2");
TEST("L3(8).3");
TEST("L3(8).6");
TEST("ONM2");
TEST("SuzM15");
TEST("2.L4(3)");
TEST("2.L4(3).2_1");
TEST("2.L4(3).2_2");
TEST("2.L4(3).2_3");
TEST("L3(9)");
TEST("L3(9).2_1");
TEST("L3(9).2_2");
TEST("L3(9).2_3");
TEST("L4(3)");
TEST("L4(3).2_1");
TEST("L4(3).2_2");
TEST("L4(3).2_3");
TEST("L4(3).2^2");
TEST("L5(2)");
TEST("L5(2).2");
TEST("L6(2)");
TEST("L6(2).2");
TEST("L4(4)");
TEST("L4(4).2_1");
TEST("L4(4).2_2");
TEST("L4(4).2_3");
TEST("L7(2)");
TEST("L7(2).2");
TEST("L5(3)");
TEST("L5(3).2");
TEST("L2(37)");
TEST("L2(41)");
TEST("L2(43)");
TEST("L2(47)");
TEST("L2(53)");
TEST("L2(59)");
TEST("L2(61)");
TEST("L2(64)");
TEST("L2(67)");
TEST("L2(71)");
TEST("L2(73)");
TEST("L2(79)");
TEST("L2(83)");
TEST("L2(89)");
TEST("L2(97)");
TEST("L2(101)");
TEST("L2(103)");
TEST("L2(107)");
TEST("L2(109)");
TEST("L2(113)");
TEST("L2(121)");
TEST("L4(9)");
TEST("12.M22");
TEST("12.M22.2");
TEST("2.M12");
TEST("2.M12.2");
TEST("Isoclinic(2.M12.2)");
TEST("2.M22");
TEST("2.M22.2");
TEST("3.M22");
TEST("3.M22.2");
TEST("4.M22");
TEST("4.M22.2");
TEST("6.M22");
TEST("6.M22.2");
TEST("HNM12");
TEST("HSM9");
TEST("M11");
TEST("M12");
TEST("M12.2");
TEST("M12M2");
TEST("M22");
TEST("M22.2");
TEST("M23");
TEST("M24");
TEST("McLM3");
TEST("3.McLM3");
TEST("ONM11");
TEST("2^4:s5");
TEST("2.M22M5");
TEST("2.S4");
TEST("23:11");
TEST("2^3:sl(3,2)");
TEST("2^4:(3xA5).2");
TEST("2^4:a6");
TEST("2.M22M2");
TEST("3.M22M2");
TEST("4.M22M2");
TEST("6.M22M2");
TEST("12.M22M2");
TEST("2^4:a7");
TEST("3.2^4:a7");
TEST("3.McLM10");
TEST("2xA7");
TEST("2x(3.A7)");
TEST("2.(2xA7)");
TEST("2.(2x3.A7)");
TEST("3x2^4:s5");
TEST("4.M22M5");
TEST("3x2.M22M5");
TEST("3x4.M22M5");
TEST("2x2^3:L3(2)");
TEST("3x2^3:L3(2)");
TEST("4.M22M6");
TEST("6x2^3:L3(2)");
TEST("3x4.M22M6");
TEST("(4xA6).2_3");
TEST("6.M22M7");
TEST("12.M22M7");
TEST("2xL2(11)");
TEST("3xL2(11)");
TEST("2.(2xL2(11))");
TEST("6xL2(11)");
TEST("3x2.(2xL2(11))");
TEST("McLM10");
TEST("2^4:a8");
TEST("2^6:(psl(3,2)xs3)");
TEST("2^6:3.s6");
TEST("2xS5");
TEST("3^2.2.S4");
TEST("4^2:D12");
TEST("4^2:D12.2");
TEST("A4xS3");
TEST("M12M7");
TEST("M22.2M4");
TEST("M8.S4");
TEST("S4xS3");
TEST("2xM11");
TEST("2.HSM9");
TEST("2.M12M2");
TEST("2.M12M4");
TEST("2x3^2.2.S4");
TEST("2.M12M7");
TEST("2.M12M8");
TEST("2.M12M9");
TEST("2.M12M10");
TEST("2.A4xS3");
TEST("(2^2xSz(8)):3");
TEST("(3^2:4xa6).2");
TEST("(3^2:4x2.A6).2");
TEST("(3xG2(3)):2");
TEST("(D10xU3(5)).2");
TEST("(a4xpsl(3,4)):2");
TEST("2.(A4xL3(4)).2");
TEST("(a6xa5).2");
TEST("2.(2^2xSz(8)):3");
TEST("2.2.2^4+6:S5");
TEST("2.2^3+8:L3(2)");
TEST("2.2^4+6:S5");
TEST("2.2^6:u3(3):2");
TEST("2.RuM1");
TEST("2^(1+8).(A5xA5).2");
TEST("2^1+6.psl(3,2)");
TEST("2^1+6.u4q2");
TEST("2.SuzM4");
TEST("2^1+8.a9");
TEST("2^1+8.2.A9");
TEST("2^2+8(a5xs3)");
TEST("2.SuzM9");
TEST("(2xL3(3)).2");
TEST("2.SuzM15");
TEST("2^2.psl(3,4).s3");
TEST("2^3+8:L3(2)");
TEST("2^3.2^2.2^6.(3xL3(2))");
TEST("2^4+6:3a6");
TEST("2.SuzM7");
TEST("2^4.s6");
TEST("2.2^4.S6");
TEST("2^4.(S4x2)");
TEST("2^5.psl(5,2)");
TEST("2^6.U4(2)");
TEST("2^6.U4(2).2");
TEST("2^6:u3(3):2");
TEST("2xa6.2^2");
TEST("2.HSM11");
TEST("3.3^(1+4):2S5");
TEST("3.3^(1+4):4S5");
TEST("2^(1+3):L3(2)");
TEST("2^(2+4):(3x3):2");
TEST("3.2^(2+4):(3x3):2");
TEST("2^(1+1+2+2):S3");
TEST("2^(2+4).S3");
TEST("2^(2+4).(S3x2)");
TEST("3.ONM5");
TEST("31:15");
TEST("37:18");
TEST("3^(1+4):2S5");
TEST("3^(1+4):4A5");
TEST("3^(1+4):4S5");
TEST("3^(1+6):2^(3+4):3^2:2");
TEST("3^(2+4):2A5.D8");
TEST("3^2+4:2(2^2xa4)2");
TEST("3^4:2(A4xA4).4");
TEST("3^4:m10");
TEST("3.3^4:m10");
TEST("3^4.3^2.Q8");
TEST("3.3^4.3^2.Q8");
TEST("3xL3(4).2_2");
TEST("3x2.A8");
TEST("3xM11");
TEST("3x5^(1+2):3:8");
TEST("3^5:2S6");
TEST("3^5:M11");
TEST("3^6.M11");
TEST("3x2.SuzM4");
TEST("2x3^6.M11");
TEST("3x2.J2.2");
TEST("3x2.SuzM7");
TEST("3x2.SuzM9");
TEST("3xIsoclinic(2.M12.2)");
TEST("4.2^4.S5");
TEST("2.HSM10");
TEST("4.2^4:(2xS3)");
TEST("4.2^4");
TEST("S4x2^2");
TEST("4.2^4:S4");
TEST("4^3.L3(2)");
TEST("4^3:psl(3,2)");
TEST("2.4^3.L3(2)");
TEST("4^3:S4");
TEST("5:4xa5");
TEST("5:4x2.A5");
TEST("5:4xA4");
TEST("5:4x2^2");
TEST("A4xC4");
TEST("D8xV4");
TEST("5^(1+4):2^(1+4).5.4");
TEST("5^(1+4):4S6");
TEST("5^2.5.5^2.4A5");
TEST("5^2:4s5");
TEST("5^3.psl(3,5)");
TEST("67:22");
TEST("7:3xpsl(3,2)");
TEST("7^2:(3x2S4)");
TEST("7^2:2psl(2,7)");
TEST("LyM6");
TEST("ONM5");
TEST("ThM7");
TEST("ThN3B");
TEST("s4xpsl(3,2)");
TEST("2^(1+6)_-.U4(2).2");
TEST("3^5:(M11x2)");
TEST("J2.2x2");
TEST("2^(4+6):3S6");
TEST("(A4xL3(4):2_3):2");
TEST("2^(2+8):(S5xS3)");
TEST("M12.2x2");
TEST("3^(2+4):2(S4xD8)");
TEST("(A6:2_2xA5).2");
TEST("(3^2:8xA6).2");
TEST("3xG2(4)");
TEST("3x2.G2(4)");
TEST("2xU5(2)");
TEST("3xU5(2)");
TEST("3x2^(1+6)_-.U4(2)");
TEST("3xJ2.2");
TEST("3x2^(4+6).3A6");
TEST("(A4x3.L3(4)).2");
TEST("3x2^(2+8):(A5xS3)");
TEST("3xM12.2");
TEST("3.3^(2+4):2(A4x2^2).2");
TEST("(3.A6xA5):2");
TEST("(3^(1+2):4xA6).2");
TEST("3xL3(3).2");
TEST("3xL2(25)");
TEST("(3xG2(4)).2");
TEST("(3xU5(2)).2");
TEST("(3x2^(1+6)_-.U4(2)).2");
TEST("3^6:(M11x2)");
TEST("S3xJ2.2");
TEST("(3x2^(4+6):3A6).2");
TEST("(A4x3.L3(4).2_3).2");
TEST("(3x2^(2+8):(A5xS3)).2");
TEST("S3xM12.2");
TEST("3.3^(2+4):2(S4xD8)");
TEST("(3.A6.2_2xA5):2");
TEST("(3^(1+2):8xA6).2");
TEST("(3xL2(25)).2_2");
TEST("3^4:(M10x2)");
TEST("2x3^5:M11");
TEST("2.SuzM11");
TEST("6.SuzM8");
TEST("6.SuzM11");
TEST("3x(2xL3(3)).2");
TEST("6.SuzM15");
TEST("3x2.L2(25)");
TEST("(3^(1+2):4x2.A6).2");
TEST("(A6x2.A5).2");
TEST("(3.A6x2.A5).2");
TEST("Isoclinic(S8x2)");
TEST("Isoclinic(U3(5).2x2)");
TEST("2.HSM3");
TEST("(A4xG2(4)):2");
TEST("(A5xJ2):2");
TEST("(A6xU3(3)):2");
TEST("(A7xL2(7)):2");
TEST("(D10x(A5xA5).2).2");
TEST("2.2^11:M24");
TEST("2^(1+8)+.O8+(2)");
TEST("2^(2+12):(A8xS3)");
TEST("2^(4+10)(S5xS3)");
TEST("2^(4+12).(S3x3S6)");
TEST("2^1+4+6.a8");
TEST("2^1+8:s6f2");
TEST("2^10:m22:2");
TEST("2^11:M24");
TEST("2^2.(2^7.3^2).s3");
TEST("2^4.a8");
TEST("2xm12");
TEST("3^(3+4):2(S4xS4)");
TEST("3^1+4:2^1+4.s5");
TEST("3^1+4:4s6");
TEST("3^5:(2xm11)");
TEST("3^6:2M12");
TEST("5^(1+2):GL2(5)");
TEST("5^2:2A5");
TEST("5^3:(4xA5).2");
TEST("A9xS3");
TEST("a4xs5");
TEST("psl(3,4):d12");
TEST("s3xpsl(2,8).3");
TEST("u4q3:2^2");
TEST("(2^2x2^(1+8)).(3xU4(2)).2");
TEST("(3xO8+(3):3):2");
TEST("(A4xO8+(2).3).2");
TEST("(A5xA9):2");
TEST("29:14");
TEST("2^(5+8):(S3xA6)");
TEST("2^(6+8):(A7xS3)");
TEST("2x3.O7(3)");
TEST("2xO7(3)");
TEST("3^(1+8).2^(1+6).3^(1+2).2S4");
TEST("7:6xA7");
TEST("A6xL2(8):3");
TEST("Fi23M8");
TEST("S3xO7(3)");
TEST("S3xU4(3).(2^2)_{122}");
TEST("S3xU4(3).2_2");
TEST("S4xS6(2)");
TEST("O8+(2):S3x2");
TEST("(2x2^(1+8)):U4(2):2");
TEST("(2x2^(1+8)):(U4(2):2x2)");
TEST("3x(2x2^(1+8)):U4(2):2");
TEST("3.(2x2^(1+8)):(U4(2):2x2)");
TEST("Fi22.2M6");
TEST("2^12.3_1.U4(3).2_2'");
TEST("2^(1+12).3_1.U4(3).2_2'");
TEST("3^3.[3^10].GL3(3)");
TEST("2.[2^6]:(S3xS3)");
TEST("2^5:S6");
TEST("2^6:L3(2)");
TEST("S3xS6");
TEST("(2^6x2^8):S6(2)");
TEST("(2^(1+8)x2^6):S6(2)");
TEST("3^6:L3(3)");
TEST("3^(3+4):2(S4xA4)");
TEST("A4xU4(2)");
TEST("2.(A4xU4(2))");
TEST("2^(2+6):3^3:S3");
TEST("2xU3(3).2");
TEST("(2x3.A6).2");
TEST("(2xL3(2)).2");
TEST("(3xM10):2");
TEST("11:10");
TEST("19:18");
TEST("19:6");
TEST("2.J2M8");
TEST("2A4xA5");
TEST("2A5xD10");
TEST("2^(1+4).S5");
TEST("2^(2+4):(S3xS3)");
TEST("2^1+4b:a5");
TEST("2^2+4.3xs3");
TEST("2^{1+4}_-:2A5");
TEST("2^{3+4}:(3xS3)");
TEST("2xA5");
TEST("2xU3(3)");
TEST("37:12");
TEST("3^2.3^(1+2):8.2");
TEST("3x2^4:(3xA5)");
TEST("43:14");
TEST("5^2:D12");
TEST("7:6");
TEST("D6xD10");
TEST("(2^2xA5):2");
TEST("D8.(S4x2)");
TEST("F3+M7");
TEST("J4M4");
TEST("L2(17)x2");
TEST("a4xa5");
TEST("a5xd10");
TEST("c2aj4");
TEST("frob");
TEST("j3m4");
TEST("j3m6");
TEST("2^10:L5(2)");
TEST("mx1j4");
TEST("(A4xA5):2");
TEST("(A5xD10).2");
TEST("L3(2).2x2");
TEST("3^5.U4(2)");
TEST("3.3^5.U4(2)");
TEST("C9Y3.3^5.U4(2)");
TEST("2^24.Co1");
TEST("2^1+24.Co1");
TEST("2^1+24.2.Co1");
TEST("(3^(1+2)+x3^2):2S4");
TEST("G2(3)M4");
TEST("2^(1+4)+:3^2.2");
TEST("2^(5+5):31");
TEST("41:4");
TEST("25:4");
TEST("D62");
TEST("O8+(3)M14");
TEST("(A4xU4(2)):2");
TEST("O8+(3)M19");
TEST("O8+(3)M20");
TEST("O8+(3)M21");
TEST("O8+(3)M22");
TEST("O8+(3)M23");
TEST("(A6xA6):2^2");
TEST("O8+(3)M25");
TEST("O8+(3)M26");
TEST("(A4wr2^2):2");
TEST("O8+(3)M27");
TEST("2..11.m23");
TEST("2.2^8.f20");
TEST("2^10:(2^5:s5)");
TEST("2^2.2^8:s3");
TEST("2^6:u3(3)");
TEST("2^{1+6}:3^{1+2}:2A4");
TEST("3.s7x2");
TEST("4.s4");
TEST("4^2:s3");
TEST("A11Syl2");
TEST("A15");
TEST("A16");
TEST("a4");
TEST("2.L2(3)");
TEST("a5wc2");
TEST("affine");
TEST("b33141");
TEST("bd10");
TEST("bd6");
TEST("bd8");
TEST("c2m22");
TEST("c2m24");
TEST("c3d2");
TEST("d60");
TEST("esp43t");
TEST("j2nd2");
TEST("2^10:m22");
TEST("2.Fi22M5");
TEST("3.Fi22M5");
TEST("6.Fi22M5");
TEST("2^6:s6f2");
TEST("f22s2");
TEST("g61");
TEST("g61s1");
TEST("g72x16");
TEST("ghh");
TEST("gl25");
TEST("group2");
TEST("group3");
TEST("group5");
TEST("group6");
TEST("gs4");
TEST("h4");
TEST("hed3");
TEST("hess");
TEST("hsd2");
TEST("m12d2");
TEST("mo61");
TEST("2^4:(S3xS3)");
TEST("mo62");
TEST("mo62p");
TEST("mo81");
TEST("2^6:A8");
TEST("ons1");
TEST("u4q3.s3");
TEST("P1L62");
TEST("P1L72");
TEST("P1L82");
TEST("P2L62");
TEST("P2L72");
TEST("P3L62");
TEST("P3L72");
TEST("P2L82");
TEST("L3(4)Syl2");
TEST("M23C2A");
TEST("U72CT");
TEST("pap");
TEST("V4");
TEST("Q8");
TEST("s2m24");
TEST("s2wrs2");
TEST("s2wrs3");
TEST("s2wrs4");
TEST("s2wrs5");
TEST("s3wrs2");
TEST("s3wrs3");
TEST("s4");
TEST("s4wrs2");
TEST("s5wrs2");
TEST("s61");
TEST("s61p");
TEST("sl25ex");
TEST("suzd2");
TEST("suzdx");
TEST("suzs2");
TEST("twd5a");
TEST("w(d4)");
TEST("w(d5)");
TEST("w(f4)");
TEST("2.B");
TEST("B");
TEST("M");
TEST("(3^2:2xG2(3)).2");
TEST("(3xA6).2_1");
TEST("(A6xA6).D8");
TEST("2.(A4xA4)");
TEST("2.2^(2+8).(3xA5)");
TEST("2F4(8)");
TEST("2^(1+6)_-3.3.3^2:2");
TEST("2^(2+8):(3xA5)");
TEST("2^(4+6):(A5x3)");
TEST("2^(4+8):(S3xA5)");
TEST("2^5:L5(2)");
TEST("2^6:U4(2)");
TEST("2^8:O8-(2)");
TEST("2^9.L3(4)");
TEST("2.U6(2)M3");
TEST("3.U6(2)M3");
TEST("6.U6(2)M3");
TEST("2^2.U6(2)M3");
TEST("(2^2x3).U6(2)M3");
TEST("2xS6(2)");
TEST("3.ONM6");
TEST("3^(1+4).2U4(2)");
TEST("3^(1+4).2U4(2).2");
TEST("3^3.S4");
TEST("3^3:A4");
TEST("3^4.2U4(2)");
TEST("3^4.2U4(2).2");
TEST("3^4:(2xA5)");
TEST("3^4:A6");
TEST("3^6:L4(3)");
TEST("O8+(3)M8");
TEST("O8+(3)M9");
TEST("3^7.O7(3)");
TEST("5^(1+4):GL(2,5)");
TEST("6xU5(2)");
TEST("7^2:2.L2(7).2");
TEST("A6.D8");
TEST("D8xL4(3).2_2");
TEST("M22.2M3");
TEST("O7(3).2x2");
TEST("S4xU4(2).2");
TEST("2^6:U4(2).2");
TEST("2^3.L3(2)");
TEST("S8(2)M3");
TEST("5:4");
TEST("2^8:S6(2)");
TEST("2.O7(3)");
TEST("2.O7(3).2");
TEST("3.O7(3)");
TEST("3.O7(3).2");
TEST("6.O7(3)");
TEST("6.O7(3).2");
TEST("Fi22M3");
TEST("O7(3)");
TEST("O8+(3)M2");
TEST("O8+(3)M3");
TEST("O8+(3)M4");
TEST("O8+(3)M5");
TEST("O8+(3)M6");
TEST("O7(3).2");
TEST("2.O8+(2)");
TEST("2.O8+(2).2");
TEST("2^2.O8+(2)");
TEST("O8+(2)");
TEST("O8+(3)M11");
TEST("O8+(3)M12");
TEST("O8+(3)M13");
TEST("O8+(2).2");
TEST("O8+(2).3");
TEST("O8+(2).3.2");
TEST("O8+(3)");
TEST("O8+(3).2_1");
TEST("O8+(3).2_2");
TEST("O8+(3).3");
TEST("O8+(3).3.2");
TEST("O8+(3).4");
TEST("O8+(3).(2^2)_{111}");
TEST("O8+(3).A4");
TEST("O8+(3).S4");
TEST("O10+(2)");
TEST("O10+(2).2");
TEST("O10-(2)");
TEST("O10-(2).2");
TEST("O8-(2)");
TEST("O8-(2).2");
TEST("O8-(3)");
TEST("O12-(2).2");
TEST("O12+(2).2");
TEST("2.HS");
TEST("2.HS.2");
TEST("2.Ru");
TEST("2.Suz");
TEST("2.Suz.2");
TEST("3.McL");
TEST("3.McL.2");
TEST("3.ON");
TEST("3.ON.2");
TEST("3.Suz");
TEST("3.Suz.2");
TEST("6.Suz");
TEST("6.Suz.2");
TEST("F3+M14");
TEST("HN");
TEST("HN.2");
TEST("HS");
TEST("HS.2");
TEST("He");
TEST("He.2");
TEST("Ly");
TEST("McL");
TEST("McL.2");
TEST("ON");
TEST("ON.2");
TEST("Ru");
TEST("Suz");
TEST("Suz.2");
TEST("Th");
TEST("(3^(1+2)x2).SD16");
TEST("11+^(1+2):(5x2S4)");
TEST("2.HS.2N5");
TEST("2^3.7.3");
TEST("2^4:D8");
TEST("2x(3^2.QD16)");
TEST("3^(1+2):8");
TEST("3^(1+2):D8");
TEST("3^(1+2):SD16");
TEST("3^2.3^(1+2):8");
TEST("3^2:Q8");
TEST("3^2:Q8.2");
TEST("3^2:SD16");
TEST("3^4:(3^2:Q8)");
TEST("3^4:2^(1+4)D10");
TEST("3^5:(3^2:SD16)");
TEST("4^3.D8");
TEST("5^(1+2):(24:2)");
TEST("5^(1+2):(8.2)");
TEST("5^(1+2):3:8");
TEST("5^(1+2):4S4");
TEST("5^1+2:(2^5)");
TEST("5^2:(4xS3)");
TEST("5^2:4A4");
TEST("7^(1+2):(D8x3)");
TEST("7^(1+2):(S3x3)");
TEST("7^2:(3x2A4)");
TEST("Co1N3");
TEST("Co3N2");
TEST("Co3N3");
TEST("Fi22N3");
TEST("Fi22N5");
TEST("HS.2N5");
TEST("HSN2");
TEST("J2N2");
TEST("J3N2");
TEST("LyN2");
TEST("LyN3");
TEST("LyN5");
TEST("M11N2");
TEST("M12N2");
TEST("M12N3");
TEST("M24N2");
TEST("McLN2");
TEST("RuN2");
TEST("SuzN2");
TEST("ThN2");
TEST("2.HSN3");
TEST("2.S4(5)");
TEST("2.S4(5).2");
TEST("2.S6(2)");
TEST("2.S6(3)");
TEST("2.S6(3).2");
TEST("S10(2)");
TEST("S4(4)");
TEST("S4(4).2");
TEST("S4(4).4");
TEST("S4(5)");
TEST("S4(5).2");
TEST("S6(2)");
TEST("S6(3)");
TEST("S6(3).2");
TEST("S8(2)");
TEST("S4(7)");
TEST("S4(7).2");
TEST("S6(4)");
TEST("S6(5)");
TEST("S12(2)");
TEST("2F4(2)'");
TEST("2F4(2)'.2");
TEST("3D4(2)");
TEST("3D4(2).3");
TEST("2.2E6(2)");
TEST("2.2E6(2).2");
TEST("2^2.2E6(2)");
TEST("2^2.2E6(2).2");
TEST("2^2.2E6(2).3");
TEST("2^2.2E6(2).3.2");
TEST("2E6(2)");
TEST("2E6(2).2");
TEST("2E6(2).3");
TEST("2E6(2).3.2");
TEST("12_1.U4(3)");
TEST("12_1.U4(3).2_1");
TEST("12_1.U4(3).2_2");
TEST("12_2.U4(3)");
TEST("12_2.U4(3).2_1");
TEST("12_2.U4(3).2_3");
TEST("2.U4(3)");
TEST("2.U4(3).2_1");
TEST("2.U4(3).2_2");
TEST("2.U4(3).2_3");
TEST("2.U4(3).2_3'");
TEST("2.U4(3).4");
TEST("2.U4(3).(2^2)_{122}");
TEST("O8+(3)M16");
TEST("O8+(3)M17");
TEST("3^2.U4(3).2_3'");
TEST("3^2.U4(3).(2^2)_{133}");
TEST("3^2.U4(3).D8");
TEST("3_1.U4(3)");
TEST("3_1.U4(3).2_1");
TEST("3_1.U4(3).2_2");
TEST("3_1.U4(3).2_2'");
TEST("3_2.U4(3)");
TEST("3_2.U4(3).2_1");
TEST("3_2.U4(3).2_3");
TEST("3_2.U4(3).2_3'");
TEST("3_2.U4(3).(2^2)_{133}");
TEST("4.U4(3)");
TEST("4.U4(3).2_1");
TEST("4.U4(3).2_2");
TEST("4.U4(3).2_3");
TEST("4.U4(3).4");
TEST("6_1.U4(3)");
TEST("6_1.U4(3).2_1");
TEST("6_1.U4(3).2_2");
TEST("6_2.U4(3)");
TEST("6_2.U4(3).2_1");
TEST("6_2.U4(3).2_3");
TEST("6_2.U4(3).2_3'");
TEST("Isoclinic(6_2.U4(3).2_3')");
TEST("U4(3)");
TEST("U4(3).(2^2)_{122}");
TEST("U4(3).(2^2)_{133}");
TEST("U4(3).2_1");
TEST("U4(3).2_2");
TEST("U4(3).2_2'");
TEST("U4(3).2_3");
TEST("U4(3).2_3'");
TEST("U4(3).4");
TEST("U4(3).D8");
TEST("(3^2x2).U4(3).2_3'");
TEST("Isoclinic((3^2x2).U4(3).2_3')");
TEST("3.U3(5)");
TEST("3.U3(5).2");
TEST("3.U3(5).3");
TEST("3.U3(8)");
TEST("3.U3(8).2");
TEST("3.U3(8).3_1");
TEST("3.U3(8).3_2");
TEST("3.U3(8).6");
TEST("HSM3");
TEST("U3(3)");
TEST("U3(3).2");
TEST("G2(3)M2");
TEST("U3(4)");
TEST("U3(4).2");
TEST("U3(4).4");
TEST("U3(5)");
TEST("U3(5).2");
TEST("U3(5).3");
TEST("U3(5).3.2");
TEST("U3(7)");
TEST("U3(7).2");
TEST("U3(8)");
TEST("U3(8).2");
TEST("U3(8).3_1");
TEST("U3(8).3_2");
TEST("U3(8).3_3");
TEST("U3(8).6");
TEST("U3(9)");
TEST("U3(9).2");
TEST("U3(9).4");
TEST("2.U4(2)");
TEST("2.U4(2).2");
TEST("3.U3(11)");
TEST("3.U3(11).2");
TEST("3.U3(11).3");
TEST("U3(11)");
TEST("U3(11).2");
TEST("U3(11).3");
TEST("U4(2)");
TEST("U4(2).2");
TEST("U5(2)");
TEST("U5(2).2");
TEST("2.U6(2)");
TEST("2.U6(2).2");
TEST("2^2.U6(2)");
TEST("2^2.U6(2).2");
TEST("2^2.U6(2).3");
TEST("2^2.U6(2).3.2");
TEST("3.U6(2)");
TEST("3.U6(2).2");
TEST("3.U6(2).3");
TEST("6.U6(2)");
TEST("6.U6(2).2");
TEST("U6(2)");
TEST("U6(2).2");
TEST("U6(2).3");
TEST("U6(2).3.2");
TEST("(2^2x3).U6(2)");
TEST("U4(4)");


TEST2("2.A10.2",3);
TEST2("2.A10.2",5);
TEST2("2.A10.2",7);
TEST2("2.A10",3);
TEST2("2.A10",5);
TEST2("2.A10",7);
TEST2("2.A11.2",11);
TEST2("2.A11.2",3);
TEST2("2.A11.2",5);
TEST2("2.A11.2",7);
TEST2("2.A11",11);
TEST2("2.A11",3);
TEST2("2.A11",5);
TEST2("2.A11",7);
TEST2("2.A12.2",11);
TEST2("2.A12.2",3);
TEST2("2.A12.2",5);
TEST2("2.A12.2",7);
TEST2("2.A12",11);
TEST2("2.A12",3);
TEST2("2.A12",5);
TEST2("2.A12",7);
TEST2("2.A13.2",11);
TEST2("2.A13.2",13);
TEST2("2.A13.2",3);
TEST2("2.A13.2",5);
TEST2("2.A13.2",7);
TEST2("2.A13",11);
TEST2("2.A13",13);
TEST2("2.A13",3);
TEST2("2.A13",5);
TEST2("2.A13",7);
TEST2("2.A5.2",3);
TEST2("2.A5.2",5);
TEST2("2.A5",3);
TEST2("2.A5",5);
TEST2("2.A6.2_1",3);
TEST2("2.A6.2_1",5);
TEST2("2.A6.2_2",3);
TEST2("2.A6.2_2",5);
TEST2("2.A6",3);
TEST2("2.A6",5);
TEST2("2.A7.2",3);
TEST2("2.A7.2",5);
TEST2("2.A7.2",7);
TEST2("2.A7",3);
TEST2("2.A7",5);
TEST2("2.A7",7);
TEST2("2.A8.2",3);
TEST2("2.A8.2",5);
TEST2("2.A8.2",7);
TEST2("2.A8",3);
TEST2("2.A8",5);
TEST2("2.A8",7);
TEST2("2.A9.2",3);
TEST2("2.A9.2",5);
TEST2("2.A9.2",7);
TEST2("2.A9",3);
TEST2("2.A9",5);
TEST2("2.A9",7);
TEST2("3.A6.2_1",2);
TEST2("3.A6.2_1",5);
TEST2("3.A6.2_2",2);
TEST2("3.A6.2_2",5);
TEST2("3.A6.2_3",2);
TEST2("3.A6.2_3",5);
TEST2("3.A6",2);
TEST2("3.A6",5);
TEST2("3.A7.2",2);
TEST2("3.A7.2",5);
TEST2("3.A7.2",7);
TEST2("3.A7",2);
TEST2("3.A7",5);
TEST2("3.A7",7);
TEST2("6.A6.2_1",5);
TEST2("6.A6.2_2",5);
TEST2("6.A6",5);
TEST2("6.A7.2",5);
TEST2("6.A7.2",7);
TEST2("6.A7",5);
TEST2("6.A7",7);
TEST2("A10.2",2);
TEST2("A10.2",3);
TEST2("A10.2",5);
TEST2("A10.2",7);
TEST2("A10",2);
TEST2("A10",3);
TEST2("A10",5);
TEST2("A10",7);
TEST2("A11.2",11);
TEST2("A11.2",2);
TEST2("A11.2",3);
TEST2("A11.2",5);
TEST2("A11.2",7);
TEST2("A11",11);
TEST2("A11",2);
TEST2("A11",3);
TEST2("A11",5);
TEST2("A11",7);
TEST2("A12.2",11);
TEST2("A12.2",2);
TEST2("A12.2",3);
TEST2("A12.2",5);
TEST2("A12.2",7);
TEST2("A12",11);
TEST2("A12",2);
TEST2("A12",3);
TEST2("A12",5);
TEST2("A12",7);
TEST2("A13.2",11);
TEST2("A13.2",13);
TEST2("A13.2",2);
TEST2("A13.2",3);
TEST2("A13.2",5);
TEST2("A13.2",7);
TEST2("A16.2",3);
TEST2("A13",11);
TEST2("A13",13);
TEST2("A13",2);
TEST2("A13",3);
TEST2("A13",5);
TEST2("A13",7);
TEST2("A14",11);
TEST2("A14",13);
TEST2("A14",2);
TEST2("A14",3);
TEST2("A14",5);
TEST2("A14",7);
TEST2("A5.2",2);
TEST2("A5.2",3);
TEST2("A5.2",5);
TEST2("A5",2);
TEST2("A5",3);
TEST2("A5",5);
TEST2("A6.2_1",2);
TEST2("A6.2_1",3);
TEST2("A6.2_1",5);
TEST2("A6.2_2",2);
TEST2("A6.2_2",3);
TEST2("A6.2_2",5);
TEST2("A6.2_3",2);
TEST2("A6.2_3",3);
TEST2("A6.2_3",5);
TEST2("A6.2^2",3);
TEST2("A6",2);
TEST2("A6",3);
TEST2("A6",5);
TEST2("A7.2",2);
TEST2("A7.2",3);
TEST2("A7.2",5);
TEST2("A7.2",7);
TEST2("A7",2);
TEST2("A7",3);
TEST2("A7",5);
TEST2("A7",7);
TEST2("A8.2",2);
TEST2("A8.2",3);
TEST2("A8.2",5);
TEST2("A8.2",7);
TEST2("A8",2);
TEST2("A8",3);
TEST2("A8",5);
TEST2("A8",7);
TEST2("A9.2",2);
TEST2("A9.2",3);
TEST2("A9.2",5);
TEST2("A9.2",7);
TEST2("A9",2);
TEST2("A9",3);
TEST2("A9",5);
TEST2("A9",7);
TEST2("A14.2",2);
TEST2("A14.2",3);
TEST2("A14.2",5);
TEST2("A14.2",7);
TEST2("A14.2",11);
TEST2("A14.2",13);
TEST2("A15.2",2);
TEST2("A15.2",3);
TEST2("A15.2",5);
TEST2("A15.2",7);
TEST2("A15.2",11);
TEST2("A15.2",13);
TEST2("A16.2",2);
TEST2("A16.2",5);
TEST2("A16.2",7);
TEST2("A16.2",11);
TEST2("A16.2",13);
TEST2("A17.2",2);
TEST2("A17.2",3);
TEST2("A17.2",5);
TEST2("A17.2",7);
TEST2("A17.2",11);
TEST2("A17.2",13);
TEST2("A17.2",17);
TEST2("2.F4(2).2",13);
TEST2("2.F4(2)",13);
TEST2("2.F4(2)",17);
TEST2("2.F4(2)",5);
TEST2("2.F4(2)",7);
TEST2("2.G2(4).2",13);
TEST2("2.G2(4).2",3);
TEST2("2.G2(4).2",5);
TEST2("2.G2(4).2",7);
TEST2("2.G2(4)",13);
TEST2("2.G2(4)",3);
TEST2("2.G2(4)",5);
TEST2("2.G2(4)",7);
TEST2("2.Sz(8)",13);
TEST2("2.Sz(8)",5);
TEST2("2.Sz(8)",7);
TEST2("3.G2(3).2",13);
TEST2("3.G2(3).2",2);
TEST2("3.G2(3).2",7);
TEST2("3.G2(3)",13);
TEST2("3.G2(3)",2);
TEST2("3.G2(3)",7);
TEST2("F4(2).2",13);
TEST2("F4(2).2",17);
TEST2("F4(2)",13);
TEST2("F4(2)",17);
TEST2("F4(2)",5);
TEST2("F4(2)",7);
TEST2("G2(3).2",13);
TEST2("G2(3).2",2);
TEST2("G2(3).2",3);
TEST2("G2(3).2",7);
TEST2("G2(3)",13);
TEST2("G2(3)",2);
TEST2("G2(3)",3);
TEST2("G2(3)",7);
TEST2("G2(4).2",13);
TEST2("G2(4).2",2);
TEST2("G2(4).2",3);
TEST2("G2(4).2",5);
TEST2("G2(4).2",7);
TEST2("G2(4)",13);
TEST2("G2(4)",2);
TEST2("G2(4)",3);
TEST2("G2(4)",5);
TEST2("G2(4)",7);
TEST2("G2(5)",2);
TEST2("G2(5)",3);
TEST2("G2(5)",31);
TEST2("G2(5)",5);
TEST2("G2(5)",7);
TEST2("R(27).3",13);
TEST2("R(27).3",19);
TEST2("R(27).3",2);
TEST2("R(27).3",3);
TEST2("R(27).3",37);
TEST2("R(27).3",7);
TEST2("R(27)",13);
TEST2("R(27)",19);
TEST2("R(27)",2);
TEST2("R(27)",3);
TEST2("R(27)",37);
TEST2("R(27)",7);
TEST2("Sz(32).5",2);
TEST2("Sz(32).5",31);
TEST2("Sz(32).5",41);
TEST2("Sz(32).5",5);
TEST2("Sz(32)",2);
TEST2("Sz(32)",31);
TEST2("Sz(32)",41);
TEST2("Sz(32)",5);
TEST2("Sz(8).3",13);
TEST2("Sz(8).3",2);
TEST2("Sz(8).3",5);
TEST2("Sz(8).3",7);
TEST2("Sz(8)",13);
TEST2("Sz(8)",2);
TEST2("Sz(8)",5);
TEST2("Sz(8)",7);
TEST2("2.Co1",11);
TEST2("2.Co1",13);
TEST2("2.Co1",23);
TEST2("2.Co1",7);
TEST2("2.J2.2",3);
TEST2("2.J2.2",5);
TEST2("2.J2.2",7);
TEST2("2.J2",3);
TEST2("2.J2",5);
TEST2("2.J2",7);
TEST2("3.J3.2",17);
TEST2("3.J3.2",19);
TEST2("3.J3.2",2);
TEST2("3.J3.2",5);
TEST2("3.J3",17);
TEST2("3.J3",19);
TEST2("3.J3",2);
TEST2("3.J3",5);
TEST2("Co1",11);
TEST2("Co1",13);
TEST2("Co1",23);
TEST2("Co1",7);
TEST2("Co2",11);
TEST2("Co2",2);
TEST2("Co2",23);
TEST2("Co2",3);
TEST2("Co2",5);
TEST2("Co2",7);
TEST2("Co3",11);
TEST2("Co3",2);
TEST2("Co3",5);
TEST2("Co3",23);
TEST2("Co3",3);
TEST2("Co3",7);
TEST2("J1",11);
TEST2("J1",19);
TEST2("J1",2);
TEST2("J1",3);
TEST2("J1",5);
TEST2("J1",7);
TEST2("J2.2",2);
TEST2("J2.2",3);
TEST2("J2.2",5);
TEST2("J2.2",7);
TEST2("J2",2);
TEST2("J2",3);
TEST2("J2",5);
TEST2("J2",7);
TEST2("J3.2",17);
TEST2("J3.2",19);
TEST2("J3.2",2);
TEST2("J3.2",3);
TEST2("J3.2",5);
TEST2("J3",17);
TEST2("J3",19);
TEST2("J3",2);
TEST2("J3",3);
TEST2("J3",5);
TEST2("J4",37);
TEST2("J4",5);
TEST2("J4",7);
TEST2("6.Fi22",11);
TEST2("6.Fi22",13);
TEST2("6.Fi22",5);
TEST2("6.Fi22",7);
TEST2("6.Fi22.2",11);
TEST2("6.Fi22.2",13);
TEST2("6.Fi22.2",5);
TEST2("6.Fi22.2",7);
TEST2("3.Fi22",11);
TEST2("3.Fi22",13);
TEST2("3.Fi22",5);
TEST2("3.Fi22",7);
TEST2("3.Fi22.2",11);
TEST2("3.Fi22.2",13);
TEST2("3.Fi22.2",5);
TEST2("3.Fi22.2",7);
TEST2("2.Fi22",11);
TEST2("2.Fi22",13);
TEST2("2.Fi22",5);
TEST2("2.Fi22",7);
TEST2("2.Fi22.2",11);
TEST2("2.Fi22.2",13);
TEST2("2.Fi22.2",5);
TEST2("2.Fi22.2",7);
TEST2("Fi22",11);
TEST2("Fi22",13);
TEST2("Fi22",5);
TEST2("Fi22",7);
TEST2("Fi22.2",11);
TEST2("Fi22.2",13);
TEST2("Fi22.2",5);
TEST2("Fi22.2",7);
TEST2("3.F3+",11);
TEST2("3.F3+",23);
TEST2("3.F3+.2",11);
TEST2("3.F3+.2",13);
TEST2("3.F3+.2",23);
TEST2("F3+",11);
TEST2("F3+.2",13);
TEST2("F3+",17);
TEST2("F3+",23);
TEST2("F3+",29);
TEST2("F3+.2",11);
TEST2("F3+.2",17);
TEST2("F3+.2",23);
TEST2("F3+.2",29);
TEST2("Fi23",11);
TEST2("Fi23",13);
TEST2("Fi23",23);
TEST2("Fi23",5);
TEST2("Fi23",7);
TEST2("2.L2(11).2",11);
TEST2("2.L2(11).2",3);
TEST2("2.L2(11).2",5);
TEST2("2.L2(11)",11);
TEST2("2.L2(11)",3);
TEST2("2.L2(11)",5);
TEST2("2.L2(13).2",13);
TEST2("2.L2(13).2",3);
TEST2("2.L2(13).2",7);
TEST2("2.L2(13)",13);
TEST2("2.L2(13)",3);
TEST2("2.L2(13)",7);
TEST2("2.L2(17).2",17);
TEST2("2.L2(17).2",3);
TEST2("2.L2(17)",17);
TEST2("2.L2(17)",3);
TEST2("2.L2(19).2",19);
TEST2("2.L2(19).2",3);
TEST2("2.L2(19).2",5);
TEST2("2.L2(19)",19);
TEST2("2.L2(19)",3);
TEST2("2.L2(19)",5);
TEST2("2.L2(23).2",11);
TEST2("2.L2(23).2",23);
TEST2("2.L2(23).2",3);
TEST2("2.L2(23)",11);
TEST2("2.L2(23)",23);
TEST2("2.L2(23)",3);
TEST2("2.L2(25).2_1",13);
TEST2("2.L2(25).2_1",3);
TEST2("2.L2(25).2_1",5);
TEST2("2.L2(25).2_2",13);
TEST2("2.L2(25).2_2",3);
TEST2("2.L2(25).2_2",5);
TEST2("2.L2(25)",13);
TEST2("2.L2(25)",3);
TEST2("2.L2(25)",5);
TEST2("2.L2(27).2",13);
TEST2("2.L2(27).2",3);
TEST2("2.L2(27).2",7);
TEST2("2.L2(27).3",13);
TEST2("2.L2(27).3",3);
TEST2("2.L2(27).3",7);
TEST2("2.L2(27).6",13);
TEST2("2.L2(27).6",3);
TEST2("2.L2(27).6",7);
TEST2("2.L2(27)",13);
TEST2("2.L2(27)",3);
TEST2("2.L2(27)",7);
TEST2("2.L2(29).2",29);
TEST2("2.L2(29).2",3);
TEST2("2.L2(29).2",5);
TEST2("2.L2(29).2",7);
TEST2("2.L2(29)",29);
TEST2("2.L2(29)",3);
TEST2("2.L2(29)",5);
TEST2("2.L2(29)",7);
TEST2("2.L2(31).2",3);
TEST2("2.L2(31).2",31);
TEST2("2.L2(31).2",5);
TEST2("2.L2(31)",3);
TEST2("2.L2(31)",31);
TEST2("2.L2(31)",5);
TEST2("L2(11).2",11);
TEST2("L2(11).2",2);
TEST2("L2(11).2",3);
TEST2("L2(11).2",5);
TEST2("L2(11)",11);
TEST2("L2(11)",2);
TEST2("L2(11)",3);
TEST2("L2(11)",5);
TEST2("L2(13).2",13);
TEST2("L2(13).2",2);
TEST2("L2(13).2",3);
TEST2("L2(13).2",7);
TEST2("L2(13)",13);
TEST2("L2(13)",2);
TEST2("L2(13)",3);
TEST2("L2(13)",7);
TEST2("L2(16).2",17);
TEST2("L2(16).2",2);
TEST2("L2(16).2",3);
TEST2("L2(16).2",5);
TEST2("L2(16).4",17);
TEST2("L2(16).4",2);
TEST2("L2(16).4",3);
TEST2("L2(16).4",5);
TEST2("L2(16)",17);
TEST2("L2(16)",2);
TEST2("L2(16)",3);
TEST2("L2(16)",5);
TEST2("L2(17).2",17);
TEST2("L2(17).2",2);
TEST2("L2(17).2",3);
TEST2("L2(17)",17);
TEST2("L2(17)",2);
TEST2("L2(17)",3);
TEST2("L2(19).2",19);
TEST2("L2(19).2",2);
TEST2("L2(19).2",3);
TEST2("L2(19).2",5);
TEST2("L2(19)",19);
TEST2("L2(19)",2);
TEST2("L2(19)",3);
TEST2("L2(19)",5);
TEST2("L2(23).2",11);
TEST2("L2(23).2",2);
TEST2("L2(23).2",23);
TEST2("L2(23).2",3);
TEST2("L2(23)",11);
TEST2("L2(23)",2);
TEST2("L2(23)",23);
TEST2("L2(23)",3);
TEST2("L2(25).2_1",13);
TEST2("L2(25).2_1",2);
TEST2("L2(25).2_1",3);
TEST2("L2(25).2_1",5);
TEST2("L2(25).2_2",13);
TEST2("L2(25).2_2",2);
TEST2("L2(25).2_2",3);
TEST2("L2(25).2_2",5);
TEST2("L2(25).2_3",13);
TEST2("L2(25).2_3",2);
TEST2("L2(25).2_3",3);
TEST2("L2(25).2_3",5);
TEST2("L2(25)",13);
TEST2("L2(25)",2);
TEST2("L2(25)",3);
TEST2("L2(25)",5);
TEST2("L2(27).2",13);
TEST2("L2(27).2",2);
TEST2("L2(27).2",3);
TEST2("L2(27).2",7);
TEST2("L2(27).3",13);
TEST2("L2(27).3",2);
TEST2("L2(27).3",3);
TEST2("L2(27).3",7);
TEST2("L2(27).6",13);
TEST2("L2(27).6",2);
TEST2("L2(27).6",3);
TEST2("L2(27).6",7);
TEST2("L2(27)",13);
TEST2("L2(27)",2);
TEST2("L2(27)",3);
TEST2("L2(27)",7);
TEST2("L2(29).2",2);
TEST2("L2(29).2",29);
TEST2("L2(29).2",3);
TEST2("L2(29).2",5);
TEST2("L2(29).2",7);
TEST2("L2(29)",2);
TEST2("L2(29)",29);
TEST2("L2(29)",3);
TEST2("L2(29)",5);
TEST2("L2(29)",7);
TEST2("L2(31).2",2);
TEST2("L2(31).2",3);
TEST2("L2(31).2",31);
TEST2("L2(31).2",5);
TEST2("L2(31)",2);
TEST2("L2(31)",3);
TEST2("L2(31)",31);
TEST2("L2(31)",5);
TEST2("L2(32).5",11);
TEST2("L2(32).5",2);
TEST2("L2(32).5",3);
TEST2("L2(32).5",31);
TEST2("L2(32)",11);
TEST2("L2(32)",2);
TEST2("L2(32)",3);
TEST2("L2(32)",31);
TEST2("L2(8).3",2);
TEST2("L2(8).3",3);
TEST2("L2(8).3",7);
TEST2("L2(8)",2);
TEST2("L2(8)",3);
TEST2("L2(8)",7);
TEST2("2.L2(49).2_1",3);
TEST2("2.L2(49).2_1",5);
TEST2("2.L2(49).2_2",3);
TEST2("2.L2(49).2_2",5);
TEST2("2.L2(49)",3);
TEST2("2.L2(49)",5);
TEST2("2.L2(81).2_1",41);
TEST2("2.L2(81).2_1",5);
TEST2("2.L2(81).2_2",41);
TEST2("2.L2(81).2_2",5);
TEST2("2.L2(81)",41);
TEST2("2.L2(81)",5);
TEST2("L2(49).2_1",2);
TEST2("L2(49).2_1",3);
TEST2("L2(49).2_1",5);
TEST2("L2(49).2_2",2);
TEST2("L2(49).2_2",3);
TEST2("L2(49).2_2",5);
TEST2("L2(49).2_3",2);
TEST2("L2(49).2_3",3);
TEST2("L2(49).2_3",5);
TEST2("L2(49)",2);
TEST2("L2(49)",3);
TEST2("L2(49)",5);
TEST2("L2(81).2_1",2);
TEST2("L2(81).2_1",41);
TEST2("L2(81).2_1",5);
TEST2("L2(81).2_2",2);
TEST2("L2(81).2_2",41);
TEST2("L2(81).2_2",5);
TEST2("L2(81).2_3",2);
TEST2("L2(81).2_3",41);
TEST2("L2(81).2_3",5);
TEST2("L2(81).4_1",2);
TEST2("L2(81).4_1",5);
TEST2("L2(81).4_2",2);
TEST2("L2(81)",2);
TEST2("L2(81)",41);
TEST2("L2(81)",5);
TEST2("12_1.L3(4).2_1",5);
TEST2("12_1.L3(4).2_1",7);
TEST2("12_1.L3(4).2_2",5);
TEST2("12_1.L3(4).2_2",7);
TEST2("12_1.L3(4).2_3",5);
TEST2("12_1.L3(4).2_3",7);
TEST2("12_1.L3(4)",5);
TEST2("12_1.L3(4)",7);
TEST2("12_2.L3(4).2_1",5);
TEST2("12_2.L3(4).2_1",7);
TEST2("12_2.L3(4).2_2",5);
TEST2("12_2.L3(4).2_2",7);
TEST2("12_2.L3(4).2_3",5);
TEST2("12_2.L3(4).2_3",7);
TEST2("12_2.L3(4)",5);
TEST2("12_2.L3(4)",7);
TEST2("2.L3(4).2_1",3);
TEST2("2.L3(4).2_1",5);
TEST2("2.L3(4).2_1",7);
TEST2("2.L3(4).2_2",3);
TEST2("2.L3(4).2_2",5);
TEST2("2.L3(4).2_2",7);
TEST2("2.L3(4).2_3",3);
TEST2("2.L3(4).2_3",5);
TEST2("2.L3(4).2_3",7);
TEST2("2.L3(4)",3);
TEST2("2.L3(4)",5);
TEST2("2.L3(4)",7);
TEST2("3.L3(4).2_1",2);
TEST2("3.L3(4).2_1",5);
TEST2("3.L3(4).2_1",7);
TEST2("3.L3(4).2_2",2);
TEST2("3.L3(4).2_2",5);
TEST2("3.L3(4).2_2",7);
TEST2("3.L3(4).2_3",2);
TEST2("3.L3(4).2_3",5);
TEST2("3.L3(4).2_3",7);
TEST2("3.L3(4).3",2);
TEST2("3.L3(4).3",5);
TEST2("3.L3(4).3",7);
TEST2("3.L3(4).6",2);
TEST2("3.L3(4).6",5);
TEST2("3.L3(4).6",7);
TEST2("3.L3(4)",2);
TEST2("3.L3(4)",5);
TEST2("3.L3(4)",7);
TEST2("4_1.L3(4).2_1",3);
TEST2("4_1.L3(4).2_1",5);
TEST2("4_1.L3(4).2_1",7);
TEST2("4_1.L3(4).2_2",3);
TEST2("4_1.L3(4).2_2",5);
TEST2("4_1.L3(4).2_2",7);
TEST2("4_1.L3(4).2_3",3);
TEST2("4_1.L3(4).2_3",5);
TEST2("4_1.L3(4).2_3",7);
TEST2("4_1.L3(4)",3);
TEST2("4_1.L3(4)",5);
TEST2("4_1.L3(4)",7);
TEST2("4_2.L3(4).2_1",3);
TEST2("4_2.L3(4).2_1",5);
TEST2("4_2.L3(4).2_1",7);
TEST2("4_2.L3(4).2_2",3);
TEST2("4_2.L3(4).2_2",5);
TEST2("4_2.L3(4).2_2",7);
TEST2("4_2.L3(4).2_3",3);
TEST2("4_2.L3(4).2_3",5);
TEST2("4_2.L3(4).2_3",7);
TEST2("4_2.L3(4)",3);
TEST2("4_2.L3(4)",5);
TEST2("4_2.L3(4)",7);
TEST2("6.L3(4).2_1",5);
TEST2("6.L3(4).2_1",7);
TEST2("6.L3(4).2_2",5);
TEST2("6.L3(4).2_2",7);
TEST2("6.L3(4).2_3",5);
TEST2("6.L3(4).2_3",7);
TEST2("6.L3(4)",5);
TEST2("6.L3(4)",7);
TEST2("L3(4).2_1",2);
TEST2("L3(4).2_1",3);
TEST2("L3(4).2_1",5);
TEST2("L3(4).2_1",7);
TEST2("L3(4).2_2",2);
TEST2("L3(4).2_2",3);
TEST2("L3(4).2_2",5);
TEST2("L3(4).2_2",7);
TEST2("L3(4).2_3",2);
TEST2("L3(4).2_3",3);
TEST2("L3(4).2_3",5);
TEST2("L3(4).2_3",7);
TEST2("L3(4).3",2);
TEST2("L3(4).3",3);
TEST2("L3(4).3",5);
TEST2("L3(4).3",7);
TEST2("L3(4).6",2);
TEST2("L3(4).6",3);
TEST2("L3(4).6",5);
TEST2("L3(4).6",7);
TEST2("L3(4)",2);
TEST2("L3(4)",3);
TEST2("L3(4)",5);
TEST2("L3(4)",7);
TEST2("2.L3(2).2",3);
TEST2("2.L3(2).2",7);
TEST2("2.L3(2)",3);
TEST2("2.L3(2)",7);
TEST2("3.L3(7).2",19);
TEST2("3.L3(7).2",2);
TEST2("3.L3(7).2",7);
TEST2("3.L3(7).3",19);
TEST2("3.L3(7).3",2);
TEST2("3.L3(7).3",7);
TEST2("3.L3(7)",19);
TEST2("3.L3(7)",2);
TEST2("3.L3(7)",7);
TEST2("L3(2).2",2);
TEST2("L3(2).2",3);
TEST2("L3(2).2",7);
TEST2("L3(2)",2);
TEST2("L3(2)",3);
TEST2("L3(2)",7);
TEST2("L3(3).2",13);
TEST2("L3(3).2",2);
TEST2("L3(3).2",3);
TEST2("L3(3)",13);
TEST2("L3(3)",2);
TEST2("L3(3)",3);
TEST2("L3(5).2",2);
TEST2("L3(5).2",3);
TEST2("L3(5).2",31);
TEST2("L3(5).2",5);
TEST2("L3(5)",2);
TEST2("L3(5)",3);
TEST2("L3(5)",31);
TEST2("L3(5)",5);
TEST2("L3(7).2",19);
TEST2("L3(7).2",2);
TEST2("L3(7).2",3);
TEST2("L3(7).2",7);
TEST2("L3(7).3",19);
TEST2("L3(7).3",2);
TEST2("L3(7).3",3);
TEST2("L3(7).3",7);
TEST2("L3(7)",19);
TEST2("L3(7)",2);
TEST2("L3(7)",3);
TEST2("L3(7)",7);
TEST2("L3(8).2",2);
TEST2("L3(8).2",3);
TEST2("L3(8).2",7);
TEST2("L3(8).2",73);
TEST2("L3(8).3",2);
TEST2("L3(8).3",3);
TEST2("L3(8).3",7);
TEST2("L3(8).3",73);
TEST2("L3(8).6",2);
TEST2("L3(8).6",3);
TEST2("L3(8).6",7);
TEST2("L3(8).6",73);
TEST2("L3(8)",2);
TEST2("L3(8)",3);
TEST2("L3(8)",7);
TEST2("L3(8)",73);
TEST2("2.L4(3).2_1",13);
TEST2("2.L4(3).2_1",3);
TEST2("2.L4(3).2_1",5);
TEST2("2.L4(3).2_2",13);
TEST2("2.L4(3).2_2",3);
TEST2("2.L4(3).2_2",5);
TEST2("2.L4(3).2_3",13);
TEST2("2.L4(3).2_3",3);
TEST2("2.L4(3).2_3",5);
TEST2("2.L4(3)",13);
TEST2("2.L4(3)",3);
TEST2("2.L4(3)",5);
TEST2("L3(9).2_1",13);
TEST2("L3(9).2_1",2);
TEST2("L3(9).2_1",3);
TEST2("L3(9).2_1",5);
TEST2("L3(9).2_1",7);
TEST2("L3(9).2_2",13);
TEST2("L3(9).2_2",2);
TEST2("L3(9).2_2",3);
TEST2("L3(9).2_2",5);
TEST2("L3(9).2_2",7);
TEST2("L3(9).2_3",13);
TEST2("L3(9).2_3",2);
TEST2("L3(9).2_3",3);
TEST2("L3(9).2_3",5);
TEST2("L3(9).2_3",7);
TEST2("L3(9)",13);
TEST2("L3(9)",2);
TEST2("L3(9)",3);
TEST2("L3(9)",5);
TEST2("L3(9)",7);
TEST2("L4(3).2_1",13);
TEST2("L4(3).2_1",2);
TEST2("L4(3).2_1",3);
TEST2("L4(3).2_1",5);
TEST2("L4(3).2_2",13);
TEST2("L4(3).2_2",2);
TEST2("L4(3).2_2",3);
TEST2("L4(3).2_2",5);
TEST2("L4(3).2_3",13);
TEST2("L4(3).2_3",2);
TEST2("L4(3).2_3",3);
TEST2("L4(3).2_3",5);
TEST2("L4(3)",13);
TEST2("L4(3)",2);
TEST2("L4(3)",3);
TEST2("L4(3)",5);
TEST2("L5(2).2",2);
TEST2("L5(2).2",3);
TEST2("L5(2).2",31);
TEST2("L5(2).2",5);
TEST2("L5(2).2",7);
TEST2("L5(2)",2);
TEST2("L5(2)",3);
TEST2("L5(2)",31);
TEST2("L5(2)",5);
TEST2("L5(2)",7);
TEST2("L6(2)",3);
TEST2("L6(2)",31);
TEST2("L6(2)",5);
TEST2("L6(2)",7);
TEST2("L6(2).2",3);
TEST2("L6(2).2",31);
TEST2("L6(2).2",5);
TEST2("L4(4)",3);
TEST2("L4(4)",5);
TEST2("L4(4)",7);
TEST2("L4(4)",17);
TEST2("12.M22.2",11);
TEST2("12.M22.2",5);
TEST2("12.M22.2",7);
TEST2("12.M22",11);
TEST2("12.M22",5);
TEST2("12.M22",7);
TEST2("2.M12.2",11);
TEST2("2.M12.2",3);
TEST2("2.M12.2",5);
TEST2("2.M12",11);
TEST2("2.M12",3);
TEST2("2.M12",5);
TEST2("2.M22.2",11);
TEST2("2.M22.2",3);
TEST2("2.M22.2",5);
TEST2("2.M22.2",7);
TEST2("2.M22",11);
TEST2("2.M22",3);
TEST2("2.M22",5);
TEST2("2.M22",7);
TEST2("3.M22.2",11);
TEST2("3.M22.2",2);
TEST2("3.M22.2",5);
TEST2("3.M22.2",7);
TEST2("3.M22",11);
TEST2("3.M22",2);
TEST2("3.M22",5);
TEST2("3.M22",7);
TEST2("4.M22.2",11);
TEST2("4.M22.2",3);
TEST2("4.M22.2",5);
TEST2("4.M22.2",7);
TEST2("4.M22",11);
TEST2("4.M22",3);
TEST2("4.M22",5);
TEST2("4.M22",7);
TEST2("6.M22.2",11);
TEST2("6.M22.2",5);
TEST2("6.M22.2",7);
TEST2("6.M22",11);
TEST2("6.M22",5);
TEST2("6.M22",7);
TEST2("M11",11);
TEST2("M11",2);
TEST2("M11",3);
TEST2("M11",5);
TEST2("M12.2",11);
TEST2("M12.2",2);
TEST2("M12.2",3);
TEST2("M12.2",5);
TEST2("M12",11);
TEST2("M12",2);
TEST2("M12",3);
TEST2("M12",5);
TEST2("M22.2",11);
TEST2("M22.2",2);
TEST2("M22.2",3);
TEST2("M22.2",5);
TEST2("M22.2",7);
TEST2("M22",11);
TEST2("M22",2);
TEST2("M22",3);
TEST2("M22",5);
TEST2("M22",7);
TEST2("M23",11);
TEST2("M23",2);
TEST2("M23",23);
TEST2("M23",3);
TEST2("M23",5);
TEST2("M23",7);
TEST2("M24",11);
TEST2("M24",2);
TEST2("M24",23);
TEST2("M24",3);
TEST2("M24",5);
TEST2("M24",7);
TEST2("2.B",11);
TEST2("2.B",17);
TEST2("2.B",23);
TEST2("B",11);
TEST2("B",13);
TEST2("B",17);
TEST2("B",23);
TEST2("B",31);
TEST2("M",17);
TEST2("M",19);
TEST2("M",23);
TEST2("M",31);
TEST2("2.O7(3).2",13);
TEST2("2.O7(3).2",3);
TEST2("2.O7(3).2",5);
TEST2("2.O7(3).2",7);
TEST2("2.O7(3)",13);
TEST2("2.O7(3)",3);
TEST2("2.O7(3)",5);
TEST2("2.O7(3)",7);
TEST2("3.O7(3).2",13);
TEST2("3.O7(3).2",2);
TEST2("3.O7(3).2",5);
TEST2("3.O7(3).2",7);
TEST2("3.O7(3)",13);
TEST2("3.O7(3)",2);
TEST2("3.O7(3)",5);
TEST2("3.O7(3)",7);
TEST2("6.O7(3).2",13);
TEST2("6.O7(3).2",5);
TEST2("6.O7(3).2",7);
TEST2("6.O7(3)",13);
TEST2("6.O7(3)",5);
TEST2("6.O7(3)",7);
TEST2("O7(3).2",13);
TEST2("O7(3).2",2);
TEST2("O7(3).2",3);
TEST2("O7(3).2",5);
TEST2("O7(3).2",7);
TEST2("O7(3)",13);
TEST2("O7(3)",2);
TEST2("O7(3)",3);
TEST2("O7(3)",5);
TEST2("O7(3)",7);
TEST2("2.O8+(2).2",3);
TEST2("2.O8+(2).2",5);
TEST2("2.O8+(2).2",7);
TEST2("2.O8+(2)",3);
TEST2("2.O8+(2)",5);
TEST2("2.O8+(2)",7);
TEST2("O8+(2).2",2);
TEST2("O8+(2).2",3);
TEST2("O8+(2).2",5);
TEST2("O8+(2).2",7);
TEST2("O8+(2).3",2);
TEST2("O8+(2).3",3);
TEST2("O8+(2).3",5);
TEST2("O8+(2).3",7);
TEST2("O8+(2)",2);
TEST2("O8+(2)",3);
TEST2("O8+(2)",5);
TEST2("O8+(2)",7);
TEST2("O8+(3)",13);
TEST2("O8+(3)",2);
TEST2("O8+(3)",5);
TEST2("O8+(3)",7);
TEST2("O8+(3).2_1",13);
TEST2("O8+(3).2_1",2);
TEST2("O8+(3).2_1",5);
TEST2("O8+(3).2_1",7);
TEST2("O8+(3).2_2",13);
TEST2("O8+(3).2_2",2);
TEST2("O8+(3).2_2",5);
TEST2("O8+(3).2_2",7);
TEST2("O8+(3).3",13);
TEST2("O8+(3).3",2);
TEST2("O8+(3).3",5);
TEST2("O8+(3).3",7);
TEST2("O8+(3).4",13);
TEST2("O8+(3).4",2);
TEST2("O8+(3).4",5);
TEST2("O8+(3).4",7);
TEST2("O10+(2).2",17);
TEST2("O10+(2).2",3);
TEST2("O10+(2).2",31);
TEST2("O10+(2).2",5);
TEST2("O10+(2).2",7);
TEST2("O10+(2)",17);
TEST2("O10+(2)",3);
TEST2("O10+(2)",31);
TEST2("O10+(2)",5);
TEST2("O10+(2)",7);
TEST2("O10-(2).2",11);
TEST2("O10-(2).2",17);
TEST2("O10-(2).2",3);
TEST2("O10-(2).2",5);
TEST2("O10-(2).2",7);
TEST2("O10-(2)",11);
TEST2("O10-(2)",17);
TEST2("O10-(2)",3);
TEST2("O10-(2)",5);
TEST2("O10-(2)",7);
TEST2("O8-(2).2",17);
TEST2("O8-(2).2",2);
TEST2("O8-(2).2",3);
TEST2("O8-(2).2",5);
TEST2("O8-(2).2",7);
TEST2("O8-(2)",17);
TEST2("O8-(2)",2);
TEST2("O8-(2)",3);
TEST2("O8-(2)",5);
TEST2("O8-(2)",7);
TEST2("O8-(3)",13);
TEST2("O8-(3)",2);
TEST2("O8-(3)",41);
TEST2("O8-(3)",5);
TEST2("O8-(3)",7);
TEST2("2.HS.2",11);
TEST2("2.HS.2",3);
TEST2("2.HS.2",5);
TEST2("2.HS.2",7);
TEST2("2.HS",11);
TEST2("2.HS",3);
TEST2("2.HS",5);
TEST2("2.HS",7);
TEST2("2.Ru",3);
TEST2("2.Ru",5);
TEST2("2.Ru",7);
TEST2("2.Ru",13);
TEST2("2.Ru",29);
TEST2("2.Suz",11);
TEST2("2.Suz",13);
TEST2("2.Suz",3);
TEST2("2.Suz",5);
TEST2("2.Suz",7);
TEST2("2.Suz.2",11);
TEST2("2.Suz.2",3);
TEST2("2.Suz.2",5);
TEST2("2.Suz.2",7);
TEST2("3.McL.2",11);
TEST2("3.McL.2",2);
TEST2("3.McL.2",5);
TEST2("3.McL.2",7);
TEST2("3.McL",11);
TEST2("3.McL",2);
TEST2("3.McL",5);
TEST2("3.McL",7);
TEST2("3.ON",2);
TEST2("3.ON",5);
TEST2("3.ON",7);
TEST2("3.ON",11);
TEST2("3.ON",19);
TEST2("3.ON",31);
TEST2("3.ON.2",19);
TEST2("3.ON.2",2);
TEST2("3.ON.2",5);
TEST2("3.ON.2",7);
TEST2("3.Suz",11);
TEST2("3.Suz.2",13);
TEST2("3.Suz.2",11);
TEST2("3.Suz",13);
TEST2("3.Suz",2);
TEST2("3.Suz.2",2);
TEST2("3.Suz",5);
TEST2("3.Suz.2",5);
TEST2("3.Suz",7);
TEST2("3.Suz.2",7);
TEST2("6.Suz",11);
TEST2("6.Suz",13);
TEST2("6.Suz",5);
TEST2("6.Suz",7);
TEST2("6.Suz.2",11);
TEST2("6.Suz.2",5);
TEST2("6.Suz.2",7);
TEST2("HN.2",11);
TEST2("HN.2",19);
TEST2("HN.2",7);
TEST2("HN",11);
TEST2("HN",19);
TEST2("HN",7);
TEST2("HS.2",11);
TEST2("HS.2",2);
TEST2("HS.2",3);
TEST2("HS.2",5);
TEST2("HS.2",7);
TEST2("HS",11);
TEST2("HS",2);
TEST2("HS",3);
TEST2("HS",5);
TEST2("HS",7);
TEST2("He.2",17);
TEST2("He.2",2);
TEST2("He.2",3);
TEST2("He.2",5);
TEST2("He.2",7);
TEST2("He",17);
TEST2("He",2);
TEST2("He",3);
TEST2("He",5);
TEST2("He",7);
TEST2("Ly",11);
TEST2("Ly",31);
TEST2("Ly",37);
TEST2("Ly",67);
TEST2("Ly",7);
TEST2("McL.2",11);
TEST2("McL.2",2);
TEST2("McL.2",3);
TEST2("McL.2",5);
TEST2("McL.2",7);
TEST2("McL",11);
TEST2("McL",2);
TEST2("McL",3);
TEST2("McL",5);
TEST2("McL",7);
TEST2("ON",2);
TEST2("ON",3);
TEST2("ON",5);
TEST2("ON",7);
TEST2("ON",11);
TEST2("ON",19);
TEST2("ON",31);
TEST2("ON.2",19);
TEST2("ON.2",2);
TEST2("ON.2",5);
TEST2("ON.2",7);
TEST2("Ru",2);
TEST2("Ru",3);
TEST2("Ru",5);
TEST2("Ru",7);
TEST2("Ru",13);
TEST2("Ru",29);
TEST2("Suz",11);
TEST2("Suz",13);
TEST2("Suz",2);
TEST2("Suz",3);
TEST2("Suz",5);
TEST2("Suz",7);
TEST2("Suz.2",11);
TEST2("Suz.2",13);
TEST2("Suz.2",2);
TEST2("Suz.2",3);
TEST2("Suz.2",5);
TEST2("Suz.2",7);
TEST2("Th",13);
TEST2("Th",19);
TEST2("Th",31);
TEST2("2.S4(5).2",13);
TEST2("2.S4(5).2",3);
TEST2("2.S4(5).2",5);
TEST2("2.S4(5)",13);
TEST2("2.S4(5)",3);
TEST2("2.S4(5)",5);
TEST2("2.S6(2)",3);
TEST2("2.S6(2)",5);
TEST2("2.S6(2)",7);
TEST2("2.S6(3).2",13);
TEST2("2.S6(3).2",3);
TEST2("2.S6(3).2",5);
TEST2("2.S6(3).2",7);
TEST2("2.S6(3)",13);
TEST2("2.S6(3)",3);
TEST2("2.S6(3)",5);
TEST2("2.S6(3)",7);
TEST2("S10(2)",5);
TEST2("S10(2)",7);
TEST2("S10(2)",11);
TEST2("S10(2)",17);
TEST2("S10(2)",31);
TEST2("S4(4).2",17);
TEST2("S4(4).2",2);
TEST2("S4(4).2",3);
TEST2("S4(4).2",5);
TEST2("S4(4).4",17);
TEST2("S4(4).4",2);
TEST2("S4(4).4",3);
TEST2("S4(4).4",5);
TEST2("S4(4)",17);
TEST2("S4(4)",2);
TEST2("S4(4)",3);
TEST2("S4(4)",5);
TEST2("S4(5).2",13);
TEST2("S4(5).2",2);
TEST2("S4(5).2",3);
TEST2("S4(5).2",5);
TEST2("S4(5)",13);
TEST2("S4(5)",2);
TEST2("S4(5)",3);
TEST2("S4(5)",5);
TEST2("S6(2)",2);
TEST2("S6(2)",3);
TEST2("S6(2)",5);
TEST2("S6(2)",7);
TEST2("S6(3).2",13);
TEST2("S6(3).2",2);
TEST2("S6(3).2",3);
TEST2("S6(3).2",5);
TEST2("S6(3).2",7);
TEST2("S6(3)",13);
TEST2("S6(3)",2);
TEST2("S6(3)",3);
TEST2("S6(3)",5);
TEST2("S6(3)",7);
TEST2("S8(2)",17);
TEST2("S8(2)",2);
TEST2("S8(2)",3);
TEST2("S8(2)",5);
TEST2("S8(2)",7);
TEST2("2F4(2)'.2",13);
TEST2("2F4(2)'.2",2);
TEST2("2F4(2)'.2",3);
TEST2("2F4(2)'.2",5);
TEST2("2F4(2)'",13);
TEST2("2F4(2)'",2);
TEST2("2F4(2)'",3);
TEST2("2F4(2)'",5);
TEST2("3D4(2).3",13);
TEST2("3D4(2).3",2);
TEST2("3D4(2).3",3);
TEST2("3D4(2).3",7);
TEST2("3D4(2)",13);
TEST2("3D4(2)",2);
TEST2("3D4(2)",3);
TEST2("3D4(2)",7);
TEST2("2E6(2).2",11);
TEST2("2E6(2).2",13);
TEST2("2E6(2).2",17);
TEST2("2E6(2).2",19);
TEST2("2E6(2)",11);
TEST2("2E6(2)",13);
TEST2("2E6(2)",17);
TEST2("2E6(2)",19);
TEST2("2.2E6(2).2",11);
TEST2("2.2E6(2).2",13);
TEST2("2.2E6(2).2",17);
TEST2("2.2E6(2).2",19);
TEST2("2.2E6(2)",11);
TEST2("2.2E6(2)",13);
TEST2("2.2E6(2)",17);
TEST2("2.2E6(2)",19);
TEST2("12_1.U4(3).2_1",5);
TEST2("12_1.U4(3).2_1",7);
TEST2("12_1.U4(3).2_2",5);
TEST2("12_1.U4(3).2_2",7);
TEST2("12_1.U4(3)",5);
TEST2("12_1.U4(3)",7);
TEST2("12_2.U4(3).2_1",5);
TEST2("12_2.U4(3).2_1",7);
TEST2("12_2.U4(3).2_3",5);
TEST2("12_2.U4(3).2_3",7);
TEST2("12_2.U4(3)",5);
TEST2("12_2.U4(3)",7);
TEST2("2.U4(3).2_1",3);
TEST2("2.U4(3).2_1",5);
TEST2("2.U4(3).2_1",7);
TEST2("2.U4(3).2_2",3);
TEST2("2.U4(3).2_2",5);
TEST2("2.U4(3).2_2",7);
TEST2("2.U4(3).2_3",3);
TEST2("2.U4(3).2_3",5);
TEST2("2.U4(3).2_3",7);
TEST2("2.U4(3).4",3);
TEST2("2.U4(3).4",5);
TEST2("2.U4(3).4",7);
TEST2("2.U4(3)",3);
TEST2("2.U4(3)",5);
TEST2("2.U4(3)",7);
TEST2("3_1.U4(3).2_1",2);
TEST2("3_1.U4(3).2_1",5);
TEST2("3_1.U4(3).2_1",7);
TEST2("3_1.U4(3).2_2",2);
TEST2("3_1.U4(3).2_2",5);
TEST2("3_1.U4(3).2_2",7);
TEST2("3_1.U4(3)",2);
TEST2("3_1.U4(3)",5);
TEST2("3_1.U4(3)",7);
TEST2("3_2.U4(3).2_1",2);
TEST2("3_2.U4(3).2_1",5);
TEST2("3_2.U4(3).2_1",7);
TEST2("3_2.U4(3).2_3",2);
TEST2("3_2.U4(3).2_3",5);
TEST2("3_2.U4(3).2_3",7);
TEST2("3_2.U4(3)",2);
TEST2("3_2.U4(3)",5);
TEST2("3_2.U4(3)",7);
TEST2("4.U4(3).2_1",3);
TEST2("4.U4(3).2_1",5);
TEST2("4.U4(3).2_1",7);
TEST2("4.U4(3).2_2",3);
TEST2("4.U4(3).2_2",5);
TEST2("4.U4(3).2_2",7);
TEST2("4.U4(3).2_3",3);
TEST2("4.U4(3).2_3",5);
TEST2("4.U4(3).2_3",7);
TEST2("4.U4(3).4",3);
TEST2("4.U4(3).4",5);
TEST2("4.U4(3).4",7);
TEST2("4.U4(3)",3);
TEST2("4.U4(3)",5);
TEST2("4.U4(3)",7);
TEST2("6_1.U4(3).2_1",5);
TEST2("6_1.U4(3).2_1",7);
TEST2("6_1.U4(3).2_2",5);
TEST2("6_1.U4(3).2_2",7);
TEST2("6_1.U4(3)",5);
TEST2("6_1.U4(3)",7);
TEST2("6_2.U4(3).2_1",5);
TEST2("6_2.U4(3).2_1",7);
TEST2("6_2.U4(3).2_3",5);
TEST2("6_2.U4(3).2_3",7);
TEST2("6_2.U4(3)",5);
TEST2("6_2.U4(3)",7);
TEST2("U4(3).2_1",2);
TEST2("U4(3).2_1",3);
TEST2("U4(3).2_1",5);
TEST2("U4(3).2_1",7);
TEST2("U4(3).2_2",2);
TEST2("U4(3).2_2",3);
TEST2("U4(3).2_2",5);
TEST2("U4(3).2_2",7);
TEST2("U4(3).2_3",2);
TEST2("U4(3).2_3",3);
TEST2("U4(3).2_3",5);
TEST2("U4(3).2_3",7);
TEST2("U4(3).4",2);
TEST2("U4(3).4",3);
TEST2("U4(3).4",5);
TEST2("U4(3).4",7);
TEST2("U4(3)",2);
TEST2("U4(3)",3);
TEST2("U4(3)",5);
TEST2("U4(3)",7);
TEST2("3.U3(5).2",2);
TEST2("3.U3(5).2",5);
TEST2("3.U3(5).2",7);
TEST2("3.U3(5).3",2);
TEST2("3.U3(5).3",5);
TEST2("3.U3(5).3",7);
TEST2("3.U3(5)",2);
TEST2("3.U3(5)",5);
TEST2("3.U3(5)",7);
TEST2("3.U3(8).2",19);
TEST2("3.U3(8).2",2);
TEST2("3.U3(8).2",7);
TEST2("3.U3(8).3_1",19);
TEST2("3.U3(8).3_1",2);
TEST2("3.U3(8).3_1",7);
TEST2("3.U3(8).3_2",19);
TEST2("3.U3(8).3_2",2);
TEST2("3.U3(8).3_2",7);
TEST2("3.U3(8).6",19);
TEST2("3.U3(8).6",2);
TEST2("3.U3(8).6",7);
TEST2("3.U3(8)",19);
TEST2("3.U3(8)",2);
TEST2("3.U3(8)",7);
TEST2("U3(3).2",2);
TEST2("U3(3).2",3);
TEST2("U3(3).2",7);
TEST2("U3(3)",2);
TEST2("U3(3)",3);
TEST2("U3(3)",7);
TEST2("U3(4).2",13);
TEST2("U3(4).2",2);
TEST2("U3(4).2",3);
TEST2("U3(4).2",5);
TEST2("U3(4).4",13);
TEST2("U3(4).4",2);
TEST2("U3(4).4",3);
TEST2("U3(4).4",5);
TEST2("U3(4)",13);
TEST2("U3(4)",2);
TEST2("U3(4)",3);
TEST2("U3(4)",5);
TEST2("U3(5).2",2);
TEST2("U3(5).2",3);
TEST2("U3(5).2",5);
TEST2("U3(5).2",7);
TEST2("U3(5).3",2);
TEST2("U3(5).3",3);
TEST2("U3(5).3",5);
TEST2("U3(5).3",7);
TEST2("U3(5)",2);
TEST2("U3(5)",3);
TEST2("U3(5)",5);
TEST2("U3(5)",7);
TEST2("U3(7).2",2);
TEST2("U3(7).2",3);
TEST2("U3(7).2",43);
TEST2("U3(7).2",7);
TEST2("U3(7)",2);
TEST2("U3(7)",3);
TEST2("U3(7)",43);
TEST2("U3(7)",7);
TEST2("U3(8).2",19);
TEST2("U3(8).2",2);
TEST2("U3(8).2",3);
TEST2("U3(8).2",7);
TEST2("U3(8).3_1",19);
TEST2("U3(8).3_1",2);
TEST2("U3(8).3_1",3);
TEST2("U3(8).3_1",7);
TEST2("U3(8).3_2",19);
TEST2("U3(8).3_2",2);
TEST2("U3(8).3_2",3);
TEST2("U3(8).3_2",7);
TEST2("U3(8).3_3",19);
TEST2("U3(8).3_3",2);
TEST2("U3(8).3_3",3);
TEST2("U3(8).3_3",7);
TEST2("U3(8).6",19);
TEST2("U3(8).6",2);
TEST2("U3(8).6",3);
TEST2("U3(8).6",7);
TEST2("U3(8)",19);
TEST2("U3(8)",2);
TEST2("U3(8)",3);
TEST2("U3(8)",7);
TEST2("U3(9).2",2);
TEST2("U3(9).2",3);
TEST2("U3(9).2",5);
TEST2("U3(9).2",73);
TEST2("U3(9).4",2);
TEST2("U3(9).4",3);
TEST2("U3(9).4",5);
TEST2("U3(9).4",73);
TEST2("U3(9)",2);
TEST2("U3(9)",3);
TEST2("U3(9)",5);
TEST2("U3(9)",73);
TEST2("2.U4(2).2",3);
TEST2("2.U4(2).2",5);
TEST2("2.U4(2)",3);
TEST2("2.U4(2)",5);
TEST2("3.U3(11).2",11);
TEST2("3.U3(11).2",2);
TEST2("3.U3(11).2",37);
TEST2("3.U3(11).2",5);
TEST2("3.U3(11).3",11);
TEST2("3.U3(11).3",2);
TEST2("3.U3(11).3",37);
TEST2("3.U3(11).3",5);
TEST2("3.U3(11)",11);
TEST2("3.U3(11)",2);
TEST2("3.U3(11)",37);
TEST2("3.U3(11)",5);
TEST2("U3(11).2",11);
TEST2("U3(11).2",2);
TEST2("U3(11).2",3);
TEST2("U3(11).2",37);
TEST2("U3(11).2",5);
TEST2("U3(11).3",11);
TEST2("U3(11).3",2);
TEST2("U3(11).3",3);
TEST2("U3(11).3",37);
TEST2("U3(11).3",5);
TEST2("U3(11)",11);
TEST2("U3(11)",2);
TEST2("U3(11)",3);
TEST2("U3(11)",37);
TEST2("U3(11)",5);
TEST2("U4(2).2",2);
TEST2("U4(2).2",3);
TEST2("U4(2).2",5);
TEST2("U4(2)",2);
TEST2("U4(2)",3);
TEST2("U4(2)",5);
TEST2("U5(2).2",11);
TEST2("U5(2).2",2);
TEST2("U5(2).2",3);
TEST2("U5(2).2",5);
TEST2("U5(2)",11);
TEST2("U5(2)",2);
TEST2("U5(2)",3);
TEST2("U5(2)",5);
TEST2("2.U6(2).2",11);
TEST2("2.U6(2).2",3);
TEST2("2.U6(2).2",5);
TEST2("2.U6(2).2",7);
TEST2("2.U6(2)",11);
TEST2("2.U6(2)",3);
TEST2("2.U6(2)",5);
TEST2("2.U6(2)",7);
TEST2("3.U6(2).2",11);
TEST2("3.U6(2).2",2);
TEST2("3.U6(2).2",5);
TEST2("3.U6(2).2",7);
TEST2("3.U6(2).3",11);
TEST2("3.U6(2).3",2);
TEST2("3.U6(2).3",5);
TEST2("3.U6(2).3",7);
TEST2("3.U6(2)",11);
TEST2("3.U6(2)",2);
TEST2("3.U6(2)",5);
TEST2("3.U6(2)",7);
TEST2("6.U6(2).2",11);
TEST2("6.U6(2).2",5);
TEST2("6.U6(2).2",7);
TEST2("6.U6(2)",11);
TEST2("6.U6(2)",5);
TEST2("6.U6(2)",7);
TEST2("U6(2).2",11);
TEST2("U6(2).2",2);
TEST2("U6(2).2",3);
TEST2("U6(2).2",5);
TEST2("U6(2).2",7);
TEST2("U6(2).3",11);
TEST2("U6(2).3",2);
TEST2("U6(2).3",3);
TEST2("U6(2).3",5);
TEST2("U6(2).3",7);
TEST2("U6(2)",11);
TEST2("U6(2)",2);
TEST2("U6(2)",3);
TEST2("U6(2)",5);
TEST2("U6(2)",7);

