/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.dce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.dce.AnalysisResult;
import org.jetbrains.kotlin.js.dce.Context;
import org.jetbrains.kotlin.js.dce.DCELogLevel;
import org.jetbrains.kotlin.js.dce.UtilKt;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ?2\u00020\u0001:\u0001?B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001a\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020,H\u0016J\u0016\u0010-\u001a\u00020\n2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0/H\u0002J\u0010\u00100\u001a\u00020\n2\u0006\u0010\u0019\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\n2\u0006\u0010\u0019\u001a\u000203H\u0016J\u0012\u00104\u001a\u00020\n2\n\u00105\u001a\u00060\u0013R\u00020\u0003J\u0014\u00106\u001a\u00020\n2\n\u00105\u001a\u00060\u0013R\u00020\u0003H\u0002J\u0014\u00107\u001a\u00020\n2\n\u00105\u001a\u00060\u0013R\u00020\u0003H\u0002J\u0010\u00108\u001a\u00020\n2\u0006\u0010\u0019\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\n2\u0006\u00105\u001a\u00020\u000eH\u0014J(\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\t2\b\u0010=\u001a\u0004\u0018\u00010\u000e2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0/H\u0002J\u0016\u0010>\u001a\u00020\n2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0/H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0013R\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u0013R\u00020\u00030\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/js/dce/ReachabilityTracker;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "context", "Lorg/jetbrains/kotlin/js/dce/Context;", "analysisResult", "Lorg/jetbrains/kotlin/js/dce/AnalysisResult;", "logConsumer", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/js/dce/DCELogLevel;", "", "", "<init>", "(Lorg/jetbrains/kotlin/js/dce/Context;Lorg/jetbrains/kotlin/js/dce/AnalysisResult;Lkotlin/jvm/functions/Function2;)V", "currentNodeWithLocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "depth", "", "reachableNodesImpl", "", "Lorg/jetbrains/kotlin/js/dce/Context$Node;", "reachableNodes", "", "getReachableNodes", "()Ljava/lang/Iterable;", "visit", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "visitExpressionStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "visitReturn", "Lorg/jetbrains/kotlin/js/backend/ast/JsReturn;", "shouldTraverse", "", "visitNameRef", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "visitArrayAccess", "Lorg/jetbrains/kotlin/js/backend/ast/JsArrayAccess;", "visitNameLikeNode", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "visitInvocation", "invocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "visitFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "withErasedThis", "action", "Lkotlin/Function0;", "visitBreak", "Lorg/jetbrains/kotlin/js/backend/ast/JsBreak;", "visitContinue", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "reach", "node", "reachDependencies", "reachDeclaration", "visitPrefixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPrefixOperation;", "visitElement", "reportAndNest", "message", "dueTo", "nested", "Companion", "js.dce"})
@SourceDebugExtension(value={"SMAP\nReachabilityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReachabilityTracker.kt\norg/jetbrains/kotlin/js/dce/ReachabilityTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n774#2:258\n865#2,2:259\n1863#2,2:262\n1797#2,3:264\n1#3:261\n*S KotlinDebug\n*F\n+ 1 ReachabilityTracker.kt\norg/jetbrains/kotlin/js/dce/ReachabilityTracker\n*L\n98#1:258\n98#1:259,2\n151#1:262,2\n182#1:264,3\n*E\n"})
public final class ReachabilityTracker
extends RecursiveJsVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final AnalysisResult analysisResult;
    @Nullable
    private final Function2<DCELogLevel, String, Unit> logConsumer;
    @Nullable
    private JsNode currentNodeWithLocation;
    private int depth;
    @NotNull
    private final List<Context.Node> reachableNodesImpl;
    @NotNull
    private static final Set<String> CALL_FUNCTIONS;

    public ReachabilityTracker(@NotNull Context context, @NotNull AnalysisResult analysisResult2, @Nullable Function2<? super DCELogLevel, ? super String, Unit> logConsumer) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(analysisResult2, "analysisResult");
        this.context = context;
        this.analysisResult = analysisResult2;
        this.logConsumer = logConsumer;
        this.context.clearVisited();
        this.reachableNodesImpl = new ArrayList();
    }

    @NotNull
    public final Iterable<Context.Node> getReachableNodes() {
        return this.reachableNodesImpl;
    }

    @Override
    public void visit(@NotNull JsVars.JsVar x) {
        Intrinsics.checkNotNullParameter(x, "x");
        if (this.shouldTraverse(x)) {
            super.visit(x);
        }
    }

    @Override
    public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
        Intrinsics.checkNotNullParameter(x, "x");
        if (this.shouldTraverse(x)) {
            super.visitExpressionStatement(x);
        }
    }

    @Override
    public void visitReturn(@NotNull JsReturn x) {
        Intrinsics.checkNotNullParameter(x, "x");
        if (this.shouldTraverse(x)) {
            super.visitReturn(x);
        }
    }

    private final boolean shouldTraverse(JsNode x) {
        return this.analysisResult.getNodeMap().get(x) == null && !this.analysisResult.getAstNodesToEliminate().contains(x);
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        Intrinsics.checkNotNullParameter(nameRef, "nameRef");
        if (this.visitNameLikeNode(nameRef)) {
            super.visitNameRef(nameRef);
        }
    }

    @Override
    public void visitArrayAccess(@NotNull JsArrayAccess x) {
        Intrinsics.checkNotNullParameter(x, "x");
        if (this.visitNameLikeNode(x)) {
            super.visitArrayAccess(x);
        }
    }

    private final boolean visitNameLikeNode(JsExpression x) {
        if (this.analysisResult.getAstNodesToSkip().contains(x)) {
            return false;
        }
        Context.Node node = this.context.extractNode(x);
        if (node != null) {
            if (!node.getReachable()) {
                this.reportAndNest("reach: referenced name " + node, this.currentNodeWithLocation, () -> ReachabilityTracker.visitNameLikeNode$lambda$1(this, node));
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitInvocation(@NotNull JsInvocation invocation) {
        Intrinsics.checkNotNullParameter(invocation, "invocation");
        JsExpression jsExpression = invocation.getQualifier();
        Intrinsics.checkNotNullExpressionValue(jsExpression, "getQualifier(...)");
        JsExpression function2 = jsExpression;
        if (function2 instanceof JsFunction && this.analysisResult.getFunctionsToEnter().contains(function2)) {
            void $this$filterTo$iv$iv;
            this.accept((JsNode)((JsFunction)function2).getBody());
            List<JsExpression> list = invocation.getArguments();
            Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                JsExpression it = (JsExpression)element$iv$iv;
                boolean bl = false;
                if (!(it instanceof JsFunction && this.analysisResult.getFunctionsToEnter().contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (JsExpression argument : (List)destination$iv$iv) {
                this.accept((JsNode)argument);
            }
        } else if (!this.analysisResult.getInvocationsToSkip().contains(invocation)) {
            JsExpression jsExpression2 = invocation.getQualifier();
            Intrinsics.checkNotNullExpressionValue(jsExpression2, "getQualifier(...)");
            Context.Node node = this.context.extractNode(jsExpression2);
            if (node != null && CollectionsKt.contains((Iterable)CALL_FUNCTIONS, node.getMemberName())) {
                Context.Node node2 = node.getParent();
                Intrinsics.checkNotNull(node2);
                Context.Node parent2 = node2;
                this.reach(parent2);
                JsNode jsNode = this.currentNodeWithLocation;
                if (jsNode != null) {
                    JsNode it = jsNode;
                    boolean bl = false;
                    parent2.addUsedByAstNode(it);
                }
            }
            super.visitInvocation(invocation);
        }
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        Intrinsics.checkNotNullParameter(x, "x");
        if (!this.analysisResult.getFunctionsToEnter().contains(x)) {
            Set it = CollectUtilsKt.collectLocalVariables$default(x, false, 1, null);
            boolean bl = false;
            this.context.addNodesForLocalVars(it);
            CollectionsKt.addAll((Collection)this.context.getNamesOfLocalVars(), it);
            this.withErasedThis(() -> ReachabilityTracker.visitFunction$lambda$5(this, x));
        } else {
            super.visitFunction(x);
        }
    }

    private final void withErasedThis(Function0<Unit> action) {
        Context.Node oldThis = this.context.getThisNode();
        this.context.setThisNode(null);
        action.invoke();
        this.context.setThisNode(oldThis);
    }

    @Override
    public void visitBreak(@NotNull JsBreak x) {
        Intrinsics.checkNotNullParameter(x, "x");
    }

    @Override
    public void visitContinue(@NotNull JsContinue x) {
        Intrinsics.checkNotNullParameter(x, "x");
    }

    public final void reach(@NotNull Context.Node node) {
        Intrinsics.checkNotNullParameter(node, "node");
        if (node.getReachable()) {
            return;
        }
        node.setReachable(true);
        if (this.context.visit(node)) {
            ((Collection)this.reachableNodesImpl).add(node);
        }
        this.reachDeclaration(node);
        this.reachDependencies(node);
        Iterable $this$forEach$iv = MapsKt.toList(node.getMembers());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String name2 = (String)pair.component1();
            Context.Node member = (Context.Node)pair.component2();
            if (member.getReachable()) continue;
            this.reportAndNest("reach: member " + name2, null, () -> ReachabilityTracker.reach$lambda$7$lambda$6(this, member));
        }
        if (!this.analysisResult.getFunctionsToSkip().contains(node)) {
            for (JsFunction expr : node.getFunctions()) {
                this.reportAndNest("traverse: function", expr, () -> ReachabilityTracker.reach$lambda$10(expr, this));
            }
        }
        for (JsExpression expr : node.getExpressions()) {
            this.reportAndNest("traverse: value", expr, () -> ReachabilityTracker.reach$lambda$11(expr, this));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reachDependencies(Context.Node node) {
        List path = new ArrayList();
        Context.Node current = node;
        while (true) {
            for (Context.Node ancestorDependency : current.getDependencies()) {
                if (SequencesKt.contains(SequencesKt.generateSequence(ancestorDependency, ReachabilityTracker::reachDependencies$lambda$12), current)) continue;
                Iterable $this$fold$iv = CollectionsKt.asReversedMutable(path);
                boolean $i$f$fold = false;
                Context.Node accumulator$iv = ancestorDependency;
                for (Object element$iv : $this$fold$iv) {
                    void memberName;
                    String string2 = (String)element$iv;
                    Context.Node n = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = n.member((String)memberName);
                }
                Context.Node dependency = accumulator$iv;
                if (dependency.getReachable()) continue;
                this.reportAndNest("reach: dependency " + dependency, null, () -> ReachabilityTracker.reachDependencies$lambda$14(this, dependency));
            }
            Collection collection = path;
            String string3 = current.getMemberName();
            if (string3 == null) break;
            collection.add(string3);
            Intrinsics.checkNotNull(current.getParent());
        }
    }

    private final void reachDeclaration(Context.Node node) {
        if (node.getHasSideEffects() && !node.getReachable()) {
            this.reportAndNest("reach: because of side effect", null, () -> ReachabilityTracker.reachDeclaration$lambda$15(this, node));
        } else if (!node.getDeclarationReachable()) {
            node.setDeclarationReachable(true);
            if (this.context.visit(node)) {
                ((Collection)this.reachableNodesImpl).add(node);
            }
            Context.Node node2 = node.getOriginal().getParent();
            if (node2 != null) {
                Context.Node it = node2;
                boolean bl = false;
                this.reportAndNest("reach-decl: parent " + it, null, () -> ReachabilityTracker.reachDeclaration$lambda$17$lambda$16(this, it));
            }
            for (JsExpression expr : node.getExpressions()) {
                this.reportAndNest("traverse: value", expr, () -> ReachabilityTracker.reachDeclaration$lambda$18(expr, this));
            }
        }
    }

    @Override
    public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
        Intrinsics.checkNotNullParameter(x, "x");
        if (x.getOperator() == JsUnaryOperator.TYPEOF) {
            JsExpression arg = x.getArg();
            Intrinsics.checkNotNull(arg);
            Context.Node node = this.context.extractNode(arg);
            if (node != null) {
                Context.Node it = node;
                boolean bl = false;
                this.reachDeclaration(it);
                return;
            }
        }
        super.visitPrefixOperation(x);
    }

    @Override
    protected void visitElement(@NotNull JsNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        if (this.analysisResult.getAstNodesToSkip().contains(node)) {
            return;
        }
        JsLocation newLocation = UtilKt.extractLocation(node);
        JsNode old = this.currentNodeWithLocation;
        if (newLocation != null) {
            this.currentNodeWithLocation = node;
        }
        super.visitElement(node);
        this.currentNodeWithLocation = old;
    }

    private final void reportAndNest(String message, JsNode dueTo, Function0<Unit> action) {
        if (this.logConsumer != null) {
            String indent = StringsKt.repeat("  ", this.depth);
            JsNode jsNode = dueTo;
            JsLocation location = jsNode != null ? UtilKt.extractLocation(jsNode) : null;
            String fullMessage = location == null ? indent + message : indent + message + " (due to " + UtilKt.asString(location) + ')';
            this.logConsumer.invoke(DCELogLevel.INFO, fullMessage);
        }
        this.nested(action);
    }

    private final void nested(Function0<Unit> action) {
        int n = this.depth;
        this.depth = n + 1;
        action.invoke();
        n = this.depth;
        this.depth = n + -1;
    }

    private static final Unit visitNameLikeNode$lambda$1(ReachabilityTracker this$0, Context.Node $node) {
        block0: {
            this$0.reach($node);
            JsNode jsNode = this$0.currentNodeWithLocation;
            if (jsNode == null) break block0;
            JsNode it = jsNode;
            boolean bl = false;
            $node.addUsedByAstNode(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitFunction$lambda$5(ReachabilityTracker this$0, JsFunction $x) {
        super.visitFunction($x);
        return Unit.INSTANCE;
    }

    private static final Unit reach$lambda$7$lambda$6(ReachabilityTracker this$0, Context.Node $member) {
        this$0.reach($member);
        return Unit.INSTANCE;
    }

    private static final Unit reach$lambda$10$lambda$9(JsFunction $expr, ReachabilityTracker this$0) {
        $expr.getBody().accept(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit reach$lambda$10(JsFunction $expr, ReachabilityTracker this$0) {
        Set it = CollectUtilsKt.collectLocalVariables$default($expr, false, 1, null);
        boolean bl = false;
        this$0.context.addNodesForLocalVars(it);
        CollectionsKt.addAll((Collection)this$0.context.getNamesOfLocalVars(), it);
        this$0.withErasedThis(() -> ReachabilityTracker.reach$lambda$10$lambda$9($expr, this$0));
        return Unit.INSTANCE;
    }

    private static final Unit reach$lambda$11(JsExpression $expr, ReachabilityTracker this$0) {
        $expr.accept(this$0);
        return Unit.INSTANCE;
    }

    private static final Context.Node reachDependencies$lambda$12(Context.Node it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getParent();
    }

    private static final Unit reachDependencies$lambda$14(ReachabilityTracker this$0, Context.Node $dependency) {
        this$0.reach($dependency);
        return Unit.INSTANCE;
    }

    private static final Unit reachDeclaration$lambda$15(ReachabilityTracker this$0, Context.Node $node) {
        this$0.reach($node);
        return Unit.INSTANCE;
    }

    private static final Unit reachDeclaration$lambda$17$lambda$16(ReachabilityTracker this$0, Context.Node $it) {
        this$0.reachDeclaration($it);
        return Unit.INSTANCE;
    }

    private static final Unit reachDeclaration$lambda$18(JsExpression $expr, ReachabilityTracker this$0) {
        $expr.accept(this$0);
        return Unit.INSTANCE;
    }

    static {
        String[] stringArray = new String[]{"call", "apply"};
        CALL_FUNCTIONS = SetsKt.setOf(stringArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/js/dce/ReachabilityTracker$Companion;", "", "<init>", "()V", "CALL_FUNCTIONS", "", "", "js.dce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

